#ifndef MIRQ_H
#define MIRQ_H
#ifdef __FLAT__
#include "int32.h"
#endif
#include "mtypes.h"


#ifdef __WATCOMC__
	#define MIRQARGS void
	typedef void (interrupt far *PVI)(MIRQARGS);
#endif

#ifdef __DJGPP__
	#define MIRQARGS void
	typedef void (*PVI)(MIRQARGS);
#endif

#ifdef __BORLANDC__

	#ifdef __FLAT__
	    #define MIRQARGS unsigned long	ebp, unsigned long	edi, unsigned long	esi,unsigned long	 ds, unsigned long	 es, unsigned long	edx, unsigned long	ecx, unsigned long	ebx, unsigned long	eax, unsigned long	eip, unsigned long	 cs, unsigned long	flags
	#else
	    #ifdef __cplusplus
		    #define MIRQARGS ...
	    #else
		    #define MIRQARGS
	    #endif
	#endif
#ifdef __FLAT__
	typedef void (*PVI)(MIRQARGS);
#else
	typedef void interrupt (far *PVI)(MIRQARGS);
#endif

#endif


BOOL MIrq_IsEnabled(UBYTE irqno);
BOOL MIrq_OnOff(UBYTE irqno,UBYTE onoff);
#ifdef __FLAT__
interrupt_struct MIrq_SetHandler(UBYTE irqno,PVI handler);
#else
PVI MIrq_SetHandler(UBYTE irqno,PVI handler);
#endif
void MIrq_EOI(UBYTE irqno);

#endif
