.TH TiMidity 1 "8 May 1995" \" -*-nroff-*-
.SH NAME
TiMidity \- MIDI to WAVE converter and player
.P
.SH SYNOPSIS
.B timidity
[\-options] filename [filenames ...]
.P
.SH DESCRIPTION
TiMidity is a MIDI to WAVE converter using Gravis
Ultrasound\-compatible patch files to generate digital audio data from
General MIDI files.  The data can be stored in a file for processing,
or played in real time through an audio device.
.P
.SH OPTIONS
The following command line options are accepted by version 0.2g of
TiMidity:
.TP
.BI \-o " filename"
Place output on \fIfilename\fP, which may be a file, device, or HP-UX
audio server, depending on the output mode selected with the \fB\-O\fP
option. The special filename ``\-'' causes output to be placed on
stdout.
.TP
.BI \-O " mode"
Selects the output mode from the compiled-in alternatives.  \fImode\fP
must begin with one of the supported output mode identifiers.  Run
TiMidity with the \fB\-h\fP option to see a list.  The following
identifiers should be available in all versions:
.RS
.TP
.B \-Or
Generate raw waveform data.  All format options are supported.  Common
formats include:
.RS
.TP
.B \-OrU
uLaw
.TP
.B \-Or1sl
16-bit signed linear PCM
.TP
.B \-Or8ul
8-bit unsigned linear PCM
.RE
.TP
.B \-Ow
Generate RIFF WAVE format output.  If output is directed to a
non-seekable file, or if TiMidity is interrupted before closing the
file, the file header will contain 0xFFFFFFFF in the RIFF and data
block length fields.  The popular sound conversion utility \fIsox\fP
is able to read such malformed files, so you can pipe data directly to
sox for on\-the\-fly conversion to other formats.
.TP
.B "Format options"
Option characters may be added immediately after the mode identifier
to change the output format.  The following options are recognized:
.RS
.LP
.TP
.B 8
8-bit sample width
.TP
.B 1
16-bit sample width
.TP
.B l
Linear encoding
.TP
.B U
uLaw (8-bit) encoding
.TP
.B M
Monophonic
.TP
.B S
Stereo
.TP
.B s
Signed output
.TP
.B u
Unsigned output
.TP
.B x
Byte-swapped output
.RE
.LP
Note that some options have no effect on some modes.  For example, you
cannot generate a byte-swapped RIFF WAVE file, or force uLaw output on
a Linux PCM device.
.RE
.LP
.TP
.BI \-s " frequency"
Sets the resampling frequency.  Not all sound devices are capable of
all frequencies -- an approximate frequency may be selected, depending
on the implementation.
.TP
.B \-a
Turns on antialiasing.  Non-looped samples are run through a lowpass
filter before playing, which reduces aliasing noise at low resampling
frequencies.  The filter may introduce a click at some loop points, so
it isn't used for looped samples.
.TP
.B \-f
Toggles fast envelopes. Some MIDI files sound better when notes decay
slower -- it gives the impression of reverb, which TiMidity doesn't
currently support.
.TP
.BI \-p " voices"
Sets polyphony (maximum number of simultaneous voices) to
\fIvoices\fP.
.TP
.BI \-A " amplification"
Multiplies the master volume by \fIamplification\fP%.
.TP
.BI \-C " ratio"
Sets the ratio of sampling and control frequencies.  This determines how
often envelopes are recalculated -- small ratios yield better quality
but use more CPU time.
.TP
.BI \-L " directory"
Adds \fIdirectory\fP to the library path.  Patch, configuration, and
MIDI files are searched along this path.  Directories added last will
be searched first.  Note that the current directory is always searched
first before the library path.
.TP
.BI \-c " file"
Reads an extra configuration file.
.TP
.BI \-I " number"
Uses the program \fInumber\fP as the default instrument.  Any Program
Change events in MIDI files will override this option.
.TP
.BI \-P " file"
Uses the patch \fIfile\fP for every program except drums.  Program
Change events will be ignored.  This is useful for testing new
patches.
.TP
.BI \-D " channel"
Marks \fIchannel\fP as a drum channel.  
If \fIchannel\fP is negative, channel \-\fIchannel\fP is marked as an
instrumental channel.
If \fIchannel\fP is 0, all channels are marked as instrumental.
.TP 
.BI \-Q " channel"
Causes \fIchannel\fP to be quiet. 
If \fIchannel\fP is negative, channel \-\fIchannel\fP is turned back on. 
If \fIchannel\fP is 0, all channels are turned on.
.TP 
.B \-F
Turns off fast panning. Some MIDI pieces expect panning adjustments to
affect notes that are already playing, some don't. The latter have a
habit of flipping balance rapidly between left and right, which can
cause severe clicks. Turn off fast panning to accommodate such files.
.TP
.BI \-U
Instructs TiMidity to unload all instruments from memory between
MIDI files.  This can reduce memory requirements when playing many
files in succession.
.TP
.BI \-i " interface"
Selects the user interface from the compiled-in alternatives.
\fIinterface\fP must begin with one of the supported interface
identifiers.  Run TiMidity with the \fB\-h\fP option to see a list.
The following identifiers may be available:
.RS
.TP
.B \-id
The dumb interface -- plays files in sequence, prints messages
according to verbosity level.  The trace mode shows the current and
total playing time.
.TP
.B \-in
The ncurses full\-screen interface with interactive controls.
.TP
.B \-is
The S-Lang full\-screen interface with interactive controls.
.TP
.B "Interface options"
Option characters may be added immediately after the interface
identifier.  The following options are recognized:
.RS
.TP
.B v
Increases verbosity.  This option is cumulative.
.TP
.B q
Decreases verbosity.  This option is cumulative.
.TP
.B t
Toggles trace mode.  In trace mode, TiMidity attempts to display its
current state in real time.  For the Linux sound driver, this is
accomplished through the use of short DMA buffer fragments, which can
be tuned via the \fB\-B\fP option.
.RE
.RE
.LP
.TP
.TP
.BI \-B " fragments"
For the Linux sound driver, selects the number of buffer fragments in
interactive mode.  Increasing the number of fragments may reduce
choppiness when many processes are running.  It will make TiMidity seem
to respond sluggishly to fast forward, rewind, and volume controls,
and it will throw the status display off sync.  Specify a
\fIfragments\fP of 0 to use the maximum number of fragments available.
.P
.SH FILES
TiMidity looks for the configuration file \fItimidity.cfg\fP at
startup, before processing any options.  If it can't be accessed, and
the library path is changed with a \fB\-L\fP option on the command
line, then the default file will be sought again along the new library
path after processing all options, unless another configuration file was
specified with the \fB\-c\fP option. 
.P
Configuration files define the mapping of MIDI programs to instrument
files.  Multiple files may be specified, and statements in later ones
will override earlier ones.  The following statements can be used in a
configuration file:
.TP
.BI dir " directory"
Adds \fIdirectory\fP to the search path in the same manner as the
\fB\-L\fP command line option.
.TP
.BI source " file"
Reads another configuration file, then continues processing the
current one.
.TP
.BI bank " number"
Selects the tone bank to modify.  Patch mappings that follow will
affect this tone bank.
.TP
.BI drumset " number"
Selects the drum set to modify.  Patch mappings that follow will affect
this drum set.
.TP
.I "number file [options]"
Specifies that the the MIDI program \fInumber\fP in the current tone
bank or drum set should be played using the patch \fIfile\fP.
\fIoptions\fP may be any of the following:
.RS
.TP
\fBamp=\fP\fIamplification\fP
Amplifies the instrument's volume by \fIamplification\fP percent.
If no value is specified, one will be automatically determined whenever
the instrument is loaded.
.TP
\fBnote=\fP\fInote\fP
Specifies a fixed MIDI note to use when playing the instrument.
If \fInote\fP is 0, the instrument will be played at whatever note
the Note On event triggering it has. For percussion instruments, if no
value is specified in the configuration file, the default in the patch
file will be used.
.TP
\fBpan=\fP\fIpanning\fP
Sets the instrument's default panning. 
\fIpanning\fP may be \fBleft\fP, \fBright\fP, \fBcenter\fP, or an
integer between -100 and 100, designating full left and full right
respectively. 
If no value is specified, the default in the patch file will be used. 
Note that panning controls in MIDI files will override this value.
.TP
\fBkeep=\fP{\fBloop\fP|\fBenv\fP}
By default, percussion instruments have their loop and envelope
information stripped. Strangely shaped envelopes are removed
automatically from melodic instruments as well. \fBkeep\fP can be used
to prevent stripping envelope or loop data. For example, the Short and
Long Whistle percussion instruments (General Midi numbers 71 and 72)
need to have ``\fBkeep=loop keep=env\fP'' specified in the configuration
file.
.TP
\fBstrip=\fP{\fBloop\fP|\fBenv\fP|\fBtail\fP}
Force removal of loop or envelope information from all patches in the
instrument, or strip the tail, i.e. all data after the loop. Some
third-party instruments have garbage after the loop, so adding the
\fBstrip=tail\fP option will markedly improve sound quality.
.RE
.LP
.P
\fBNOTE:\fP Whenever any filename ends in one of the compiled\-in
compression identifiers, such as \fI.gz\fP, or \fI.sht\fP, TiMidity
will pipe the file through the appropriate decompressor.  MIDI files
often compress very well, so the ability to handle compressed files
can be useful.
.P
The special filename ``\-'' can be used on the command line to
indicate that a MIDI file should be read from stdin.
.P
.SH COPYRIGHT
Copyright (C) 1995 Tuukka Toivonen.
.P
TiMidity is free software; you can redistribute it
and/or modify it under the terms of the \fIGNU General Public
License\fP as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.
.P
TiMidity is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
\fIGNU General Public License\fP for more details.
.SH AVAILABILITY
The latest release is available on the TiMidity Home Page,
URL \fIhttp://www.hut.fi/~titoivon/timidity/\fP.
.SH BUGS
8-bit and low-rate output sounds worse than it should.
.P
Eats more CPU time than a small CPU-time-eating animal.
.SH AUTHORS
Tuukka Toivonen <titoivon@snakemail.hut.fi>
.br
HP\-UX audio code and antialiasing filter by Vincent Pagel <pagel@loria.fr>
.br
S\-Lang user interface by Riccardo Facchetti <riccardo@cdc8g5.cdc.polimi.it>
