/*
 *		guimidi.h
 *		timidity port for win32 'windows' mode
 *		based on timidity (Unix ) from Tuukka Toivonen and
 *		win32 console port from  Davide Moretti's 
 *		provided under GNU General Public License
 *	contents : 
 *    configuration through windows 'ini' file 
 * and timidity.cgf file , midi file lauching
 *    header file 
 *    Nicolas Witczak mai 1996
 */

#ifndef __WIN95__
	#error this file is for windows95 version of timidity	
#endif /* __WIN95__ */ 


#ifndef GUITIMID_H
	#define GUITIMID_H

#include "win_inc.h"

#include "winhlp.h"

/////////////////////////////////////////////////
// variables to export
extern BOOL bIsPlaying ;
extern HANDLE hPlayThread  ;
extern DWORD dwPlayThreadId ;
extern int iVolume ;
extern int iDeltaVolume  ;

extern int iGUIWhishedState  ;

#define RC_STOP RC_QUIT // we interpret RC_QUIT as stop 
	// midi file info
extern int iMidiFileTotalMin ;
extern int iMidiFileTotalSec ;
extern int iMidiFileCurMin ;
extern int iMidiFileCurSec ;
	//play list
extern char** ppszPlayList;
extern int cbFileInPlayList ;
extern int iCurPlayListIndex ;

extern int free_instruments_afterwards ;
extern char def_instr_name[256] ;
extern char pszTimidCfgPath[szStringBuff] ; 
extern int iCtrlPerSecond ;
extern BOOL bTrustWinAudioSpRate ;
	   
extern int bShowOutput ; // show debugging output

BOOL
	LoadTimidCfg();
BOOL
	SaveTimidCfg();
BOOL
	LoadIniFile();
BOOL
	InitTimidity();

void    
	PlayList(LPVOID pvArg);	 /* pvArg is requested by BeginThread API fct
											but is not used*/
int 
	read_config_file(char *name);
int 
	play_midi_file(char *fn);

#endif // GUITIMID_H