/*
 *		wingui_ctl.cpp
 *		timidity port for win32 'windows' mode
 *		based on timidity (Unix ) from Tuukka Toivonen and
 *		provided under GNU General Public License
 *	contents :
 *		ControlMode redefinition for win32 GUI interface 
 *   here we declare an instance of win95_control_mode
 *    Nicolas Witczak mai 1996
 */

#ifdef __WIN95__

#include "win_inc.h"

#include "config.h"
#include "common.h"
#include "output.h"

#include "guimain.h"
#include "winhlp.h"
#include "guitimid.h"

#include "controls.h"
#include "win95ctl.h"
/////////////////////////////////////////////////////////////////
// export the interface functions 

#define ctl win95_control_mode

ControlMode ctl ;

static FILE *infp=stdin, *outfp=stdout; 

#define GUIWin95ctlName "hf interface"


/////////////////////////////////////////////////////////////////
// additional variables and functions
static HWND hwndOutput = 0 ;
static char pszCWn95CMSG[4096];

void
	CreateOutputWnd()
	{
		hwndOutput = CreateWindowEx(
		WS_EX_CLIENTEDGE|WS_EX_TOOLWINDOW|WS_EX_DLGMODALFRAME,
		"EDIT",0,
		WS_SIZEBOX|WS_VSCROLL|ES_MULTILINE|ES_LEFT|ES_AUTOVSCROLL|ES_READONLY,
		CW_USEDEFAULT,30,500,200,0,0,hInst,0);
		if(bShowOutput)
			ShowOutput();		
	}

void
	ShowOutput()
	{
		ShowWindow(hwndOutput,SW_SHOW);	
	}

void
	HideOutput()
	{
		ShowWindow(hwndOutput,SW_HIDE);
	}

void
	ClearOutput()
	{
		char pszVoid[]="";
		Edit_SetText(hwndOutput,pszVoid);
	}

static void 
	ctl_refresh(void);

static void 
	ctl_total_time(int tt);

static void 
	ctl_master_volume(int mv);

static void 
	ctl_file_name(char *name);

static void 
	ctl_current_time(int ct);

static void 
	ctl_note(int v);

static void 
	ctl_program(int ch, int val);

static void 
	ctl_volume(int channel, int val);

static void 
	ctl_expression(int channel, int val);

static void 
	ctl_panning(int channel, int val);

static void 
	ctl_sustain(int channel, int val);

static void 
	ctl_pitch_bend(int channel, int val);

static void 
	ctl_reset(void);

static int 
	ctl_open(int using_stdin, int using_stdout);

static void 
	ctl_close(void);

static int 
	ctl_read(int32 *valp);

static int 
	cmsg(int type, int verbosity_level, char *fmt, ...);

void
	InitWinGuiCtrlStruct(ControlMode* ptrlToInit)
	{
		memset(ptrlToInit,0,sizeof(ControlMode))  ;
		ptrlToInit->id_name = calloc(sizeof(GUIWin95ctlName),1) ;
		strcpy(ptrlToInit->id_name,GUIWin95ctlName);
		ptrlToInit->id_character 		= 'w' ;
		ptrlToInit->verbosity			=	1  ;
		ptrlToInit->trace_playing		=	0 	;
		ptrlToInit->opened				=	0	;
		ptrlToInit->open					=	ctl_open	;
		ptrlToInit->close					=	ctl_close ;
		ptrlToInit->read					=	ctl_read	;
		ptrlToInit->cmsg					=	cmsg ;
		ptrlToInit->refresh				=	ctl_refresh	;
		ptrlToInit->reset					=	ctl_reset  ;
		ptrlToInit->file_name			=	ctl_file_name ;
		ptrlToInit->total_time			=	ctl_total_time	;
		ptrlToInit->current_time		=	ctl_current_time ;
		ptrlToInit->note					=	ctl_note	;
		ptrlToInit->master_volume		=	ctl_master_volume	;
		ptrlToInit->program				=	ctl_program	;
		ptrlToInit->volume				=	ctl_volume	;
		ptrlToInit->expression			=	ctl_expression	;
		ptrlToInit->panning				=	ctl_panning	;
		ptrlToInit->sustain				=	ctl_sustain	;
		ptrlToInit->pitch_bend			=	ctl_pitch_bend	;
	}


void
	vcmsg(int type, int verbosity_level, char *fmt,va_list argList)
	{
		int strLength ;
		if( ((type==CMSG_TEXT) || (type==CMSG_INFO) || (type==CMSG_WARNING)) &&
			( ctl.verbosity < verbosity_level ) )
		return ;
		pszCWn95CMSG[0] = '\0' ;
		vsprintf( pszCWn95CMSG , fmt, argList) ;
		strLength = strlen(pszCWn95CMSG);
		pszCWn95CMSG[strLength] = 13 ;
		pszCWn95CMSG[strLength+1] = 10 ;
		pszCWn95CMSG[strLength+2] = '\0' ;
		if( IsWindow(hwndOutput) )
			Edit_ReplaceSel(hwndOutput,pszCWn95CMSG);
	}



/////////////////////////////////////////////////////////////////
// win 95 control interface



static int 
	ctl_open(int using_stdin, int using_stdout)
	{
		CreateOutputWnd();
		if(bShowOutput)
			ShowOutput();
		ctl.opened=1;
		return 0;
	}

static void 
	ctl_close(void)
	{ 
		DestroyWindow(hwndOutput);
		hwndOutput =0 ;
	}

static int 
	ctl_read(int32 *valp)
	{
	  int iRetState ;
	  iRetState = iGUIWhishedState ;
	  iGUIWhishedState = RC_NONE ;
	  if( (iRetState == RC_FORWARD) 
		  || (iRetState == RC_BACK) )
		  *valp=play_mode->rate ;
	  else if( iRetState == RC_CHANGE_VOLUME )
	  {
		  iVolume += iDeltaVolume ;
		  *valp = iDeltaVolume ;
		  iDeltaVolume = 0 ; 
	  }	
	  return iRetState ;
	}

static int cmsg(int type, int verbosity_level, char *fmt, ...)
{  
	va_list ap;
	va_start(ap, fmt);
	vcmsg(type,verbosity_level,fmt,ap);
	va_end(ap);
	return 0;
}


static void 
	ctl_refresh(void) 
	{ 
	}

static void 
	ctl_total_time(int tt)
	{
	  iMidiFileTotalSec=tt/play_mode->rate;
	  iMidiFileTotalMin=iMidiFileTotalSec/60;
	  iMidiFileTotalSec-=iMidiFileTotalMin*60;

	}

static void 
	ctl_master_volume(int mv) {}

static void 
	ctl_file_name(char *name)
	{
		SetMidiTitle();
	}

static void
	ctl_current_time(int ct)
	{
	  int secs;
	  secs=ct/play_mode->rate;  
	  if ( iMidiFileCurSec != secs )
		 {
			iMidiFileCurSec = secs ;
			iMidiFileCurMin=iMidiFileCurSec/60;
			iMidiFileCurSec-=iMidiFileCurMin*60;
			PaintText(hMainWnd);
		 }
	}

static void 
	ctl_note(int v) {}

static void 
	ctl_program(int ch, int val) {}

static void 
	ctl_volume(int channel, int val) {}

static void 
	ctl_expression(int channel, int val) {}

static void 
	ctl_panning(int channel, int val) {}

static void 
	ctl_sustain(int channel, int val) {}

static void 
	ctl_pitch_bend(int channel, int val) {}

static void 
	ctl_reset(void) {}


#endif /* __WIN95__ */
