#ifndef BULK_H
#define BULK_H

#include "types.h"

typedef struct {
  u_int alloc_unit;
  u_int i;
  u_int size;
  u_char *data;
} BULK;

BULK *alloc_bulk(u_int);
void free_bulk(BULK*);
BULK *resize_bulk(BULK*, u_int);
/*int position(BULK*, u_int);*/

int read_byte(BULK*, u_char*);
int read_2bytes(BULK*, u_short*);
int read_4bytes(BULK*, u_int*);
int read_nbytes(BULK*, u_char**, int);
int read_file_bulk(FILE*, BULK*);

int write_byte(BULK*, u_char);
int write_2bytes(BULK*, u_short);
int write_4bytes(BULK*, u_int);
int write_nbytes(BULK*, u_char*, int);
int write_file_bulk(FILE*, BULK*);

#endif
