#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "packet.h"

PACKET *alloc_packet(u_int tick)
{
  PACKET *packet;

  if ((packet = (PACKET*) malloc(sizeof(PACKET))) == NULL)
    return NULL;

  packet->bulk = alloc_bulk(16);  /* 16 is allocation unit */

  packet->tick = tick;
  packet->next = NULL;

  return packet;
}

void free_packet(PACKET *packet)
{
  PACKET *temp;

  while (packet != NULL) {
    temp = packet->next;
    free_bulk(packet->bulk);
    free(packet);
    packet = temp;
  }
}

int add_packet(PACKET *packet, u_char *data, int size)
{
  if (write_nbytes(packet->bulk, data, size) < 0
      || write_byte(packet->bulk, 0) < 0)  /* padding delta-time 0 */
    return -1;

  return size + 1;
}

PACKET *insert_packet(PACKET *insert_point, u_int tick)
{
  PACKET *packet;

  if ((packet = alloc_packet(tick)) == NULL)
    return NULL;

  packet->next = insert_point->next;
  insert_point->next = packet;

  return packet;
}

PACKET *get_insert_point(PACKET *packet, u_int tick)
{
  PACKET *prev;

  for (prev = packet; packet != NULL; packet = packet->next) {
    if (packet->tick == tick) {
      break;

    } else if (packet->tick > tick) {
      packet = NULL;
      break;
    }
    prev = packet;
  }

  if (packet == NULL) {
    if ((packet = insert_packet(prev, tick)) == NULL)
      return NULL;
  }

  return packet;
}

PACKET *add_event(PACKET *packet, u_int tick, u_char *data, int size)
{
  if ((packet = get_insert_point(packet, tick)) == NULL
      || add_packet(packet, data, size) < 0)
    return NULL;

  return packet;
}

PACKET *add_eot(PACKET *packet)
{
  u_char event[3] = { 0xff, 0x2f, 0 };

  for ( ; packet != NULL; packet = packet->next) {
    if (packet->next == NULL)
      break;
  }

  if (packet == NULL
      || add_packet(packet, event, sizeof event) < 0)
    return NULL;

  return packet;
}

void print_packet(PACKET *packet)
{
  int i;

  for ( ; packet != NULL; packet = packet->next) {
    fprintf(stderr, "%d:", packet->tick);

    for (i = 0; i < packet->bulk->i; i++)
      fprintf(stderr, " %02X", packet->bulk->data[i]);

    fputc('\n', stderr);
  }
}
