#ifndef PACKET_H
#define PACKET_H

#include "bulk.h"

typedef struct packet {
  u_int tick;
  BULK *bulk;
  struct packet *next;
} PACKET;

PACKET *alloc_packet(u_int);
void free_packet(PACKET*);

int add_packet(PACKET*, u_char*, int);
PACKET *insert_packet(PACKET*, u_int);
PACKET *get_insert_point(PACKET*, u_int);
PACKET *add_event(PACKET*, u_int, u_char*, int);
PACKET *add_eot(PACKET*);

void print_packet(PACKET*);

#endif
