#include <stdio.h>

#include "smf.h"
#include "rcp.h"
#include "error.h"

#define MAX_TRACKS 64

int main(int, char*[]);

static int opt_debug = 0;

int main(int argc, char *argv[])
{
  int i;
  BULK *infile = alloc_bulk(4096);
  BULK *outfile = alloc_bulk(4096);
  FILE *fp;
  MThd mthd;
  RCPhd rcphd;
  PACKET *heads[MAX_TRACKS];

  for (i = 1; i < argc; i++) {
    if (argv[i][0] != '-')
      continue;

    switch (argv[i][1]) {
    case '\0':
      continue;

    case 'D':
      opt_debug = 1;
      break;

    default:
      break;
    }

    argv[i] = NULL;
  }

  fp = stdin;
  for (i = 1; i < argc; i++) {
    if (argv[i] == NULL)
      continue;

    if (strcmp(argv[i], "-") == 0) {
      break;

    } else {
      if ((fp = fopen(argv[i], "r"))  == NULL) {
	perror(argv[i]);
      }
      break;
    }
  }

  if (read_file_bulk(fp, infile) < 0) 
    die(1, "%s: %s\n", argv[0], argv[i]);

  if (opt_debug)
    fprintf(stderr, "size %d\n", infile->i);

  infile->i = 0;  /* seek(0) */

  mthd.ntracks = rcp_read(infile, &rcphd, heads);
  free_bulk(infile);
  mthd.format = 1;
  mthd.division = rcphd.timebase;
  smf_write(outfile, &mthd, heads);

  for (i = 0; i < mthd.ntracks; i++)
    free_packet(heads[i]);

  write_file_bulk(stdout, outfile);
  free_bulk(outfile);

  return 0;
}
