#ifndef SMF_H
#define SMF_H

#include "packet.h"

typedef struct {
  u_short format;
  u_short ntracks;
  u_short division;
} MThd;

typedef enum { MIDI, SYSEX, META, ERROR } EVENT_TYPE;

typedef struct {
  EVENT_TYPE type;
  u_char status;  /* This is meta-event type when type is META. */
  u_char *data;
  u_int length;
} EVENT;

int read_varlen(BULK*, u_int*);
int smf_read_type_length(BULK*, char**, u_int*);
int smf_read_header(BULK*, MThd*);
/*int smf_read_track_header(BULK*, u_int*);*/
int smf_read_event(BULK*, EVENT*);
int smf_read_track(BULK*, PACKET*);
int smf_read(BULK*, MThd*, PACKET*[]);

int write_varlen(BULK*, u_int);
int smf_write_header(BULK*, MThd*);
int smf_write_track_header(BULK*, u_int);
int smf_write_event(BULK*, EVENT*);
int smf_write_track(BULK*, PACKET*);
int smf_write(BULK*, MThd*, PACKET*[]);

#define SMF_EOF -1  /* Premature EOF */
#define SMF_ILLRUN -2  /* Illegal running status */
#define SMF_ILLSTAT -3  /* Illegal status byte */
#define SMF_MEM -3 /* Insufficient memory */

#endif
