#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "smf.h"
#include "error.h"

int main(int, char*[]);
PACKET *smf1to0(BULK*, MThd*);

static int opt_debug = 0;

int main(int argc, char *argv[])
{
  int i;
  BULK *infile = alloc_bulk(4096);
  BULK *outfile = alloc_bulk(4096);
  FILE *fp;
  MThd mthd;
  PACKET *head;

  for (i = 1; i < argc; i++) {
    if (argv[i][0] != '-')
      continue;

    switch (argv[i][1]) {
    case '\0':
      continue;

    case 'D':
      opt_debug = 1;
      break;

    default:
      break;
    }

    argv[i] = NULL;
  }

  fp = stdin;
  for (i = 1; i < argc; i++) {
    if (argv[i] == NULL)
      continue;

    if (strcmp(argv[i], "-") == 0) {
      break;

    } else {
      if ((fp = fopen(argv[i], "r"))  == NULL) {
	perror(argv[i]);
      }
      break;
    }

  }

  if (read_file_bulk(fp, infile) < 0) 
    die(1, "%s: %s\n", argv[0], argv[i]);

  if (opt_debug)
    fprintf(stderr, "size %d\n", infile->i);

  infile->i = 0;  /* seek(0) */
  head = smf1to0(infile, &mthd);

  switch (mthd.format) {
  case 0:
    write_file_bulk(stdout, infile);
    break;

  case 1:
    mthd.format = 0;
    mthd.ntracks = 1;
    smf_write(outfile, &mthd, &head);
    write_file_bulk(stdout, outfile);
    break;

  default:
    die(1, "%s: unknown format\n", argv[0]);
    break;
  }

  return 0;
}

PACKET *smf1to0(BULK *bulk, MThd *mthd)
{
  char *type;
  int i = 0;
  u_int length;
  PACKET *head = alloc_packet(0);

  if (smf_read_type_length(bulk, &type, &length) < 0
      || strncmp(type, "MThd", 4) != 0
      || smf_read_header(bulk, mthd) < 0)
    return NULL;

  while (smf_read_track(bulk, head) >= 0) {
    if (opt_debug)
      fprintf(stderr, "Track %d\n", i++);
  }

  if (add_eot(head) == NULL)
    return NULL;

  return head;
}
