/************************************************************

mimeplugin.c
started December 7, 1996

harshaw@wpi.edu (until may 1997)

take a look at the netscape homepage and download the 
netscape plugin SDK for a complete definition of all
API functions.

************************************************************
Copyright (C) 1996 Carl Shimer

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        

************************************************************

$Author$
$Source$
$Date$
$Revision$

************************************************************/



#define NAME "linux mime plugin"
#define PURPOSE "This plugin handles embedded mime types."
#define CONF_FILE "/.netscape/mimeplugin/mimeplugin.conf"

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include "npapi.h"

/************************************************************
this struct holds all the data for a particular
application

arguments is the list of arguments to execve
mimetype, the mimetype to register with netscape
extension, the extension to call the plugin on
lastarg, the end of the arguments list, used to place the
name of the file into
************************************************************/

typedef struct {
  char** arguments;
  char* mimetype;
  char* extension;
  int lastarg;
}argstruct;

/************************************************************
this is the array of argstructs.  It is allocated to
the number of entries in the conf file
************************************************************/

argstruct** argarray;


/***********************************************************************
 * Instance state information about the plugin.
 *
 * PLUGIN DEVELOPERS:
 *	Use this struct to hold per-instance information that you'll
 *	need in the various functions in this file.
 ***********************************************************************/

typedef struct _PluginInstance
{
  int child;
  int mtype;
} PluginInstance;


/**********************************************************************
void getargs(char*)

this function parses the options file into the appropriate structures

if rval is NULL, it won't export a list of types to send to netscape

**********************************************************************/


void getargs(char* rval)
{
  char tbuff[512];
  FILE* fptr;
  char* type;
  char *temp;
  char buff[512];
  int count = 0;
  int i=0;
  int j=0;



  sprintf(buff,"%s%s",getenv("HOME"),CONF_FILE);

  if((fptr = fopen(buff,"r")) == NULL)
    return; 

  /* get a count of the number of entries so we
   * know how large to make the array
   */
  
  while(!feof(fptr))
    {
      fgets(buff,512,fptr);
      if(buff[0] != '#' && buff[0] != '\n')
	count++;
    }
  
  /* allocate array */
  argarray = (argstruct**)malloc(sizeof(argstruct*)*count);
  /* reset file to begining */
  rewind(fptr);

  i = 0;
  while(!feof(fptr))
    {
      fgets(buff,512,fptr);
      
      if(buff[0] != '#' && buff[0] != '\n')
	{
	  strcpy(tbuff,buff);
	  count = 0;
	  strtok(buff," ");
	  do
	    count++;
	  while((char*)strtok(NULL," ") != NULL);
	  argarray[i] = (argstruct*)malloc(sizeof(argstruct));

	  /* allocate an array of size count-1, ommitting the 
	   * mime type and the extension
	   */
	  argarray[i]->arguments = (char**)malloc(sizeof(char*)*count);
	  
	  /* get the mimetype */
	  temp = (char*)strtok(tbuff," ");
	  argarray[i]->mimetype = (char*)malloc(strlen(temp)+1);
	  strcpy(argarray[i]->mimetype,temp);

	  /* get the extension */
	  temp = (char*)strtok(NULL," ");
	  argarray[i]->extension = (char*)malloc(strlen(temp)+1);
	  strcpy(argarray[i]->extension,temp);
	  
	  /* get the application and switches */
	  for(j=0;(temp = (char*)strtok(NULL," ")) != NULL;j++)
	    {
	      argarray[i]->arguments[j] = (char*)malloc(strlen(temp)+1);

	      if(temp[strlen(temp)-1] == '\n')
		temp[strlen(temp)-1] = '\0';
	      strcpy(argarray[i]->arguments[j],temp);
	    }
	  argarray[i]->arguments[j+1] = NULL;
	  argarray[i]->lastarg = j;
	  
	  /* increment array index */
	  i++;
	}
    }
  /* terminate with a NULL entry */
  argarray[i] = NULL;
  
  if(rval != NULL)
    {
      strcpy(rval,"");
    for(i=0;argarray[i] != NULL;i++)
	{
	  sprintf(tbuff,"%s:%s:%s;",
		  argarray[i]->mimetype,
		  argarray[i]->extension,
		  NAME);
	  strcat(rval,tbuff);
	}
    }
}

/************************************************************
this function cleans up any memory we may have allocated
************************************************************/

void cleanup()
{
  int i,j;
  
  for(i=0;i<argarray[i]->lastarg-2;i++)
    {
      free(argarray[i]->extension);
      free(argarray[i]->mimetype);
      for(j=0;argarray[i]->arguments[j] != NULL;j++)
	free(argarray[i]->arguments[j]);
    }
}


/**********************************************************************
this function is called when the about:plugins window is
instantiated.

this function appears to be undocumented
**********************************************************************/

char* NPP_GetMIMEDescription(void)
{
  char* rval = (char*)malloc(1024);
  getargs(rval);
  /*cleanup();*/
  return(rval);
}

/**********************************************************************
this function is also called when the about:plugins window is
instantiated.  The function is not documented except in npapi.h
**********************************************************************/


NPError NPP_GetValue(void *future,NPPVariable variable, void *value)
{
	NPError err = NPERR_NO_ERROR;

	switch (variable) {
		case NPPVpluginNameString:
			*((char **)value) = NAME;
			break;
		case NPPVpluginDescriptionString:
			*((char **)value) = PURPOSE;				
			break;
		default:
			err = NPERR_GENERIC_ERROR;
	}
	return err;
}



/**********************************************************************
this function is called when Netscape first initializes the plugin.
this is called only once before the first instantiation of the plugin.
**********************************************************************/

NPError NPP_Initialize(void)
{
  getargs(NULL);

  return NPERR_NO_ERROR;
}

jref NPP_GetJavaClass()
{
    return NULL;
}

/**********************************************************************
this function is called when Netscape destroys the plugin.
We will eventually free memory here and clean up after ourself
**********************************************************************/

void NPP_Shutdown(void)
{
cleanup();
}
/**********************************************************************
create a new instance of a plugin

REMARKS:
NPMIMEType is a char*.


**********************************************************************/


NPError NPP_New(NPMIMEType pluginType,NPP instance,uint16 mode,
				int16 argc,char** argn,char** argv,
				NPSavedData* saved)
{
  PluginInstance* This;
  int i;
  int j;
  char* temp;



  if (instance == NULL)
	return NPERR_INVALID_INSTANCE_ERROR;
		
  instance->pdata = NPN_MemAlloc(sizeof(PluginInstance));
	
  This = (PluginInstance*) instance->pdata;
  This->child = 0;
  
  
  for(i=0;i<argc;i++)
    {
    /* find the right tag */
      if(strcmp(argn[i],"SRC") == 0 || 
	 strcmp(argn[i],"src") == 0)
	{
	  temp = (char*)strtok(argv[i],".");
	  temp = (char*)strtok(NULL," ");

	  for(j=0;argarray[j] != NULL;j++)
	    {
	      if(strcmp(temp,argarray[j]->extension) == 0)
		{
		  This->mtype = j;
		return NPERR_NO_ERROR;
		}
	      
	    }
	}
    }
return NPERR_FILE_NOT_FOUND;

}


NPError 
NPP_Destroy(NPP instance, NPSavedData** save)
{
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;

	/* PLUGIN DEVELOPERS:
	 *	If desired, call NP_MemAlloc to create a
	 *	NPSavedDate structure containing any state information
	 *	that you want restored if this plugin instance is later
	 *	recreated.
	 */
	
	/* kill the child associated with this instance */

	kill(This->child,SIGINT);


	if (This != NULL) {
		NPN_MemFree(instance->pdata);
		instance->pdata = NULL;
		
	      }

	return NPERR_NO_ERROR;
}



NPError 
NPP_SetWindow(NPP instance, NPWindow* window)
{
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	if (window == NULL)
		return NPERR_NO_ERROR;

	This = (PluginInstance*) instance->pdata;

	/*
	 * PLUGIN DEVELOPERS:
	 *	Before setting window to point to the
	 *	new window, you may wish to compare the new window
	 *	info to the previous window (if any) to note window
	 *	size changes, etc.
	 */

	return NPERR_NO_ERROR;
}


NPError 
NPP_NewStream(NPP instance,
			  NPMIMEType type,
			  NPStream *stream, 
			  NPBool seekable,
			  uint16 *stype)
{
	NPByteRange range;
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;
	
	This = (PluginInstance*) instance->pdata;
	*stype = NP_ASFILEONLY;

	/* initialize child to 0 */
	This->child = 0;
	
	
	return NPERR_NO_ERROR;
}


/* PLUGIN DEVELOPERS:
 *	These next 2 functions are directly relevant in a plug-in which
 *	handles the data in a streaming manner. If you want zero bytes
 *	because no buffer space is YET available, return 0. As long as
 *	the stream has not been written to the plugin, Navigator will
 *	continue trying to send bytes.  If the plugin doesn't want them,
 *	just return some large number from NPP_WriteReady(), and
 *	ignore them in NPP_Write().  For a NP_ASFILE stream, they are
 *	still called but can safely be ignored using this strategy.
 */

int32 STREAMBUFSIZE = 0X0FFFFFFF; /* If we are reading from a file in NPAsFile
				   * mode so we can take any size stream in our
				   * write call (since we ignore it) */

int32 
NPP_WriteReady(NPP instance, NPStream *stream)
{
	PluginInstance* This;
	if (instance != NULL)
		This = (PluginInstance*) instance->pdata;

	return STREAMBUFSIZE;
}


int32 
NPP_Write(NPP instance, NPStream *stream, int32 offset, int32 len, void *buffer)
{
	if (instance != NULL)
	{
		PluginInstance* This = (PluginInstance*) instance->pdata;
	}
	return len;
	
}


NPError NPP_DestroyStream(NPP instance, NPStream *stream,
			  NPError reason)
{
  PluginInstance* This;
  
  if (instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;
  This = (PluginInstance*) instance->pdata;

  
  /************************************************************
    if the user clicked break, or there was 
    a problem close down the program
    ************************************************************/
  
  if(reason == NPRES_USER_BREAK || reason == NPRES_NETWORK_ERR)
    if(This->child != 0)
      kill(This->child,SIGINT);
  
  return NPERR_NO_ERROR;
}

/**********************************************************************

void NPP_StreamAsFile

This function is called when the plugin requests
**********************************************************************/

void  NPP_StreamAsFile(NPP instance, NPStream *stream, const char* fname)
{
  char buffer[256];
  int child;
  int i;

	PluginInstance* This;
	if (instance != NULL)
	  This = (PluginInstance*) instance->pdata;
 
  child = fork();
  if(child == 0)
    {
      /* this is done so netscape doesn't pop up the banner
       *  of helper functions like playmidi
       */
      
      fclose(stdout);
      fclose(stderr);
      argarray[This->mtype]->
	arguments[argarray[This->mtype]->lastarg] = (char*)fname;

      execv(argarray[This->mtype]->arguments[0],
		argarray[This->mtype]->arguments);
    }
  /* save the pid so we can kill it later */
  This->child = child;
}


void 
NPP_Print(NPP instance, NPPrint* printInfo)
{
  if(printInfo == NULL)
    return;

}











