/*
 *		guimidi.cpp
 *		timidity port for win32 'windows' mode
 *		based on timidity (Unix ) from Tuukka Toivonen and
 *		win32 console port from  Davide Moretti's 
 *		provided under GNU General Public License
 *	contents : 
 *    configuration through windows 'ini' file 
 * and timidity.cgf file , midi file lauching
 *    Nicolas Witczak mai 1996
 */

#ifdef __WIN95__


#include "win_inc.h"
#include "winhlp.h"
#include "guitimid.h"
#include "guimain.h"

#include "config.h"
#include "common.h"
#include "instrum.h"
#include "playmidi.h"
#include "readmidi.h"
#include "output.h"
#include "tables.h"
#include "controls.h"
#include "resource.h"
#include "win95ctl.h"

static char pszIntBuff[64];

#define GetIniStr(key,retStr,defaultStr) \
	(GetPrivateProfileString(TIMID_APP_NAME,(key),(defaultStr),(retStr)	\
		,sizeof(retStr),TIMID_INI_FILENAME) )

#define SetIniStr(key,newStr)	\
	WritePrivateProfileString(TIMID_APP_NAME,(key),(newStr),TIMID_INI_FILENAME)

#define GetIniInt(key,defaultInt) \
	( GetIniStr((key),(pszIntBuff),itoa((defaultInt),(pszIntBuff),10)),atoi(pszIntBuff) )

#define SetIniInt(key,newInt)	\
	SetIniStr(key,itoa(newInt,pszIntBuff,10))


//////////////////////////////////////////
// timidity additionnal config variables

char pszTimidCfgPath[szStringBuff] ; 
int iCtrlPerSecond ;

//////////////////////////////////////////
// timidity additionnal control variables
	//thread
BOOL bIsPlaying = FALSE ;
HANDLE hPlayThread = 0 ;
DWORD dwPlayThreadId = 0 ;
	// gui control
int iVolume = 0;
int iDeltaVolume =0 ; /* timidity ctrl request delta vol info*/

int iGUIWhishedState = RC_NONE ; /* user request are stored here 
and read by ctrl in timidity play loop */

	// midi file info
int iMidiFileTotalMin = 0;
int iMidiFileTotalSec = 0;
int iMidiFileCurMin = 0 ;
int iMidiFileCurSec = 0;
	//play list
char** ppszPlayList;
int cbFileInPlayList = 0 ;
int iCurPlayListIndex = 0;


//////////////////////////////////////////
// timidity.ini sections entry
#define CFG_FILE_NAME "CfgFileName"
#define CFG_PLAY_RATE "PlayRate"
#define CFG_ANTIALIAS "AntiAliasing" 
#define CFG_STEREO    "Stereo"
#define CFG_VOICES	 "Voices"

#define GFG_AMPLIFICATION "Amplification"
#define CFG_CBFRAGMENTS "FragmentNumber"
#define CFG_SZFRAGMENTS "FragmentSize"

#define GFG_FAST_DECAY "FastDecay"
#define CFG_CTRL_PER_SEC "CtrlPsec"
#define CFG_PROMPT_PANNING "PromptPanning"
#define CFG_DEFAULT_INST	"DefaultInst"
#define CFG_FREE_INSTR "FreeInst"

void
	InitOutPutMenu();

BOOL
	LoadTimidCfg()
	{
		BOOL isOk = TRUE ;
		BOOL bFlag ;
		GetIniStr(CFG_FILE_NAME,pszTimidCfgPath,CONFIG_FILE);
		if ( read_config_file( pszTimidCfgPath ) )	 
		{
			DisplayMessage("Unable to load instrument definition file");
			isOk = FALSE ;
		}
// sound rendering		
		play_mode->rate = GetIniInt( CFG_PLAY_RATE , DEFAULT_RATE);
		play_mode->extra_param[0] = GetIniInt( CFG_CBFRAGMENTS , 4 );
		antialiasing_allowed = GetIniInt( CFG_ANTIALIAS , 0 );
		
		GetIniInt(GFG_AMPLIFICATION,amplification);
		SetTrkBarVol(hVolumeTkBar,amplification);
		iVolume =  amplification ;

		bFlag = GetIniInt( CFG_STEREO , 1 ); 
		if(bFlag)  // stereo
			play_mode->encoding &= ~PE_MONO;	
		else
			play_mode->encoding |= PE_MONO;
// instruments rendering		
		fast_decay = GetIniInt( GFG_FAST_DECAY , 1 );
		iCtrlPerSecond = GetIniInt( CFG_CTRL_PER_SEC , CONTROLS_PER_SECOND );
		adjust_panning_immediately = GetIniInt(CFG_PROMPT_PANNING,adjust_panning_immediately);  
		if(iCtrlPerSecond <= 0)
			iCtrlPerSecond = CONTROLS_PER_SECOND ;
		control_ratio = play_mode->rate / iCtrlPerSecond ;
		GetIniStr(CFG_DEFAULT_INST,def_instr_name,"");
		voices = GetIniInt(CFG_VOICES,DEFAULT_VOICES);
// other
		amplification = GetIniInt( GFG_AMPLIFICATION , DEFAULT_AMPLIFICATION );
		free_instruments_afterwards = GetIniInt(CFG_FREE_INSTR,1);
		return  isOk;		
	}

BOOL
	SaveTimidCfg()
	{
		BOOL isOk = TRUE ;
		BOOL bFlag ;
		SetIniStr(CFG_FILE_NAME,pszTimidCfgPath);
		SetIniInt(CFG_PLAY_RATE,play_mode->rate);
		SetIniInt(CFG_CBFRAGMENTS,play_mode->extra_param[0]);
		if( play_mode->encoding & PE_MONO )
			bFlag = FALSE;
		else
			bFlag = TRUE ;
		SetIniInt(CFG_STEREO,bFlag );

		SetIniInt(CFG_ANTIALIAS,antialiasing_allowed);
		SetIniInt(GFG_AMPLIFICATION,amplification);
		
		SetIniInt(GFG_FAST_DECAY,fast_decay);
		SetIniInt(CFG_CTRL_PER_SEC,iCtrlPerSecond ) ;
		control_ratio = play_mode->rate / iCtrlPerSecond ;
 		SetIniInt(CFG_PROMPT_PANNING,adjust_panning_immediately );
		SetIniStr(CFG_FREE_INSTR,def_instr_name);
		SetIniInt(CFG_VOICES,voices);		
		SetIniInt(CFG_FREE_INSTR,free_instruments_afterwards );
		return isOk;
	}

BOOL
	LoadIniFile()
	{
		#define szINIBuff 1024
	   char pszINIBuff[szINIBuff];
		BOOL isOk = TRUE ;	
		return  isOk ;
	}

BOOL
	InitTimidity()
	{
		BOOL bOk = TRUE ;
		FILE* psTextIni;
		char pszAbsPathIniFile[MAX_PATH+32]; 
		int buffer_fragments=-1;
		int32 tmpi32, output_rate=DEFAULT_RATE;
		
// safely initialyse ctl struct
		InitWinGuiCtrlStruct(ctl);
	
		if(!LoadTimidCfg())
			DisplayMessage("Unable to load timidity95 configuration");

// create ini file if doesn't exist
		GetWindowsDirectory(pszAbsPathIniFile,MAX_PATH+32);
		strcat(pszAbsPathIniFile,"\\"TIMID_INI_FILENAME);
		if((psTextIni=fopen(pszAbsPathIniFile,"r"))==0)
			SaveTimidCfg();
		else
			fclose(psTextIni);

		init_tables();

		if (*def_instr_name)
			set_default_instrument(def_instr_name);
	
		//end debug
		
		return bOk;
	}

void
	CleanUpTimidity()
	{
		play_mode->close_output();
		ctl->close();
	}

void WINAPI  
	PlayList(LPVOID pvArg) // this is a thread
	{
		int iCtrlState = RC_NONE ;
		
		if(!bIsPlaying) // play the files 
		{
			bIsPlaying = TRUE ;
			while( (iCurPlayListIndex < cbFileInPlayList) 
				&& (iCurPlayListIndex >= 0) )
			{
				if(play_mode->open_output()<0)
				{
					DisplayMessage("Unable to open wave device");	
					iCurPlayListIndex = cbFileInPlayList;
				}
				iCtrlState = play_midi_file(ppszPlayList[iCurPlayListIndex]) ;
				play_mode->close_output();					
				switch(iCtrlState)
				{
					case RC_NONE :
					case RC_NEXT :
					case RC_TUNE_END:
					  iCurPlayListIndex++; 
					  break;
					case RC_PREVIOUS:
					case RC_REALLY_PREVIOUS:
						iCurPlayListIndex--;
						break;
					case RC_STOP:
						bIsPlaying = FALSE ;	
						_endthread();
					default:
						break;
				}				
			}
		}
		bIsPlaying = FALSE ;		
		iCurPlayListIndex = SatToRange(iCurPlayListIndex,0,cbFileInPlayList-1);
		_endthread();
	}



#endif /* __WIN95__ */

