/*
 *		guimidi.cpp
 *		timidity port for win32 'windows' mode
 *		based on timidity (Unix ) from Tuukka Toivonen and
 *		win32 console port from  Davide Moretti's 
 *		provided under GNU General Public License
 *	contents : 
 *    dialog box about , interresting messages
 *    configuration dialog
 *    Nicolas Witczak mai 1996
 */

#ifdef __WIN95__

#include "win_inc.h"

#include "timidlg.h"
#include "guitimid.h"
#include "config.h"
#include "common.h"
#include "instrum.h"
#include "playmidi.h"
#include "readmidi.h"
#include "output.h"
#include "controls.h"
#include "tables.h"

#include "winhlp.h"
#include "guimain.h"

#include "resource.h"


LRESULT 
	MessageDlgProc(HWND  hDlg,UINT msg,WPARAM wParam,LPARAM lParam)	
	{	
		switch(msg)
		{
			HANDLE_MSG(hDlg,WM_COMMAND,MessageCmdProc);			
			case WM_CLOSE:
				EndDialog(hDlg,TRUE);
			default:
				DefWindowProc(hDlg,msg,wParam,lParam);
		}
		return FALSE ;
	}

void
	MessageCmdProc(HWND hDlg, int id, HWND hwndCtl, UINT codeNotify)
	{
		switch(id)
		{			
			case IDOK:
			case IDCANCEL:
				EndDialog(hDlg,TRUE);	
		}
	}

char pszConfigPathBuff[szStringBuff];
char pszBuffer[32];

LRESULT 
	GenConfDlgProc(HWND  hDlg,UINT msg,WPARAM wParam,LPARAM lParam)	
	{	
		switch(msg)
		{
			HANDLE_MSG(hDlg,WM_COMMAND,GenConfCmdProc);
			HANDLE_MSG(hDlg,WM_INITDIALOG,GenConfDlgOnInit);
			case WM_CLOSE:
				EndDialog(hDlg,TRUE);
			default:
				DefWindowProc(hDlg,msg,wParam,lParam);
		}
		return FALSE ;
	}

void
	OnPressBrowsePath(HWND hDlg)
	{
		DlgFileOpen("Timidity95 config file path",pszConfigPathBuff,szStringBuff);
		SetDlgItemText(hDlg,IDE_TIMIDCFGPATH,pszConfigPathBuff);
		return ;	
	}

BOOL 
	GenConfDlgOnInit(HWND hDlg, HWND hwndFocus, LPARAM lParam)
	{
		SetDlgItemText(hDlg,IDE_TIMIDCFGPATH,pszTimidCfgPath);
		SetDlgItemText(hDlg,IDE_VOLUME,itoa(amplification,pszBuffer,10));
		
		if(free_instruments_afterwards)
			CheckDlgButton(hDlg,IDC_FREEINSTR,1);
		else
			CheckDlgButton(hDlg,IDC_FREEINSTR,0);
	}

void
	GenConfDlgOnExitOk(HWND hDlg)
	{
		int iTmp ;
		GetDlgItemText(hDlg,IDE_TIMIDCFGPATH,pszConfigPathBuff,szStringBuff);
		if(strcmp(pszTimidCfgPath,pszConfigPathBuff) != 0 )
		{
			if ( read_config_file( pszConfigPathBuff ) )	 
				DisplayMessage("Unable to load instrument definition file");
			else
				strcpy(pszTimidCfgPath,pszConfigPathBuff);
		}

		GetDlgItemText(hDlg,IDE_VOLUME,pszBuffer,sizeof(pszBuffer));
		iTmp = atoi(pszBuffer);
		amplification = SatToRange(iTmp,1,MAX_AMPLIFICATION); 
		SetTrkBarVol(hVolumeTkBar,amplification);
		iVolume =  amplification ;
		iDeltaVolume =0 ;

		if(IsDlgButtonChecked(hDlg,IDC_FREEINSTR) ==	1)
			free_instruments_afterwards = 1 ;
		else
			free_instruments_afterwards = 0 ;
		SaveTimidCfg() ;
	}


void
	GenConfCmdProc(HWND hDlg, int id, HWND hwndCtl, UINT codeNotify)
	{
		switch(id)
		{			
			case IDB_GETCFGPATH:
				OnPressBrowsePath(hDlg);
				break;
			case IDOK:
				GenConfDlgOnExitOk(hDlg);
			case IDCANCEL:
				EndDialog(hDlg,TRUE);	
		}
	}

static char pszOutputPath[szStringBuff] ;

LRESULT 
	OutputConfDlgProc(HWND  hDlg,UINT msg,WPARAM wParam,LPARAM lParam)	
	{	
		switch(msg)
		{
			HANDLE_MSG(hDlg,WM_COMMAND,OutputConfCmdProc);
			HANDLE_MSG(hDlg,WM_INITDIALOG,OutputConfDlgOnInit);
			case WM_CLOSE:
				EndDialog(hDlg,TRUE);
			default:
				DefWindowProc(hDlg,msg,wParam,lParam);
		}
		return FALSE ;
	}

BOOL 
	OutputConfDlgOnInit(HWND hDlg, HWND hwndFocus, LPARAM lParam)
	{
		if( play_mode->id_character != 'd' )
		{	/* assume audio driver -> no output file */
			strcpy(pszOutputPath,play_mode->name);
			SetDlgItemText(hDlg,IDE_OUTPUTPATH,pszOutputPath);			
		}
		else
		{
			ShowWindow(GetDlgItem(hDlg,IDE_OUTPUTPATH),SW_HIDE);
			ShowWindow(GetDlgItem(hDlg,IDB_GETOUTPUTPATH),SW_HIDE);
		}
		SetWindowText(hDlg , play_mode->id_name ) ;
		SetDlgItemText(hDlg,IDE_SAMPLERATE,itoa(play_mode->rate,pszBuffer,10));
		SetDlgItemText(hDlg,IDE_CBFRGMT,itoa(play_mode->extra_param[0],pszBuffer,10));
		
		if(antialiasing_allowed)
			CheckDlgButton(hDlg,IDC_ANTIALIASING,1);
		else
			CheckDlgButton(hDlg,IDC_ANTIALIASING,0);
		
		if(play_mode->encoding & PE_MONO)
			CheckRadioButton(hDlg,IDR_MONO,IDR_STEREO,IDR_MONO);
		else
			CheckRadioButton(hDlg,IDR_MONO,IDR_STEREO,IDR_STEREO);			
	
		if(play_mode->encoding & PE_16BIT)
			CheckRadioButton(hDlg,IDR_16BIT,IDR_8BIT,IDR_16BIT);
		else
			CheckRadioButton(hDlg,IDR_16BIT,IDR_8BIT,IDR_8BIT);	
	}

void
	OutputConfDlgOnExitOk(HWND hDlg)
	{
		int iTmp ;
		GetDlgItemText(hDlg,IDE_SAMPLERATE,pszBuffer,sizeof(pszBuffer));
		iTmp = atoi(pszBuffer);
		play_mode->rate = SatToRange(iTmp,MIN_OUTPUT_RATE,MAX_OUTPUT_RATE); 

		GetDlgItemText(hDlg,IDE_CBFRGMT,pszBuffer,sizeof(pszBuffer));
		iTmp = atoi(pszBuffer);
		play_mode->extra_param[0] = SatToRange(iTmp,2,32); 
		
		GetDlgItemText(hDlg,IDE_OUTPUTPATH,pszOutputPath,sizeof(pszBuffer) ) ;
		play_mode->name = pszOutputPath ;
		
		if(IsDlgButtonChecked(hDlg,IDC_ANTIALIASING) == 1)
			antialiasing_allowed = 1 ;
		else
			antialiasing_allowed = 0 ;

		if(IsDlgButtonChecked(hDlg,IDR_MONO) == 1)
			play_mode->encoding |= PE_MONO;
		else
			play_mode->encoding &= ~PE_MONO;		
		
		if(IsDlgButtonChecked(hDlg,IDR_16BIT) == 1)
			play_mode->encoding |= PE_16BIT;
		else
			play_mode->encoding &= ~PE_16BIT;		
							
		SaveTimidCfg() ;
	}

void
	OutputConfOnPressPath(HWND hDlg)
	{
		DlgFileOpen("Output file path",pszOutputPath,szStringBuff);
		SetDlgItemText(hDlg,IDE_OUTPUTPATH,pszOutputPath);
		return ;	
	}

void
	OutputConfCmdProc(HWND hDlg, int id, HWND hwndCtl, UINT codeNotify)
	{
		switch(id)
		{			
			case IDB_GETOUTPUTPATH:
				OutputConfOnPressPath(hDlg);
				break;
			case IDOK:
				OutputConfDlgOnExitOk(hDlg);
			case IDCANCEL:
				EndDialog(hDlg,TRUE);	
		}
	}


LRESULT 
	MidiConfDlgProc(HWND  hDlg,UINT msg,WPARAM wParam,LPARAM lParam)	
	{	
		switch(msg)
		{
			HANDLE_MSG(hDlg,WM_COMMAND,MidiConfCmdProc);
			HANDLE_MSG(hDlg,WM_INITDIALOG,MidiConfDlgOnInit);	
			case WM_CLOSE:
				EndDialog(hDlg,TRUE);
			default:
				DefWindowProc(hDlg,msg,wParam,lParam);
		}
		return FALSE ;
	}

BOOL 
	MidiConfDlgOnInit(HWND hDlg, HWND hwndFocus, LPARAM lParam)
	{
		SetDlgItemText(hDlg,IDE_CTRLRATE,itoa(iCtrlPerSecond,pszBuffer,10));
		SetDlgItemText(hDlg,IDE_CBVOICE,itoa(voices,pszBuffer,10));
		if(fast_decay)
			CheckDlgButton(hDlg,IDC_FASTDECAY,1);
		else
			CheckDlgButton(hDlg,IDC_FASTDECAY,0);
		if(adjust_panning_immediately)
			CheckDlgButton(hDlg,IDC_FASTPANNING,1);
		else
			CheckDlgButton(hDlg,IDC_FASTPANNING,0);
	}

void
	MidiConfDlgOnMidiChnls(HWND hDlg)
	{
		DialogBox(hInst,MAKEINTRESOURCE(DLG_MIDICHANNELS),hMainWnd,
			MakeProcInstance((FARPROC)(&MidiChnlDlgProc),hInst));		
	}

void
	MidiConfDlgOnExitOk(HWND hDlg)
	{
		int iTmp ;
		
		GetDlgItemText(hDlg,IDE_CTRLRATE,pszBuffer,sizeof(pszBuffer));
		iTmp = atoi(pszBuffer);
		if(iTmp <= 0)
			iTmp = CONTROLS_PER_SECOND ;
		control_ratio = play_mode->rate / iTmp ;
		control_ratio = SatToRange(control_ratio, 1, MAX_CONTROL_RATIO ); 
		iCtrlPerSecond = play_mode->rate / control_ratio ;

		GetDlgItemText(hDlg,IDE_CBVOICE,pszBuffer,sizeof(pszBuffer));
		iTmp = atoi(pszBuffer);
		voices = SatToRange(iTmp,1, MAX_VOICES);

		if(IsDlgButtonChecked(hDlg,IDC_FASTDECAY) == 1)
			fast_decay = 1;
		else
			fast_decay = 0;		

		if(IsDlgButtonChecked(hDlg,IDC_FASTPANNING) == 1)
			adjust_panning_immediately = 1;
		else
			adjust_panning_immediately = 0;

		SaveTimidCfg() ;
	}



void
	MidiConfCmdProc(HWND hDlg, int id, HWND hwndCtl, UINT codeNotify)
	{
		switch(id)
		{			
			case IDB_MIDICHNLS:
				MidiConfDlgOnMidiChnls(hDlg);
				break;
			case IDOK:
				MidiConfDlgOnExitOk(hDlg);
			case IDCANCEL:
				EndDialog(hDlg,TRUE);	
		}
	}


LRESULT 
	MidiChnlDlgProc(HWND  hDlg,UINT msg,WPARAM wParam,LPARAM lParam)
	{
		switch(msg)
		{
			HANDLE_MSG(hDlg,WM_COMMAND,MidiChnlCmdProc);
			HANDLE_MSG(hDlg,WM_INITDIALOG,MidiChnlDlgOnInit);	
			case WM_CLOSE:
				EndDialog(hDlg,TRUE);
			default:
				DefWindowProc(hDlg,msg,wParam,lParam);
		}
		return FALSE ;
	}

BOOL 
	MidiChnlDlgOnInit(HWND hDlg, HWND hwndFocus, LPARAM lParam)
	{
		int iDx ;
		for(iDx = 0 ; iDx < 15  ; iDx++ )
		{
			if( quietchannels & (1 << iDx) )
				CheckDlgButton(hDlg,IDC_QUIET1+iDx,1);
			else
				CheckDlgButton(hDlg,IDC_QUIET1+iDx,0);
		}
		for(iDx = 0 ; iDx < 15  ; iDx++ )
		{
			if( drumchannels & (1 << iDx) )
				break ;
		}
		CheckRadioButton(hDlg,IDR_DRUMCHNL1,IDR_DRUMCHNL16,IDR_DRUMCHNL1+iDx);							
	}

void
	MidiChnlDlgOnExitOk(HWND hDlg)
	{
		int iDx ;
		for(iDx = 0 ; iDx < 15  ; iDx++ )
		{
			if( IsDlgButtonChecked(hDlg,IDC_QUIET1 + iDx ) == 1 )
				quietchannels |= ( 1 << iDx);
			else
				quietchannels &= (~( 1 << iDx));
			if( IsDlgButtonChecked(hDlg,IDR_DRUMCHNL1 + iDx ) == 1 )
			  drumchannels = ( 1 << iDx ) ;
		}
	}

void
	MidiChnlCmdProc(HWND hDlg, int id, HWND hwndCtl, UINT codeNotify)
	{
		switch(id)
		{			
			case IDOK:
				MidiChnlDlgOnExitOk(hDlg);
			case IDCANCEL:
				EndDialog(hDlg,TRUE);	
		}
	}


#endif /* __WIN95__ */

