#include "stdafx.h"

#include "mfceditor.h"


CMFCEditor::CMFCEditor(int id, CRuntimeClass * pClass, CMidiEffect* plugin) 
	: CPluginView(NULL) // editor size is described in gui.xml
{
	m_id = id;
	m_pClass = pClass;
	m_pDlg = NULL;
	m_pPlugin = plugin;

}

//-----------------------------------------------------------------------------
tresult PLUGIN_API CMFCEditor::attached (void* parent)
{
	CPluginView::attached (parent);

	//create the object of the runtime class
	CObject * pObject = m_pClass->CreateObject();
	
	if (pObject->IsKindOf(m_pClass))
	{
		m_pDlg = (CDialog *)pObject;
		m_pDlg->Create(m_id,CWnd::FromHandle((HWND)parent));
		m_pDlg->ShowWindow(SW_SHOW);
		m_pDlg->UpdateWindow();
	}

	return kResultOk;
}


//-----------------------------------------------------------------------------

tresult PLUGIN_API CMFCEditor::removed()
{
	if (m_pDlg != NULL)
	{
		m_pDlg->DestroyWindow();
		delete m_pDlg;
		m_pDlg = NULL;
	}

	return CPluginView::removed();
}