#include "stdafx.h"

#define INIT_CLASS_IID

#include "pluginfactory.h"


#include "mfcsample.h"
#include "plugindlg.h"
#include "mfceditor.h"



CResourceID gEditorResourceID(1, "gui.xml");

PFactoryInfo factoryInfo =
{
	"John Melas",							// company name here
	"http://www.softlab.ntua.gr/~jmelas",	// company website
	"mailto:jmelas@mail.ntua.gr",			// e-mail (currently not displayed in PlugIn Information)
	PFactoryInfo::kNoFlags		  			// (default)
};

PClassInfo pluginClass =
{
	INLINE_UID(0x4448de5f, 0xa4f63243, 0x9af43413, 0x3c9afa25),

	PClassInfo::kManyInstances,		// multiple instances of the plugin are allowed
									// (currently ignored, always set to kManyInstances)

	"Midi Module Class",				// this identifies the plugin as MIDI Effect
	"Midi MFC SDK Sample"					// plugin name visible to the user
};



IPluginFactory* PLUGIN_API GetPluginFactory()
{
//	AFX_MANAGE_STATE(AfxGetStaticModuleState());
	if (!gPluginFactory)
	{
		gPluginFactory = new CPluginFactory(factoryInfo);
		// register all exported classes here:
		gPluginFactory->registerClass(&pluginClass, CMfcSample::createInstance, pluginClass.cid);
	}
	else
		gPluginFactory->addRef();

	return gPluginFactory;
}


CMfcSample::CMfcSample(const char* storageUID) : CMidiEffect(storageUID)
{

	// Some configuration...
	flags = kMEIsEditable;		// Yes, we have an editor
	// (set kMEHasInspector if you have an inspector view, too)

	setResourceID(gEditorResourceID); // Set editor resource identifier
}


tresult PLUGIN_API CMfcSample::createView(const char* name, ViewRect* rect, IPlugView** view)
{
	if(editor && !editor->isAttached () && !strcmp (name, "MFC_VIEW"))
	{
		if(rect)
			editor->setRect (*rect);

		*view = editor;
		editor->addRef (); // because the host will release it later
		return kResultTrue;
	}

	return kResultFalse;
}


tresult PLUGIN_API CMfcSample::initialize (FUnknown* context)
{
	tresult result = CMidiEffect::initialize (context);
	if(result != kResultOk)
		return result;

	//can play in stop
	accessor->setCanPlayInStop(true);

	//create MFC editor that holds our dialog and its class
	editor = new CMFCEditor(IDD_DIALOG,RUNTIME_CLASS(CPluginDlg),this);
	
	return kResultOk;
}

//------------------------------------------------------------------------
tresult PLUGIN_API CMfcSample::terminate ()
{
	if(editor)
		editor->release ();
	editor = 0;

	// base class needs to do some cleanup, too
	return CMidiEffect::terminate ();
}

