#pragma once

/*************************************************************
 *															 *
 * CMfcSample												 *
 *															 *
 * Implements a Minimal MidiEffect plugin using the MFC      *
 * extension of the VST-MA SDK                               *
 *															 *
 * Author: John Melas (March 2005)				             *
 * jmelas@mail.ntua.gr										 *
 *															 *
 *************************************************************/



#include "../resource/resource.h"
#include "midieffect.h"
#include "mfceditor.h"


class CMfcSample : public CMidiEffect
{

public:

	
	CMfcSample(const char* storageUID = 0);
	
	//required for plugin factory,
	static FUnknown* createInstance (void* context)
	{
		return (IMidiEffect*)new CMfcSample((char*)context);
	}


	tresult PLUGIN_API createView(const char* name, ViewRect* rect, IPlugView** view);

	tresult PLUGIN_API initialize(FUnknown* _context);
	tresult PLUGIN_API terminate();


protected:

	CMFCEditor* editor;
};
