#include <stdio.h>
#include <string.h>
#include <windows.h>
#include <sapi.h>

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCommandLine, int cmdShow)
{
	SYSTEM_POWER_STATUS status;
	ZeroMemory(&status, sizeof(status));
	GetSystemPowerStatus(&status);
	if (status.BatteryFlag & 128)
	{
		MessageBox(NULL, "No system battery found!", "Error", MB_ICONERROR);
		return 0;
	}
	ISpVoice * pVoice;
	::CoInitialize(NULL);
	pVoice = NULL;
	CoCreateInstance(CLSID_SpVoice, NULL, CLSCTX_ALL, IID_ISpVoice, (void **)&pVoice);
	wchar_t text[MAX_PATH];
	ZeroMemory(text, sizeof(text));
	swprintf(text, L"BatteryTalk started.\n");
	pVoice->Speak(text, SPF_PURGEBEFORESPEAK, NULL);
	BYTE SpokenACLineStatus = 0xff;
	BYTE SpokenBatteryFlag = 0xff;
	BYTE SpokenBatteryLifePercent = 0xff;
	while(true)
	{
		Sleep(5);
		GetSystemPowerStatus(&status);
		if (status.ACLineStatus != SpokenACLineStatus)
		{
			ZeroMemory(text, sizeof(text));
			if (status.ACLineStatus == 0)
			{
				swprintf(text, L"Not charging battery.");
			}
			else if (status.ACLineStatus == 1)
			{
				swprintf(text, L"Charging battery.");
			}
			pVoice->Speak(text, SPF_PURGEBEFORESPEAK, NULL);
			SpokenACLineStatus = status.ACLineStatus;
		}
		if (status.BatteryFlag != SpokenBatteryFlag)
		{
			ZeroMemory(text, sizeof(text));
			if (status.BatteryFlag == 0)
			{
				swprintf(text, L"Battery capacity OK.");
			}
			else if (status.BatteryFlag & 1)
			{
				swprintf(text, L"Battery capacity is high.");
			}
			else if (status.BatteryFlag & 2)
			{
				swprintf(text, L"Battery capacity is low.");
			}
			else if (status.BatteryFlag & 4)
			{
				swprintf(text, L"Battery capacity is critical.");
			}
			else if (status.BatteryFlag & 8)
			{
				swprintf(text, L"Battery is charging.");
			}
			pVoice->Speak(text, SPF_PURGEBEFORESPEAK, NULL);
			SpokenBatteryFlag = status.BatteryFlag;
		}
		if (status.BatteryLifePercent != SpokenBatteryLifePercent)
		{
			ZeroMemory(text, sizeof(text));
			swprintf(text, L"Battery Is %d%% full.", status.BatteryLifePercent);
			if (status.BatteryLifePercent == 15)
			{
				Beep(440,125);
			}
			if (status.BatteryLifePercent == 100 || status.BatteryLifePercent == 75 || status.BatteryLifePercent == 50 || status.BatteryLifePercent == 25 || status.BatteryLifePercent == 15)
			{
				pVoice->Speak(text, SPF_PURGEBEFORESPEAK, NULL);
				SpokenBatteryLifePercent = status.BatteryLifePercent;
			}
		}
	}
	pVoice->Release();
	pVoice = NULL;
	::CoUninitialize();
	return 0;
}
