/*
* Title: sitemap.c
* Author: Bob Crispen
* Date: 23 August 1997
*
* Takes the output of swish (index, -v3) cleaned up so it
* contains left-justified lines of two types:
*   (a) A left-justified directory name
*   (b) A left-justified filename
* and converts it to a site map in HTML
*
* This code is available under the Gnu General Public License.
*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#define DIRPREFIX "/data2/Lkr_Usr_/crispen/public_html/"
#define URLPREFIX "http://hiwaay.net/~crispen/"
#define DIRICON "../imgs/menu.gif"
#define SRCURL "http://hiwaay.net/~crispen/src/sitemap.tar.gz"

/* Number of slashes in DIRPREFIX */
#define BASEDEPTH 5

char *months[12] = {
    "January", "February", "March", "April", "May", "June", "July",
    "August", "September", "October", "November", "December"
};

main()
{
    char buf[1000];
    int c, i, l, bufptr=0;
    int newdepth, depth = BASEDEPTH;
    int first=1;
    char pathname[500];
    char dirname[500];
    char urlname[500];
    char urlpath[500];
    FILE *webfile;
    time_t nowRaw;
    struct tm *now;

    nowRaw = time(NULL);
    now = localtime(&nowRaw);
    printf("<html>\n<head>\n<title>Site Map %d/%d/%d %d:%2.2d:%2.2d</title>\n",
	now->tm_mon+1, now->tm_mday, now->tm_year+1900,
	now->tm_hour, now->tm_min, now->tm_sec);
    printf("<base target=\"_top\">\n</head>\n");
    printf("<body bgcolor=\"#ffffff\">\n");
    printf("<center>\n<h2>Site Map<br>\n");
    printf("%s %d, %d %d:%2.2d:%2.2d</h2>\n</center>\n",
	months[now->tm_mon], now->tm_mday, now->tm_year+1900,
	now->tm_hour, now->tm_min, now->tm_sec);
    while ((c=getc(stdin)) != EOF) {
	buf[bufptr++] = c;
	if (c == '\n') {
	    buf[bufptr-1] = '\0';
	    for (i=bufptr-2; isspace(buf[i]); --i)
		buf[i] = '\0';
	    if (buf[0] == '/') {
		memchr(dirname, 0, sizeof dirname);
		strcpy (dirname, buf);
		memchr(urlname, 0, sizeof urlname);
		strcpy(urlname, URLPREFIX);
		strcat(urlname, &buf[strlen(DIRPREFIX)]);
		newdepth = 0;
		for (i=0; buf[i] != '\0'; i++) {
		    if (buf[i] == '/')
			newdepth++;
		}
		if (first) {
		    for (i=BASEDEPTH; i<newdepth; i++)
			printf("<ul>\n");
		    first = 0;
		}
		for (i=BASEDEPTH; i<depth; i++)
		    printf ("</ul>\n");
		for (i=BASEDEPTH; i<newdepth-1; i++)
		    printf ("<ul>\n");
		printf ("<li> <img src=\"%s\"> %s\n\n",
		    DIRICON, urlname);
		printf("<ul>\n");
		depth = newdepth;
	    } else {
		memchr(pathname, 0, sizeof pathname);
		strcpy(pathname, dirname);
		strcat(pathname, buf);
		memchr(urlpath, 0, sizeof urlpath);
		strcpy(urlpath, urlname);
		strcat(urlpath, buf);
		l = strlen(buf);
		printf("<li> ");
		printf ("<a href=\"%s\">%s</a>", urlpath, buf);
		if ((!strncmp(&buf[l-5], ".html", 5)) ||
		    (!strncmp(&buf[l-4], ".htm", 4))) {
		    if ((webfile = fopen(pathname, "r")) <= 0) {
			fprintf(stderr, "Can't open %s\n", pathname);
			exit(-1);
		    }
		    printf(" - ");
		    titleline(webfile);
		    fclose(webfile);
		}
		printf("\n");
	    }
	    bufptr=0;
	    memchr(buf, 0, sizeof buf);
	}
    }
    for (i=BASEDEPTH; i<depth; i++)
	printf ("</ul>\n");
    printf("<p>You can get the source code to make a site map for your\n");
    printf("own site here: <a href=\"%s\">sitemap.tar.gz</a>.\n",
	SRCURL);
    printf("<i>Note:</i> Requires the SWISH index engine.\n");
    printf("</body>\n</html>\n");
}


/*
* Finds the <title> </title> string in an HTML file and prints it
* or (if none found) prints "No title line"
*/
titleline(FILE *webfile)
{
    char buf2[1000];
    char *token;
    char *tokptr;
    int c, i, l, bufptr=0;

    while ((c=getc(webfile)) != EOF) {
	buf2[bufptr++] = c;
	if (c == '\n') {
	    buf2[bufptr] = '\0';
	    tokptr = &buf2[0];
	    while ((token = strtok(tokptr, "> \t\n\0")) != NULL) {
		tokptr = NULL;
		prettify(token);
		if (!strcmp(token, "<title")) {
		    if ((token = strtok(NULL, "\n\0")) != NULL) {
			l = strlen(token);
			for (i=0; i<l; i++) {
			    if (token[i] == '<') {
				return;
			    }
			    if (token[i] != '\n')
				putc(token[i], stdout);
			}
		    }
		    while ((c=getc(webfile)) != EOF) {
			if (c == '<') {
			    return;
			}
			if (c != '\n')
			    putc(c, stdout);
		    }
		}
	    }
	    bufptr=0;
	}
    }
    printf("(No title line)");
}



prettify(char* token)
{
    int i, l;
    l = strlen(token);
    for (i=0; i<l; i++) {
	if (isupper(token[i]))
	    token[i] = tolower(token[i]);
    }
}
