------------------------------------------------------------------------------
-- Unit Name:   Abbreviations
-- Unit Type:   package spec
-- Source File: abbreviations.adb
-- Author:      Bob Crispen <crispen@hiwaay.net>
-- Date:        19 April 1996
-- Purpose:
-- External Unit Declarations: None
-- Visibility Declarations: None
-- Unit Declaration:
--
package Abbreviations is
--
-- Exceptions Raised: None
--
-- This software is provided under the terms of the Gnu General Public
-- License
------------------------------------------------------------------------------

   ---------------------------------------------------------------------------
   -- Convert_To_Mixed_Case
   ---------------------------------------------------------------------------
   -- Purpose:
   --  Take a token, which is an identifier and may contain underscores,
   --  and break it up into sub-tokens at the underscores.  Check each
   --  sub-token against the list of valid abbreviations approved for
   --  this program (found in the body of this package).  If it's on the
   --  list, use the capitalization in the list of abbreviations.  Otherwise, 
   --  capitalize the first letter of the subtoken and leave the other
   --  characters in lower case.  This subprogram expects the token to be
   --  in all lowercase.
   ---------------------------------------------------------------------------
   procedure Convert_To_Mixed_Case (Token : in out String);

end Abbreviations;
