------------------------------------------------------------------------------
-- Unit Name:   Keywords
-- Unit Type:   package body
-- Source File: keywords.adb
-- Author:      Bob Crispen <crispen@hiwaay.net>
-- Date:        19 April 1996
-- Implementation Notes:
--  Any string that is compared with one of the keywords on our list has
--  to be in lowercase.
-- External Unit Declarations: None
-- Visibility Declarations: None
-- Unit Declaration:
--
package body Keywords is
--
-- Exceptions Raised: None
--
-- This software is provided under the terms of the Gnu General Public
-- License
------------------------------------------------------------------------------

   type String_Access is access String;
   Reserved_Words : constant array(1..69) of String_Access := (
      new String'("abort"),
      new String'("abs"),
      new String'("abstract"),
      new String'("accept"),
      new String'("access"),
      new String'("aliased"),
      new String'("all"),
      new String'("and"),
      new String'("array"),
      new String'("at"),
      new String'("begin"),
      new String'("body"),
      new String'("case"),
      new String'("constant"),
      new String'("declare"),
      new String'("delay"),
      new String'("delta"),
      new String'("digits"),
      new String'("do"),
      new String'("else"),
      new String'("elsif"),
      new String'("end"),
      new String'("entry"),
      new String'("exception"),
      new String'("exit"),
      new String'("for"),
      new String'("function"),
      new String'("generic"),
      new String'("goto"),
      new String'("if"),
      new String'("in"),
      new String'("is"),
      new String'("limited"),
      new String'("loop"),
      new String'("mod"),
      new String'("new"),
      new String'("not"),
      new String'("null"),
      new String'("of"),
      new String'("or"),
      new String'("others"),
      new String'("out"),
      new String'("package"),
      new String'("pragma"),
      new String'("private"),
      new String'("procedure"),
      new String'("protected"),
      new String'("raise"),
      new String'("range"),
      new String'("record"),
      new String'("rem"),
      new String'("renames"),
      new String'("requeue"),
      new String'("return"),
      new String'("reverse"),
      new String'("select"),
      new String'("separate"),
      new String'("subtype"),
      new String'("tagged"),
      new String'("task"),
      new String'("terminate"),
      new String'("then"),
      new String'("type"),
      new String'("until"),
      new String'("use"),
      new String'("when"),
      new String'("while"),
      new String'("with"),
      new String'("xor"));

   Attributes : constant array (1..84) of String_Access := (
      new String'("access"),
      new String'("address"),
      new String'("adjacent"),
      new String'("aft"),
      new String'("alignment"),
      new String'("base"),
      new String'("bit_order"),
      new String'("body_version"),
      new String'("callable"),
      new String'("caller"),
      new String'("ceiling"),
      new String'("class"),
      new String'("component_size"),
      new String'("compose"),
      new String'("constrained"),
      new String'("copy_sign"),
      new String'("count"),
      new String'("definite"),
      new String'("delta"),
      new String'("denorm"),
      new String'("digits"),
      new String'("exponent"),
      new String'("external_tag"),
      new String'("first"),
      new String'("first_bit"),
      new String'("floor"),
      new String'("fore"),
      new String'("fraction"),
      new String'("identity"),
      new String'("image"),
      new String'("input"),
      new String'("last"),
      new String'("last_bit"),
      new String'("leading_part"),
      new String'("length"),
      new String'("machine"),
      new String'("machine_emax"),
      new String'("machine_emin"),
      new String'("machine_mantissa"),
      new String'("machine_overflows"),
      new String'("machine_radix"),
      new String'("machine_rounds"),
      new String'("max"),
      new String'("max_size_in_storage_elements"),
      new String'("min"),
      new String'("model"),
      new String'("model_emin"),
      new String'("model_epsilon"),
      new String'("model_mantissa"),
      new String'("model_small"),
      new String'("modulus"),
      new String'("output"),
      new String'("partition_id"),
      new String'("position"),
      new String'("pred"),
      new String'("range"),
      new String'("read"),
      new String'("remainder"),
      new String'("round"),
      new String'("rounding"),
      new String'("safe_first"),
      new String'("safe_last"),
      new String'("scale"),
      new String'("scaling"),
      new String'("signed_zeros"),
      new String'("size"),
      new String'("small"),
      new String'("storage_pool"),
      new String'("storage_size"),
      new String'("succ"),
      new String'("tag"),
      new String'("terminated"),
      new String'("truncation"),
      new String'("unbiased_rounding"),
      new String'("unchecked_access"),
      new String'("val"),
      new String'("valid"),
      new String'("value"),
      new String'("version"),
      new String'("wide_image"),
      new String'("wide_value"),
      new String'("wide_width"),
      new String'("width"),
      new String'("write"));

   ---------------------------------------------------------------------------
   -- Is_Reserved_Word
   ---------------------------------------------------------------------------
   -- Implementation Notes:
   --  The input string is a lower-case token with no extra parens or other
   --  punctuation.
   ---------------------------------------------------------------------------
   function Is_Reserved_Word (Token : String) return Boolean is
   begin
      for Each_Word in Reserved_Words'RANGE loop
         if Token = Reserved_Words(Each_Word).all then
            return True;
         end if;
      end loop;
      return False;
   end Is_Reserved_Word;


   ---------------------------------------------------------------------------
   -- Is_Attribute
   ---------------------------------------------------------------------------
   -- Implementation Notes:
   --  The input string is a lower-case token with no extra parens or other
   --  punctuation.
   ---------------------------------------------------------------------------
   function Is_Attribute (Token : String) return Boolean is
   begin
      for Each_Word in Attributes'RANGE loop
         if Token = Attributes(Each_Word).all then
            return True;
         end if;
      end loop;
      return False;
   end Is_Attribute;

end Keywords;
