------------------------------------------------------------------------------
-- Unit Name:   Keywords
-- Unit Type:   package spec
-- Source File: keywords.ads
-- Author:      Bob Crispen <crispen@hiwaay.net>
-- Date:        19 April 1996
-- Purpose:
-- External Unit Declarations: None
-- Visibility Declarations: None
-- Unit Declaration:
--
package Keywords is
--
-- Exceptions Raised: None
--
-- This software is provided under the terms of the Gnu General Public
-- License
------------------------------------------------------------------------------

   ---------------------------------------------------------------------------
   -- Is_Reserved_Word
   ---------------------------------------------------------------------------
   -- Purpose:
   --  See if the token is one of Ada 95's reserved words.
   ---------------------------------------------------------------------------
   function Is_Reserved_Word (Token : String) return Boolean;


   ---------------------------------------------------------------------------
   -- Is_Attribute
   ---------------------------------------------------------------------------
   -- Purpose:
   --  See if the token is one of Ada 95's predefined attributes
   -- Implementation Notes:
   --  The input string is a lower-case token with no extra parens or other
   --  punctuation.
   ---------------------------------------------------------------------------
   function Is_Attribute (Token : String) return Boolean;

end Keywords;
