/*
* build_page.c
* by Bob Crispen
* 27 July 1997
* called: swish | build_page
* Takes the output of the Swish indexing program and converts it
* into a webpage.  Clicking a link on the webpage calls "highlight"
* through the script "get_link".
*
* The user will want to modify GETLINKURL
*/
#include <stdio.h>
#include <string.h>

#define GETLINKURL "<a href=\"http://hiwaay.net:8000/~crispen/cgi-bin/uncgi.cgi/get_link"
#define MAXBUFLEN 1000
main ()
{
    char buf[MAXBUFLEN];
    char url[MAXBUFLEN];
    char score[MAXBUFLEN];
    char title[MAXBUFLEN];
    char query[MAXBUFLEN];
    int i, j, c, bufptr=0;
    int slashes;

    query[0] = '\0';
    while ((c = getc(stdin)) != EOF) {
	buf[bufptr++] = c;
	/*
	* Process one line at a time
	*/
	if (c == '\n') {
	    buf[bufptr] = '\0';
	    if ((buf[0] != '#') && (buf[0] != '.')) {
		/*
		* Error message
		*/
		if (!strncmp(buf, "err:", 4)) {
		    printf ("<p>Sorry, no match found.  Please try again.\n");
		    exit(0);
		}
		/*
		* search words:
		*/
		if (!strncmp(buf, "search", 6)) {
		    i=14;
		    for (j=0; ((buf[i] != '\n')&&(buf[i] != '\r')); i++,j++)
			query[j] = buf[i];
		    buf[++i] = '\0';
		    for (i=0; (i<strlen(query)); i++) {
			if (query[i] == ' ')
			    query[i] = '+';
		    }
		} else {
		    /*
		    * score url title length
		    */
		    for (i=0; (buf[i] !=' '); i++)
			score[i] = buf[i];
		    score[i] = '\0';
		    slashes = 0;
		    bzero(url, sizeof(url));
		    for (j=0; (buf[++i] != ' '); j++)
			url[j] = buf[i];
		    url[j] = '\0';
		    for (;buf[i]!='\"'; i++);
		    i++;
		    for (j=0; (buf[i] != '\"'); j++)
			title[j] = buf[i++];
		    title[j] = '\0';
		    printf("<li> %s %s", score, GETLINKURL);
		    printf("?url=%s&query=%s#HEREHEREHERE\">%s</a>\n", url, query, title);
		}
	    }
	    bufptr = 0;
	}
    }
}
