########################################################################
#
# mail2html.sed
# Bob Crispen (crispen@hiwaay.net)
#
# Converts mail messages into more or less reasonable-looking HTML.
# You'll still need to do some hand-editing, particularly if your mail
# program won't delete "Received-From:" lines, but at least this gets
# you started.
#
########################################################################

# Turns all quoted lines (using the net convention of ">") to italic
/^>/{
s/>*//;
i\
<i>
a\
<\/i><br>
}

# Convert "<" and ">" to proper HTML
/</s//\&lt;/
/>/s//\&gt;/

# Any blank line in the text will be substituted with a paragraph marker
/^ *$/s//<p>/

# Delete the "From" line from the header.  Hopefully this won't delete
# any lines beginning with "From" from your text.
/^From:/{
s///;
x;
}

# The Subject: line is the title of the paper and the headline
# at the top of the paper
/^Subject: /{
s///;
s/\&/\&amp;/
i\
<html>\
<head>\
<title>
p;
i\
<\/title>\
<\/head>\
<body>\
<center>\
<h1>
p;
i\
<\/h1>\
<h3>by
x;
p;
a\
</h3>\
</center>\
<p>\
<hr>\
<p>
d;
}

# Some really lame web browsers won't take an ampersand in the text
/\&/s/\&/\&amp;/

# If you have at least 5 dashes, substitute an underline
/^-----/c\
<hr>

# Lines preceded by 5 or more spaces may be quotes or poetry.
/^     /a\
<br>

# Makes your HTTP URLS browsable (if there's any text after the
# URL in the line, it'll get tacked onto the end of the URL, but
# Netscape ignores it).
/http:/{
s//<a href="http:/
p;
i\
">
s/^.*<a href="//
p;
a\
<\/a>
d;
}

# Ditto for FTP URLs
/ftp:/{
s//<a href="ftp:/
p;
i\
">
s/^.*<a href="//
p;
a\
<\/a>
d;
}

# If there are any words italicized using the net convention of "*bang*"
# convert them to real italics
/\*.*\*/{
s/\*/<i>/
s/\*/<\/i>/
}

# If any of these lines appear in your mail headers, this will delete them
/^Cc: /d
/^To: /d
/^Comments:/d
/^Content-Length:/d
/^Content-Transfer-Encoding:/d
/^Content-Type:/d
/^Date:/d
/^Distribution:/d
/^Lines:/d
/^Message-ID:/d
/^Message-Id:/d
/^Mime-Version:/d
/^Newsgroups:/d
/^News-Software:/d
/^Nntp-Posting-Host:/d
/^NNTP-Posting-Host:/d
/^Organization:/d
/^Original-From:/d
/^Path:/d
/^Posted-Date:/d
/^Priority:/d
/^Received:/d
/^Reply-To:/d
/^Sender:/d
/^X-Cc:/d
/^X-Envelope-To:/d
/^X-Lines:/d
/^X-Mailer:/d
/^X-Mozilla-Status:/d
/^X-Sender:/d
/^X-To:/d
/^X-Vms-To:/d
/^X-Vmsmail-To:/d
/^X-Msmail-/d
/^Xref:/d

# Now we're at the last line, put on a standard trailer if you
# want to.
${a\
<\/body>\
<\/html>
}
