//
// foxynews.h -- header file for foxynews
//
// Copyright (C) 1999 by Bob Crispen <crispen@hiwaay.net> doing business as
//   Foxy Software
//
// Heavily adapted from checkmail.c, in the public domain.
//
// LICENSE:
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

// Maximum transfer unit
#define ETHER_MTU 1500
#define BUFSIZE 1600
#define SHORTBUFSIZE 256

// ----- Helper macros
#define Display(s) SendMessage(hwndStatusBar, SB_SETTEXT, (WPARAM)1, (LPARAM)(LPSTR)s)
#define Display3(s) SendMessage(hwndStatusBar, SB_SETTEXT, (WPARAM)2, (LPARAM)(LPSTR)s)
#define Display2(s) SendMessage(hwndEdit2, EM_REPLACESEL, 0, (LPARAM)((LPSTR)s))


#define EnableOneButton(id, flag) EnableWindow(GetDlgItem(hwndDlg, id), flag)
#define EnableButtons(flag) EnableOneButton(ID_CHECKNEWS, flag); \
	EnableOneButton(ID_SHOWHDRS, flag);
						   
// ----- Messages for asynchronous notification                    
#define SM_GETHOST	WM_USER+1
#define SM_ASYNC	WM_USER+2

#define bzero(x,y) memset((x),0,(y))

// functions in foxynews.c (forward references)
LRESULT CALLBACK MainDialogProc(HWND, UINT, WPARAM, LPARAM);
static BOOL CALLBACK AboutDlgProc (HWND, UINT, WPARAM, LPARAM);
static BOOL CALLBACK ShowDlgProc (HWND, UINT, WPARAM, LPARAM);
static BOOL CALLBACK LoginDlgProc (HWND, UINT, WPARAM, LPARAM);
static BOOL CALLBACK PrefsDlgProc (HWND, UINT, WPARAM, LPARAM);
void HandleGetHostMsg(HWND, WPARAM, LPARAM);
void HandleAsyncMsg(HWND, WPARAM, LPARAM);
void start_socket_connection(HWND, int);
void start_state_machine(HWND);
void do_reset(HWND);
void fill_in_news_host_list(HWND);
void fill_in_newsgroup_list(HWND);

// functions in newslib.c
void init_state_machine_data(
    HWND, HWND,
    SOCKET,
    char*, char*, char*, char*, char*,
    int, int,
    BOOL, BOOL, BOOL, BOOL, BOOL, BOOL, BOOL, BOOL);
int state_machine();
void signal_quit(BOOL);

// Command from main dialog
#define SHOW_HEADERS	1
#define LIST_NEWSGROUPS	2
#define GET_ATTACHMENTS	3

// Application state
#define QUITTING				 0
#define CONNECTING				 1
#define WAITING_FOR_LIST_NEWSGROUPS_REPLY	 2
#define WAITING_FOR_LIST_REPLY			 3
#define LISTING_NEWSGROUPS			 4
#define WAITING_FOR_GROUP_REPLY			 5
#define WAITING_FOR_LIST_OVERVIEW_FMT_REPLY	 6
#define GETTING_OVERVIEW_FMT			 7
#define WAITING_FOR_XOVER_REPLY			 8
#define READING_XOVER_DATA			 9
#define WAITING_FOR_HEAD_REPLY			10
#define READING_HEADER				11
#define WAITING_FOR_ARTICLE_REPLY		12
#define READING_ARTICLE				13
#define WAITING_FOR_AUTHINFO_USER_REPLY		14
#define WAITING_FOR_AUTHINFO_PASS_REPLY		15
#define AUTHORIZATION_FAILED			16
#define LOGIN_NOT_REQUIRED			17

