/*
 * nd.c
 * Bob Crispen (crispen@hiwaay.net)
 *
 * New hex/ASCII dump (replaces od, at least in MY heart)
 *
 * Usage: nd file (probably | less)
 * or     foo | nd (| less)
 *
 * 13 April 1996: made the display 79 characters wide to accommodate
 * less (if we ever get less working)
 *
 * This software is distributed according to the terms of the Gnu
 * General Public License.
 */
#include <stdio.h>
#include <string.h>

main (int argc, char **argv)
{
    FILE *fromfile;
    long int addr;
    int count, i;
    int c;
    char text[17];  /* 16 chars and null */

    /* Get argument (filename) */
    if (argc > 2) {
	fprintf (stderr, "Usage: %s file\n", argv[0]);
	exit (-1);
    }

    if (argc == 2) {
	/* We're dumping a file: open it */
	if ((fromfile = fopen (argv[1], "r")) == NULL) {
	    fprintf (stderr, "can't open %s\n", argv[1]);
	    exit (-1);
	}
    } else {
	/* We're dumping from stdin */
	fromfile = stdin;
    }

    count = 0;
    strcpy (text, "                ");
    addr = 0;

    while ((c=getc(fromfile)) != EOF) {
	/* Start of line */
	if (count == 0)
	    printf ("%8.8x   ", addr);

	/* Middle of line */
	if (count < 16) {
	    printf ("%2.2x ",c);
	    /* Show the character if it's printable */
	    if ((c >= 0x20) && (c < 0x7f))
		text[count++] = (char) c;
	    else
		text[count++] = '.';
	}

	/* End of line */
	if (count == 16) {
	    printf ("   %s\n", text);
	    count = 0;
	    addr += 16;
	    strcpy (text, "                ");
	}
    }

    /* If we haven't ended on an even boundary, clean up */
    if (count > 0) {
	for (i=count; i<16; i++)
	    printf ("   ");
	printf ("   %s\n", text);
    }

    fclose (fromfile);  /* Gives us a 0 exit status */
}
