/*
 * unnormal
 * by Bob Crispen
 * crispen@hiwaay.net
 *
 * Removes all "Normal" and "normalIndex" nodes and fields from
 * a VRML 1.0 file.  Removes "normal" and "normalIndex" fields
 * from a VRML 2.0 file.
 *
 * Called: unnormal [infile] [outfile]
 *
 * Why?  CAD programs that export VRML and some VRML conversion
 * utilities often create bogus normals.  Often the world looks
 * considerably better without the Normals, and in any case,
 * removing the Normals reduces the file size and speeds downloading
 * and rendering.  For some files unnormal is just the ticket.
 * For others, it messes up the appearance of the file.
 *
 * On DOS/Windows machines, if the output file is named, the
 * input file will have extra CR characters (0x0d, '\r')
 * stripped off.  If you don't want this, redirect standard
 * output to your destination file.
 *
 * XXX -- in oddball worlds that USE a normal or normalIndex, this
 * relies on the complete USE statement and nothing else being on
 * the same line.
 *
 */
#include <stdio.h>
#include <string.h>

#ifdef MSDOS
#define READOPTS "rb"
#define WRITEOPTS "wb"
#else
#define READOPTS "r"
#define WRITEOPTS "w"
#endif

static char *xusage = "[infile] [outfile]";
static char *progname;

main (int argc, char **argv)
{
    FILE *infile = stdin;
    FILE *outfile = stdout;
    int c, i;
    char buf[1000];
    char buf2[2000];
    int bufptr = 0;
    char *token;
    char *outfilename = NULL;
    int argn=1;

    progname = argv[0];
    if (argc > 1)
	if (argv[argn][0] == '-')
	    usage(); /* We ain't got no steenking options */
    if (argn < argc) {
	if ((infile = fopen(argv[argn++], READOPTS)) <= 0) {
	    perror ("Infile");
	    exit(-1);
	}
    }

    if (argn < argc) {
	if ((outfile=fopen(argv[argn++], WRITEOPTS)) <= 0) {
	    perror ("Outfile");
	    exit(-1);
	}
    }
    if (argn < argc)
	usage();

    while ((c=getc(infile)) != EOF) {
	buf[bufptr++] = c;
	if ((c == '\n') || (c == '\r')) {
	    buf[--bufptr] = '\0';
	    strcpy(buf2, buf);
	    if ((token = strtok (buf2, " \t\n\r\0")) != NULL) {
		if ((!strcmp(token, "Normal")) || (!strcmp(token, "normal"))) {
		    if (buf[bufptr-1] == '}') {
			bufptr=0;
		    } else {
			token = strtok (NULL, " \t\n\r\0");
			if (token && (!strcmp(token, "USE"))) {
			    bufptr = 0;
			} else {
			    bufptr=0;
			    while ((c=getc(infile)) != '}');
			}
		    }
		}
		if (!strcmp(token, "normalIndex")) {
		    if (buf[bufptr-1] == ']') {
			bufptr=0;
		    } else {
			token = strtok (NULL, " \t\n\r\0");
			if (token && (!strcmp(token, "USE"))) {
			    bufptr = 0;
			} else {
			    bufptr=0;
			    while ((c=getc(infile)) != ']');
			}
		    }
		}
	    }
	    if (bufptr != 0) {
		fprintf(outfile, "%s\n", buf);
		bufptr=0;
	    }
	}
    }
}

usage()
{
    fprintf (stderr, "Usage: %s %s\n", progname, xusage);
    exit(-1);
}
