@ECHO OFF
cls
REM Purpose: This batch file creates complete dump of NK.BIN provided
REM Author: jwoegerbauer
REM Date: 2013-01-03
REM License: GPL v3
REM
:START
if "%~1" == "" (
echo CREATEDUMP.BAT&echo Using NK.BIN in current directory
set nkbin=nk.bin
) else (
set nkbin="%~1"
)
setlocal enabledelayedexpansion
if not exist %nkbin% goto :FAILURE1
REM clean up
if exist viewbin.txt del viewbin.txt 
if exist nk.nb0 del nk.nb0
REM determine start and length of NK.BIN
echo Determining exact length of %nkbin% ...
viewbin %nkbin% > viewbin.txt
if not exist viewbin.txt goto :FAILURE2
REM
REM that's how contents of first 2 lines of file viewbin.txt might look
REM ViewBin... nk.bin 
REM Image Start = 0x80100000, length = 0x01EDAD34
REM
set start=""
set length=""
for /f "skip=1 tokens=2,4 delims=,=" %%A in (viewbin.txt) do (
   set start=%%A
   for /f %%N in ("%%A") do set start=%%N
   set length=%%B
   for /f %%N in ("%%B") do set length=%%N
   goto :BREAK
)
:BREAK
if ".%start%" == "." goto :FAILURE3
if ".%length%" == "." goto :FAILURE3
REM convert the nk.bin provided to a nk.nb0
echo Converting %nkbin% to nk.nb0 ...
cvrtbin -r -a %start% -w 32 -l %length% %nkbin% > NUL
if not exist nk.nb0 goto :FAILURE4
REM content of the nk.nb0 will be written in the directory "dump". 
REM directory dump must exist, otherwise an error occurs.
mkdir dump > NUL
echo Extracting all files and modules from the kernel&echo This may take some minutes ...
dumprom -d dump -v -4 nk.nb0 > NUL
echo Dumping finshed&echo Dumped files should be in ..\dump&goto :END
:FAILURE1
echo Error:&echo File nk.bin not found&echo Aborting ...&goto :END
:FAILURE2
echo Error:&echo Failed to create file viewbin.txt&echo Aborting ...&goto :END
:FAILURE3
echo Error:&echo Failed to determine image's start and/or length&echo Aborting ...&goto :END
:FAILURE4
echo Error:&echo Failed to create temporary file nk.nb0&echo Aborting ...
:END
endlocal
pause
@ECHO ON
exit
