#if !defined(AFX_GRID_H__A9C11787_8DDC_40EA_B117_F5E61C244F7B__INCLUDED_)
#define AFX_GRID_H__A9C11787_8DDC_40EA_B117_F5E61C244F7B__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// Grid.h : header file
//

#include "Piece.h"
#include "Space.h"

/////////////////////////////////////////////////////////////////////////////
// Grid window

class Grid
{
// Construction
public:
	Grid();

// Attributes
public:
	CPtrArray pieces;
	CPtrArray spaces;
	CPtrArray free_spaces;
	CPtrArray open;
	CPtrArray closed;
	CPtrArray path;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(Grid)
	//}}AFX_VIRTUAL

// Implementation
public:
	bool CheckForRows(bool);
	bool SetDoomed(int);
	void Move();
	void PrepareNextMove();
	bool PenDown(int x, int y);
	bool finishedWay;
	bool found;
	bool markTarget;
	bool getReady;
	void Reset();
	int gameState;
	int score;
	int bonus;
	void AddPieces(int number);
	Space *GetSpace(int, int);
	Space *GetFreeSpace(int, int);
	Piece *depot[3];
	bool passage;
	Space *target;
	int temp1, temp2;

	virtual ~Grid();

	// Generated message map functions
protected:
	//{{AFX_MSG(Grid)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG
	
private:	
	void CleanUp();
	bool IsInside(CPtrArray &ar, Piece *p);
	void CalculatePath();
	void CalculateCost(Space*, int dir);
	CPtrArray *FindRow(Piece *p, int dir);
	Space *GetCheapest();
	Space *GetNeighbor(Space*, int);
	Piece *GetNeighbor(Piece*, int);	
	Space *start;

	bool FindPath();
	bool IsOccupied(Space *space);
	
	int freeSize;	
	int markedIndex;
	int waypoint;	
	
	bool targetFound;	
	bool moveAborted;
	
	
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_GRID_H__A9C11787_8DDC_40EA_B117_F5E61C244F7B__INCLUDED_)
