// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "Lineo.h"
#include "MainFrm.h"
#include "Tutorial.h"
#include "Atlbase.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define PSPC_TOOLBAR_HEIGHT 24

const int WIDTH = 23;
const int NORMAL = 0;
const int MARKED = 1;
const int DOOMED = 2;

const int FIRST_MOVE = 0;
const int SECOND_MOVE = 1;
const int MOVING = 2;

const bool DEMO_VERSION = true;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CString	m_regtext;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();		// Added for WCE apps
	afx_msg void OnOk();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	m_regtext = _T("");
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Text(pDX, IDC_REGTEXT, m_regtext);
	DDV_MaxChars(pDX, m_regtext, 100);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)	
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLineoApp commands
// Added for WCE apps

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CenterWindow();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_TIMER()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_PAINT()
	ON_COMMAND(ID_GAME_QUIT, OnGameQuit)
	ON_COMMAND(ID_GAME_NEW, OnGameNew)
	ON_COMMAND(HOW_TO_PLAY, OnToPlay)
	ON_WM_DESTROY()
	ON_COMMAND(ID_PREVIEW, OnPreview)
	ON_COMMAND(ID_TS1, OnTs1)
	ON_COMMAND(ID_TS2, OnTs2)
	ON_COMMAND(ID_TS3, OnTs3)
	ON_COMMAND(ID_CLEAR, OnClearHighscore)
	ON_COMMAND(ID_SOUND, OnToggleSound)
	ON_NOTIFY_REFLECT(NM_RECOGNIZEGESTURE, OnRecognizeGesture)	
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	width = ::GetSystemMetrics(SM_CXSCREEN);
	height = ::GetSystemMetrics(SM_CYSCREEN);

	CClientDC dc(this);
	memDC.CreateCompatibleDC(&dc);		
	pieceDC.CreateCompatibleDC(&dc);
	bombDC.CreateCompatibleDC(&dc);
	expDC.CreateCompatibleDC(&dc);
		
	membmp.CreateCompatibleBitmap(&dc, width, height);	
	memDC.SelectObject(&membmp);

	redBrush.CreateSolidBrush(RGB(255,0,0));
	yellowBrush.CreateSolidBrush(RGB(255,255,0));  
	
	font.CreateFont(16,0,0,0,FW_BOLD,
		0,0,0,ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
		DEFAULT_QUALITY, DEFAULT_PITCH || FF_DONTCARE,
		_T("Arial"));
	
	//load bitmaps:
	
	tilesetImg[0].LoadBitmap(IDB_TILESET1);	
	tilesetImg[1].LoadBitmap(IDB_TILESET2);	
	tilesetImg[2].LoadBitmap(IDB_TILESET3);	
	
	starImg.LoadBitmap(IDB_STAR);	
	stopImg.LoadBitmap(IDB_STOP);	

	lineoImg.LoadBitmap(IDB_LINEO);	
	copyrightImg.LoadBitmap(IDB_COPYRIGHT);	

	overImg.LoadBitmap(IDB_OVER);	
	highscoreImg.LoadBitmap(IDB_HIGHSCORE);	

	bomb1Img.LoadBitmap(IDB_BOMB1);	
	bomb2Img.LoadBitmap(IDB_BOMB2);	
	explImg.LoadBitmap(IDB_EXPLOSION);	

	blindsImg.LoadBitmap(IDB_BLINDS);	

	intro = true;	
	introTicker = 0;		
	gamesPlayed = 0;

	tileset = 1;
}

CMainFrame::~CMainFrame()
{
	
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
		
	if(!m_wndCommandBar.Create(this) ||
	   !m_wndCommandBar.InsertMenuBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create CommandBar\n");
		return -1;      // fail to create
	}

	///////Read registry/////////////////////////////

	HKEY Highscore, Preview, Tileset, Checksum, Sound; 		
	DWORD dwValType = REG_DWORD, dwDSize;	

	//How much data do we have
    dwDSize = 2; // pass non null to get array size    
	//allocate space 
    PBYTE  pbData = (PBYTE)LocalAlloc(LPTR, dwDSize);		

	int rc;	

	//read registry
	rc = RegOpenKeyEx (HKEY_LOCAL_MACHINE, _T("Lineo\\n2"), 0, 0, &Highscore);
	//Get the key value
	if (rc == ERROR_SUCCESS) 
	{
		RegQueryValueEx (Highscore, _T("highscore"), NULL, &dwValType, pbData, &dwDSize);		
		highScore = (*(int*)pbData);
		RegCloseKey(Highscore);			
	}
	else
		highScore = 0;

	//////////////////////////////////////////////////////////////////////////
	
	rc = RegOpenKeyEx (HKEY_LOCAL_MACHINE, _T("Lineo\\n2"), 0, 0, &Preview);
	
	if (rc == ERROR_SUCCESS) 
	{
		RegQueryValueEx (Preview, _T("preview"), NULL, &dwValType, pbData, &dwDSize);		
		showPreview = (*(bool*)pbData);
		RegCloseKey(Preview);		
	}
	else
		showPreview = true;

	if(showPreview)
	{		
		CMenu* pMenu = GetMenu();
		pMenu->CheckMenuItem(ID_PREVIEW, MF_CHECKED);
	}

	//////////////////////////////////////////////////////////////////////////
	
	rc = RegOpenKeyEx (HKEY_LOCAL_MACHINE, _T("Lineo\\n2"), 0, 0, &Sound);
	
	if (rc == ERROR_SUCCESS) 
	{
		RegQueryValueEx (Preview, _T("sound"), NULL, &dwValType, pbData, &dwDSize);		
		playSound = (*(bool*)pbData);
		RegCloseKey(Sound);		
	}
	else
		playSound = true;

	if(playSound)
	{		
		CMenu* pMenu = GetMenu();
		pMenu->CheckMenuItem(ID_SOUND, MF_CHECKED);
	}
	
	//////////////////////////////////////////////////////////////////////////

	rc = RegOpenKeyEx (HKEY_LOCAL_MACHINE, _T("Lineo\\n2"), 0, 0, &Tileset);
	
	if (rc == ERROR_SUCCESS) 
	{
		RegQueryValueEx (Tileset, _T("tileset"), NULL, &dwValType, pbData, &dwDSize);		
		tileset = (*(int*)pbData);
		RegCloseKey(Tileset);	
	}
	else	
		tileset = 0;

	CMenu* pMenu = GetMenu();

	if(tileset == 1)
		pMenu->CheckMenuItem(ID_TS2, MF_CHECKED);	
	else if(tileset == 2)
		pMenu->CheckMenuItem(ID_TS3, MF_CHECKED);		
	else
		pMenu->CheckMenuItem(ID_TS1, MF_CHECKED);	

	//////////////////////////////////////////////////////////////////////////
	
	rc = RegOpenKeyEx (HKEY_LOCAL_MACHINE, _T("Lineo\\n2"), 0, 0, &Checksum);
	
	if (rc == ERROR_SUCCESS) 
	{
		RegQueryValueEx (Checksum, _T("checksum"), NULL, &dwValType, pbData, &dwDSize);		
		timesPlayed = (*(int*)pbData);
		RegCloseKey(Checksum);	
	}
	else
		timesPlayed = 0;

	timesPlayed ++;	

	/////////////////////////////////////////////////

	SetTimer(4, 200, 0);
	
	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;

	cs.lpszClass = AfxRegisterWndClass(0);	

	return TRUE;
}



LPTSTR CMainFrame::MakeString(UINT stringID)
{
	TCHAR buffer[255];
	TCHAR* theString;

	::LoadString(AfxGetInstanceHandle(), stringID, buffer, 255);
	theString = new TCHAR[lstrlen(buffer) + 1];
	lstrcpy(theString, buffer);
	return theString;
}   

 
/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

void CMainFrame::OnTimer(UINT nIDEvent) 
{
	int piecesSize; 				

	//move dot to the target space	
	if(nIDEvent == 1)
	{		
		KillTimer(3);
		grid.markTarget = false;	

		if(grid.finishedWay)
		{
			KillTimer(1);					
			foundRows = grid.CheckForRows(true);		
			timerTicker = 0;			

			SetTimer(2, 150, 0);				
		}
		else				
			grid.Move();							
	}

	//remove dots
	if(nIDEvent == 2)
	{									
		bool stop = grid.SetDoomed(timerTicker++);

		if(foundRows && timerTicker == 1)
		{
			if(grid.bonus > 1)
				PlaySound(IDR_WAVE2);			
			else
				PlaySound(IDR_WAVE1);
		}
		
		if(stop || !foundRows)
		{	
			grid.finishedWay = false;														
												
			if(!foundRows)																
				grid.AddPieces(3);								
									
			foundRows = grid.CheckForRows(false);		
			
			if(foundRows)	
				timerTicker = 0;	//remove row during the next timer tick							
			else
			{	
				KillTimer(2);
				
				piecesSize = grid.pieces.GetSize(); 				

				if(piecesSize > 80)	
				{														
					gameOver = true;		

					PlaySound(IDR_WAVE3);

					showBomb = false;

					if(grid.score > highScore)
					{
						highScore = grid.score;
						newHighscore = true;
					}

					extroTicker = 0;						
					SetTimer(5, 250, 0);						
				}
				else				
					grid.gameState = FIRST_MOVE;									
			}						
		}	
		
		piecesSize = grid.pieces.GetSize(); 				
				
		if(piecesSize > 60)
			showBomb = true;
		else 
			showBomb = false;								
	}

	//unmark target
	if(nIDEvent == 3)
	{
		KillTimer(3);
		grid.markTarget = false;	
	}
	
	//intro
	if(nIDEvent == 4)
	{
		introTicker++;

		if(introTicker > 18)
		{
			intro = false;
			KillTimer(4);
		}		
	}

	//extro
	if(nIDEvent == 5)
	{
		extroTicker++;

		if(extroTicker == 10 && newHighscore)
			PlaySound(IDR_WAVE4);

		if((newHighscore && extroTicker > 20) || (!newHighscore && extroTicker > 14))
		{										
			KillTimer(5);
			newHighscore = gameOver = false;	
			
			gamesPlayed ++;

			if(DEMO_VERSION && gamesPlayed >= 3)
			{
				AfxMessageBox(_T("The demo version only allows 3 games in a row."), MB_ICONASTERISK | MB_OK);
				SendMessage(WM_CLOSE);	
			}			

			NewGame();					
		}			
	}

	//show explosions
	if(nIDEvent == 6)
	{
		if(explosionTicker == 0)
			PlaySound(IDR_WAVE5);

		if(explosionTicker > 13)
		{			
			KillTimer(6);
			newHighscore = gameOver = showExplosions = false;	

			gamesPlayed ++;

			if(DEMO_VERSION && gamesPlayed >= 3)
			{
				AfxMessageBox(_T("The demo version only allows 3 games in a row."), MB_ICONASTERISK | MB_OK);
				SendMessage(WM_CLOSE);	
			}		

			NewGame();										
		}
		
		explosionTicker ++;
	}	

	Invalidate();	
	UpdateWindow();
	
	CFrameWnd::OnTimer(nIDEvent);
}

void CMainFrame::OnLButtonDown(UINT nFlags, CPoint point) 
{	
	bool canClick = (grid.gameState == FIRST_MOVE || grid.gameState == SECOND_MOVE) && !gameOver && !intro;
	CRect rect;
	rect.left = 4;
	rect.top = 32;
	rect.right = 4 + 232;
	rect.bottom = 32 + 232;

	CRect bombRect;
	bombRect.left = 108;
	bombRect.top = 3;
	bombRect.right = 108 + 25;
	bombRect.bottom = 3 + 25;

	if(canClick)
	{
		if(bombRect.PtInRect(point) && showBomb)
		{
			pressedBomb = true;
		}
		if(rect.PtInRect(point))
		{	
			getMoving = grid.PenDown(point.x, point.y);					
			
			Invalidate(false);
			
			if(grid.found)
			{		
				if(grid.gameState == FIRST_MOVE)		
					grid.gameState = SECOND_MOVE;
				else
				{					
					if(getMoving)
					{
						getMoving = false;													
						SetTimer(1, 80, 0);
					}
					else
					{
						grid.gameState = FIRST_MOVE;				
						SetTimer(3, 100, 0);
					}
				}							
			}
		}
	}
	
	Invalidate();	
	UpdateWindow();
	Default(); 	
}

void CMainFrame::OnLButtonUp(UINT nFlags, CPoint point) 
{	
	CRect bombRect;
	bombRect.left = 108;
	bombRect.top = 3;
	bombRect.right = 108 + 25;
	bombRect.bottom = 3 + 25;

	if(showBomb)
	{
		if(bombRect.PtInRect(point) && showBomb)			 	
		{
			pressedBomb = false;	
			showExplosions = true;	
			explosionTicker = 0;
			SetTimer(6, 90, 0);			
		}
		else		
			pressedBomb = false;				
			
		Invalidate();	
		UpdateWindow();	
	}	
	
	if(intro)
	{
		intro = false;
		KillTimer(4);
		Invalidate();	
		UpdateWindow();	
	}
	
	CFrameWnd::OnLButtonUp(nFlags, point);
}

void CMainFrame::Update()
{
	if(DEMO_VERSION && timesPlayed > 30)
		DrawExtro();

	else if(intro)
		DrawIntro();

	else
	{
		Piece *p;

		//fill the background
		memDC.FillSolidRect(0,0,width,height,RGB(70,150,210));
		
		//3 preview pieces	
		if(showPreview)
		{
			memDC.FillSolidRect(160,3,77,25,RGB(185,185,185));

			memDC.Draw3dRect(160,3,25,25,RGB(240,240,240),RGB(110,110,110));		
			memDC.Draw3dRect(186,3,25,25,RGB(240,240,240),RGB(110,110,110));		
			memDC.Draw3dRect(212,3,25,25,RGB(240,240,240),RGB(110,110,110));	
		}
		memDC.FillSolidRect(4,32,233,233,RGB(185,185,185));
		
		for(int i=4; i<220; i+=26)
			for(int j=32; j<260; j+=26)			
				memDC.Draw3dRect(i,j,25,25,RGB(240,240,240),RGB(90,90,90));		
		
		if(grid.bonus > 1)
		{	
			memDC.SetTextColor(RGB(255,255,0));
			str = "Bonus: x " + IntToStr(grid.bonus);	
		}
		else if(grid.getReady)
		{
			memDC.SetTextColor(RGB(255,255,0));
			str = "Get ready...";	
		}
		else
		{
			memDC.SetTextColor(RGB(255,255,255));
			str = "Score: " + IntToStr(grid.score);								
		}
		
		memDC.SetBkMode(TRANSPARENT);	
		memDC.SelectObject(font);
		memDC.DrawText(str, CRect(5,8,200,40), DT_LEFT | DT_SINGLELINE);	

		//Draw the pieces
		int piecesSize = grid.pieces.GetSize(); 

		for(int k=0; k < piecesSize; k++)
		{
			p = (Piece*)grid.pieces.ElementAt(k);
			DrawPiece(*p);
		}	

		//Draw the preview
		if(showPreview)
		{
			for(int l=0; l < 3; l++)
			{
				p = (Piece*)grid.depot[l];
				DrawPiece(*p);
			}
		}
		
		if(grid.markTarget)
		{
			if(grid.passage)
				TransparentImage(memDC, grid.target->x, grid.target->y, 21, 21, starImg, 0, 0, 21, 21, RGB(185,185,185));
			else
				TransparentImage(memDC, grid.target->x, grid.target->y, 21, 21, stopImg, 0, 0, 21, 21, RGB(185,185,185));
		}

		if(gameOver)
		{
			if(extroTicker < 9)
				TransparentImage(memDC, 32, 120, 175, 31, overImg, 0, 0, 175, 31, RGB(185, 185, 185));
			
			if(newHighscore && extroTicker >= 9 && extroTicker < 15 && (extroTicker % 2 == 0))
				TransparentImage(memDC, 37, 120, 175, 31, highscoreImg, 0, 0, 175, 31, RGB(185, 185, 185));
												
			if((newHighscore && extroTicker >= 15) || (!newHighscore && extroTicker >= 9))
				grid.getReady = true;
		}
		
		if(showBomb)
		{			
			if(pressedBomb)
			{
				CBitmap *pOldBitmap = bombDC.SelectObject(&bomb2Img);
				memDC.BitBlt(108, 3, 25, 25, &bombDC, 0, 0, SRCCOPY);		
				bombDC.SelectObject(pOldBitmap);			
			}
			else
			{
				CBitmap *pOldBitmap = bombDC.SelectObject(&bomb1Img);
				memDC.BitBlt(108, 3, 25, 25, &bombDC, 0, 0, SRCCOPY);		
				bombDC.SelectObject(pOldBitmap);	
			}
		}	
	}
}

void CMainFrame::OnPaint() 
{
	Update();
	CPaintDC dc(this);
	dc.BitBlt(0,0,width,height,&memDC,0,0,SRCCOPY);		
}

inline CString CMainFrame::IntToStr(int i)
{
	char ch[10];		
	_itoa(i, ch, 10);			
	return (CString)ch;	
}

void CMainFrame::DrawPiece(Piece p)
{
	CBitmap *pOldBitmap;	

	if(!showExplosions || (showExplosions && explosionTicker < 7))
	{
		if(p.state == NORMAL)
		{		
			pOldBitmap = pieceDC.SelectObject(&tilesetImg[tileset]);			
			memDC.BitBlt(p.x, p.y, 21, 21, &pieceDC, p.colorIndex * 21, 0, SRCCOPY);				
			pieceDC.SelectObject(pOldBitmap);		
		}
		else if(p.state == MARKED)
		{			
			memDC.FillSolidRect(p.x, p.y-1, 23, 23, RGB(255,255,255));		
			TransparentImage(memDC, p.x, p.y, 21, 21, tilesetImg[tileset], p.colorIndex * 21, 0, 21, 21, RGB(185,185,185));
		}
		else	//DOOMED
		{		
			pOldBitmap = pieceDC.SelectObject(&tilesetImg[tileset]);
			memDC.BitBlt(p.x, p.y, 21, 21, &pieceDC, p.colorIndex * 21, 0, SRCCOPY);		
			pieceDC.SelectObject(pOldBitmap);		
			
			if(timerTicker == 2)		
				TransparentImage(memDC, p.x, p.y, 21, 21, blindsImg, 0, 0, 21, 21, RGB(255,255,255));
			
			if(timerTicker == 3)		
				TransparentImage(memDC, p.x, p.y, 21, 21, blindsImg, 21, 0, 21, 21, RGB(255,255,255));
			
			if(timerTicker == 4)		
				TransparentImage(memDC, p.x, p.y, 21, 21, blindsImg, 42, 0, 21, 21, RGB(255,255,255));
			
			if(timerTicker >= 5)		
				TransparentImage(memDC, p.x, p.y, 21, 21, blindsImg, 63, 0, 21, 21, RGB(255,255,255));
		}	
	}	

	if(showExplosions && explosionTicker < 14)
		TransparentImage(memDC, p.x-1, p.y-1, 23, 23, explImg, explosionTicker * 23, 0, 23, 23, RGB(185,185,185));	
}


void CMainFrame::OnRecognizeGesture(NMHDR *pNMHDR, LRESULT *pResult)
{
	*pResult = TRUE; 
}


void CMainFrame::DrawIntro()
{	
	memDC.FillSolidRect(0,0,width,height,RGB(3,53,204));

	TransparentImage(memDC, 25, 50, 190, 66, lineoImg, 0, 0, 190, 66, RGB(3, 53, 204));	
	TransparentImage(memDC, 61, 130, 118, 31, copyrightImg, 0, 0, 118, 31, RGB(3, 53, 204));
	
	CString str = "Highscore: " + IntToStr(highScore);

	memDC.SetTextColor(RGB(255,255,255));	
	memDC.SetBkMode(TRANSPARENT);	
	memDC.SelectObject(font);

	if(highScore > 0)
		memDC.DrawText(str, CRect(40,200,200,240), DT_CENTER | DT_SINGLELINE);	

	if(DEMO_VERSION)
	{
		memDC.SetTextColor(RGB(150,150,210));	
		memDC.DrawText(IntToStr(31-timesPlayed) + " demo games left", CRect(40,230,200,270), DT_CENTER | DT_SINGLELINE);	
	}
}

void CMainFrame::DrawExtro()
{	
	memDC.FillSolidRect(0,0,width,height,RGB(3,53,204));

	TransparentImage(memDC, 25, 30, 190, 66, lineoImg, 0, 0, 190, 66, RGB(3, 53, 204));	
	TransparentImage(memDC, 61, 110, 118, 31, copyrightImg, 0, 0, 118, 31, RGB(3, 53, 204));
	
	CString str = "This Demo has expired,\nI hope you enjoyed it!\n\n"
	"Visit www.programming.de\nto get the registered version.";

	memDC.SetTextColor(RGB(255,255,0));	
	memDC.SetBkMode(TRANSPARENT);	
	memDC.SelectObject(font);
	
	memDC.DrawText(str, CRect(10,160,220,280), DT_CENTER);		
}

void CMainFrame::NewGame()
{
	gameOver = newHighscore = showBomb = showExplosions = false;	
	grid.Reset();
	Sleep(500);
	Invalidate(false);
}

void CMainFrame::OnGameQuit() 
{
	SendMessage(WM_CLOSE);	
}

void CMainFrame::OnGameNew() 
{
	gamesPlayed ++;

	if(DEMO_VERSION && gamesPlayed >= 3)
	{
		AfxMessageBox(_T("The demo version only allows 3 games in a row."), MB_ICONASTERISK | MB_OK);
		SendMessage(WM_CLOSE);	
	}

	NewGame();	
}

void CMainFrame::OnToPlay()	//How to play
{
	
	CTutorial tutorial;
	tutorial.DoModal();	
}

void CMainFrame::OnDestroy() 
{
	CFrameWnd::OnDestroy();

	////////////write data to registry////////////////////////////

	HKEY Highscore, Preview, Tileset, Checksum, Sound; 
	DWORD dwDisp;		
	DWORD dwValType = REG_DWORD;	

	DWORD dwRegVal = highScore;

	int rc;
		
	RegCreateKeyEx (HKEY_LOCAL_MACHINE, _T("Lineo\\n2"), 0, TEXT (""), 0, 0, NULL, &Highscore, &dwDisp);
	rc = RegSetValueEx(Highscore, _T("highscore"), 0, REG_DWORD , (LPBYTE)&dwRegVal, sizeof(dwRegVal));

	RegCloseKey(Highscore);		

	///////////////////////////////////////////////////////////////
	dwRegVal = showPreview;

	RegCreateKeyEx (HKEY_LOCAL_MACHINE, _T("Lineo\\n2"), 0, TEXT (""), 0, 0, NULL, &Preview, &dwDisp);
	rc = RegSetValueEx(Preview, _T("preview"), 0, REG_DWORD , (LPBYTE)&dwRegVal, sizeof(dwRegVal));

	RegCloseKey(Preview);

	///////////////////////////////////////////////////////////////
	dwRegVal = playSound;

	RegCreateKeyEx (HKEY_LOCAL_MACHINE, _T("Lineo\\n2"), 0, TEXT (""), 0, 0, NULL, &Sound, &dwDisp);
	rc = RegSetValueEx(Sound, _T("sound"), 0, REG_DWORD , (LPBYTE)&dwRegVal, sizeof(dwRegVal));

	RegCloseKey(Sound);
	
	///////////////////////////////////////////////////////////////
	dwRegVal = tileset;

	RegCreateKeyEx (HKEY_LOCAL_MACHINE, _T("Lineo\\n2"), 0, TEXT (""), 0, 0, NULL, &Tileset, &dwDisp);
	rc = RegSetValueEx(Tileset, _T("tileset"), 0, REG_DWORD , (LPBYTE)&dwRegVal, sizeof(dwRegVal));

	RegCloseKey(Tileset);		

	///////////////////////////////////////////////////////////////
	dwRegVal = timesPlayed;

	RegCreateKeyEx (HKEY_LOCAL_MACHINE, _T("Lineo\\n2"), 0, TEXT (""), 0, 0, NULL, &Checksum, &dwDisp);
	rc = RegSetValueEx(Checksum, _T("checksum"), 0, REG_DWORD , (LPBYTE)&dwRegVal, sizeof(dwRegVal));

	RegCloseKey(Checksum);		
}

void CMainFrame::OnPreview() 
{
	showPreview = !showPreview;	

	CMenu* pMenu = GetMenu();//m_wndCommandBar.GetMenuBar(0); 

	if(showPreview)
		pMenu->CheckMenuItem(ID_PREVIEW, MF_CHECKED);
	else
		pMenu->CheckMenuItem(ID_PREVIEW, MF_UNCHECKED);

	Invalidate(false);	
}

void CMainFrame::OnTs1() 
{
	tileset = 0;
	CMenu* pMenu = GetMenu();
	pMenu->CheckMenuItem(ID_TS2, MF_UNCHECKED);
	pMenu->CheckMenuItem(ID_TS3, MF_UNCHECKED);	
	pMenu->CheckMenuItem(ID_TS1, MF_CHECKED);	
	Invalidate(false);	
}

void CMainFrame::OnTs2() 
{
	tileset = 1;
	CMenu* pMenu = GetMenu();
	pMenu->CheckMenuItem(ID_TS1, MF_UNCHECKED);
	pMenu->CheckMenuItem(ID_TS3, MF_UNCHECKED);	
	pMenu->CheckMenuItem(ID_TS2, MF_CHECKED);	
	Invalidate(false);	
}

void CMainFrame::OnTs3() 
{
	tileset = 2;
	CMenu* pMenu = GetMenu();
	pMenu->CheckMenuItem(ID_TS1, MF_UNCHECKED);
	pMenu->CheckMenuItem(ID_TS2, MF_UNCHECKED);	
	pMenu->CheckMenuItem(ID_TS3, MF_CHECKED);
	Invalidate(false);	  
}

void CMainFrame::OnClearHighscore() 
{		
	if(highScore > 0)
	{
		if(AfxMessageBox(_T("Clear the Highscore (" + IntToStr(highScore) + ")?"), MB_ICONWARNING | MB_YESNO) == IDYES)
			highScore = 0;	
	}
}


void CMainFrame::PlaySound(int id)
{
	//::sndPlaySound(NULL, 0);

	if(playSound)
	{
		HRSRC hWaveRes;
		HGLOBAL hWaveData;
		LPCTSTR pWaveData;

		if (hWaveRes = ::FindResource(AfxGetResourceHandle(), MAKEINTRESOURCE(id), _T("WAVE"))) {
			if (hWaveData = ::LoadResource(AfxGetResourceHandle(), hWaveRes)) {
				if (pWaveData = (LPCTSTR)::LockResource(hWaveData)) {
					::sndPlaySound(pWaveData, SND_MEMORY | SND_ASYNC);
				}
			}
		}
	}    
}

void CMainFrame::OnToggleSound() 
{
	playSound = !playSound;	

	CMenu* pMenu = GetMenu();

	if(playSound)
		pMenu->CheckMenuItem(ID_SOUND, MF_CHECKED);
	else
		pMenu->CheckMenuItem(ID_SOUND, MF_UNCHECKED);
}

void CMainFrame::OnAppAbout() 
{
	CAboutDlg aboutDlg;

	if(DEMO_VERSION)
		aboutDlg.m_regtext = "Demo version - " + IntToStr(31-timesPlayed) + " games left";
	else
		aboutDlg.m_regtext = _T("Unlimited registered version");

	aboutDlg.DoModal();	
}

