// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////
#include "Piece.h"
#include "Space.h"
#include "Grid.h"


#if !defined(AFX_MAINFRM_H__A8B371CA_4847_475F_9EAB_9BFA508252E5__INCLUDED_)
#define AFX_MAINFRM_H__A8B371CA_4847_475F_9EAB_9BFA508252E5__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CMainFrame : public CFrameWnd
{
public:
	CMainFrame();
protected: 
	DECLARE_DYNAMIC(CMainFrame)

// Attributes
public:

// Operations
public:
	
	CPoint mouseCoord;
	CDC memDC, pieceDC, bombDC, expDC;
	
	CBitmap membmp;	
	int width, height, x;
	
	CBrush redBrush, yellowBrush;
	CFont font, smallFont;
	 
	CBitmap starImg;
	CBitmap stopImg;
	CBitmap lineoImg;
	CBitmap copyrightImg;
	CBitmap overImg;
	CBitmap highscoreImg;
	CBitmap bomb1Img, bomb2Img, explImg;
	CBitmap blindsImg;
	CBitmap tilesetImg[3];

	Grid grid;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);	
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CCeCommandBar	m_wndCommandBar;
	
// Generated message map functions
protected:
	void OnRecognizeGesture(NMHDR* pNMHDR, LRESULT* pResult);
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnPaint();
	afx_msg void OnGameQuit();
	afx_msg void OnGameNew();
	afx_msg void OnToPlay();
	afx_msg void OnDestroy();
	afx_msg void OnPreview();
	afx_msg void OnTs1();
	afx_msg void OnTs2();
	afx_msg void OnTs3();
	afx_msg void OnClearHighscore();	
	afx_msg void OnToggleSound();
	afx_msg void OnAppAbout();
	//}}AFX_MSG
	

	LPTSTR MakeString(UINT stringID);
	
	DECLARE_MESSAGE_MAP()
private:
	void PlaySound(int id);
	void NewGame();
	void DrawIntro();
	void DrawExtro();
	void DrawPiece(Piece);
	CString IntToStr(int);
	void Update();
	bool foundRows;
	bool getMoving;
	bool gameOver;
	bool newHighscore;
	int timerTicker;
	int introTicker;
	int extroTicker;
	int explosionTicker;
	int highScore;
	int tileset;
	int timesPlayed;
	int gamesPlayed;
	bool intro;	
	bool pressedBomb, showBomb, showExplosions;
	bool showPreview, playSound;
	CString str;	
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft eMbedded Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINFRM_H__A8B371CA_4847_475F_9EAB_9BFA508252E5__INCLUDED_)
