#ifndef HOOKLIB 
#define HOOKLIB 

// DLL export conventions.
#ifdef __cplusplus
#define EXPORT extern "C" __declspec (dllexport)
#else
#define EXPORT __declspec (dllexport)
#endif

#define MAX_TEXT_LENGTH 1048576

EXPORT BOOL CALLBACK hooklibInitialize(HWND hWnd);
EXPORT void CALLBACK hooklibCleanup(void);
EXPORT void CALLBACK hooklibReadActive(void);
EXPORT void CALLBACK hooklibReadFocused(BOOL verbose);
EXPORT void CALLBACK hooklibReadTitle(void);
EXPORT void CALLBACK hooklibReadStatus(void);
EXPORT void CALLBACK hooklibReadDesktop(void);
EXPORT void CALLBACK hooklibRepeat(void);
EXPORT void CALLBACK hooklibEchoChars(BOOL enable);
EXPORT void CALLBACK hooklibEchoCommands(BOOL enable);
EXPORT void CALLBACK hooklibEchoModifiers(BOOL enable);
EXPORT void CALLBACK hooklibSpeakShortcuts(BOOL enable);
EXPORT void CALLBACK hooklibSpeakEditChange(BOOL enable);
LRESULT CALLBACK callprocHookFunction(int ncode, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK cbtHookFunction(int ncode, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK kbdHookFunction(int ncode, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK mouseHookFunction(int ncode, WPARAM wParam, LPARAM lParam);
void notifyObserver(BOOL interrupt);
BOOL CALLBACK enumerateDescendants(HWND hwnd, LPARAM lParam);
BOOL CALLBACK enumerateDirectDescendants(HWND hwnd, LPARAM lParam);
void filterShortcut(void);
void handleControls(HWND hWindow, BOOL verbose);
void handleCommon(HWND hWindow);
void handleButtons(HWND hWindow, BOOL verbose);
void handleComboBox(HWND hWindow, BOOL verbose);
void handleEdit(HWND hWindow, BOOL verbose);
void handleListBox(HWND hWindow, BOOL verbose);
void handleMDIClient(HWND hWindow, BOOL verbose);
void handleScrollBar(HWND hWindow, BOOL verbose);
void handleStaticText(HWND hWindow);
void handleAnimation(HWND hWindow);
void handleComboBoxEx(HWND hWindow);
void handleDateTimeControl(HWND hWindow, BOOL verbose);
void handleHeaderControl(HWND hWindow, BOOL verbose);
void handleHotKeyControl(HWND hWindow, BOOL verbose);
void handleIPAddress(HWND hWindow, BOOL verbose);
void handleListView(HWND hWindow, BOOL verbose);
void handleMonthCalControl(HWND hWindow, BOOL verbose);
void handlePagerControl(HWND hWindow);
void handleProgressBar(HWND hWindow, BOOL verbose);
void handleReBar(HWND hWindow);
void handleSpinControl(HWND hWindow, BOOL verbose);
void handleStatusBar(HWND hWindow, BOOL verbose);
void handleTabControl(HWND hWindow, BOOL verbose);
void handleToolBar(HWND hWindow);
void handleToolTip(HWND hWindow);
void handleTrackBar(HWND hWindow, BOOL verbose);
void handleTreeView(HWND hWindow, BOOL verbose);
void handleMenus(WPARAM wParam, LPARAM lParam);
void handleNotifications(LPARAM lParam);
void handleKeys(WPARAM wParam, LPARAM lParam);
#endif
