# ROAR, the Really Old Ass Reader for Windows
This is a fairly basic screen reader that runs on all32-bit versions of Windows, going back to NT 3.51. It might run on older versions of NT, however this isnt something I have gotten around to testing.
## Hotkeys
This screen reader has several global hotkeys that can be used from anywhere in Windows. These are listed below.
* Ctrl+Shift+T: Read window title (includes name of window class).
* Ctrl+Shift+B: Read status bar.
* Ctrl+Shift+W: Read window contents.
* Ctrl+Shift+Space: Read currently focused control.
* Ctrl+Shift+Backspace: Read verbose description of currently focused control.
* Ctrl+Shift+D: Read desktop window.
* Ctrl+Shift+L: Repeat last speech.
* Ctrl+Shift+S: Bring up settings dialog.
* Ctrl+Shift+R: Reinstall hooks.
* Ctrl+Shift+H: Hide or show ROAR window.
* Ctrl+Shift+E: Reload speech settings.
* Ctrl+Shift+A: Restart speech engine.

## Settings
This section attempts to describe the various options in the settings dialog.
* Audio Device: Sets the audio output device that is used for software generated speech.
* Own Audio Device: Keeps the sound card open even when nothing is being spoken. When this option is used with single channel sound cards, nothing else will be able to play.
* Volume: Sets the audio volume.
* Enable Hardware Output: Enables hardware output mode, which sends text to a serial port. This feature works best with the DECtalk Express speech synthesizer.
* COM Port: Sets the COM port that is used for hardware output.
* Speaker: Sets the speaking voice.
* Speaking Rate: Sets how fast the speech synthesizer speaks (in words per minute).
* User Dictionary: Sets a user defined dictionary that is loaded into the software synthesizer.
* Echo Characters: Speaks characters as they are typed.
* Echo Command Keys: Speaks command keys when they are pressed.
* Echo Modifier Keys: Speaks modifier keys when they are pressed.
* Speak Shortcut Keys: Speaks shortcut keys associated with controls and menu items.
* Speak on Edit Change: Reads focused edit controls when they are updated.
* Speak Startup Message: Speaks a message when the screen reader successfully starts.

## Background
I have always been fascinated with older operating systems, especially older versions of Windows. One of the Windows versions I always wanted to experiment with is NT 3.x, and I happen to have a virtual machine that has NT 3.51 installed. I was able to get sighted assistance with getting sound blaster 16 drivers installed in the virtual machine, and that is how things have been for 8 years or so. I recently stumbled across an essay written by the late Veli-Pekka Ttil that describes how to use Windows hooks for accessibility. For anyone interested, it can be found [here](https://web.archive.org/web/20071014052751/http://tols17.oulu.fi:80/~vtatila/ohjy/english/index.html).
After initially reading the article, I realized I could build a rudimentary screen reader with nothing more than the Win32 API and a supported speech synthesizer. I know the software versions of the DECtalk text to speech system can run on Windows NT 3.51, as this is something I have been able to test. Considering I was unable to find a decent screen reader for NT 3.x, able to verify that a decent speech synthesizer works on this platform, and have experience writing Win32 applications, there was only one logical solution in mind. I decided to write a screen reader myself. I downloaded the sample source code included in the article linked above, and improved on it. I hope you enjoy the result!
## How the Name Came About
Before I started work on this project, I told a friend about my idea, and asked if he had any suggestions for names. He suggested Old Ass Reader, and I really liked that name, so that is what I initially went with. A couple days later, I was telling someone else about the project, and this person suggested I add Really to the start of the name. I thought that was a great idea, Especially considering the abbreviated project name was now an acronym.
## Hardware Synthesizer Support
ROAR now has a mode that can send text to a serial port. This is useful if you are on a system without a working sound card, or a sound driver isn't currently installed. If a sound card isn't detected on startup, the program will attempt to open a serial port. The PC speaker will also beep when this condition is met.
## Loading and Saving Custom Configurations
If you would like to load and or save the configuration file in a different location or under a different filename, you can pass the configuration file path on the command line. For example, to have settings be saved to a file named test.cfg in a folder named configs on drive A, you would type the following to launch ROAR on the command line. "ROAR A:\configs\test.cfg" (without the quotes). If the configuration file path has spaces in it, you will have to surround it with quotes.
## Extra Notes
* DECtalk is the only supported speech synthesizer at this time.
* Owner-drawn combo and list boxes that don't expose any text (such as the one's in the Windows NT 3.51 File Manager) won't properly read.
