#include "hooklib.h" // Includes WIndows.h, also.

HWND textBox = NULL; // Read-only edit, child.
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM); // Window procedure.

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	static TCHAR szAppName[] = TEXT("SysHook");
    MSG msg;

	WNDCLASS wndclass = {CS_HREDRAW | CS_VREDRAW, WndProc, 0, 0, hInstance, LoadIcon(NULL, IDI_APPLICATION), LoadCursor(NULL, IDC_ARROW), (HBRUSH) GetStockObject(WHITE_BRUSH), NULL, szAppName};
	RegisterClass(&wndclass);
	HWND hwnd = CreateWindow(szAppName, TEXT("Accessibility Demo"), WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);
	// Set always-on-top, ignore the rest.
	SetWindowPos(hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
	if(! hooklibInitialize(hwnd))
	{ // If setting up the hooks failed.
		MessageBox(NULL, TEXT("Error installing a hook."), TEXT("ERROR"), 0);
		return GetLastError();
	} // if
	ShowWindow(hwnd, iCmdShow);
    UpdateWindow(hwnd);

	// The message loop:
	while(GetMessage(&msg, NULL, 0, 0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    } // while
    return msg.wParam;
} // winmain

LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static COPYDATASTRUCT* copyData = NULL; // For IPC with hooklib.dll.
	switch(message)
    {
		case WM_CREATE: // Create the read-only text box.
			textBox = CreateWindow(TEXT("edit"), NULL, WS_CHILD|WS_VISIBLE|WS_BORDER|
			ES_LEFT|ES_MULTILINE|ES_READONLY|WS_HSCROLL|WS_VSCROLL|ES_AUTOHSCROLL|
			ES_AUTOVSCROLL, 0, 0, 0, 0, hwnd, NULL,
			((LPCREATESTRUCT)lParam)->hInstance, NULL);
			return 0;
        case WM_SETFOCUS: // Set the focus to the edit control.
			SetFocus(textBox);
			return 0;
		case WM_SIZE: // Resize to parent dimensions, don't reposition, do repaint.
			MoveWindow(textBox, 0, 0, LOWORD(lParam), HIWORD(lParam), TRUE);
			return 0;
		case WM_COPYDATA: // A message from hooklib.dll - display it.
			copyData = (COPYDATASTRUCT*) lParam;
			SetWindowText(textBox, (PTCHAR) copyData->lpData);
			return TRUE;
		case WM_DESTROY: // App quitted: kill windows, free hooks.
			PostQuitMessage(0);
			hooklibCleanup();
			return 0;
	} // switch
    return DefWindowProc(hwnd, message, wParam, lParam);
} // window procedure
