#include "hooklib.h"
#include <cassert>
// Shared data section that's global to all DLL instances.
#pragma data_seg ("shared")
HHOOK hCbtHook = NULL; // CBT-hook handle.
HHOOK hCallprocHook = NULL; // Callwndproc-hook handle.
HWND hObserver = NULL; // Main app to be notified of events.
CWPSTRUCT* cwp = NULL; // Message parameters to the callwndproc hook.
TCHAR textOut[MAX_TEXT_LENGTH] = {'\0'}; // Output buffer: message to observer.
TCHAR textBuf[MAX_TEXT_LENGTH] = {'\0'}; // Scratch-buffer for appending.
#pragma data_seg ()
// Linker options for data segment.
#pragma comment(linker,"/SECTION:shared,RWS")

HINSTANCE hDllInstance = NULL; // Current DLL instance.

int WINAPI DllMain(HINSTANCE hInstance, DWORD fdwReason, PVOID pvReserved)
{
	if(fdwReason == DLL_PROCESS_ATTACH)
		hDllInstance = hInstance; // Save current instance.
	return TRUE;
} // main

LRESULT CALLBACK cbtHookFunction(int ncode, WPARAM wParam, LPARAM lParam)
{
	if(ncode >= 0)
	{ // Pass on the message unmodified.
		if(ncode == HCBT_SETFOCUS && GetParent((HWND) wParam) != hObserver  && ((HWND) wParam != hObserver))
		{ // Handle focuschange.
			lstrcat(textOut, "Focus ");
			handleControls((HWND) wParam);
			lstrcat(textOut, "\r\n");
			notifyObserver();
		} // if
		else if(ncode == HCBT_ACTIVATE && ((HWND) wParam) != hObserver)
		{ // Get the children of the window being activated.
			HWND hWindow = (HWND) wParam;
			lstrcat(textOut, "Active window ");
			handleCommon(hWindow);
			lstrcat(textOut, "\r\nChildren:\r\n");
			EnumChildWindows(hWindow, enumerateDirectDescendants, (LPARAM) hWindow);
			notifyObserver();
		} // else if
	} // if
	return CallNextHookEx(hCbtHook, ncode, wParam, lParam);
} // cbtHookFunction

LRESULT CALLBACK callprocHookFunction(int ncode, WPARAM wParam, LPARAM lParam)
{
	if(ncode >= 0)
	{ // Can process the message.
		cwp = (CWPSTRUCT*) lParam;
		if(cwp->message == WM_COMMAND && HIWORD(cwp->wParam) == BN_CLICKED)
		{ // On button click.
			lstrcat(textOut, "State ");
			handleControls((HWND) cwp->lParam);
			lstrcat(textOut, "\r\n");
			notifyObserver();
		} // if
		else if(cwp->message ==	WM_MENUSELECT)
		{ // On menu selection change.
			lstrcat(textOut, "Menu item ");
			handleMenus(cwp->wParam, cwp->lParam);
			notifyObserver();
		} // else if
	} // if
	return CallNextHookEx(hCallprocHook, ncode, wParam, lParam);
} // callprocHookFunction

BOOL CALLBACK enumerateDirectDescendants(HWND hwnd, LPARAM lParam)
{
	if(GetParent(hwnd) == ((HWND) lParam))
	{ // Only if it's a direct descendant.
		lstrcat(textOut, "-");
		handleControls(hwnd);
		lstrcat(textOut, "\r\n");
	} // if
	return TRUE;
} // enumerateDirectDescendants

void notifyObserver()
{
	// Send the text in textOut to main window.
	COPYDATASTRUCT data = {0, lstrlen(textOut) + 1, (PVOID) textOut};
	SendMessage(hObserver, WM_COPYDATA, (WPARAM) hDllInstance, (LPARAM) &data);

	// Clear the buffer as we aren't doing dynamic memory allocation.
	// The limit may need to be tweaked to match user preference.
	if(lstrlen(textOut) >= MAX_TEXT_LENGTH / 3)
	{ // Append a NULL in front.
		strcpy(textOut, "\0");
		strcpy(textBuf, "\0");
	} // if
} // notifyObserver

void handleControls(HWND hWindow)
{
	handleCommon(hWindow);
	GetClassName(hWindow, textBuf, MAX_TEXT_LENGTH);
	if(lstrcmp(textBuf, "Button") == 0)
		handleButtons(hWindow);
} // handleControls

void handleCommon(HWND hWindow)
{
	GetClassName(hWindow, textBuf, MAX_TEXT_LENGTH);
	lstrcat(textOut, textBuf);
	GetWindowText(hWindow, textBuf, MAX_TEXT_LENGTH);
	lstrcat(textOut, " ");
	lstrcat(textOut, textBuf);
} // handleCommon

void handleButtons(HWND hWindow)
{
	DWORD s = GetWindowLongPtr(hWindow, GWL_STYLE) & 0xFL; // All but the 4 LSB.
	BOOL isCheckable = TRUE; // SHould query whether it's checked.
	lstrcat(textOut, " ");
	if(s == BS_PUSHBUTTON || s == BS_DEFPUSHBUTTON)
	{
		isCheckable = FALSE;
		lstrcat(textOut, "push button ");
	} // if
	else if(s == BS_GROUPBOX)
	{
		isCheckable = FALSE;
		lstrcat(textOut, "group box ");
	} // else if
	else if(s == BS_USERBUTTON || s == BS_OWNERDRAW)
	{
		isCheckable = FALSE;
		lstrcat(textOut, "customized button ");
	} // else if
	else if(s == BS_CHECKBOX || s == BS_AUTOCHECKBOX)
		lstrcat(textOut, "check box ");
	else if(s == BS_3STATE || s == BS_AUTO3STATE)
		lstrcat(textOut, "3-state check box ");
	else if(s == BS_RADIOBUTTON || s == BS_AUTORADIOBUTTON)
		lstrcat(textOut, "radio button ");

	if(isCheckable == TRUE)
	{
		switch(SendMessage(hWindow, BM_GETCHECK, 0, 0))
		{
			case BST_CHECKED:
					lstrcat(textOut, "selected");
					break;
			case BST_INDETERMINATE:
				lstrcat(textOut, "partially Selected");
				break;
			case BST_UNCHECKED:
				lstrcat(textOut, "unselected");
				break;
		} // switch
	} // if
} // handleButtons

void handleMenus(WPARAM wParam, LPARAM lParam)
{
	HMENU handle = (HMENU) lParam;
	UINT offset = LOWORD(wParam);
	UINT flags = HIWORD(wParam);
	if(flags == 0xFFFF && handle == NULL)
	{ // The menu is closed.
		lstrcat(textOut, "Menu closed\r\n");
		return;
	} // if
	UINT offsetStyle; // Search by id or index.
	if(flags & MF_POPUP)
		offsetStyle = MF_BYPOSITION; // If it's got a popup, by index then.
	else
		offsetStyle = MF_BYCOMMAND; // By id.
	GetMenuString(handle, offset, textBuf, MAX_TEXT_LENGTH, offsetStyle);
	lstrcat(textOut, textBuf);
	lstrcat(textOut, " ");
	if(flags & MF_GRAYED)
		lstrcat(textOut, "grayed ");
	if(flags & MF_CHECKED)
		lstrcat(textOut, "checked ");
	if(flags & MF_POPUP)
		lstrcat(textOut, "has Sub-menu ");
	if(flags & MF_BITMAP)
		lstrcat(textOut, "bitmap ");
	if(flags & MF_OWNERDRAW)
		lstrcat(textOut, "owner-drawn ");
	if(flags & MF_SYSMENU)
		lstrcat(textOut, "in system menu ");
	lstrcat(textOut, "\r\n");
} // handleMenus

EXPORT BOOL CALLBACK hooklibInitialize(HWND hWnd)
{
	// There musn't be any former hooks by this app. Ensure single-instance only!
	assert(hCbtHook == NULL && hCallprocHook == NULL);
	hObserver = hWnd;
	hCbtHook = SetWindowsHookEx(WH_CBT, cbtHookFunction, hDllInstance, 0);
	hCallprocHook = SetWindowsHookEx(WH_CALLWNDPROC, callprocHookFunction, hDllInstance, 0);
	return hCbtHook && hCallprocHook ? TRUE : FALSE;
} // hooklibInitialize

EXPORT void CALLBACK hooklibCleanup()
{
	// Unhooking always returns true.
	UnhookWindowsHookEx(hCbtHook);
	UnhookWindowsHookEx(hCallprocHook);
} // hooklibCleanup