;----------------------------------------------------------------------------;
;                               WINDOWS.INC                                  ;
;----------------------------------------------------------------------------;
;           Using H2INC to Convert the WINDOWS.H include file.               ;
;----------------------------------------------------------------------------;
;                                                                            ;
; THE EXPLANATION BEHIND THESE CHANGES CAN BE FOUND IN THE 'USER-DEFINED AND ;
; PREDEFINED CONSTANTS' SECTION OF THE ENVIRONMENT & TOOLS CHAPTER ON H2INC. ;
;                                                                            ;
; To use the windows.h file in MASM, some changes have to be made before     ;
; running the file through H2INC:                                            ;
;                                                                            ;
;       1. Since MASM keywords should not be redefined, an underscore was    ;
;          added to the following Windows keywords: SIZE, cx, dx, length,    ;
;          offset. You should remember appending the underscore in your MASM ;
;          programs, for example _SIZE, _cx, _dx, ...                        ;
;                                                                            ;
;       2. Parenthesis around negative numbers were removed: (-4) is now -4  ;
;                                                                            ;
;       3. The MAKEINTRESOURCE and MAKEINTATOM macros were eliminated:       ;
;              They were changed to                                          ;
;                                       #define MAKEINTRESOURCE(i) i         ;
;                                       #define MAKEINTATOM(i) i             ;
;          If any of the resources were negative numbers, #2 above would     ;
;          apply as well.                                                    ;
;                                                                            ;
;       4. Definitions that included a type cast conversion were altered     ;
;            i.e.,            '#define HFILE_ERROR ((HFILE) -1)'             ;
;            is now           '#define HFILE_ERROR -1'                       ;
;          This was done for: HINSTANCE_ERROR, HFILE_ERROR, HWND_BROADCAST,  ;
;               HWND_DESKTOP, CW_USEDEFAULT, HWND_TOP, HWND_BOTTOM,          ;
;               HWND_TOPMOST and HWND_NOTOPMOST.                             ;
;                                                                            ;
;----------------------------------------------------------------------------;
;                                                                            ;
; After running windows.h through H2INC, some change were made to the file   ;
;                                                                            ;
;	THESE CHANGES ARE OPTIONAL. THEY ONLY ENHANCE WINDOWS.INC.           ;
;                                                                            ;
;	1. If ?WINPROLOGUE is defined, then PROLOGUE.INC is included with    ;
;	   the INCBP and LOADDS options.                                     ;
;                                                                            ;
;	2. The DOS3Call prototype was added. This function isn't defined in  ;
;	   WINDOWS.H, but assembly programmers find it useful.               ;
;                                                                            ;
;	3. IFDEFs corresponding to WINDOWS.H ifdefs were included. To reduce ;
;	   assembly time, these variables can be set to avoid inclusion of   ;
;	   some areas. The meaning of the variables follows, by way of the   ;
;	   comment included in WINDOWS.H.			 	     ;
;                                                                            ;
;----------------------------------------------------------------------------;

ifdef	?WINPROLOGUE

ECHO
ECHO Loading prologue.inc.
ECHO
                                                  ;------ PROLOGUE.INC ------;
?WP_INCBP       = 1                               ; INC  BP on all far procs ;
?WP_LOADDS      = 1                               ; LOAD DS on all far procs ;
                include prologue.inc              ;--------------------------;

endif

; Not in WINDOWS.H, but useful for assembly programming 

DOS3Call	PROTO FAR PASCAL		 ; INT 21h CALLING ROUTINE

comment ^

/*****************************************************************************\
*                                                                             *
* windows.h -   Windows functions, types, and definitions                     *
*                                                                             *
*               Version 3.10                                                  *
*                                                                             *
*               Copyright (c) 1985-1992, Microsoft Corp. All rights reserved. *
*                                                                             *
*******************************************************************************
*
* The following symbols control inclusion of various parts of this file:
*
* WINVER            Windows version number (0x030a).  To exclude
*                   definitions introduced in version 3.1 (or above)
*                   #define WINVER 0x0300 before #including <windows.h>
*
* #define:          To prevent inclusion of:
*
* NOKERNEL          KERNEL APIs and definitions
* NOGDI             GDI APIs and definitions
* NOUSER            USER APIs and definitions
* NOSOUND           Sound APIs and definitions
* NOCOMM            Comm driver APIs and definitions
* NODRIVERS         Installable driver APIs and definitions
*
* NOHELP            Help support
* NOCLIPBOARD       Clipboard APIs and definitions
* NOMENUS           Menu APIs
* NOSCROLL          Scrolling APIs and scroll bar control
*
\****************************************************************************/

^

option expr32
option casemap:none

; Begin of file win31.h

ifndef _INC_WINDOWS_INC		; if WINDOWS.INC hasn't been included
_INC_WINDOWS_INC = 1

WINVER		EQU		00000030ah	; assume WINDOWS 3.1

BOOL		TYPEDEF		SWORD

FALSE		EQU		0t
TRUE		EQU		1t
UINT		TYPEDEF		WORD

WPARAM		TYPEDEF		UINT

LPARAM		TYPEDEF		SDWORD

LRESULT		TYPEDEF		SDWORD

NULL		EQU		0t
PSTR		TYPEDEF		NEAR PTR SBYTE

NPSTR		TYPEDEF		NEAR PTR SBYTE

LPSTR		TYPEDEF		FAR PTR SBYTE

LPCSTR		TYPEDEF		FAR PTR SBYTE

PBYTE		TYPEDEF		NEAR PTR BYTE

LPBYTE		TYPEDEF		FAR PTR BYTE

PINT		TYPEDEF		NEAR PTR SWORD

LPINT		TYPEDEF		FAR PTR SWORD

PWORD		TYPEDEF		NEAR PTR WORD

LPWORD		TYPEDEF		FAR PTR WORD

PLONG		TYPEDEF		NEAR PTR SDWORD

LPLONG		TYPEDEF		FAR PTR SDWORD

PDWORD		TYPEDEF		NEAR PTR DWORD

LPDWORD		TYPEDEF		FAR PTR DWORD

LPVOID		TYPEDEF		FAR PTR 

HANDLE		TYPEDEF		UINT

PHANDLE		TYPEDEF		PTR HANDLE

SPHANDLE		TYPEDEF		NEAR PTR HANDLE

LPHANDLE		TYPEDEF		FAR PTR HANDLE

HGLOBAL		TYPEDEF		HANDLE

HLOCAL		TYPEDEF		HANDLE

GLOBALHANDLE		TYPEDEF		HANDLE

LOCALHANDLE		TYPEDEF		HANDLE

ATOM		TYPEDEF		UINT

FARPROC		TYPEDEF		FAR PTR 

NEARPROC		TYPEDEF		NEAR PTR 

HSTR		TYPEDEF		UINT

HINSTANCE		TYPEDEF		UINT

HMODULE		TYPEDEF		HINSTANCE

ifndef NOKERNEL	; KERNEL FUNCTIONS

@proto_0		TYPEDEF		PROTO FAR PASCAL 
GetVersion		PROTO		@proto_0

@proto_1		TYPEDEF		PROTO FAR PASCAL :UINT
GetFreeSpace		PROTO		@proto_1

@proto_2		TYPEDEF		PROTO FAR PASCAL 
GetCurrentPDB		PROTO		@proto_2

@proto_3		TYPEDEF		PROTO FAR PASCAL :LPSTR, :UINT
GetWindowsDirectory		PROTO		@proto_3

@proto_4		TYPEDEF		PROTO FAR PASCAL :LPSTR, :UINT
GetSystemDirectory		PROTO		@proto_4

@proto_5		TYPEDEF		PROTO FAR PASCAL :UINT
GetFreeSystemResources		PROTO		@proto_5

GFSR_SYSTEMRESOURCES		EQU		000000000h
GFSR_GDIRESOURCES		EQU		000000001h
GFSR_USERRESOURCES		EQU		000000002h

@proto_6		TYPEDEF		PROTO FAR PASCAL 
GetWinFlags		PROTO		@proto_6

WF_PMODE		EQU		000000001h
WF_CPU286		EQU		000000002h
WF_CPU386		EQU		000000004h
WF_CPU486		EQU		000000008h
WF_STANDARD		EQU		000000010h
WF_WIN286		EQU		000000010h
WF_ENHANCED		EQU		000000020h
WF_WIN386		EQU		000000020h
WF_CPU086		EQU		000000040h
WF_CPU186		EQU		000000080h
WF_LARGEFRAME		EQU		000000100h
WF_SMALLFRAME		EQU		000000200h
WF_80x87		EQU		000000400h
WF_PAGING		EQU		000000800h
WF_WLO		EQU		000008000h
@proto_7		TYPEDEF		PROTO FAR PASCAL 
GetDOSEnvironment		PROTO		@proto_7

@proto_8		TYPEDEF		PROTO FAR PASCAL 
GetCurrentTime		PROTO		@proto_8

@proto_9		TYPEDEF		PROTO FAR PASCAL 
GetTickCount		PROTO		@proto_9

@proto_10		TYPEDEF		PROTO FAR PASCAL 
GetTimerResolution		PROTO		@proto_10

@proto_11		TYPEDEF		PROTO FAR PASCAL :UINT, :FAR PTR 
LogError		PROTO		@proto_11

@proto_12		TYPEDEF		PROTO FAR PASCAL :UINT, :FARPROC, :FAR PTR 
LogParamError		PROTO		@proto_12

ERR_WARNING		EQU		000008000h
ERR_PARAM		EQU		000004000h
ERR_SIZE_MASK		EQU		000003000h
ERR_BYTE		EQU		000001000h
ERR_WORD		EQU		000002000h
ERR_DWORD		EQU		000003000h
ERR_BAD_VALUE		EQU		000006001h
ERR_BAD_FLAGS		EQU		000006002h
ERR_BAD_INDEX		EQU		000006003h
ERR_BAD_DVALUE		EQU		000007004h
ERR_BAD_DFLAGS		EQU		000007005h
ERR_BAD_DINDEX		EQU		000007006h
ERR_BAD_PTR		EQU		000007007h
ERR_BAD_FUNC_PTR		EQU		000007008h
ERR_BAD_SELECTOR		EQU		000006009h
ERR_BAD_STRING_PTR		EQU		00000700ah
ERR_BAD_HANDLE		EQU		00000600bh
ERR_BAD_HINSTANCE		EQU		000006020h
ERR_BAD_HMODULE		EQU		000006021h
ERR_BAD_GLOBAL_HANDLE		EQU		000006022h
ERR_BAD_LOCAL_HANDLE		EQU		000006023h
ERR_BAD_ATOM		EQU		000006024h
ERR_BAD_HFILE		EQU		000006025h
ERR_BAD_HWND		EQU		000006040h
ERR_BAD_HMENU		EQU		000006041h
ERR_BAD_HCURSOR		EQU		000006042h
ERR_BAD_HICON		EQU		000006043h
ERR_BAD_HDWP		EQU		000006044h
ERR_BAD_CID		EQU		000006045h
ERR_BAD_HDRVR		EQU		000006046h
ERR_BAD_COORDS		EQU		000007060h
ERR_BAD_GDI_OBJECT		EQU		000006061h
ERR_BAD_HDC		EQU		000006062h
ERR_BAD_HPEN		EQU		000006063h
ERR_BAD_HFONT		EQU		000006064h
ERR_BAD_HBRUSH		EQU		000006065h
ERR_BAD_HBITMAP		EQU		000006066h
ERR_BAD_HRGN		EQU		000006067h
ERR_BAD_HPALETTE		EQU		000006068h
ERR_BAD_HMETAFILE		EQU		000006069h
ERR_GALLOC		EQU		000000001h
ERR_GREALLOC		EQU		000000002h
ERR_GLOCK		EQU		000000003h
ERR_LALLOC		EQU		000000004h
ERR_LREALLOC		EQU		000000005h
ERR_LLOCK		EQU		000000006h
ERR_ALLOCRES		EQU		000000007h
ERR_LOCKRES		EQU		000000008h
ERR_LOADMODULE		EQU		000000009h
ERR_CREATEDLG		EQU		000000040h
ERR_CREATEDLG2		EQU		000000041h
ERR_REGISTERCLASS		EQU		000000042h
ERR_DCBUSY		EQU		000000043h
ERR_CREATEWND		EQU		000000044h
ERR_STRUCEXTRA		EQU		000000045h
ERR_LOADSTR		EQU		000000046h
ERR_LOADMENU		EQU		000000047h
ERR_NESTEDBEGINPAINT		EQU		000000048h
ERR_BADINDEX		EQU		000000049h
ERR_CREATEMENU		EQU		00000004ah
ERR_CREATEDC		EQU		000000080h
ERR_CREATEMETA		EQU		000000081h
ERR_DELOBJSELECTED		EQU		000000082h
ERR_SELBITMAP		EQU		000000083h
tagWINDEBUGINFO		STRUCT 1t
flags		UINT		?
dwOptions		DWORD		?
dwFilter		DWORD		?
achAllocModule		SBYTE		8t DUP (?)
dwAllocBreak		DWORD		?
dwAllocCount		DWORD		?
tagWINDEBUGINFO		ENDS

WINDEBUGINFO		TYPEDEF		tagWINDEBUGINFO

@proto_13		TYPEDEF		PROTO FAR PASCAL :FAR PTR WINDEBUGINFO, :UINT
GetWinDebugInfo		PROTO		@proto_13

@proto_14		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagWINDEBUGINFO
SetWinDebugInfo		PROTO		@proto_14

@proto_15		TYPEDEF		PROTO FAR C :UINT, :LPCSTR, :VARARG
DebugOutput		PROTO		@proto_15

WDI_OPTIONS		EQU		000000001h
WDI_FILTER		EQU		000000002h
WDI_ALLOCBREAK		EQU		000000004h
DBO_CHECKHEAP		EQU		000000001h
DBO_BUFFERFILL		EQU		000000004h
DBO_DISABLEGPTRAPPING		EQU		000000010h
DBO_CHECKFREE		EQU		000000020h
DBO_SILENT		EQU		000008000h
DBO_TRACEBREAK		EQU		000002000h
DBO_WARNINGBREAK		EQU		000001000h
DBO_NOERRORBREAK		EQU		000000800h
DBO_NOFATALBREAK		EQU		000000400h
DBO_INT3BREAK		EQU		000000100h
DBF_TRACE		EQU		000000000h
DBF_WARNING		EQU		000004000h
DBF_ERROR		EQU		000008000h
DBF_FATAL		EQU		00000c000h
DBF_KERNEL		EQU		000001000h
DBF_KRN_MEMMAN		EQU		000000001h
DBF_KRN_LOADMODULE		EQU		000000002h
DBF_KRN_SEGMENTLOAD		EQU		000000004h
DBF_USER		EQU		000000800h
DBF_GDI		EQU		000000400h
DBF_MMSYSTEM		EQU		000000040h
DBF_PENWIN		EQU		000000020h
DBF_APPLICATION		EQU		000000008h
DBF_DRIVER		EQU		000000010h
@proto_16		TYPEDEF		PROTO FAR PASCAL :SWORD
FatalExit		PROTO		@proto_16

@proto_17		TYPEDEF		PROTO FAR PASCAL :UINT, :LPCSTR
FatalAppExit		PROTO		@proto_17

@proto_18		TYPEDEF		PROTO FAR PASCAL :DWORD, :UINT
ExitWindows		PROTO		@proto_18

EW_RESTARTWINDOWS		EQU		000000042h
EW_REBOOTSYSTEM		EQU		000000043h
@proto_19		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR
ExitWindowsExec		PROTO		@proto_19

@proto_20		TYPEDEF		PROTO FAR PASCAL 
DebugBreak		PROTO		@proto_20

@proto_21		TYPEDEF		PROTO FAR PASCAL :LPCSTR
OutputDebugString		PROTO		@proto_21

SEM_FAILCRITICALERRORS		EQU		000000001h
SEM_NOGPFAULTERRORBOX		EQU		000000002h
SEM_NOOPENFILEERRORBOX		EQU		000008000h
@proto_22		TYPEDEF		PROTO FAR PASCAL :UINT
SetErrorMode		PROTO		@proto_22

@proto_23		TYPEDEF		PROTO FAR PASCAL :FAR PTR , :UINT
IsBadReadPtr		PROTO		@proto_23

@proto_24		TYPEDEF		PROTO FAR PASCAL :FAR PTR , :UINT
IsBadWritePtr		PROTO		@proto_24

@proto_25		TYPEDEF		PROTO FAR PASCAL :FAR PTR , :DWORD
IsBadHugeReadPtr		PROTO		@proto_25

@proto_26		TYPEDEF		PROTO FAR PASCAL :FAR PTR , :DWORD
IsBadHugeWritePtr		PROTO		@proto_26

@proto_27		TYPEDEF		PROTO FAR PASCAL :FARPROC
IsBadCodePtr		PROTO		@proto_27

@proto_28		TYPEDEF		PROTO FAR PASCAL :FAR PTR , :UINT
IsBadStringPtr		PROTO		@proto_28

@proto_29		TYPEDEF		PROTO FAR PASCAL 
ProfInsChk		PROTO		@proto_29

@proto_30		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD
ProfSetup		PROTO		@proto_30

@proto_31		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD
ProfSampRate		PROTO		@proto_31

@proto_32		TYPEDEF		PROTO FAR PASCAL 
ProfStart		PROTO		@proto_32

@proto_33		TYPEDEF		PROTO FAR PASCAL 
ProfStop		PROTO		@proto_33

@proto_34		TYPEDEF		PROTO FAR PASCAL 
ProfClear		PROTO		@proto_34

@proto_35		TYPEDEF		PROTO FAR PASCAL 
ProfFlush		PROTO		@proto_35

@proto_36		TYPEDEF		PROTO FAR PASCAL 
ProfFinish		PROTO		@proto_36

CATCHBUF		TYPEDEF		SWORD

LPCATCHBUF		TYPEDEF		FAR PTR SWORD

@proto_37		TYPEDEF		PROTO FAR PASCAL :FAR PTR SWORD
Catch		PROTO		@proto_37

@proto_38		TYPEDEF		PROTO FAR PASCAL :FAR PTR SWORD, :SWORD
Throw		PROTO		@proto_38

@proto_39		TYPEDEF		PROTO FAR PASCAL 
SwitchStackBack		PROTO		@proto_39

@proto_40		TYPEDEF		PROTO FAR PASCAL :UINT, :UINT, :UINT
SwitchStackTo		PROTO		@proto_40

@proto_41		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPVOID
LoadModule		PROTO		@proto_41

@proto_42		TYPEDEF		PROTO FAR PASCAL :HINSTANCE
FreeModule		PROTO		@proto_42

@proto_43		TYPEDEF		PROTO FAR PASCAL :LPCSTR
LoadLibrary		PROTO		@proto_43

@proto_44		TYPEDEF		PROTO FAR PASCAL :HINSTANCE
FreeLibrary		PROTO		@proto_44

@proto_45		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :UINT
WinExec		PROTO		@proto_45

@proto_46		TYPEDEF		PROTO FAR PASCAL :LPCSTR
GetModuleHandle		PROTO		@proto_46

@proto_47		TYPEDEF		PROTO FAR PASCAL :HINSTANCE
GetModuleUsage		PROTO		@proto_47

@proto_48		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :LPSTR, :SWORD
GetModuleFileName		PROTO		@proto_48

@proto_49		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :LPCSTR
GetProcAddress		PROTO		@proto_49

@proto_50		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :PTR BYTE, :SWORD
GetInstanceData		PROTO		@proto_50

@proto_51		TYPEDEF		PROTO FAR PASCAL :FARPROC
GetCodeHandle		PROTO		@proto_51

tagSEGINFO		STRUCT 1t
offSegment		UINT		?
cbSegment		UINT		?
flags		UINT		?
cbAlloc		UINT		?
h		HGLOBAL		?
alignShift		UINT		?
reserved		UINT		2t DUP (?)
tagSEGINFO		ENDS

SEGINFO		TYPEDEF		tagSEGINFO

LPSEGINFO		TYPEDEF		FAR PTR SEGINFO

@proto_52		TYPEDEF		PROTO FAR PASCAL :FARPROC, :FAR PTR SEGINFO
GetCodeInfo		PROTO		@proto_52

@proto_53		TYPEDEF		PROTO FAR PASCAL :FARPROC, :HINSTANCE
MakeProcInstance		PROTO		@proto_53

@proto_54		TYPEDEF		PROTO FAR PASCAL :FARPROC
FreeProcInstance		PROTO		@proto_54

@proto_55		TYPEDEF		PROTO FAR PASCAL :UINT
SetSwapAreaSize		PROTO		@proto_55

@proto_56		TYPEDEF		PROTO FAR PASCAL :UINT
SwapRecording		PROTO		@proto_56

@proto_57		TYPEDEF		PROTO FAR PASCAL 
ValidateCodeSegments		PROTO		@proto_57

WEP_SYSTEM_EXIT		EQU		1t
WEP_FREE_DLL		EQU		0t

endif	; of ifndef NOKERNEL

HTASK		TYPEDEF		UINT

ifndef	NOKERNEL ; KERNEL FUNCTIONS

@proto_58		TYPEDEF		PROTO FAR PASCAL 
GetNumTasks		PROTO		@proto_58

@proto_59		TYPEDEF		PROTO FAR PASCAL :HTASK
IsTask		PROTO		@proto_59

@proto_60		TYPEDEF		PROTO FAR PASCAL 
GetCurrentTask		PROTO		@proto_60

@proto_61		TYPEDEF		PROTO FAR PASCAL 
Yield		PROTO		@proto_61

@proto_62		TYPEDEF		PROTO FAR PASCAL :HTASK
DirectedYield		PROTO		@proto_62

GMEM_FIXED		EQU		000000000h
GMEM_MOVEABLE		EQU		000000002h
GMEM_NOCOMPACT		EQU		000000010h
GMEM_NODISCARD		EQU		000000020h
GMEM_ZEROINIT		EQU		000000040h
GMEM_MODIFY		EQU		000000080h
GMEM_DISCARDABLE		EQU		000000100h
GMEM_NOT_BANKED		EQU		000001000h
GMEM_SHARE		EQU		000002000h
GMEM_DDESHARE		EQU		000002000h
GMEM_NOTIFY		EQU		000004000h
GMEM_LOWER		EQU		000001000h
GHND		EQU		000000042h
GPTR		EQU		000000040h
@proto_63		TYPEDEF		PROTO FAR PASCAL :UINT, :DWORD
GlobalAlloc		PROTO		@proto_63

@proto_64		TYPEDEF		PROTO FAR PASCAL :HGLOBAL, :DWORD, :UINT
GlobalReAlloc		PROTO		@proto_64

@proto_65		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
GlobalFree		PROTO		@proto_65

@proto_66		TYPEDEF		PROTO FAR PASCAL :DWORD
GlobalDosAlloc		PROTO		@proto_66

@proto_67		TYPEDEF		PROTO FAR PASCAL :UINT
GlobalDosFree		PROTO		@proto_67

@proto_68		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
GlobalLock		PROTO		@proto_68

@proto_69		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
GlobalUnlock		PROTO		@proto_69

@proto_70		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
GlobalSize		PROTO		@proto_70

@proto_71		TYPEDEF		PROTO FAR PASCAL :UINT
GlobalHandle		PROTO		@proto_71

GMEM_DISCARDED		EQU		000004000h
GMEM_LOCKCOUNT		EQU		0000000ffh
@proto_72		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
GlobalFlags		PROTO		@proto_72

@proto_73		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
GlobalWire		PROTO		@proto_73

@proto_74		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
GlobalUnWire		PROTO		@proto_74

@proto_75		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
GlobalPageLock		PROTO		@proto_75

@proto_76		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
GlobalPageUnlock		PROTO		@proto_76

@proto_77		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
GlobalFix		PROTO		@proto_77

@proto_78		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
GlobalUnfix		PROTO		@proto_78

@proto_79		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
GlobalLRUNewest		PROTO		@proto_79

@proto_80		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
GlobalLRUOldest		PROTO		@proto_80

@proto_81		TYPEDEF		PROTO FAR PASCAL :DWORD
GlobalCompact		PROTO		@proto_81

GNOTIFYPROC		TYPEDEF		FARPROC

@proto_82		TYPEDEF		PROTO FAR PASCAL :GNOTIFYPROC
GlobalNotify		PROTO		@proto_82

@proto_83		TYPEDEF		PROTO FAR PASCAL :UINT
LockSegment		PROTO		@proto_83

@proto_84		TYPEDEF		PROTO FAR PASCAL :UINT
UnlockSegment		PROTO		@proto_84

@proto_85		TYPEDEF		PROTO FAR PASCAL :UINT
AllocSelector		PROTO		@proto_85

@proto_86		TYPEDEF		PROTO FAR PASCAL :UINT
FreeSelector		PROTO		@proto_86

@proto_87		TYPEDEF		PROTO FAR PASCAL :UINT
AllocDStoCSAlias		PROTO		@proto_87

@proto_88		TYPEDEF		PROTO FAR PASCAL :UINT, :UINT
PrestoChangoSelector		PROTO		@proto_88

@proto_89		TYPEDEF		PROTO FAR PASCAL :UINT
GetSelectorBase		PROTO		@proto_89

@proto_90		TYPEDEF		PROTO FAR PASCAL :UINT, :DWORD
SetSelectorBase		PROTO		@proto_90

@proto_91		TYPEDEF		PROTO FAR PASCAL :UINT
GetSelectorLimit		PROTO		@proto_91

@proto_92		TYPEDEF		PROTO FAR PASCAL :UINT, :DWORD
SetSelectorLimit		PROTO		@proto_92

@proto_93		TYPEDEF		PROTO FAR PASCAL :DWORD
LimitEmsPages		PROTO		@proto_93

@proto_94		TYPEDEF		PROTO FAR PASCAL 
ValidateFreeSpaces		PROTO		@proto_94

WM_COMPACTING		EQU		000000041h
LMEM_FIXED		EQU		000000000h
LMEM_MOVEABLE		EQU		000000002h
LMEM_NOCOMPACT		EQU		000000010h
LMEM_NODISCARD		EQU		000000020h
LMEM_ZEROINIT		EQU		000000040h
LMEM_MODIFY		EQU		000000080h
LMEM_DISCARDABLE		EQU		000000f00h
LHND		EQU		000000042h
LPTR		EQU		000000040h
NONZEROLHND		EQU		000000002h
NONZEROLPTR		EQU		000000000h
@proto_95		TYPEDEF		PROTO FAR PASCAL :UINT, :UINT
LocalAlloc		PROTO		@proto_95

@proto_96		TYPEDEF		PROTO FAR PASCAL :HLOCAL, :UINT, :UINT
LocalReAlloc		PROTO		@proto_96

@proto_97		TYPEDEF		PROTO FAR PASCAL :HLOCAL
LocalFree		PROTO		@proto_97

@proto_98		TYPEDEF		PROTO FAR PASCAL :HLOCAL
LocalLock		PROTO		@proto_98

@proto_99		TYPEDEF		PROTO FAR PASCAL :HLOCAL
LocalUnlock		PROTO		@proto_99

@proto_100		TYPEDEF		PROTO FAR PASCAL :HLOCAL
LocalSize		PROTO		@proto_100

@proto_101		TYPEDEF		PROTO FAR PASCAL :UINT
LocalHandle		PROTO		@proto_101

LMEM_DISCARDED		EQU		000004000h
LMEM_LOCKCOUNT		EQU		0000000ffh
@proto_102		TYPEDEF		PROTO FAR PASCAL :HLOCAL
LocalFlags		PROTO		@proto_102

@proto_103		TYPEDEF		PROTO FAR PASCAL :UINT, :UINT, :UINT
LocalInit		PROTO		@proto_103

@proto_104		TYPEDEF		PROTO FAR PASCAL :UINT
LocalCompact		PROTO		@proto_104

@proto_105		TYPEDEF		PROTO FAR PASCAL :HLOCAL, :UINT
LocalShrink		PROTO		@proto_105

HFILE		TYPEDEF		SWORD

HFILE_ERROR		EQU		-1t
tagOFSTRUCT		STRUCT 1t
cBytes		BYTE		?
fFixedDisk		BYTE		?
nErrCode		UINT		?
reserved		BYTE		4t DUP (?)
szPathName		SBYTE		128t DUP (?)
tagOFSTRUCT		ENDS

OFSTRUCT		TYPEDEF		tagOFSTRUCT

POFSTRUCT		TYPEDEF		PTR OFSTRUCT

NPOFSTRUCT		TYPEDEF		NEAR PTR OFSTRUCT

LPOFSTRUCT		TYPEDEF		FAR PTR OFSTRUCT

OF_READ		EQU		000000000h
OF_WRITE		EQU		000000001h
OF_READWRITE		EQU		000000002h
OF_SHARE_COMPAT		EQU		000000000h
OF_SHARE_EXCLUSIVE		EQU		000000010h
OF_SHARE_DENY_WRITE		EQU		000000020h
OF_SHARE_DENY_READ		EQU		000000030h
OF_SHARE_DENY_NONE		EQU		000000040h
OF_PARSE		EQU		000000100h
OF_DELETE		EQU		000000200h
OF_VERIFY		EQU		000000400h
OF_SEARCH		EQU		000000400h
OF_CANCEL		EQU		000000800h
OF_CREATE		EQU		000001000h
OF_PROMPT		EQU		000002000h
OF_EXIST		EQU		000004000h
OF_REOPEN		EQU		000008000h
@proto_106		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :FAR PTR OFSTRUCT, :UINT
OpenFile		PROTO		@proto_106

READ		EQU		0t
WRITE		EQU		1t
READ_WRITE		EQU		2t
@proto_107		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :SWORD
_lopen		PROTO		@proto_107

@proto_108		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :SWORD
_lcreat		PROTO		@proto_108

@proto_109		TYPEDEF		PROTO FAR PASCAL :HFILE
_lclose		PROTO		@proto_109

@proto_110		TYPEDEF		PROTO FAR PASCAL :HFILE, :SDWORD, :SWORD
_llseek		PROTO		@proto_110

SEEK_SET		EQU		0t
SEEK_CUR		EQU		1t
SEEK_END		EQU		2t
@proto_111		TYPEDEF		PROTO FAR PASCAL :HFILE, :FAR PTR , :UINT
_lread		PROTO		@proto_111

@proto_112		TYPEDEF		PROTO FAR PASCAL :HFILE, :FAR PTR , :UINT
_lwrite		PROTO		@proto_112

@proto_113		TYPEDEF		PROTO FAR PASCAL :HFILE, :FAR PTR , :SDWORD
_hread		PROTO		@proto_113

@proto_114		TYPEDEF		PROTO FAR PASCAL :HFILE, :FAR PTR , :SDWORD
_hwrite		PROTO		@proto_114

@proto_115		TYPEDEF		PROTO FAR PASCAL :BYTE, :LPCSTR, :UINT, :LPSTR
GetTempFileName		PROTO		@proto_115

@proto_116		TYPEDEF		PROTO FAR PASCAL :SBYTE
GetTempDrive		PROTO		@proto_116

DRIVE_REMOVABLE		EQU		2t
DRIVE_FIXED		EQU		3t
DRIVE_REMOTE		EQU		4t
@proto_117		TYPEDEF		PROTO FAR PASCAL :SWORD
GetDriveType		PROTO		@proto_117

@proto_118		TYPEDEF		PROTO FAR PASCAL :UINT
SetHandleCount		PROTO		@proto_118

@proto_119		TYPEDEF		PROTO FAR PASCAL :LPSTR, :LPSTR, :LPSTR
WNetAddConnection		PROTO		@proto_119

@proto_120		TYPEDEF		PROTO FAR PASCAL :LPSTR, :LPSTR, :FAR PTR UINT
WNetGetConnection		PROTO		@proto_120

@proto_121		TYPEDEF		PROTO FAR PASCAL :LPSTR, :BOOL
WNetCancelConnection		PROTO		@proto_121

WN_SUCCESS		EQU		000000000h
WN_NOT_SUPPORTED		EQU		000000001h
WN_NET_ERROR		EQU		000000002h
WN_MORE_DATA		EQU		000000003h
WN_BAD_POINTER		EQU		000000004h
WN_BAD_VALUE		EQU		000000005h
WN_BAD_PASSWORD		EQU		000000006h
WN_ACCESS_DENIED		EQU		000000007h
WN_FUNCTION_BUSY		EQU		000000008h
WN_WINDOWS_ERROR		EQU		000000009h
WN_BAD_USER		EQU		00000000ah
WN_OUT_OF_MEMORY		EQU		00000000bh
WN_CANCEL		EQU		00000000ch
WN_CONTINUE		EQU		00000000dh
WN_NOT_CONNECTED		EQU		000000030h
WN_OPEN_FILES		EQU		000000031h
WN_BAD_NETNAME		EQU		000000032h
WN_BAD_LOCALNAME		EQU		000000033h
WN_ALREADY_CONNECTED		EQU		000000034h
WN_DEVICE_ERROR		EQU		000000035h
WN_CONNECTION_CLOSED		EQU		000000036h
HRSRC		TYPEDEF		UINT

@proto_122		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :LPCSTR, :LPCSTR
FindResource		PROTO		@proto_122

@proto_123		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :HRSRC
LoadResource		PROTO		@proto_123

@proto_124		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
FreeResource		PROTO		@proto_124

@proto_125		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
LockResource		PROTO		@proto_125

@proto_126		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :HRSRC
SizeofResource		PROTO		@proto_126

@proto_127		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :HRSRC
AccessResource		PROTO		@proto_127

@proto_128		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :HRSRC, :DWORD
AllocResource		PROTO		@proto_128

RSRCHDLRPROC		TYPEDEF		FARPROC

@proto_129		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :LPCSTR, :RSRCHDLRPROC
SetResourceHandler		PROTO		@proto_129

RT_CURSOR		EQU		000000001h
RT_BITMAP		EQU		000000002h
RT_ICON		EQU		000000003h
RT_MENU		EQU		000000004h
RT_DIALOG		EQU		000000005h
RT_STRING		EQU		000000006h
RT_FONTDIR		EQU		000000007h
RT_FONT		EQU		000000008h
RT_ACCELERATOR		EQU		000000009h
RT_RCDATA		EQU		00000000ah
RT_GROUP_CURSOR		EQU		00000000ch
RT_GROUP_ICON		EQU		00000000eh
@proto_130		TYPEDEF		PROTO FAR PASCAL :SWORD
InitAtomTable		PROTO		@proto_130

@proto_131		TYPEDEF		PROTO FAR PASCAL :LPCSTR
AddAtom		PROTO		@proto_131

@proto_132		TYPEDEF		PROTO FAR PASCAL :ATOM
DeleteAtom		PROTO		@proto_132

@proto_133		TYPEDEF		PROTO FAR PASCAL :LPCSTR
FindAtom		PROTO		@proto_133

@proto_134		TYPEDEF		PROTO FAR PASCAL :ATOM, :LPSTR, :SWORD
GetAtomName		PROTO		@proto_134

@proto_135		TYPEDEF		PROTO FAR PASCAL :LPCSTR
GlobalAddAtom		PROTO		@proto_135

@proto_136		TYPEDEF		PROTO FAR PASCAL :ATOM
GlobalDeleteAtom		PROTO		@proto_136

@proto_137		TYPEDEF		PROTO FAR PASCAL :LPCSTR
GlobalFindAtom		PROTO		@proto_137

@proto_138		TYPEDEF		PROTO FAR PASCAL :ATOM, :LPSTR, :SWORD
GlobalGetAtomName		PROTO		@proto_138

@proto_139		TYPEDEF		PROTO FAR PASCAL :ATOM
GetAtomHandle		PROTO		@proto_139

@proto_140		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR, :SWORD
GetProfileInt		PROTO		@proto_140

@proto_141		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR, :LPCSTR, :LPSTR, :SWORD
GetProfileString		PROTO		@proto_141

@proto_142		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR, :LPCSTR
WriteProfileString		PROTO		@proto_142

@proto_143		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR, :SWORD, :LPCSTR
GetPrivateProfileInt		PROTO		@proto_143

@proto_144		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR, :LPCSTR, :LPSTR, :SWORD, :LPCSTR
GetPrivateProfileString		PROTO		@proto_144

@proto_145		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR, :LPCSTR, :LPCSTR
WritePrivateProfileString		PROTO		@proto_145

WM_WININICHANGE		EQU		00000001ah
@proto_146		TYPEDEF		PROTO FAR PASCAL :FAR PTR SBYTE, :FAR PTR SBYTE
AnsiToOem		PROTO		@proto_146

@proto_147		TYPEDEF		PROTO FAR PASCAL :FAR PTR SBYTE, :FAR PTR SBYTE
OemToAnsi		PROTO		@proto_147

@proto_148		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPSTR, :UINT
AnsiToOemBuff		PROTO		@proto_148

@proto_149		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPSTR, :UINT
OemToAnsiBuff		PROTO		@proto_149

@proto_150		TYPEDEF		PROTO FAR PASCAL :LPCSTR
AnsiNext		PROTO		@proto_150

@proto_151		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR
AnsiPrev		PROTO		@proto_151

@proto_152		TYPEDEF		PROTO FAR PASCAL :LPSTR
AnsiUpper		PROTO		@proto_152

@proto_153		TYPEDEF		PROTO FAR PASCAL :LPSTR
AnsiLower		PROTO		@proto_153

@proto_154		TYPEDEF		PROTO FAR PASCAL :LPSTR, :UINT
AnsiUpperBuff		PROTO		@proto_154

@proto_155		TYPEDEF		PROTO FAR PASCAL :LPSTR, :UINT
AnsiLowerBuff		PROTO		@proto_155

@proto_156		TYPEDEF		PROTO FAR PASCAL :SBYTE
IsCharAlpha		PROTO		@proto_156

@proto_157		TYPEDEF		PROTO FAR PASCAL :SBYTE
IsCharAlphaNumeric		PROTO		@proto_157

@proto_158		TYPEDEF		PROTO FAR PASCAL :SBYTE
IsCharUpper		PROTO		@proto_158

@proto_159		TYPEDEF		PROTO FAR PASCAL :SBYTE
IsCharLower		PROTO		@proto_159

@proto_160		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR
lstrcmp		PROTO		@proto_160

@proto_161		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR
lstrcmpi		PROTO		@proto_161

@proto_162		TYPEDEF		PROTO FAR PASCAL :LPSTR, :LPCSTR
lstrcpy		PROTO		@proto_162

@proto_163		TYPEDEF		PROTO FAR PASCAL :LPSTR, :LPCSTR
lstrcat		PROTO		@proto_163

@proto_164		TYPEDEF		PROTO FAR PASCAL :LPCSTR
lstrlen		PROTO		@proto_164

@proto_165		TYPEDEF		PROTO FAR PASCAL :LPSTR, :LPCSTR, :SWORD
lstrcpyn		PROTO		@proto_165

@proto_166		TYPEDEF		PROTO FAR PASCAL :FAR PTR , :FAR PTR , :SDWORD
hmemcpy		PROTO		@proto_166

@proto_167		TYPEDEF		PROTO FAR PASCAL :BYTE
IsDBCSLeadByte		PROTO		@proto_167

@proto_168		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :UINT, :LPSTR, :SWORD
LoadString		PROTO		@proto_168

@proto_169		TYPEDEF		PROTO FAR PASCAL :UINT
OemKeyScan		PROTO		@proto_169

@proto_170		TYPEDEF		PROTO FAR PASCAL :UINT
VkKeyScan		PROTO		@proto_170

@proto_171		TYPEDEF		PROTO FAR PASCAL :SWORD
GetKeyboardType		PROTO		@proto_171

@proto_172		TYPEDEF		PROTO FAR PASCAL :UINT, :UINT
MapVirtualKey		PROTO		@proto_172

@proto_173		TYPEDEF		PROTO FAR PASCAL 
GetKBCodePage		PROTO		@proto_173

@proto_174		TYPEDEF		PROTO FAR PASCAL :SDWORD, :LPSTR, :SWORD
GetKeyNameText		PROTO		@proto_174

@proto_175		TYPEDEF		PROTO FAR PASCAL :UINT, :UINT, :FAR PTR BYTE, :FAR PTR DWORD, :UINT
ToAscii		PROTO		@proto_175

endif	; of ifndef NOKERNEL

HDC		TYPEDEF		UINT

ifndef NOGDI ; GDI FUNCTIONS

HGDIOBJ		TYPEDEF		UINT

endif	; of ifndef NOGDI

HBITMAP		TYPEDEF		UINT

HPEN		TYPEDEF		UINT

HBRUSH		TYPEDEF		UINT

HRGN		TYPEDEF		UINT

HPALETTE		TYPEDEF		UINT

HFONT		TYPEDEF		UINT

tagRECT		STRUCT 1t
left		SWORD		?
top		SWORD		?
right		SWORD		?
bottom		SWORD		?
tagRECT		ENDS

RECT		TYPEDEF		tagRECT

PRECT		TYPEDEF		PTR RECT

NPRECT		TYPEDEF		NEAR PTR RECT

LPRECT		TYPEDEF		FAR PTR RECT

tagPOINT		STRUCT 1t
x		SWORD		?
y		SWORD		?
tagPOINT		ENDS

POINT		TYPEDEF		tagPOINT

PPOINT		TYPEDEF		PTR POINT

NPPOINT		TYPEDEF		NEAR PTR POINT

LPPOINT		TYPEDEF		FAR PTR POINT

tagSIZE		STRUCT 1t
_cx		SWORD		?
cy		SWORD		?
tagSIZE		ENDS

_SIZE		TYPEDEF		tagSIZE

PSIZE		TYPEDEF		PTR _SIZE

NPSIZE		TYPEDEF		NEAR PTR _SIZE

LPSIZE		TYPEDEF		FAR PTR _SIZE


ifndef	NOGDI	; GDI FUNCTIONS

@proto_176		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR, :LPCSTR, :FAR PTR 
CreateDC		PROTO		@proto_176

@proto_177		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR, :LPCSTR, :FAR PTR 
CreateIC		PROTO		@proto_177

@proto_178		TYPEDEF		PROTO FAR PASCAL :HDC
CreateCompatibleDC		PROTO		@proto_178

@proto_179		TYPEDEF		PROTO FAR PASCAL :HDC
DeleteDC		PROTO		@proto_179

@proto_180		TYPEDEF		PROTO FAR PASCAL :HDC
GetDCOrg		PROTO		@proto_180

@proto_181		TYPEDEF		PROTO FAR PASCAL :HDC
SaveDC		PROTO		@proto_181

@proto_182		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD
RestoreDC		PROTO		@proto_182

@proto_183		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :FAR PTR , :UINT
SetEnvironment		PROTO		@proto_183

@proto_184		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :FAR PTR , :UINT
GetEnvironment		PROTO		@proto_184

@proto_185		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD, :SWORD
MulDiv		PROTO		@proto_185

@proto_186		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR tagRECT, :UINT
SetBoundsRect		PROTO		@proto_186

@proto_187		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR RECT, :UINT
GetBoundsRect		PROTO		@proto_187

DCB_RESET		EQU		000000001h
DCB_ACCUMULATE		EQU		000000002h
DCB_DIRTY		EQU		000000002h
DCB_SET		EQU		000000003h
DCB_ENABLE		EQU		000000004h
DCB_DISABLE		EQU		000000008h
@proto_188		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD
GetDeviceCaps		PROTO		@proto_188

DRIVERVERSION		EQU		0t
TECHNOLOGY		EQU		2t
HORZSIZE		EQU		4t
VERTSIZE		EQU		6t
HORZRES		EQU		8t
VERTRES		EQU		10t
BITSPIXEL		EQU		12t
PLANES		EQU		14t
NUMBRUSHES		EQU		16t
NUMPENS		EQU		18t
NUMMARKERS		EQU		20t
NUMFONTS		EQU		22t
NUMCOLORS		EQU		24t
PDEVICESIZE		EQU		26t
CURVECAPS		EQU		28t
LINECAPS		EQU		30t
POLYGONALCAPS		EQU		32t
TEXTCAPS		EQU		34t
CLIPCAPS		EQU		36t
RASTERCAPS		EQU		38t
ASPECTX		EQU		40t
ASPECTY		EQU		42t
ASPECTXY		EQU		44t
LOGPIXELSX		EQU		88t
LOGPIXELSY		EQU		90t
SIZEPALETTE		EQU		104t
NUMRESERVED		EQU		106t
COLORRES		EQU		108t
DT_PLOTTER		EQU		0t
DT_RASDISPLAY		EQU		1t
DT_RASPRINTER		EQU		2t
DT_RASCAMERA		EQU		3t
DT_CHARSTREAM		EQU		4t
DT_METAFILE		EQU		5t
DT_DISPFILE		EQU		6t
CC_NONE		EQU		000000000h
CC_CIRCLES		EQU		000000001h
CC_PIE		EQU		000000002h
CC_CHORD		EQU		000000004h
CC_ELLIPSES		EQU		000000008h
CC_WIDE		EQU		000000010h
CC_STYLED		EQU		000000020h
CC_WIDESTYLED		EQU		000000040h
CC_INTERIORS		EQU		000000080h
CC_ROUNDRECT		EQU		000000100h
LC_NONE		EQU		000000000h
LC_POLYLINE		EQU		000000002h
LC_MARKER		EQU		000000004h
LC_POLYMARKER		EQU		000000008h
LC_WIDE		EQU		000000010h
LC_STYLED		EQU		000000020h
LC_WIDESTYLED		EQU		000000040h
LC_INTERIORS		EQU		000000080h
PC_NONE		EQU		000000000h
PC_POLYGON		EQU		000000001h
PC_RECTANGLE		EQU		000000002h
PC_WINDPOLYGON		EQU		000000004h
PC_SCANLINE		EQU		000000008h
PC_WIDE		EQU		000000010h
PC_STYLED		EQU		000000020h
PC_WIDESTYLED		EQU		000000040h
PC_INTERIORS		EQU		000000080h
TC_OP_CHARACTER		EQU		000000001h
TC_OP_STROKE		EQU		000000002h
TC_CP_STROKE		EQU		000000004h
TC_CR_90		EQU		000000008h
TC_CR_ANY		EQU		000000010h
TC_SF_X_YINDEP		EQU		000000020h
TC_SA_DOUBLE		EQU		000000040h
TC_SA_INTEGER		EQU		000000080h
TC_SA_CONTIN		EQU		000000100h
TC_EA_DOUBLE		EQU		000000200h
TC_IA_ABLE		EQU		000000400h
TC_UA_ABLE		EQU		000000800h
TC_SO_ABLE		EQU		000001000h
TC_RA_ABLE		EQU		000002000h
TC_VA_ABLE		EQU		000004000h
TC_RESERVED		EQU		000008000h
CP_NONE		EQU		000000000h
CP_RECTANGLE		EQU		000000001h
CP_REGION		EQU		000000002h
RC_BITBLT		EQU		000000001h
RC_BANDING		EQU		000000002h
RC_SCALING		EQU		000000004h
RC_BITMAP64		EQU		000000008h
RC_GDI20_OUTPUT		EQU		000000010h
RC_GDI20_STATE		EQU		000000020h
RC_SAVEBITMAP		EQU		000000040h
RC_DI_BITMAP		EQU		000000080h
RC_PALETTE		EQU		000000100h
RC_DIBTODEV		EQU		000000200h
RC_BIGFONT		EQU		000000400h
RC_STRETCHBLT		EQU		000000800h
RC_FLOODFILL		EQU		000001000h
RC_STRETCHDIB		EQU		000002000h
RC_OP_DX_OUTPUT		EQU		000004000h
RC_DEVBITS		EQU		000008000h
@proto_189		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD
SetMapMode		PROTO		@proto_189

@proto_190		TYPEDEF		PROTO FAR PASCAL :HDC
GetMapMode		PROTO		@proto_190

MM_TEXT		EQU		1t
MM_LOMETRIC		EQU		2t
MM_HIMETRIC		EQU		3t
MM_LOENGLISH		EQU		4t
MM_HIENGLISH		EQU		5t
MM_TWIPS		EQU		6t
MM_ISOTROPIC		EQU		7t
MM_ANISOTROPIC		EQU		8t
@proto_191		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
SetWindowOrg		PROTO		@proto_191

@proto_192		TYPEDEF		PROTO FAR PASCAL :HDC
GetWindowOrg		PROTO		@proto_192

@proto_193		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
SetWindowExt		PROTO		@proto_193

@proto_194		TYPEDEF		PROTO FAR PASCAL :HDC
GetWindowExt		PROTO		@proto_194

@proto_195		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
OffsetWindowOrg		PROTO		@proto_195

@proto_196		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD
ScaleWindowExt		PROTO		@proto_196

@proto_197		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
SetViewportOrg		PROTO		@proto_197

@proto_198		TYPEDEF		PROTO FAR PASCAL :HDC
GetViewportOrg		PROTO		@proto_198

@proto_199		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
SetViewportExt		PROTO		@proto_199

@proto_200		TYPEDEF		PROTO FAR PASCAL :HDC
GetViewportExt		PROTO		@proto_200

@proto_201		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
OffsetViewportOrg		PROTO		@proto_201

@proto_202		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD
ScaleViewportExt		PROTO		@proto_202

@proto_203		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :FAR PTR POINT
SetWindowOrgEx		PROTO		@proto_203

@proto_204		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR POINT
GetWindowOrgEx		PROTO		@proto_204

@proto_205		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :FAR PTR _SIZE
SetWindowExtEx		PROTO		@proto_205

@proto_206		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR _SIZE
GetWindowExtEx		PROTO		@proto_206

@proto_207		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :FAR PTR POINT
OffsetWindowOrgEx		PROTO		@proto_207

@proto_208		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD, :FAR PTR _SIZE
ScaleWindowExtEx		PROTO		@proto_208

@proto_209		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :FAR PTR _SIZE
SetViewportExtEx		PROTO		@proto_209

@proto_210		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR _SIZE
GetViewportExtEx		PROTO		@proto_210

@proto_211		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :FAR PTR POINT
SetViewportOrgEx		PROTO		@proto_211

@proto_212		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR POINT
GetViewportOrgEx		PROTO		@proto_212

@proto_213		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :FAR PTR POINT
OffsetViewportOrgEx		PROTO		@proto_213

@proto_214		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD, :FAR PTR _SIZE
ScaleViewportExtEx		PROTO		@proto_214

@proto_215		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR POINT, :SWORD
DPtoLP		PROTO		@proto_215

@proto_216		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR POINT, :SWORD
LPtoDP		PROTO		@proto_216

ABSOLUTE		EQU		1t
RELATIVE		EQU		2t
COLORREF		TYPEDEF		DWORD

@proto_217		TYPEDEF		PROTO FAR PASCAL :HDC, :COLORREF
GetNearestColor		PROTO		@proto_217

@proto_218		TYPEDEF		PROTO FAR PASCAL :SWORD
GetSysColor		PROTO		@proto_218

@proto_219		TYPEDEF		PROTO FAR PASCAL :SWORD, :FAR PTR SWORD, :FAR PTR DWORD
SetSysColors		PROTO		@proto_219

COLOR_SCROLLBAR		EQU		0t
COLOR_BACKGROUND		EQU		1t
COLOR_ACTIVECAPTION		EQU		2t
COLOR_INACTIVECAPTION		EQU		3t
COLOR_MENU		EQU		4t
COLOR_WINDOW		EQU		5t
COLOR_WINDOWFRAME		EQU		6t
COLOR_MENUTEXT		EQU		7t
COLOR_WINDOWTEXT		EQU		8t
COLOR_CAPTIONTEXT		EQU		9t
COLOR_ACTIVEBORDER		EQU		10t
COLOR_INACTIVEBORDER		EQU		11t
COLOR_APPWORKSPACE		EQU		12t
COLOR_HIGHLIGHT		EQU		13t
COLOR_HIGHLIGHTTEXT		EQU		14t
COLOR_BTNFACE		EQU		15t
COLOR_BTNSHADOW		EQU		16t
COLOR_GRAYTEXT		EQU		17t
COLOR_BTNTEXT		EQU		18t
COLOR_INACTIVECAPTIONTEXT		EQU		19t
COLOR_BTNHIGHLIGHT		EQU		20t
WM_SYSCOLORCHANGE		EQU		000000015h
@proto_220		TYPEDEF		PROTO FAR PASCAL :SWORD
GetStockObject		PROTO		@proto_220

@proto_221		TYPEDEF		PROTO FAR PASCAL :HGDIOBJ
IsGDIObject		PROTO		@proto_221

@proto_222		TYPEDEF		PROTO FAR PASCAL :HGDIOBJ
DeleteObject		PROTO		@proto_222

@proto_223		TYPEDEF		PROTO FAR PASCAL :HDC, :HGDIOBJ
SelectObject		PROTO		@proto_223

@proto_224		TYPEDEF		PROTO FAR PASCAL :HGDIOBJ, :SWORD, :FAR PTR 
GetObject		PROTO		@proto_224

@proto_225		TYPEDEF		PROTO FAR PASCAL :HGDIOBJ
UnrealizeObject		PROTO		@proto_225

GOBJENUMPROC		TYPEDEF		FARPROC

@proto_226		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :GOBJENUMPROC, :LPSTR
EnumObjects		PROTO		@proto_226

OBJ_PEN		EQU		1t
OBJ_BRUSH		EQU		2t
tagLOGPEN		STRUCT 1t
lopnStyle		UINT		?
lopnWidth		POINT		<>
lopnColor		COLORREF		?
tagLOGPEN		ENDS

LOGPEN		TYPEDEF		tagLOGPEN

PLOGPEN		TYPEDEF		PTR LOGPEN

NPLOGPEN		TYPEDEF		NEAR PTR LOGPEN

LPLOGPEN		TYPEDEF		FAR PTR LOGPEN

PS_SOLID		EQU		0t
PS_DASH		EQU		1t
PS_DOT		EQU		2t
PS_DASHDOT		EQU		3t
PS_DASHDOTDOT		EQU		4t
PS_NULL		EQU		5t
PS_INSIDEFRAME		EQU		6t
@proto_227		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD, :COLORREF
CreatePen		PROTO		@proto_227

@proto_228		TYPEDEF		PROTO FAR PASCAL :FAR PTR LOGPEN
CreatePenIndirect		PROTO		@proto_228

WHITE_PEN		EQU		6t
BLACK_PEN		EQU		7t
NULL_PEN		EQU		8t
BS_SOLID		EQU		0t
BS_NULL		EQU		1t
BS_HOLLOW		EQU		000000001h
BS_HATCHED		EQU		2t
BS_PATTERN		EQU		3t
BS_INDEXED		EQU		4t
BS_DIBPATTERN		EQU		5t
HS_HORIZONTAL		EQU		0t
HS_VERTICAL		EQU		1t
HS_FDIAGONAL		EQU		2t
HS_BDIAGONAL		EQU		3t
HS_CROSS		EQU		4t
HS_DIAGCROSS		EQU		5t
tagLOGBRUSH		STRUCT 1t
lbStyle		UINT		?
lbColor		COLORREF		?
lbHatch		SWORD		?
tagLOGBRUSH		ENDS

LOGBRUSH		TYPEDEF		tagLOGBRUSH

PLOGBRUSH		TYPEDEF		PTR LOGBRUSH

NPLOGBRUSH		TYPEDEF		NEAR PTR LOGBRUSH

LPLOGBRUSH		TYPEDEF		FAR PTR LOGBRUSH

PATTERN		TYPEDEF		LOGBRUSH

PPATTERN		TYPEDEF		PTR PATTERN

NPPATTERN		TYPEDEF		NEAR PTR PATTERN

LPPATTERN		TYPEDEF		FAR PTR PATTERN

@proto_229		TYPEDEF		PROTO FAR PASCAL :COLORREF
CreateSolidBrush		PROTO		@proto_229

@proto_230		TYPEDEF		PROTO FAR PASCAL :SWORD, :COLORREF
CreateHatchBrush		PROTO		@proto_230

@proto_231		TYPEDEF		PROTO FAR PASCAL :HBITMAP
CreatePatternBrush		PROTO		@proto_231

@proto_232		TYPEDEF		PROTO FAR PASCAL :HGLOBAL, :UINT
CreateDIBPatternBrush		PROTO		@proto_232

@proto_233		TYPEDEF		PROTO FAR PASCAL :FAR PTR LOGBRUSH
CreateBrushIndirect		PROTO		@proto_233

WHITE_BRUSH		EQU		0t
LTGRAY_BRUSH		EQU		1t
GRAY_BRUSH		EQU		2t
DKGRAY_BRUSH		EQU		3t
BLACK_BRUSH		EQU		4t
NULL_BRUSH		EQU		5t
HOLLOW_BRUSH		EQU		000000005h
@proto_234		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
SetBrushOrg		PROTO		@proto_234

@proto_235		TYPEDEF		PROTO FAR PASCAL :HDC
GetBrushOrg		PROTO		@proto_235

@proto_236		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR POINT
GetBrushOrgEx		PROTO		@proto_236

@proto_237		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD, :SWORD, :SWORD
CreateRectRgn		PROTO		@proto_237

@proto_238		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagRECT
CreateRectRgnIndirect		PROTO		@proto_238

@proto_239		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagRECT
CreateEllipticRgnIndirect		PROTO		@proto_239

@proto_240		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD, :SWORD, :SWORD
CreateEllipticRgn		PROTO		@proto_240

@proto_241		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagPOINT, :SWORD, :SWORD
CreatePolygonRgn		PROTO		@proto_241

@proto_242		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagPOINT, :FAR PTR SWORD, :SWORD, :SWORD
CreatePolyPolygonRgn		PROTO		@proto_242

@proto_243		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD
CreateRoundRectRgn		PROTO		@proto_243

ERROR		EQU		0t
NULLREGION		EQU		1t
SIMPLEREGION		EQU		2t
COMPLEXREGION		EQU		3t
@proto_244		TYPEDEF		PROTO FAR PASCAL :HRGN, :SWORD, :SWORD, :SWORD, :SWORD
SetRectRgn		PROTO		@proto_244

@proto_245		TYPEDEF		PROTO FAR PASCAL :HRGN, :HRGN, :HRGN, :SWORD
CombineRgn		PROTO		@proto_245

RGN_AND		EQU		1t
RGN_OR		EQU		2t
RGN_XOR		EQU		3t
RGN_DIFF		EQU		4t
RGN_COPY		EQU		5t
@proto_246		TYPEDEF		PROTO FAR PASCAL :HRGN, :HRGN
EqualRgn		PROTO		@proto_246

@proto_247		TYPEDEF		PROTO FAR PASCAL :HRGN, :SWORD, :SWORD
OffsetRgn		PROTO		@proto_247

@proto_248		TYPEDEF		PROTO FAR PASCAL :HRGN, :FAR PTR RECT
GetRgnBox		PROTO		@proto_248

@proto_249		TYPEDEF		PROTO FAR PASCAL :HRGN, :FAR PTR tagRECT
RectInRegion		PROTO		@proto_249

@proto_250		TYPEDEF		PROTO FAR PASCAL :HRGN, :SWORD, :SWORD
PtInRegion		PROTO		@proto_250

tagPALETTEENTRY		STRUCT 1t
peRed		BYTE		?
peGreen		BYTE		?
peBlue		BYTE		?
peFlags		BYTE		?
tagPALETTEENTRY		ENDS

PALETTEENTRY		TYPEDEF		tagPALETTEENTRY

LPPALETTEENTRY		TYPEDEF		FAR PTR PALETTEENTRY

PC_RESERVED		EQU		000000001h
PC_EXPLICIT		EQU		000000002h
PC_NOCOLLAPSE		EQU		000000004h
tagLOGPALETTE		STRUCT 1t
palVersion		WORD		?
palNumEntries		WORD		?
palPalEntry		PALETTEENTRY		1t DUP (<>)
tagLOGPALETTE		ENDS

LOGPALETTE		TYPEDEF		tagLOGPALETTE

PLOGPALETTE		TYPEDEF		PTR LOGPALETTE

NPLOGPALETTE		TYPEDEF		NEAR PTR LOGPALETTE

LPLOGPALETTE		TYPEDEF		FAR PTR LOGPALETTE

@proto_251		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagLOGPALETTE
CreatePalette		PROTO		@proto_251

@proto_252		TYPEDEF		PROTO FAR PASCAL :HDC, :HPALETTE, :BOOL
SelectPalette		PROTO		@proto_252

@proto_253		TYPEDEF		PROTO FAR PASCAL :HDC
RealizePalette		PROTO		@proto_253

@proto_254		TYPEDEF		PROTO FAR PASCAL :HDC
UpdateColors		PROTO		@proto_254

@proto_255		TYPEDEF		PROTO FAR PASCAL :HPALETTE, :UINT, :UINT, :FAR PTR tagPALETTEENTRY
AnimatePalette		PROTO		@proto_255

@proto_256		TYPEDEF		PROTO FAR PASCAL :HPALETTE, :UINT, :UINT, :FAR PTR tagPALETTEENTRY
SetPaletteEntries		PROTO		@proto_256

@proto_257		TYPEDEF		PROTO FAR PASCAL :HPALETTE, :UINT, :UINT, :FAR PTR PALETTEENTRY
GetPaletteEntries		PROTO		@proto_257

@proto_258		TYPEDEF		PROTO FAR PASCAL :HPALETTE, :COLORREF
GetNearestPaletteIndex		PROTO		@proto_258

@proto_259		TYPEDEF		PROTO FAR PASCAL :HPALETTE, :UINT
ResizePalette		PROTO		@proto_259

@proto_260		TYPEDEF		PROTO FAR PASCAL :HDC, :UINT, :UINT, :FAR PTR PALETTEENTRY
GetSystemPaletteEntries		PROTO		@proto_260

@proto_261		TYPEDEF		PROTO FAR PASCAL :HDC
GetSystemPaletteUse		PROTO		@proto_261

@proto_262		TYPEDEF		PROTO FAR PASCAL :HDC, :UINT
SetSystemPaletteUse		PROTO		@proto_262

SYSPAL_STATIC		EQU		1t
SYSPAL_NOSTATIC		EQU		2t
WM_QUERYNEWPALETTE		EQU		00000030fh
WM_PALETTEISCHANGING		EQU		000000310h
WM_PALETTECHANGED		EQU		000000311h
@proto_263		TYPEDEF		PROTO FAR PASCAL :HDC, :HRGN
SelectClipRgn		PROTO		@proto_263

@proto_264		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR RECT
GetClipBox		PROTO		@proto_264

@proto_265		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD
IntersectClipRect		PROTO		@proto_265

@proto_266		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
OffsetClipRgn		PROTO		@proto_266

@proto_267		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD
ExcludeClipRect		PROTO		@proto_267

@proto_268		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
PtVisible		PROTO		@proto_268

@proto_269		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR tagRECT
RectVisible		PROTO		@proto_269

@proto_270		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
MoveTo		PROTO		@proto_270

@proto_271		TYPEDEF		PROTO FAR PASCAL :HDC
GetCurrentPosition		PROTO		@proto_271

@proto_272		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :FAR PTR POINT
MoveToEx		PROTO		@proto_272

@proto_273		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR POINT
GetCurrentPositionEx		PROTO		@proto_273

@proto_274		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
LineTo		PROTO		@proto_274

@proto_275		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR tagPOINT, :SWORD
Polyline		PROTO		@proto_275

LINEDDAPROC		TYPEDEF		FARPROC

@proto_276		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD, :SWORD, :SWORD, :LINEDDAPROC, :LPARAM
LineDDA		PROTO		@proto_276

@proto_277		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD
Rectangle		PROTO		@proto_277

@proto_278		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD
RoundRect		PROTO		@proto_278

@proto_279		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD
Ellipse		PROTO		@proto_279

@proto_280		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD
Arc		PROTO		@proto_280

@proto_281		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD
Chord		PROTO		@proto_281

@proto_282		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD
Pie		PROTO		@proto_282

@proto_283		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR tagPOINT, :SWORD
Polygon		PROTO		@proto_283

@proto_284		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR tagPOINT, :FAR PTR SWORD, :SWORD
PolyPolygon		PROTO		@proto_284

ALTERNATE		EQU		1t
WINDING		EQU		2t
@proto_285		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD
SetPolyFillMode		PROTO		@proto_285

@proto_286		TYPEDEF		PROTO FAR PASCAL :HDC
GetPolyFillMode		PROTO		@proto_286

@proto_287		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :COLORREF
FloodFill		PROTO		@proto_287

@proto_288		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :COLORREF, :UINT
ExtFloodFill		PROTO		@proto_288

FLOODFILLBORDER		EQU		0t
FLOODFILLSURFACE		EQU		1t
@proto_289		TYPEDEF		PROTO FAR PASCAL :HDC, :HRGN, :HBRUSH
FillRgn		PROTO		@proto_289

@proto_290		TYPEDEF		PROTO FAR PASCAL :HDC, :HRGN, :HBRUSH, :SWORD, :SWORD
FrameRgn		PROTO		@proto_290

@proto_291		TYPEDEF		PROTO FAR PASCAL :HDC, :HRGN
InvertRgn		PROTO		@proto_291

@proto_292		TYPEDEF		PROTO FAR PASCAL :HDC, :HRGN
PaintRgn		PROTO		@proto_292

@proto_293		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR tagRECT, :HBRUSH
FillRect		PROTO		@proto_293

@proto_294		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR tagRECT, :HBRUSH
FrameRect		PROTO		@proto_294

@proto_295		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR tagRECT
InvertRect		PROTO		@proto_295

@proto_296		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR tagRECT
DrawFocusRect		PROTO		@proto_296

@proto_297		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :LPCSTR, :SWORD
TextOut		PROTO		@proto_297

@proto_298		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :LPCSTR, :SWORD, :SWORD, :FAR PTR SWORD, :SWORD
TabbedTextOut		PROTO		@proto_298

@proto_299		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :UINT, :FAR PTR tagRECT, :LPCSTR, :UINT, :FAR PTR SWORD
ExtTextOut		PROTO		@proto_299

ETO_GRAYED		EQU		000000001h
ETO_OPAQUE		EQU		000000002h
ETO_CLIPPED		EQU		000000004h
@proto_300		TYPEDEF		PROTO FAR PASCAL :HDC, :LPCSTR, :SWORD
GetTextExtent		PROTO		@proto_300

@proto_301		TYPEDEF		PROTO FAR PASCAL :HDC, :LPCSTR, :SWORD, :SWORD, :FAR PTR SWORD
GetTabbedTextExtent		PROTO		@proto_301

@proto_302		TYPEDEF		PROTO FAR PASCAL :HDC, :LPCSTR, :SWORD, :FAR PTR _SIZE
GetTextExtentPoint		PROTO		@proto_302

DT_TOP		EQU		000000000h
DT_LEFT		EQU		000000000h
DT_CENTER		EQU		000000001h
DT_RIGHT		EQU		000000002h
DT_VCENTER		EQU		000000004h
DT_BOTTOM		EQU		000000008h
DT_WORDBREAK		EQU		000000010h
DT_SINGLELINE		EQU		000000020h
DT_EXPANDTABS		EQU		000000040h
DT_TABSTOP		EQU		000000080h
DT_NOCLIP		EQU		000000100h
DT_EXTERNALLEADING		EQU		000000200h
DT_CALCRECT		EQU		000000400h
DT_NOPREFIX		EQU		000000800h
DT_INTERNAL		EQU		000001000h
@proto_303		TYPEDEF		PROTO FAR PASCAL :HDC, :LPCSTR, :SWORD, :FAR PTR RECT, :UINT
DrawText		PROTO		@proto_303

GRAYSTRINGPROC		TYPEDEF		FARPROC

@proto_304		TYPEDEF		PROTO FAR PASCAL :HDC, :HBRUSH, :GRAYSTRINGPROC, :LPARAM, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD
GrayString		PROTO		@proto_304

@proto_305		TYPEDEF		PROTO FAR PASCAL :HDC, :UINT, :UINT, :FAR PTR SWORD
GetCharWidth		PROTO		@proto_305

@proto_306		TYPEDEF		PROTO FAR PASCAL :HDC, :COLORREF
SetTextColor		PROTO		@proto_306

@proto_307		TYPEDEF		PROTO FAR PASCAL :HDC
GetTextColor		PROTO		@proto_307

@proto_308		TYPEDEF		PROTO FAR PASCAL :HDC, :COLORREF
SetBkColor		PROTO		@proto_308

@proto_309		TYPEDEF		PROTO FAR PASCAL :HDC
GetBkColor		PROTO		@proto_309

@proto_310		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD
SetBkMode		PROTO		@proto_310

@proto_311		TYPEDEF		PROTO FAR PASCAL :HDC
GetBkMode		PROTO		@proto_311

TRANSPARENT		EQU		1t
OPAQUE		EQU		2t
@proto_312		TYPEDEF		PROTO FAR PASCAL :HDC, :UINT
SetTextAlign		PROTO		@proto_312

@proto_313		TYPEDEF		PROTO FAR PASCAL :HDC
GetTextAlign		PROTO		@proto_313

TA_NOUPDATECP		EQU		000000000h
TA_UPDATECP		EQU		000000001h
TA_LEFT		EQU		000000000h
TA_RIGHT		EQU		000000002h
TA_CENTER		EQU		000000006h
TA_TOP		EQU		000000000h
TA_BOTTOM		EQU		000000008h
TA_BASELINE		EQU		000000018h
@proto_314		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD
SetTextCharacterExtra		PROTO		@proto_314

@proto_315		TYPEDEF		PROTO FAR PASCAL :HDC
GetTextCharacterExtra		PROTO		@proto_315

@proto_316		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
SetTextJustification		PROTO		@proto_316

LF_FACESIZE		EQU		32t
tagLOGFONT		STRUCT 1t
lfHeight		SWORD		?
lfWidth		SWORD		?
lfEscapement		SWORD		?
lfOrientation		SWORD		?
lfWeight		SWORD		?
lfItalic		BYTE		?
lfUnderline		BYTE		?
lfStrikeOut		BYTE		?
lfCharSet		BYTE		?
lfOutPrecision		BYTE		?
lfClipPrecision		BYTE		?
lfQuality		BYTE		?
lfPitchAndFamily		BYTE		?
lfFaceName		SBYTE		32t DUP (?)
tagLOGFONT		ENDS

LOGFONT		TYPEDEF		tagLOGFONT

PLOGFONT		TYPEDEF		PTR LOGFONT

NPLOGFONT		TYPEDEF		NEAR PTR LOGFONT

LPLOGFONT		TYPEDEF		FAR PTR LOGFONT

FW_DONTCARE		EQU		0t
FW_THIN		EQU		100t
FW_EXTRALIGHT		EQU		200t
FW_LIGHT		EQU		300t
FW_NORMAL		EQU		400t
FW_MEDIUM		EQU		500t
FW_SEMIBOLD		EQU		600t
FW_BOLD		EQU		700t
FW_EXTRABOLD		EQU		800t
FW_HEAVY		EQU		900t
FW_ULTRALIGHT		EQU		0000000c8h
FW_REGULAR		EQU		000000190h
FW_DEMIBOLD		EQU		000000258h
FW_ULTRABOLD		EQU		000000320h
FW_BLACK		EQU		000000384h
ANSI_CHARSET		EQU		0t
DEFAULT_CHARSET		EQU		1t
SYMBOL_CHARSET		EQU		2t
SHIFTJIS_CHARSET		EQU		128t
HANGEUL_CHARSET		EQU		129t
CHINESEBIG5_CHARSET		EQU		136t
OEM_CHARSET		EQU		255t
OUT_DEFAULT_PRECIS		EQU		0t
OUT_STRING_PRECIS		EQU		1t
OUT_CHARACTER_PRECIS		EQU		2t
OUT_STROKE_PRECIS		EQU		3t
OUT_TT_PRECIS		EQU		4t
OUT_DEVICE_PRECIS		EQU		5t
OUT_RASTER_PRECIS		EQU		6t
OUT_TT_ONLY_PRECIS		EQU		7t
CLIP_DEFAULT_PRECIS		EQU		000000000h
CLIP_CHARACTER_PRECIS		EQU		000000001h
CLIP_STROKE_PRECIS		EQU		000000002h
CLIP_MASK		EQU		00000000fh
CLIP_LH_ANGLES		EQU		000000010h
CLIP_TT_ALWAYS		EQU		000000020h
CLIP_EMBEDDED		EQU		000000080h
DEFAULT_QUALITY		EQU		0t
DRAFT_QUALITY		EQU		1t
PROOF_QUALITY		EQU		2t
DEFAULT_PITCH		EQU		000000000h
FIXED_PITCH		EQU		000000001h
VARIABLE_PITCH		EQU		000000002h
FF_DONTCARE		EQU		000000000h
FF_ROMAN		EQU		000000010h
FF_SWISS		EQU		000000020h
FF_MODERN		EQU		000000030h
FF_SCRIPT		EQU		000000040h
FF_DECORATIVE		EQU		000000050h
@proto_317		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :BYTE, :BYTE, :BYTE, :BYTE, :BYTE, :BYTE, :BYTE, :BYTE, :LPCSTR
CreateFont		PROTO		@proto_317

@proto_318		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagLOGFONT
CreateFontIndirect		PROTO		@proto_318

OEM_FIXED_FONT		EQU		10t
ANSI_FIXED_FONT		EQU		11t
ANSI_VAR_FONT		EQU		12t
SYSTEM_FONT		EQU		13t
DEVICE_DEFAULT_FONT		EQU		14t
DEFAULT_PALETTE		EQU		15t
SYSTEM_FIXED_FONT		EQU		16t
@proto_319		TYPEDEF		PROTO FAR PASCAL :HDC, :DWORD
SetMapperFlags		PROTO		@proto_319

ASPECT_FILTERING		EQU		000000001h
@proto_320		TYPEDEF		PROTO FAR PASCAL :LPCSTR
AddFontResource		PROTO		@proto_320

@proto_321		TYPEDEF		PROTO FAR PASCAL :LPCSTR
RemoveFontResource		PROTO		@proto_321

WM_FONTCHANGE		EQU		00000001dh
@proto_322		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :LPSTR
GetTextFace		PROTO		@proto_322

@proto_323		TYPEDEF		PROTO FAR PASCAL :HDC
GetAspectRatioFilter		PROTO		@proto_323

@proto_324		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR _SIZE
GetAspectRatioFilterEx		PROTO		@proto_324

tagTEXTMETRIC		STRUCT 1t
tmHeight		SWORD		?
tmAscent		SWORD		?
tmDescent		SWORD		?
tmInternalLeading		SWORD		?
tmExternalLeading		SWORD		?
tmAveCharWidth		SWORD		?
tmMaxCharWidth		SWORD		?
tmWeight		SWORD		?
tmItalic		BYTE		?
tmUnderlined		BYTE		?
tmStruckOut		BYTE		?
tmFirstChar		BYTE		?
tmLastChar		BYTE		?
tmDefaultChar		BYTE		?
tmBreakChar		BYTE		?
tmPitchAndFamily		BYTE		?
tmCharSet		BYTE		?
tmOverhang		SWORD		?
tmDigitizedAspectX		SWORD		?
tmDigitizedAspectY		SWORD		?
tagTEXTMETRIC		ENDS

TEXTMETRIC		TYPEDEF		tagTEXTMETRIC

PTEXTMETRIC		TYPEDEF		PTR TEXTMETRIC

NPTEXTMETRIC		TYPEDEF		NEAR PTR TEXTMETRIC

LPTEXTMETRIC		TYPEDEF		FAR PTR TEXTMETRIC

TMPF_FIXED_PITCH		EQU		000000001h
TMPF_VECTOR		EQU		000000002h
TMPF_DEVICE		EQU		000000008h
TMPF_TRUETYPE		EQU		000000004h
@proto_325		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR TEXTMETRIC
GetTextMetrics		PROTO		@proto_325

tagPANOSE		STRUCT 1t
bFamilyType		BYTE		?
bSerifStyle		BYTE		?
bWeight		BYTE		?
bProportion		BYTE		?
bContrast		BYTE		?
bStrokeVariation		BYTE		?
bArmStyle		BYTE		?
bLetterform		BYTE		?
bMidline		BYTE		?
bXHeight		BYTE		?
tagPANOSE		ENDS

PANOSE		TYPEDEF		tagPANOSE

LPPANOSE		TYPEDEF		FAR PTR tagPANOSE

tagOUTLINETEXTMETRIC		STRUCT 1t
otmSize		UINT		?
otmTextMetrics		TEXTMETRIC		<>
otmFiller		BYTE		?
otmPanoseNumber		PANOSE		<>
otmfsSelection		UINT		?
otmfsType		UINT		?
otmsCharSlopeRise		SWORD		?
otmsCharSlopeRun		SWORD		?
otmItalicAngle		SWORD		?
otmEMSquare		UINT		?
otmAscent		SWORD		?
otmDescent		SWORD		?
otmLineGap		UINT		?
otmsCapEmHeight		UINT		?
otmsXHeight		UINT		?
otmrcFontBox		RECT		<>
otmMacAscent		SWORD		?
otmMacDescent		SWORD		?
otmMacLineGap		UINT		?
otmusMinimumPPEM		UINT		?
otmptSubscriptSize		POINT		<>
otmptSubscriptOffset		POINT		<>
otmptSuperscriptSize		POINT		<>
otmptSuperscriptOffset		POINT		<>
otmsStrikeoutSize		UINT		?
otmsStrikeoutPosition		SWORD		?
otmsUnderscorePosition		SWORD		?
otmsUnderscoreSize		SWORD		?
otmpFamilyName		PSTR		?
otmpFaceName		PSTR		?
otmpStyleName		PSTR		?
otmpFullName		PSTR		?
tagOUTLINETEXTMETRIC		ENDS

OUTLINETEXTMETRIC		TYPEDEF		tagOUTLINETEXTMETRIC

LPOUTLINETEXTMETRIC		TYPEDEF		FAR PTR tagOUTLINETEXTMETRIC

@proto_326		TYPEDEF		PROTO FAR PASCAL :HDC, :UINT, :FAR PTR OUTLINETEXTMETRIC
GetOutlineTextMetrics		PROTO		@proto_326

tagNEWTEXTMETRIC		STRUCT 1t
tmHeight		SWORD		?
tmAscent		SWORD		?
tmDescent		SWORD		?
tmInternalLeading		SWORD		?
tmExternalLeading		SWORD		?
tmAveCharWidth		SWORD		?
tmMaxCharWidth		SWORD		?
tmWeight		SWORD		?
tmItalic		BYTE		?
tmUnderlined		BYTE		?
tmStruckOut		BYTE		?
tmFirstChar		BYTE		?
tmLastChar		BYTE		?
tmDefaultChar		BYTE		?
tmBreakChar		BYTE		?
tmPitchAndFamily		BYTE		?
tmCharSet		BYTE		?
tmOverhang		SWORD		?
tmDigitizedAspectX		SWORD		?
tmDigitizedAspectY		SWORD		?
ntmFlags		DWORD		?
ntmSizeEM		UINT		?
ntmCellHeight		UINT		?
ntmAvgWidth		UINT		?
tagNEWTEXTMETRIC		ENDS

NEWTEXTMETRIC		TYPEDEF		tagNEWTEXTMETRIC

PNEWTEXTMETRIC		TYPEDEF		PTR NEWTEXTMETRIC

NPNEWTEXTMETRIC		TYPEDEF		NEAR PTR NEWTEXTMETRIC

LPNEWTEXTMETRIC		TYPEDEF		FAR PTR NEWTEXTMETRIC

NTM_REGULAR		EQU		000000040h
NTM_BOLD		EQU		000000020h
NTM_ITALIC		EQU		000000001h
LF_FULLFACESIZE		EQU		64t
tagENUMLOGFONT		STRUCT 1t
elfLogFont		LOGFONT		<>
elfFullName		SBYTE		64t DUP (?)
elfStyle		SBYTE		32t DUP (?)
tagENUMLOGFONT		ENDS

ENUMLOGFONT		TYPEDEF		tagENUMLOGFONT

LPENUMLOGFONT		TYPEDEF		FAR PTR tagENUMLOGFONT

OLDFONTENUMPROC		TYPEDEF		FARPROC

FONTENUMPROC		TYPEDEF		FARPROC

@proto_327		TYPEDEF		PROTO FAR PASCAL :HDC, :LPCSTR, :OLDFONTENUMPROC, :LPSTR
EnumFonts		PROTO		@proto_327

@proto_328		TYPEDEF		PROTO FAR PASCAL :HDC, :LPCSTR, :FONTENUMPROC, :LPSTR
EnumFontFamilies		PROTO		@proto_328

RASTER_FONTTYPE		EQU		000000001h
DEVICE_FONTTYPE		EQU		000000002h
TRUETYPE_FONTTYPE		EQU		000000004h
@proto_329		TYPEDEF		PROTO FAR PASCAL :HDC, :DWORD, :DWORD, :FAR PTR , :DWORD
GetFontData		PROTO		@proto_329

@proto_330		TYPEDEF		PROTO FAR PASCAL :UINT, :LPCSTR, :LPCSTR, :LPCSTR
CreateScalableFontResource		PROTO		@proto_330

tagGLYPHMETRICS		STRUCT 1t
gmBlackBoxX		UINT		?
gmBlackBoxY		UINT		?
gmptGlyphOrigin		POINT		<>
gmCellIncX		SWORD		?
gmCellIncY		SWORD		?
tagGLYPHMETRICS		ENDS

GLYPHMETRICS		TYPEDEF		tagGLYPHMETRICS

LPGLYPHMETRICS		TYPEDEF		FAR PTR tagGLYPHMETRICS

tagFIXED		STRUCT 1t
fract		UINT		?
value		SWORD		?
tagFIXED		ENDS

FIXED		TYPEDEF		tagFIXED

LPFIXED		TYPEDEF		FAR PTR tagFIXED

tagMAT2		STRUCT 1t
eM11		FIXED		<>
eM12		FIXED		<>
eM21		FIXED		<>
eM22		FIXED		<>
tagMAT2		ENDS

MAT2		TYPEDEF		tagMAT2

LPMAT2		TYPEDEF		FAR PTR tagMAT2

@proto_331		TYPEDEF		PROTO FAR PASCAL :HDC, :UINT, :UINT, :FAR PTR GLYPHMETRICS, :DWORD, :FAR PTR , :FAR PTR tagMAT2
GetGlyphOutline		PROTO		@proto_331

GGO_METRICS		EQU		0t
GGO_BITMAP		EQU		1t
GGO_NATIVE		EQU		2t
TT_POLYGON_TYPE		EQU		24t
TT_PRIM_LINE		EQU		1t
TT_PRIM_QSPLINE		EQU		2t
tagPOINTFX		STRUCT 1t
x		FIXED		<>
y		FIXED		<>
tagPOINTFX		ENDS

POINTFX		TYPEDEF		tagPOINTFX

LPPOINTFX		TYPEDEF		FAR PTR tagPOINTFX

tagTTPOLYCURVE		STRUCT 1t
wType		UINT		?
cpfx		UINT		?
apfx		POINTFX		1t DUP (<>)
tagTTPOLYCURVE		ENDS

TTPOLYCURVE		TYPEDEF		tagTTPOLYCURVE

LPTTPOLYCURVE		TYPEDEF		FAR PTR tagTTPOLYCURVE

tagTTPOLYGONHEADER		STRUCT 1t
cb		DWORD		?
dwType		DWORD		?
pfxStart		POINTFX		<>
tagTTPOLYGONHEADER		ENDS

TTPOLYGONHEADER		TYPEDEF		tagTTPOLYGONHEADER

LPTTPOLYGONHEADER		TYPEDEF		FAR PTR tagTTPOLYGONHEADER

tagABC		STRUCT 1t
abcA		SWORD		?
abcB		UINT		?
abcC		SWORD		?
tagABC		ENDS

ABC		TYPEDEF		tagABC

LPABC		TYPEDEF		FAR PTR ABC

@proto_332		TYPEDEF		PROTO FAR PASCAL :HDC, :UINT, :UINT, :FAR PTR ABC
GetCharABCWidths		PROTO		@proto_332

tagKERNINGPAIR		STRUCT 1t
wFirst		WORD		?
wSecond		WORD		?
iKernAmount		SWORD		?
tagKERNINGPAIR		ENDS

KERNINGPAIR		TYPEDEF		tagKERNINGPAIR

LPKERNINGPAIR		TYPEDEF		FAR PTR tagKERNINGPAIR

@proto_333		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :FAR PTR KERNINGPAIR
GetKerningPairs		PROTO		@proto_333

tagRASTERIZER_STATUS		STRUCT 1t
nSize		SWORD		?
wFlags		SWORD		?
nLanguageID		SWORD		?
tagRASTERIZER_STATUS		ENDS

RASTERIZER_STATUS		TYPEDEF		tagRASTERIZER_STATUS

LPRASTERIZER_STATUS		TYPEDEF		FAR PTR RASTERIZER_STATUS

TT_AVAILABLE		EQU		000000001h
TT_ENABLED		EQU		000000002h
@proto_334		TYPEDEF		PROTO FAR PASCAL :FAR PTR RASTERIZER_STATUS, :SWORD
GetRasterizerCaps		PROTO		@proto_334

@t_0		TYPEDEF		FAR PTR 
tagBITMAP		STRUCT 1t
bmType		SWORD		?
bmWidth		SWORD		?
bmHeight		SWORD		?
bmWidthBytes		SWORD		?
bmPlanes		BYTE		?
bmBitsPixel		BYTE		?
bmBits		@t_0		?
tagBITMAP		ENDS

BITMAP		TYPEDEF		tagBITMAP

PBITMAP		TYPEDEF		PTR BITMAP

NPBITMAP		TYPEDEF		NEAR PTR BITMAP

LPBITMAP		TYPEDEF		FAR PTR BITMAP

tagRGBTRIPLE		STRUCT 1t
rgbtBlue		BYTE		?
rgbtGreen		BYTE		?
rgbtRed		BYTE		?
tagRGBTRIPLE		ENDS

RGBTRIPLE		TYPEDEF		tagRGBTRIPLE

LPRGBTRIPLE		TYPEDEF		FAR PTR RGBTRIPLE

tagRGBQUAD		STRUCT 1t
rgbBlue		BYTE		?
rgbGreen		BYTE		?
rgbRed		BYTE		?
rgbReserved		BYTE		?
tagRGBQUAD		ENDS

RGBQUAD		TYPEDEF		tagRGBQUAD

LPRGBQUAD		TYPEDEF		FAR PTR RGBQUAD

tagBITMAPCOREHEADER		STRUCT 1t
bcSize		DWORD		?
bcWidth		SWORD		?
bcHeight		SWORD		?
bcPlanes		WORD		?
bcBitCount		WORD		?
tagBITMAPCOREHEADER		ENDS

BITMAPCOREHEADER		TYPEDEF		tagBITMAPCOREHEADER

PBITMAPCOREHEADER		TYPEDEF		PTR BITMAPCOREHEADER

LPBITMAPCOREHEADER		TYPEDEF		FAR PTR BITMAPCOREHEADER

tagBITMAPINFOHEADER		STRUCT 1t
biSize		DWORD		?
biWidth		SDWORD		?
biHeight		SDWORD		?
biPlanes		WORD		?
biBitCount		WORD		?
biCompression		DWORD		?
biSizeImage		DWORD		?
biXPelsPerMeter		SDWORD		?
biYPelsPerMeter		SDWORD		?
biClrUsed		DWORD		?
biClrImportant		DWORD		?
tagBITMAPINFOHEADER		ENDS

BITMAPINFOHEADER		TYPEDEF		tagBITMAPINFOHEADER

PBITMAPINFOHEADER		TYPEDEF		PTR BITMAPINFOHEADER

LPBITMAPINFOHEADER		TYPEDEF		FAR PTR BITMAPINFOHEADER

BI_RGB		EQU		000000000h
BI_RLE8		EQU		000000001h
BI_RLE4		EQU		000000002h
tagBITMAPINFO		STRUCT 1t
bmiHeader		BITMAPINFOHEADER		<>
bmiColors		RGBQUAD		1t DUP (<>)
tagBITMAPINFO		ENDS

BITMAPINFO		TYPEDEF		tagBITMAPINFO

PBITMAPINFO		TYPEDEF		PTR BITMAPINFO

LPBITMAPINFO		TYPEDEF		FAR PTR BITMAPINFO

tagBITMAPCOREINFO		STRUCT 1t
bmciHeader		BITMAPCOREHEADER		<>
bmciColors		RGBTRIPLE		1t DUP (<>)
tagBITMAPCOREINFO		ENDS

BITMAPCOREINFO		TYPEDEF		tagBITMAPCOREINFO

PBITMAPCOREINFO		TYPEDEF		PTR BITMAPCOREINFO

LPBITMAPCOREINFO		TYPEDEF		FAR PTR BITMAPCOREINFO

tagBITMAPFILEHEADER		STRUCT 1t
bfType		UINT		?
bfSize		DWORD		?
bfReserved1		UINT		?
bfReserved2		UINT		?
bfOffBits		DWORD		?
tagBITMAPFILEHEADER		ENDS

BITMAPFILEHEADER		TYPEDEF		tagBITMAPFILEHEADER

PBITMAPFILEHEADER		TYPEDEF		PTR BITMAPFILEHEADER

LPBITMAPFILEHEADER		TYPEDEF		FAR PTR BITMAPFILEHEADER

@proto_335		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD, :UINT, :UINT, :FAR PTR 
CreateBitmap		PROTO		@proto_335

@proto_336		TYPEDEF		PROTO FAR PASCAL :FAR PTR BITMAP
CreateBitmapIndirect		PROTO		@proto_336

@proto_337		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
CreateCompatibleBitmap		PROTO		@proto_337

@proto_338		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
CreateDiscardableBitmap		PROTO		@proto_338

@proto_339		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR BITMAPINFOHEADER, :DWORD, :FAR PTR , :FAR PTR BITMAPINFO, :UINT
CreateDIBitmap		PROTO		@proto_339

@proto_340		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :LPCSTR
LoadBitmap		PROTO		@proto_340

DIB_RGB_COLORS		EQU		0t
DIB_PAL_COLORS		EQU		1t
CBM_INIT		EQU		000000004h
R2_BLACK		EQU		1t
R2_NOTMERGEPEN		EQU		2t
R2_MASKNOTPEN		EQU		3t
R2_NOTCOPYPEN		EQU		4t
R2_MASKPENNOT		EQU		5t
R2_NOT		EQU		6t
R2_XORPEN		EQU		7t
R2_NOTMASKPEN		EQU		8t
R2_MASKPEN		EQU		9t
R2_NOTXORPEN		EQU		10t
R2_NOP		EQU		11t
R2_MERGENOTPEN		EQU		12t
R2_COPYPEN		EQU		13t
R2_MERGEPENNOT		EQU		14t
R2_MERGEPEN		EQU		15t
R2_WHITE		EQU		16t
SRCCOPY		EQU		000cc0020h
SRCPAINT		EQU		000ee0086h
SRCAND		EQU		0008800c6h
SRCINVERT		EQU		000660046h
SRCERASE		EQU		000440328h
NOTSRCCOPY		EQU		000330008h
NOTSRCERASE		EQU		0001100a6h
MERGECOPY		EQU		000c000cah
MERGEPAINT		EQU		000bb0226h
PATCOPY		EQU		000f00021h
PATPAINT		EQU		000fb0a09h
PATINVERT		EQU		0005a0049h
DSTINVERT		EQU		000550009h
BLACKNESS		EQU		000000042h
WHITENESS		EQU		000ff0062h
@proto_341		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD, :HDC, :SWORD, :SWORD, :DWORD
BitBlt		PROTO		@proto_341

@proto_342		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD, :DWORD
PatBlt		PROTO		@proto_342

@proto_343		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD, :HDC, :SWORD, :SWORD, :SWORD, :SWORD, :DWORD
StretchBlt		PROTO		@proto_343

@proto_344		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :FAR PTR , :LPBITMAPINFO, :UINT, :DWORD
StretchDIBits		PROTO		@proto_344

@proto_345		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :COLORREF
SetPixel		PROTO		@proto_345

@proto_346		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD
GetPixel		PROTO		@proto_346

BLACKONWHITE		EQU		1t
WHITEONBLACK		EQU		2t
COLORONCOLOR		EQU		3t
STRETCH_ANDSCANS		EQU		1t
STRETCH_ORSCANS		EQU		2t
STRETCH_DELETESCANS		EQU		3t
@proto_347		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD
SetStretchBltMode		PROTO		@proto_347

@proto_348		TYPEDEF		PROTO FAR PASCAL :HDC
GetStretchBltMode		PROTO		@proto_348

@proto_349		TYPEDEF		PROTO FAR PASCAL :HBITMAP, :SWORD, :SWORD
SetBitmapDimension		PROTO		@proto_349

@proto_350		TYPEDEF		PROTO FAR PASCAL :HBITMAP
GetBitmapDimension		PROTO		@proto_350

@proto_351		TYPEDEF		PROTO FAR PASCAL :HBITMAP, :SWORD, :SWORD, :FAR PTR _SIZE
SetBitmapDimensionEx		PROTO		@proto_351

@proto_352		TYPEDEF		PROTO FAR PASCAL :HBITMAP, :FAR PTR _SIZE
GetBitmapDimensionEx		PROTO		@proto_352

@proto_353		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD
SetROP2		PROTO		@proto_353

@proto_354		TYPEDEF		PROTO FAR PASCAL :HDC
GetROP2		PROTO		@proto_354

@proto_355		TYPEDEF		PROTO FAR PASCAL :HBITMAP, :DWORD, :FAR PTR 
SetBitmapBits		PROTO		@proto_355

@proto_356		TYPEDEF		PROTO FAR PASCAL :HBITMAP, :SDWORD, :FAR PTR 
GetBitmapBits		PROTO		@proto_356

@proto_357		TYPEDEF		PROTO FAR PASCAL :HDC, :HBITMAP, :UINT, :UINT, :FAR PTR , :FAR PTR BITMAPINFO, :UINT
SetDIBits		PROTO		@proto_357

@proto_358		TYPEDEF		PROTO FAR PASCAL :HDC, :HBITMAP, :UINT, :UINT, :FAR PTR , :FAR PTR BITMAPINFO, :UINT
GetDIBits		PROTO		@proto_358

@proto_359		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :SWORD, :UINT, :UINT, :FAR PTR , :FAR PTR BITMAPINFO, :UINT
SetDIBitsToDevice		PROTO		@proto_359

HMETAFILE		TYPEDEF		UINT

@proto_360		TYPEDEF		PROTO FAR PASCAL :LPCSTR
CreateMetaFile		PROTO		@proto_360

@proto_361		TYPEDEF		PROTO FAR PASCAL :HDC
CloseMetaFile		PROTO		@proto_361

@proto_362		TYPEDEF		PROTO FAR PASCAL :LPCSTR
GetMetaFile		PROTO		@proto_362

@proto_363		TYPEDEF		PROTO FAR PASCAL :HMETAFILE
DeleteMetaFile		PROTO		@proto_363

@proto_364		TYPEDEF		PROTO FAR PASCAL :HMETAFILE, :LPCSTR
CopyMetaFile		PROTO		@proto_364

@proto_365		TYPEDEF		PROTO FAR PASCAL :HDC, :HMETAFILE
PlayMetaFile		PROTO		@proto_365

@proto_366		TYPEDEF		PROTO FAR PASCAL :HMETAFILE
GetMetaFileBits		PROTO		@proto_366

@proto_367		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
SetMetaFileBits		PROTO		@proto_367

@proto_368		TYPEDEF		PROTO FAR PASCAL :HGLOBAL
SetMetaFileBitsBetter		PROTO		@proto_368

tagMETAFILEPICT		STRUCT 1t
mm		SWORD		?
xExt		SWORD		?
yExt		SWORD		?
hMF		HMETAFILE		?
tagMETAFILEPICT		ENDS

METAFILEPICT		TYPEDEF		tagMETAFILEPICT

LPMETAFILEPICT		TYPEDEF		FAR PTR METAFILEPICT

tagMETAHEADER		STRUCT 1t
mtType		UINT		?
mtHeaderSize		UINT		?
mtVersion		UINT		?
mtSize		DWORD		?
mtNoObjects		UINT		?
mtMaxRecord		DWORD		?
mtNoParameters		UINT		?
tagMETAHEADER		ENDS

METAHEADER		TYPEDEF		tagMETAHEADER

tagHANDLETABLE		STRUCT 1t
objectHandle		HGDIOBJ		1t DUP (?)
tagHANDLETABLE		ENDS

HANDLETABLE		TYPEDEF		tagHANDLETABLE

PHANDLETABLE		TYPEDEF		PTR HANDLETABLE

LPHANDLETABLE		TYPEDEF		FAR PTR HANDLETABLE

tagMETARECORD		STRUCT 1t
rdSize		DWORD		?
rdFunction		UINT		?
rdParm		UINT		1t DUP (?)
tagMETARECORD		ENDS

METARECORD		TYPEDEF		tagMETARECORD

PMETARECORD		TYPEDEF		PTR METARECORD

LPMETARECORD		TYPEDEF		FAR PTR METARECORD

META_SETBKCOLOR		EQU		000000201h
META_SETBKMODE		EQU		000000102h
META_SETMAPMODE		EQU		000000103h
META_SETROP2		EQU		000000104h
META_SETRELABS		EQU		000000105h
META_SETPOLYFILLMODE		EQU		000000106h
META_SETSTRETCHBLTMODE		EQU		000000107h
META_SETTEXTCHAREXTRA		EQU		000000108h
META_SETTEXTCOLOR		EQU		000000209h
META_SETTEXTJUSTIFICATION		EQU		00000020ah
META_SETWINDOWORG		EQU		00000020bh
META_SETWINDOWEXT		EQU		00000020ch
META_SETVIEWPORTORG		EQU		00000020dh
META_SETVIEWPORTEXT		EQU		00000020eh
META_OFFSETWINDOWORG		EQU		00000020fh
META_SCALEWINDOWEXT		EQU		000000410h
META_OFFSETVIEWPORTORG		EQU		000000211h
META_SCALEVIEWPORTEXT		EQU		000000412h
META_LINETO		EQU		000000213h
META_MOVETO		EQU		000000214h
META_EXCLUDECLIPRECT		EQU		000000415h
META_INTERSECTCLIPRECT		EQU		000000416h
META_ARC		EQU		000000817h
META_ELLIPSE		EQU		000000418h
META_FLOODFILL		EQU		000000419h
META_PIE		EQU		00000081ah
META_RECTANGLE		EQU		00000041bh
META_ROUNDRECT		EQU		00000061ch
META_PATBLT		EQU		00000061dh
META_SAVEDC		EQU		00000001eh
META_SETPIXEL		EQU		00000041fh
META_OFFSETCLIPRGN		EQU		000000220h
META_TEXTOUT		EQU		000000521h
META_BITBLT		EQU		000000922h
META_STRETCHBLT		EQU		000000b23h
META_POLYGON		EQU		000000324h
META_POLYLINE		EQU		000000325h
META_ESCAPE		EQU		000000626h
META_RESTOREDC		EQU		000000127h
META_FILLREGION		EQU		000000228h
META_FRAMEREGION		EQU		000000429h
META_INVERTREGION		EQU		00000012ah
META_PAINTREGION		EQU		00000012bh
META_SELECTCLIPREGION		EQU		00000012ch
META_SELECTOBJECT		EQU		00000012dh
META_SETTEXTALIGN		EQU		00000012eh
META_DRAWTEXT		EQU		00000062fh
META_CHORD		EQU		000000830h
META_SETMAPPERFLAGS		EQU		000000231h
META_EXTTEXTOUT		EQU		000000a32h
META_SETDIBTODEV		EQU		000000d33h
META_SELECTPALETTE		EQU		000000234h
META_REALIZEPALETTE		EQU		000000035h
META_ANIMATEPALETTE		EQU		000000436h
META_SETPALENTRIES		EQU		000000037h
META_POLYPOLYGON		EQU		000000538h
META_RESIZEPALETTE		EQU		000000139h
META_DIBBITBLT		EQU		000000940h
META_DIBSTRETCHBLT		EQU		000000b41h
META_DIBCREATEPATTERNBRUSH		EQU		000000142h
META_STRETCHDIB		EQU		000000f43h
META_EXTFLOODFILL		EQU		000000548h
META_RESETDC		EQU		00000014ch
META_STARTDOC		EQU		00000014dh
META_STARTPAGE		EQU		00000004fh
META_ENDPAGE		EQU		000000050h
META_ABORTDOC		EQU		000000052h
META_ENDDOC		EQU		00000005eh
META_DELETEOBJECT		EQU		0000001f0h
META_CREATEPALETTE		EQU		0000000f7h
META_CREATEBRUSH		EQU		0000000f8h
META_CREATEPATTERNBRUSH		EQU		0000001f9h
META_CREATEPENINDIRECT		EQU		0000002fah
META_CREATEFONTINDIRECT		EQU		0000002fbh
META_CREATEBRUSHINDIRECT		EQU		0000002fch
META_CREATEBITMAPINDIRECT		EQU		0000002fdh
META_CREATEBITMAP		EQU		0000006feh
META_CREATEREGION		EQU		0000006ffh
@proto_369		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR HANDLETABLE, :FAR PTR METARECORD, :UINT
PlayMetaFileRecord		PROTO		@proto_369

MFENUMPROC		TYPEDEF		FARPROC

@proto_370		TYPEDEF		PROTO FAR PASCAL :HDC, :HMETAFILE, :MFENUMPROC, :LPARAM
EnumMetaFile		PROTO		@proto_370

ABORTPROC		TYPEDEF		FARPROC

@tag_0		STRUCT 1t
cbSize		SWORD		?
lpszDocName		LPCSTR		?
lpszOutput		LPCSTR		?
@tag_0		ENDS

DOCINFO		TYPEDEF		@tag_0

LPDOCINFO		TYPEDEF		FAR PTR DOCINFO

@proto_371		TYPEDEF		PROTO FAR PASCAL :HDC, :FAR PTR DOCINFO
StartDoc		PROTO		@proto_371

@proto_372		TYPEDEF		PROTO FAR PASCAL :HDC
StartPage		PROTO		@proto_372

@proto_373		TYPEDEF		PROTO FAR PASCAL :HDC
EndPage		PROTO		@proto_373

@proto_374		TYPEDEF		PROTO FAR PASCAL :HDC
EndDoc		PROTO		@proto_374

@proto_375		TYPEDEF		PROTO FAR PASCAL :HDC
AbortDoc		PROTO		@proto_375

@proto_376		TYPEDEF		PROTO FAR PASCAL :HDC, :ABORTPROC
SetAbortProc		PROTO		@proto_376

@proto_377		TYPEDEF		PROTO FAR PASCAL :LPSTR, :LPSTR, :LPSTR, :LPSTR
SpoolFile		PROTO		@proto_377

@proto_378		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD
QueryAbort		PROTO		@proto_378

SP_NOTREPORTED		EQU		000004000h
SP_ERROR		EQU		-1t
SP_APPABORT		EQU		-2t
SP_USERABORT		EQU		-3t
SP_OUTOFDISK		EQU		-4t
SP_OUTOFMEMORY		EQU		-5t
PR_JOBSTATUS		EQU		000000000h

endif 	; of ifndef NOGDI

WM_SPOOLERSTATUS		EQU		00000002ah

ifndef	NOGDI	; GDI FUNCTIONS

@proto_379		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :LPCSTR, :FAR PTR 
Escape		PROTO		@proto_379

NEWFRAME		EQU		1t
ABORTDOC		EQU		2t
NEXTBAND		EQU		3t
SETCOLORTABLE		EQU		4t
GETCOLORTABLE		EQU		5t
FLUSHOUTPUT		EQU		6t
DRAFTMODE		EQU		7t
QUERYESCSUPPORT		EQU		8t
SETABORTPROC		EQU		9t
STARTDOC		EQU		10t
ENDDOC		EQU		11t
GETPHYSPAGESIZE		EQU		12t
GETPRINTINGOFFSET		EQU		13t
GETSCALINGFACTOR		EQU		14t
MFCOMMENT		EQU		15t
GETPENWIDTH		EQU		16t
SETCOPYCOUNT		EQU		17t
SELECTPAPERSOURCE		EQU		18t
DEVICEDATA		EQU		19t
PASSTHROUGH		EQU		19t
GETTECHNOLGY		EQU		20t
GETTECHNOLOGY		EQU		20t
SETLINECAP		EQU		21t
SETLINEJOIN		EQU		22t
SETMITERLIMIT		EQU		23t
BANDINFO		EQU		24t
DRAWPATTERNRECT		EQU		25t
GETVECTORPENSIZE		EQU		26t
GETVECTORBRUSHSIZE		EQU		27t
ENABLEDUPLEX		EQU		28t
GETSETPAPERBINS		EQU		29t
GETSETPRINTORIENT		EQU		30t
ENUMPAPERBINS		EQU		31t
SETDIBSCALING		EQU		32t
EPSPRINTING		EQU		33t
ENUMPAPERMETRICS		EQU		34t
GETSETPAPERMETRICS		EQU		35t
POSTSCRIPT_DATA		EQU		37t
POSTSCRIPT_IGNORE		EQU		38t
MOUSETRAILS		EQU		39t
GETEXTENDEDTEXTMETRICS		EQU		256t
GETEXTENTTABLE		EQU		257t
GETPAIRKERNTABLE		EQU		258t
GETTRACKKERNTABLE		EQU		259t
EXTTEXTOUT		EQU		512t
GETFACENAME		EQU		513t
ENABLERELATIVEWIDTHS		EQU		768t
ENABLEPAIRKERNING		EQU		769t
SETKERNTRACK		EQU		770t
SETALLJUSTVALUES		EQU		771t
SETCHARSET		EQU		772t
STRETCHBLT		EQU		2048t
GETSETSCREENPARAMS		EQU		3072t
BEGIN_PATH		EQU		4096t
CLIP_TO_PATH		EQU		4097t
END_PATH		EQU		4098t
EXT_DEVICE_CAPS		EQU		4099t
RESTORE_CTM		EQU		4100t
SAVE_CTM		EQU		4101t
SET_ARC_DIRECTION		EQU		4102t
SET_BACKGROUND_COLOR		EQU		4103t
SET_POLY_MODE		EQU		4104t
SET_SCREEN_ANGLE		EQU		4105t
SET_SPREAD		EQU		4106t
TRANSFORM_CTM		EQU		4107t
SET_CLIP_BOX		EQU		4108t
SET_BOUNDS		EQU		4109t

endif	; of ifndef NOGDI

HWND		TYPEDEF		UINT

ifndef	NOUSER	; USER FUNCTIONS

HMENU		TYPEDEF		UINT

HICON		TYPEDEF		UINT

HCURSOR		TYPEDEF		HICON

@proto_380		TYPEDEF		PROTO FAR PASCAL :SWORD
GetSystemMetrics		PROTO		@proto_380

SM_CXSCREEN		EQU		0t
SM_CYSCREEN		EQU		1t
SM_CXVSCROLL		EQU		2t
SM_CYHSCROLL		EQU		3t
SM_CYCAPTION		EQU		4t
SM_CXBORDER		EQU		5t
SM_CYBORDER		EQU		6t
SM_CXDLGFRAME		EQU		7t
SM_CYDLGFRAME		EQU		8t
SM_CYVTHUMB		EQU		9t
SM_CXHTHUMB		EQU		10t
SM_CXICON		EQU		11t
SM_CYICON		EQU		12t
SM_CXCURSOR		EQU		13t
SM_CYCURSOR		EQU		14t
SM_CYMENU		EQU		15t
SM_CXFULLSCREEN		EQU		16t
SM_CYFULLSCREEN		EQU		17t
SM_CYKANJIWINDOW		EQU		18t
SM_MOUSEPRESENT		EQU		19t
SM_CYVSCROLL		EQU		20t
SM_CXHSCROLL		EQU		21t
SM_DEBUG		EQU		22t
SM_SWAPBUTTON		EQU		23t
SM_RESERVED1		EQU		24t
SM_RESERVED2		EQU		25t
SM_RESERVED3		EQU		26t
SM_RESERVED4		EQU		27t
SM_CXMIN		EQU		28t
SM_CYMIN		EQU		29t
SM_CXSIZE		EQU		30t
SM_CYSIZE		EQU		31t
SM_CXFRAME		EQU		32t
SM_CYFRAME		EQU		33t
SM_CXMINTRACK		EQU		34t
SM_CYMINTRACK		EQU		35t
SM_CXDOUBLECLK		EQU		36t
SM_CYDOUBLECLK		EQU		37t
SM_CXICONSPACING		EQU		38t
SM_CYICONSPACING		EQU		39t
SM_MENUDROPALIGNMENT		EQU		40t
SM_PENWINDOWS		EQU		41t
SM_DBCSENABLED		EQU		42t
SM_CMETRICS		EQU		43t
@proto_381		TYPEDEF		PROTO FAR PASCAL 
GetDoubleClickTime		PROTO		@proto_381

@proto_382		TYPEDEF		PROTO FAR PASCAL :UINT
SetDoubleClickTime		PROTO		@proto_382

WM_DEVMODECHANGE		EQU		00000001bh
WM_TIMECHANGE		EQU		00000001eh
@proto_383		TYPEDEF		PROTO FAR PASCAL :UINT, :UINT, :FAR PTR , :UINT
SystemParametersInfo		PROTO		@proto_383

SPI_GETBEEP		EQU		1t
SPI_SETBEEP		EQU		2t
SPI_GETMOUSE		EQU		3t
SPI_SETMOUSE		EQU		4t
SPI_GETBORDER		EQU		5t
SPI_SETBORDER		EQU		6t
SPI_GETKEYBOARDSPEED		EQU		10t
SPI_SETKEYBOARDSPEED		EQU		11t
SPI_LANGDRIVER		EQU		12t
SPI_ICONHORIZONTALSPACING		EQU		13t
SPI_GETSCREENSAVETIMEOUT		EQU		14t
SPI_SETSCREENSAVETIMEOUT		EQU		15t
SPI_GETSCREENSAVEACTIVE		EQU		16t
SPI_SETSCREENSAVEACTIVE		EQU		17t
SPI_GETGRIDGRANULARITY		EQU		18t
SPI_SETGRIDGRANULARITY		EQU		19t
SPI_SETDESKWALLPAPER		EQU		20t
SPI_SETDESKPATTERN		EQU		21t
SPI_GETKEYBOARDDELAY		EQU		22t
SPI_SETKEYBOARDDELAY		EQU		23t
SPI_ICONVERTICALSPACING		EQU		24t
SPI_GETICONTITLEWRAP		EQU		25t
SPI_SETICONTITLEWRAP		EQU		26t
SPI_GETMENUDROPALIGNMENT		EQU		27t
SPI_SETMENUDROPALIGNMENT		EQU		28t
SPI_SETDOUBLECLKWIDTH		EQU		29t
SPI_SETDOUBLECLKHEIGHT		EQU		30t
SPI_GETICONTITLELOGFONT		EQU		31t
SPI_SETDOUBLECLICKTIME		EQU		32t
SPI_SETMOUSEBUTTONSWAP		EQU		33t
SPI_SETICONTITLELOGFONT		EQU		34t
SPI_GETFASTTASKSWITCH		EQU		35t
SPI_SETFASTTASKSWITCH		EQU		36t
SPIF_UPDATEINIFILE		EQU		000000001h
SPIF_SENDWININICHANGE		EQU		000000002h
@proto_384		TYPEDEF		PROTO FAR PASCAL :FAR PTR RECT, :SWORD, :SWORD, :SWORD, :SWORD
SetRect		PROTO		@proto_384

@proto_385		TYPEDEF		PROTO FAR PASCAL :FAR PTR RECT
SetRectEmpty		PROTO		@proto_385

@proto_386		TYPEDEF		PROTO FAR PASCAL :FAR PTR RECT, :FAR PTR tagRECT
CopyRect		PROTO		@proto_386

@proto_387		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagRECT
IsRectEmpty		PROTO		@proto_387

@proto_388		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagRECT, :FAR PTR tagRECT
EqualRect		PROTO		@proto_388

@proto_389		TYPEDEF		PROTO FAR PASCAL :FAR PTR RECT, :FAR PTR tagRECT, :FAR PTR tagRECT
IntersectRect		PROTO		@proto_389

@proto_390		TYPEDEF		PROTO FAR PASCAL :FAR PTR RECT, :FAR PTR tagRECT, :FAR PTR tagRECT
UnionRect		PROTO		@proto_390

@proto_391		TYPEDEF		PROTO FAR PASCAL :FAR PTR RECT, :FAR PTR tagRECT, :FAR PTR tagRECT
SubtractRect		PROTO		@proto_391

@proto_392		TYPEDEF		PROTO FAR PASCAL :FAR PTR RECT, :SWORD, :SWORD
OffsetRect		PROTO		@proto_392

@proto_393		TYPEDEF		PROTO FAR PASCAL :FAR PTR RECT, :SWORD, :SWORD
InflateRect		PROTO		@proto_393

@proto_394		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagRECT, :POINT
PtInRect		PROTO		@proto_394

@proto_395		TYPEDEF		PROTO FAR PASCAL :LPCSTR
RegisterWindowMessage		PROTO		@proto_395

WM_NULL		EQU		000000000h
WM_USER		EQU		000000400h
tagMSG		STRUCT 1t
hwnd		HWND		?
message		UINT		?
wParam		WPARAM		?
lParam		LPARAM		?
time		DWORD		?
pt		POINT		<>
tagMSG		ENDS

MSG		TYPEDEF		tagMSG

PMSG		TYPEDEF		PTR MSG

NPMSG		TYPEDEF		NEAR PTR MSG

LPMSG		TYPEDEF		FAR PTR MSG

@proto_396		TYPEDEF		PROTO FAR PASCAL :FAR PTR MSG, :HWND, :UINT, :UINT
GetMessage		PROTO		@proto_396

@proto_397		TYPEDEF		PROTO FAR PASCAL :FAR PTR MSG, :HWND, :UINT, :UINT, :UINT
PeekMessage		PROTO		@proto_397

PM_NOREMOVE		EQU		000000000h
PM_REMOVE		EQU		000000001h
PM_NOYIELD		EQU		000000002h
@proto_398		TYPEDEF		PROTO FAR PASCAL 
WaitMessage		PROTO		@proto_398

@proto_399		TYPEDEF		PROTO FAR PASCAL 
GetMessagePos		PROTO		@proto_399

@proto_400		TYPEDEF		PROTO FAR PASCAL 
GetMessageTime		PROTO		@proto_400

@proto_401		TYPEDEF		PROTO FAR PASCAL 
GetMessageExtraInfo		PROTO		@proto_401

@proto_402		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagMSG
TranslateMessage		PROTO		@proto_402

@proto_403		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagMSG
DispatchMessage		PROTO		@proto_403

@proto_404		TYPEDEF		PROTO FAR PASCAL :SWORD
SetMessageQueue		PROTO		@proto_404

@proto_405		TYPEDEF		PROTO FAR PASCAL 
GetInputState		PROTO		@proto_405

@proto_406		TYPEDEF		PROTO FAR PASCAL :UINT
GetQueueStatus		PROTO		@proto_406

QS_KEY		EQU		000000001h
QS_MOUSEMOVE		EQU		000000002h
QS_MOUSEBUTTON		EQU		000000004h
QS_MOUSE		EQU		000000006h
QS_POSTMESSAGE		EQU		000000008h
QS_TIMER		EQU		000000010h
QS_PAINT		EQU		000000020h
QS_SENDMESSAGE		EQU		000000040h
QS_ALLINPUT		EQU		00000007fh
@proto_407		TYPEDEF		PROTO FAR PASCAL :HWND, :UINT, :WPARAM, :LPARAM
PostMessage		PROTO		@proto_407

@proto_408		TYPEDEF		PROTO FAR PASCAL :HWND, :UINT, :WPARAM, :LPARAM
SendMessage		PROTO		@proto_408

@proto_409		TYPEDEF		PROTO FAR PASCAL :HTASK, :UINT, :WPARAM, :LPARAM
PostAppMessage		PROTO		@proto_409

@proto_410		TYPEDEF		PROTO FAR PASCAL :LRESULT
ReplyMessage		PROTO		@proto_410

@proto_411		TYPEDEF		PROTO FAR PASCAL 
InSendMessage		PROTO		@proto_411

HWND_BROADCAST		EQU		00000ffffh
@proto_412		TYPEDEF		PROTO FAR PASCAL :FAR PTR MSG, :SWORD
CallMsgFilter		PROTO		@proto_412

WH_GETMESSAGE		EQU		3t
WH_CALLWNDPROC		EQU		4t
WH_MSGFILTER		EQU		-1t
WH_SYSMSGFILTER		EQU		6t
MSGF_DIALOGBOX		EQU		0t
MSGF_MENU		EQU		2t
MSGF_MOVE		EQU		3t
MSGF_SIZE		EQU		4t
MSGF_SCROLLBAR		EQU		5t
MSGF_NEXTWINDOW		EQU		6t
MSGF_MAINLOOP		EQU		8t
MSGF_USER		EQU		4096t
WM_PENWINFIRST		EQU		000000380h
WM_PENWINLAST		EQU		00000038fh
WM_COALESCE_FIRST		EQU		000000390h
WM_COALESCE_LAST		EQU		00000039fh
WM_POWER		EQU		000000048h
PWR_OK		EQU		1t
PWR_FAIL		EQU		-1t
PWR_SUSPENDREQUEST		EQU		1t
PWR_SUSPENDRESUME		EQU		2t
PWR_CRITICALRESUME		EQU		3t
WM_QUERYENDSESSION		EQU		000000011h
WM_ENDSESSION		EQU		000000016h
WM_QUIT		EQU		000000012h
@proto_413		TYPEDEF		PROTO FAR PASCAL :SWORD
PostQuitMessage		PROTO		@proto_413

WM_SYSTEMERROR		EQU		000000017h
@proto_414		TYPEDEF		PROTO FAR PASCAL :HWND, :UINT, :WPARAM, :LPARAM
WNDPROC		TYPEDEF		FAR PTR @proto_414

tagWNDCLASS		STRUCT 1t
style		UINT		?
lpfnWndProc		WNDPROC		?
cbClsExtra		SWORD		?
cbWndExtra		SWORD		?
hInstance		HINSTANCE		?
hIcon		HICON		?
hCursor		HCURSOR		?
hbrBackground		HBRUSH		?
lpszMenuName		LPCSTR		?
lpszClassName		LPCSTR		?
tagWNDCLASS		ENDS

WNDCLASS		TYPEDEF		tagWNDCLASS

PWNDCLASS		TYPEDEF		PTR WNDCLASS

NPWNDCLASS		TYPEDEF		NEAR PTR WNDCLASS

LPWNDCLASS		TYPEDEF		FAR PTR WNDCLASS

@proto_415		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagWNDCLASS
RegisterClass		PROTO		@proto_415

@proto_416		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :HINSTANCE
UnregisterClass		PROTO		@proto_416

@proto_417		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :LPCSTR, :FAR PTR WNDCLASS
GetClassInfo		PROTO		@proto_417

@proto_418		TYPEDEF		PROTO FAR PASCAL :HWND, :LPSTR, :SWORD
GetClassName		PROTO		@proto_418

CS_VREDRAW		EQU		000000001h
CS_HREDRAW		EQU		000000002h
CS_OWNDC		EQU		000000020h
CS_CLASSDC		EQU		000000040h
CS_PARENTDC		EQU		000000080h
CS_SAVEBITS		EQU		000000800h
CS_DBLCLKS		EQU		000000008h
CS_BYTEALIGNCLIENT		EQU		000001000h
CS_BYTEALIGNWINDOW		EQU		000002000h
CS_NOCLOSE		EQU		000000200h
CS_KEYCVTWINDOW		EQU		000000004h
CS_NOKEYCVT		EQU		000000100h
CS_GLOBALCLASS		EQU		000004000h
@proto_419		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD
GetClassWord		PROTO		@proto_419

@proto_420		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :WORD
SetClassWord		PROTO		@proto_420

@proto_421		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD
GetClassLong		PROTO		@proto_421

@proto_422		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :SDWORD
SetClassLong		PROTO		@proto_422

GCL_MENUNAME		EQU		-8t
GCW_HBRBACKGROUND		EQU		-10t
GCW_HCURSOR		EQU		-12t
GCW_HICON		EQU		-14t
GCW_HMODULE		EQU		-16t
GCW_CBWNDEXTRA		EQU		-18t
GCW_CBCLSEXTRA		EQU		-20t
GCL_WNDPROC		EQU		-24t
GCW_STYLE		EQU		-26t
GCW_ATOM		EQU		-32t
WS_OVERLAPPED		EQU		000000000h
WS_POPUP		EQU		080000000h
WS_CHILD		EQU		040000000h
WS_CLIPSIBLINGS		EQU		004000000h
WS_CLIPCHILDREN		EQU		002000000h
WS_VISIBLE		EQU		010000000h
WS_DISABLED		EQU		008000000h
WS_MINIMIZE		EQU		020000000h
WS_MAXIMIZE		EQU		001000000h
WS_CAPTION		EQU		000c00000h
WS_BORDER		EQU		000800000h
WS_DLGFRAME		EQU		000400000h
WS_VSCROLL		EQU		000200000h
WS_HSCROLL		EQU		000100000h
WS_SYSMENU		EQU		000080000h
WS_THICKFRAME		EQU		000040000h
WS_MINIMIZEBOX		EQU		000020000h
WS_MAXIMIZEBOX		EQU		000010000h
WS_GROUP		EQU		000020000h
WS_TABSTOP		EQU		000010000h
WS_OVERLAPPEDWINDOW		EQU		000cf0000h
WS_POPUPWINDOW		EQU		080880000h
WS_CHILDWINDOW		EQU		040000000h
WS_EX_DLGMODALFRAME		EQU		000000001h
WS_EX_NOPARENTNOTIFY		EQU		000000004h
WS_EX_TOPMOST		EQU		000000008h
WS_EX_ACCEPTFILES		EQU		000000010h
WS_EX_TRANSPARENT		EQU		000000020h
WS_TILED		EQU		000000000h
WS_ICONIC		EQU		020000000h
WS_SIZEBOX		EQU		000040000h
WS_TILEDWINDOW		EQU		000cf0000h
HWND_DESKTOP		EQU		0t
@proto_423		TYPEDEF		PROTO FAR PASCAL :HWND
IsWindow		PROTO		@proto_423

@proto_424		TYPEDEF		PROTO FAR PASCAL :DWORD, :LPCSTR, :LPCSTR, :DWORD, :SWORD, :SWORD, :SWORD, :SWORD, :HWND, :HMENU, :HINSTANCE, :FAR PTR 
CreateWindowEx		PROTO		@proto_424

@proto_425		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR, :DWORD, :SWORD, :SWORD, :SWORD, :SWORD, :HWND, :HMENU, :HINSTANCE, :FAR PTR 
CreateWindow		PROTO		@proto_425

WM_CREATE		EQU		000000001h
WM_NCCREATE		EQU		000000081h
@t_1		TYPEDEF		FAR PTR 
tagCREATESTRUCT		STRUCT 1t
lpCreateParams		@t_1		?
hInstance		HINSTANCE		?
hMenu		HMENU		?
hwndParent		HWND		?
cy		SWORD		?
_cx		SWORD		?
y		SWORD		?
x		SWORD		?
style		SDWORD		?
lpszName		LPCSTR		?
lpszClass		LPCSTR		?
dwExStyle		DWORD		?
tagCREATESTRUCT		ENDS

CREATESTRUCT		TYPEDEF		tagCREATESTRUCT

LPCREATESTRUCT		TYPEDEF		FAR PTR CREATESTRUCT

@proto_426		TYPEDEF		PROTO FAR PASCAL :HWND
DestroyWindow		PROTO		@proto_426

WM_DESTROY		EQU		000000002h
WM_NCDESTROY		EQU		000000082h
@proto_427		TYPEDEF		PROTO FAR PASCAL :HWND
GetWindowTask		PROTO		@proto_427

@proto_428		TYPEDEF		PROTO FAR PASCAL :HWND, :HWND
IsChild		PROTO		@proto_428

@proto_429		TYPEDEF		PROTO FAR PASCAL :HWND
GetParent		PROTO		@proto_429

@proto_430		TYPEDEF		PROTO FAR PASCAL :HWND, :HWND
SetParent		PROTO		@proto_430

@proto_431		TYPEDEF		PROTO FAR PASCAL :HWND
IsWindowVisible		PROTO		@proto_431

@proto_432		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD
ShowWindow		PROTO		@proto_432

SW_HIDE		EQU		0t
SW_SHOWNORMAL		EQU		1t
SW_NORMAL		EQU		1t
SW_SHOWMINIMIZED		EQU		2t
SW_SHOWMAXIMIZED		EQU		3t
SW_MAXIMIZE		EQU		3t
SW_SHOWNOACTIVATE		EQU		4t
SW_SHOW		EQU		5t
SW_MINIMIZE		EQU		6t
SW_SHOWMINNOACTIVE		EQU		7t
SW_SHOWNA		EQU		8t
SW_RESTORE		EQU		9t
HIDE_WINDOW		EQU		0t
SHOW_OPENWINDOW		EQU		1t
SHOW_ICONWINDOW		EQU		2t
SHOW_FULLSCREEN		EQU		3t
SHOW_OPENNOACTIVATE		EQU		4t
WM_SHOWWINDOW		EQU		000000018h
SW_PARENTCLOSING		EQU		1t
SW_OTHERMAXIMIZED		EQU		2t
SW_PARENTOPENING		EQU		3t
SW_OTHERRESTORED		EQU		4t
SW_OTHERZOOM		EQU		000000002h
SW_OTHERUNZOOM		EQU		000000004h
WM_SETREDRAW		EQU		00000000bh
@proto_433		TYPEDEF		PROTO FAR PASCAL :HWND, :BOOL
EnableWindow		PROTO		@proto_433

@proto_434		TYPEDEF		PROTO FAR PASCAL :HWND
IsWindowEnabled		PROTO		@proto_434

WM_ENABLE		EQU		00000000ah
@proto_435		TYPEDEF		PROTO FAR PASCAL :HWND, :LPCSTR
SetWindowText		PROTO		@proto_435

@proto_436		TYPEDEF		PROTO FAR PASCAL :HWND, :LPSTR, :SWORD
GetWindowText		PROTO		@proto_436

@proto_437		TYPEDEF		PROTO FAR PASCAL :HWND
GetWindowTextLength		PROTO		@proto_437

WM_SETTEXT		EQU		00000000ch
WM_GETTEXT		EQU		00000000dh
WM_GETTEXTLENGTH		EQU		00000000eh
@proto_438		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD
GetWindowWord		PROTO		@proto_438

@proto_439		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :WORD
SetWindowWord		PROTO		@proto_439

@proto_440		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD
GetWindowLong		PROTO		@proto_440

@proto_441		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :SDWORD
SetWindowLong		PROTO		@proto_441

GWL_WNDPROC		EQU		-4t
GWW_HINSTANCE		EQU		-6t
GWW_HWNDPARENT		EQU		-8t
GWW_ID		EQU		-12t
GWL_STYLE		EQU		-16t
GWL_EXSTYLE		EQU		-20t
CW_USEDEFAULT		EQU		000008000h
@proto_442		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR RECT
GetClientRect		PROTO		@proto_442

@proto_443		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR RECT
GetWindowRect		PROTO		@proto_443

tagWINDOWPLACEMENT		STRUCT 1t
_length		UINT		?
flags		UINT		?
showCmd		UINT		?
ptMinPosition		POINT		<>
ptMaxPosition		POINT		<>
rcNormalPosition		RECT		<>
tagWINDOWPLACEMENT		ENDS

WINDOWPLACEMENT		TYPEDEF		tagWINDOWPLACEMENT

PWINDOWPLACEMENT		TYPEDEF		PTR WINDOWPLACEMENT

LPWINDOWPLACEMENT		TYPEDEF		FAR PTR WINDOWPLACEMENT

WPF_SETMINPOSITION		EQU		000000001h
WPF_RESTORETOMAXIMIZED		EQU		000000002h
@proto_444		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR WINDOWPLACEMENT
GetWindowPlacement		PROTO		@proto_444

@proto_445		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR tagWINDOWPLACEMENT
SetWindowPlacement		PROTO		@proto_445

@proto_446		TYPEDEF		PROTO FAR PASCAL :HWND, :HWND, :SWORD, :SWORD, :SWORD, :SWORD, :UINT
SetWindowPos		PROTO		@proto_446

SWP_NOSIZE		EQU		000000001h
SWP_NOMOVE		EQU		000000002h
SWP_NOZORDER		EQU		000000004h
SWP_NOREDRAW		EQU		000000008h
SWP_NOACTIVATE		EQU		000000010h
SWP_FRAMECHANGED		EQU		000000020h
SWP_SHOWWINDOW		EQU		000000040h
SWP_HIDEWINDOW		EQU		000000080h
SWP_NOCOPYBITS		EQU		000000100h
SWP_NOOWNERZORDER		EQU		000000200h
SWP_DRAWFRAME		EQU		000000020h
SWP_NOREPOSITION		EQU		000000200h
SWP_NOSENDCHANGING		EQU		000000400h
SWP_DEFERERASE		EQU		000002000h
HWND_TOP		EQU		0t
HWND_BOTTOM		EQU		1t
HWND_TOPMOST		EQU		-1t
HWND_NOTOPMOST		EQU		-2t
HDWP		TYPEDEF		UINT

@proto_447		TYPEDEF		PROTO FAR PASCAL :SWORD
BeginDeferWindowPos		PROTO		@proto_447

@proto_448		TYPEDEF		PROTO FAR PASCAL :HDWP, :HWND, :HWND, :SWORD, :SWORD, :SWORD, :SWORD, :UINT
DeferWindowPos		PROTO		@proto_448

@proto_449		TYPEDEF		PROTO FAR PASCAL :HDWP
EndDeferWindowPos		PROTO		@proto_449

@proto_450		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :SWORD, :SWORD, :SWORD, :BOOL
MoveWindow		PROTO		@proto_450

@proto_451		TYPEDEF		PROTO FAR PASCAL :HWND
BringWindowToTop		PROTO		@proto_451

WM_WINDOWPOSCHANGING		EQU		000000046h
WM_WINDOWPOSCHANGED		EQU		000000047h
tagWINDOWPOS		STRUCT 1t
hwnd		HWND		?
hwndInsertAfter		HWND		?
x		SWORD		?
y		SWORD		?
_cx		SWORD		?
cy		SWORD		?
flags		UINT		?
tagWINDOWPOS		ENDS

WINDOWPOS		TYPEDEF		tagWINDOWPOS

LPWINDOWPOS		TYPEDEF		FAR PTR WINDOWPOS

WM_MOVE		EQU		000000003h
WM_SIZE		EQU		000000005h
SIZE_RESTORED		EQU		0t
SIZE_MINIMIZED		EQU		1t
SIZE_MAXIMIZED		EQU		2t
SIZE_MAXSHOW		EQU		3t
SIZE_MAXHIDE		EQU		4t
SIZENORMAL		EQU		000000000h
SIZEICONIC		EQU		000000001h
SIZEFULLSCREEN		EQU		000000002h
SIZEZOOMSHOW		EQU		000000003h
SIZEZOOMHIDE		EQU		000000004h
@proto_452		TYPEDEF		PROTO FAR PASCAL :HWND, :UINT, :WPARAM, :LPARAM
DefWindowProc		PROTO		@proto_452

@proto_453		TYPEDEF		PROTO FAR PASCAL :FARPROC, :HWND, :UINT, :WPARAM, :LPARAM
CallWindowProc		PROTO		@proto_453

@proto_454		TYPEDEF		PROTO FAR PASCAL :FAR PTR RECT, :DWORD, :BOOL
AdjustWindowRect		PROTO		@proto_454

@proto_455		TYPEDEF		PROTO FAR PASCAL :FAR PTR RECT, :DWORD, :BOOL, :DWORD
AdjustWindowRectEx		PROTO		@proto_455

WM_QUERYOPEN		EQU		000000013h
WM_CLOSE		EQU		000000010h
tagMINMAXINFO		STRUCT 1t
ptReserved		POINT		<>
ptMaxSize		POINT		<>
ptMaxPosition		POINT		<>
ptMinTrackSize		POINT		<>
ptMaxTrackSize		POINT		<>
tagMINMAXINFO		ENDS

MINMAXINFO		TYPEDEF		tagMINMAXINFO

WM_GETMINMAXINFO		EQU		000000024h
@proto_456		TYPEDEF		PROTO FAR PASCAL :HWND, :BOOL
FlashWindow		PROTO		@proto_456

@proto_457		TYPEDEF		PROTO FAR PASCAL :HWND, :BOOL
ShowOwnedPopups		PROTO		@proto_457

@proto_458		TYPEDEF		PROTO FAR PASCAL :HWND
OpenIcon		PROTO		@proto_458

@proto_459		TYPEDEF		PROTO FAR PASCAL :HWND
CloseWindow		PROTO		@proto_459

@proto_460		TYPEDEF		PROTO FAR PASCAL 
AnyPopup		PROTO		@proto_460

@proto_461		TYPEDEF		PROTO FAR PASCAL :HWND
IsIconic		PROTO		@proto_461

@proto_462		TYPEDEF		PROTO FAR PASCAL :HWND
IsZoomed		PROTO		@proto_462

@proto_463		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR POINT
ClientToScreen		PROTO		@proto_463

@proto_464		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR POINT
ScreenToClient		PROTO		@proto_464

@proto_465		TYPEDEF		PROTO FAR PASCAL :HWND, :HWND, :FAR PTR POINT, :UINT
MapWindowPoints		PROTO		@proto_465

@proto_466		TYPEDEF		PROTO FAR PASCAL :POINT
WindowFromPoint		PROTO		@proto_466

@proto_467		TYPEDEF		PROTO FAR PASCAL :HWND, :POINT
ChildWindowFromPoint		PROTO		@proto_467

@proto_468		TYPEDEF		PROTO FAR PASCAL 
GetDesktopWindow		PROTO		@proto_468

@proto_469		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR
FindWindow		PROTO		@proto_469

WNDENUMPROC		TYPEDEF		FARPROC

@proto_470		TYPEDEF		PROTO FAR PASCAL :WNDENUMPROC, :LPARAM
EnumWindows		PROTO		@proto_470

@proto_471		TYPEDEF		PROTO FAR PASCAL :HWND, :WNDENUMPROC, :LPARAM
EnumChildWindows		PROTO		@proto_471

@proto_472		TYPEDEF		PROTO FAR PASCAL :HTASK, :WNDENUMPROC, :LPARAM
EnumTaskWindows		PROTO		@proto_472

@proto_473		TYPEDEF		PROTO FAR PASCAL :HWND
GetTopWindow		PROTO		@proto_473

@proto_474		TYPEDEF		PROTO FAR PASCAL :HWND, :UINT
GetWindow		PROTO		@proto_474

@proto_475		TYPEDEF		PROTO FAR PASCAL :HWND, :UINT
GetNextWindow		PROTO		@proto_475

GW_HWNDFIRST		EQU		0t
GW_HWNDLAST		EQU		1t
GW_HWNDNEXT		EQU		2t
GW_HWNDPREV		EQU		3t
GW_OWNER		EQU		4t
GW_CHILD		EQU		5t
@proto_476		TYPEDEF		PROTO FAR PASCAL :HWND, :LPCSTR, :HANDLE
SetProp		PROTO		@proto_476

@proto_477		TYPEDEF		PROTO FAR PASCAL :HWND, :LPCSTR
GetProp		PROTO		@proto_477

@proto_478		TYPEDEF		PROTO FAR PASCAL :HWND, :LPCSTR
RemoveProp		PROTO		@proto_478

PROPENUMPROC		TYPEDEF		FARPROC

@proto_479		TYPEDEF		PROTO FAR PASCAL :HWND, :PROPENUMPROC
EnumProps		PROTO		@proto_479

@proto_480		TYPEDEF		PROTO FAR PASCAL :HWND
GetDC		PROTO		@proto_480

@proto_481		TYPEDEF		PROTO FAR PASCAL :HWND, :HDC
ReleaseDC		PROTO		@proto_481

@proto_482		TYPEDEF		PROTO FAR PASCAL :HWND
GetWindowDC		PROTO		@proto_482

@proto_483		TYPEDEF		PROTO FAR PASCAL :HWND, :HRGN, :DWORD
GetDCEx		PROTO		@proto_483

DCX_WINDOW		EQU		000000001h
DCX_CACHE		EQU		000000002h
DCX_CLIPCHILDREN		EQU		000000008h
DCX_CLIPSIBLINGS		EQU		000000010h
DCX_PARENTCLIP		EQU		000000020h
DCX_EXCLUDERGN		EQU		000000040h
DCX_INTERSECTRGN		EQU		000000080h
DCX_LOCKWINDOWUPDATE		EQU		000000400h
DCX_USESTYLE		EQU		000010000h
WM_PAINT		EQU		00000000fh
WM_ERASEBKGND		EQU		000000014h
WM_ICONERASEBKGND		EQU		000000027h
tagPAINTSTRUCT		STRUCT 1t
hdc		HDC		?
fErase		BOOL		?
rcPaint		RECT		<>
fRestore		BOOL		?
fIncUpdate		BOOL		?
rgbReserved		BYTE		16t DUP (?)
tagPAINTSTRUCT		ENDS

PAINTSTRUCT		TYPEDEF		tagPAINTSTRUCT

PPAINTSTRUCT		TYPEDEF		PTR PAINTSTRUCT

NPPAINTSTRUCT		TYPEDEF		NEAR PTR PAINTSTRUCT

LPPAINTSTRUCT		TYPEDEF		FAR PTR PAINTSTRUCT

@proto_484		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR PAINTSTRUCT
BeginPaint		PROTO		@proto_484

@proto_485		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR tagPAINTSTRUCT
EndPaint		PROTO		@proto_485

@proto_486		TYPEDEF		PROTO FAR PASCAL :HWND
UpdateWindow		PROTO		@proto_486

@proto_487		TYPEDEF		PROTO FAR PASCAL :HDC, :HWND
ExcludeUpdateRgn		PROTO		@proto_487

@proto_488		TYPEDEF		PROTO FAR PASCAL :HWND
LockWindowUpdate		PROTO		@proto_488

@proto_489		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR RECT, :BOOL
GetUpdateRect		PROTO		@proto_489

@proto_490		TYPEDEF		PROTO FAR PASCAL :HWND, :HRGN, :BOOL
GetUpdateRgn		PROTO		@proto_490

@proto_491		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR tagRECT, :BOOL
InvalidateRect		PROTO		@proto_491

@proto_492		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR tagRECT
ValidateRect		PROTO		@proto_492

@proto_493		TYPEDEF		PROTO FAR PASCAL :HWND, :HRGN, :BOOL
InvalidateRgn		PROTO		@proto_493

@proto_494		TYPEDEF		PROTO FAR PASCAL :HWND, :HRGN
ValidateRgn		PROTO		@proto_494

@proto_495		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR tagRECT, :HRGN, :UINT
RedrawWindow		PROTO		@proto_495

RDW_INVALIDATE		EQU		000000001h
RDW_INTERNALPAINT		EQU		000000002h
RDW_ERASE		EQU		000000004h
RDW_VALIDATE		EQU		000000008h
RDW_NOINTERNALPAINT		EQU		000000010h
RDW_NOERASE		EQU		000000020h
RDW_NOCHILDREN		EQU		000000040h
RDW_ALLCHILDREN		EQU		000000080h
RDW_UPDATENOW		EQU		000000100h
RDW_ERASENOW		EQU		000000200h
RDW_FRAME		EQU		000000400h
RDW_NOFRAME		EQU		000000800h
@proto_496		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :SWORD, :FAR PTR tagRECT, :FAR PTR tagRECT
ScrollWindow		PROTO		@proto_496

@proto_497		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :FAR PTR tagRECT, :FAR PTR tagRECT, :HRGN, :FAR PTR RECT
ScrollDC		PROTO		@proto_497

@proto_498		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :SWORD, :FAR PTR tagRECT, :FAR PTR tagRECT, :HRGN, :FAR PTR RECT, :UINT
ScrollWindowEx		PROTO		@proto_498

SW_SCROLLCHILDREN		EQU		000000001h
SW_INVALIDATE		EQU		000000002h
SW_ERASE		EQU		000000004h
WM_NCPAINT		EQU		000000085h
WM_NCCALCSIZE		EQU		000000083h
WVR_ALIGNTOP		EQU		000000010h
WVR_ALIGNLEFT		EQU		000000020h
WVR_ALIGNBOTTOM		EQU		000000040h
WVR_ALIGNRIGHT		EQU		000000080h
WVR_HREDRAW		EQU		000000100h
WVR_VREDRAW		EQU		000000200h
WVR_REDRAW		EQU		000000300h
WVR_VALIDRECTS		EQU		000000400h
@t_2		TYPEDEF		FAR PTR WINDOWPOS
tagNCCALCSIZE_PARAMS		STRUCT 1t
rgrc		RECT		3t DUP (<>)
lppos		@t_2		?
tagNCCALCSIZE_PARAMS		ENDS

NCCALCSIZE_PARAMS		TYPEDEF		tagNCCALCSIZE_PARAMS

LPNCCALCSIZE_PARAMS		TYPEDEF		FAR PTR NCCALCSIZE_PARAMS

WM_NCHITTEST		EQU		000000084h
HTERROR		EQU		-2t
HTTRANSPARENT		EQU		-1t
HTNOWHERE		EQU		0t
HTCLIENT		EQU		1t
HTCAPTION		EQU		2t
HTSYSMENU		EQU		3t
HTSIZE		EQU		4t
HTMENU		EQU		5t
HTHSCROLL		EQU		6t
HTVSCROLL		EQU		7t
HTMINBUTTON		EQU		8t
HTMAXBUTTON		EQU		9t
HTLEFT		EQU		10t
HTRIGHT		EQU		11t
HTTOP		EQU		12t
HTTOPLEFT		EQU		13t
HTTOPRIGHT		EQU		14t
HTBOTTOM		EQU		15t
HTBOTTOMLEFT		EQU		16t
HTBOTTOMRIGHT		EQU		17t
HTBORDER		EQU		18t
HTGROWBOX		EQU		000000004h
HTREDUCE		EQU		000000008h
HTZOOM		EQU		000000009h
WM_QUERYDRAGICON		EQU		000000037h
WM_DROPFILES		EQU		000000233h
@proto_499		TYPEDEF		PROTO FAR PASCAL :HWND
SetActiveWindow		PROTO		@proto_499

@proto_500		TYPEDEF		PROTO FAR PASCAL 
GetActiveWindow		PROTO		@proto_500

@proto_501		TYPEDEF		PROTO FAR PASCAL :HWND
GetLastActivePopup		PROTO		@proto_501

WA_INACTIVE		EQU		0t
WA_ACTIVE		EQU		1t
WA_CLICKACTIVE		EQU		2t
WM_ACTIVATE		EQU		000000006h
WM_ACTIVATEAPP		EQU		00000001ch
WM_NCACTIVATE		EQU		000000086h
@proto_502		TYPEDEF		PROTO FAR PASCAL :HWND
SetFocus		PROTO		@proto_502

@proto_503		TYPEDEF		PROTO FAR PASCAL 
GetFocus		PROTO		@proto_503

@proto_504		TYPEDEF		PROTO FAR PASCAL :SWORD
GetKeyState		PROTO		@proto_504

@proto_505		TYPEDEF		PROTO FAR PASCAL :SWORD
GetAsyncKeyState		PROTO		@proto_505

@proto_506		TYPEDEF		PROTO FAR PASCAL :FAR PTR BYTE
GetKeyboardState		PROTO		@proto_506

@proto_507		TYPEDEF		PROTO FAR PASCAL :FAR PTR BYTE
SetKeyboardState		PROTO		@proto_507

WM_SETFOCUS		EQU		000000007h
WM_KILLFOCUS		EQU		000000008h
WM_KEYDOWN		EQU		000000100h
WM_KEYUP		EQU		000000101h
WM_CHAR		EQU		000000102h
WM_DEADCHAR		EQU		000000103h
WM_SYSKEYDOWN		EQU		000000104h
WM_SYSKEYUP		EQU		000000105h
WM_SYSCHAR		EQU		000000106h
WM_SYSDEADCHAR		EQU		000000107h
WM_KEYFIRST		EQU		000000100h
WM_KEYLAST		EQU		000000108h
KF_EXTENDED		EQU		000000100h
KF_DLGMODE		EQU		000000800h
KF_MENUMODE		EQU		000001000h
KF_ALTDOWN		EQU		000002000h
KF_REPEAT		EQU		000004000h
KF_UP		EQU		000008000h
VK_LBUTTON		EQU		000000001h
VK_RBUTTON		EQU		000000002h
VK_CANCEL		EQU		000000003h
VK_MBUTTON		EQU		000000004h
VK_BACK		EQU		000000008h
VK_TAB		EQU		000000009h
VK_CLEAR		EQU		00000000ch
VK_RETURN		EQU		00000000dh
VK_SHIFT		EQU		000000010h
VK_CONTROL		EQU		000000011h
VK_MENU		EQU		000000012h
VK_PAUSE		EQU		000000013h
VK_CAPITAL		EQU		000000014h
VK_ESCAPE		EQU		00000001bh
VK_SPACE		EQU		000000020h
VK_PRIOR		EQU		000000021h
VK_NEXT		EQU		000000022h
VK_END		EQU		000000023h
VK_HOME		EQU		000000024h
VK_LEFT		EQU		000000025h
VK_UP		EQU		000000026h
VK_RIGHT		EQU		000000027h
VK_DOWN		EQU		000000028h
VK_SELECT		EQU		000000029h
VK_PRINT		EQU		00000002ah
VK_EXECUTE		EQU		00000002bh
VK_SNAPSHOT		EQU		00000002ch
VK_INSERT		EQU		00000002dh
VK_DELETE		EQU		00000002eh
VK_HELP		EQU		00000002fh
VK_NUMPAD0		EQU		000000060h
VK_NUMPAD1		EQU		000000061h
VK_NUMPAD2		EQU		000000062h
VK_NUMPAD3		EQU		000000063h
VK_NUMPAD4		EQU		000000064h
VK_NUMPAD5		EQU		000000065h
VK_NUMPAD6		EQU		000000066h
VK_NUMPAD7		EQU		000000067h
VK_NUMPAD8		EQU		000000068h
VK_NUMPAD9		EQU		000000069h
VK_MULTIPLY		EQU		00000006ah
VK_ADD		EQU		00000006bh
VK_SEPARATOR		EQU		00000006ch
VK_SUBTRACT		EQU		00000006dh
VK_DECIMAL		EQU		00000006eh
VK_DIVIDE		EQU		00000006fh
VK_F1		EQU		000000070h
VK_F2		EQU		000000071h
VK_F3		EQU		000000072h
VK_F4		EQU		000000073h
VK_F5		EQU		000000074h
VK_F6		EQU		000000075h
VK_F7		EQU		000000076h
VK_F8		EQU		000000077h
VK_F9		EQU		000000078h
VK_F10		EQU		000000079h
VK_F11		EQU		00000007ah
VK_F12		EQU		00000007bh
VK_F13		EQU		00000007ch
VK_F14		EQU		00000007dh
VK_F15		EQU		00000007eh
VK_F16		EQU		00000007fh
VK_F17		EQU		000000080h
VK_F18		EQU		000000081h
VK_F19		EQU		000000082h
VK_F20		EQU		000000083h
VK_F21		EQU		000000084h
VK_F22		EQU		000000085h
VK_F23		EQU		000000086h
VK_F24		EQU		000000087h
VK_NUMLOCK		EQU		000000090h
VK_SCROLL		EQU		000000091h
WH_KEYBOARD		EQU		2t
@proto_508		TYPEDEF		PROTO FAR PASCAL :HWND
SetCapture		PROTO		@proto_508

@proto_509		TYPEDEF		PROTO FAR PASCAL 
ReleaseCapture		PROTO		@proto_509

@proto_510		TYPEDEF		PROTO FAR PASCAL 
GetCapture		PROTO		@proto_510

@proto_511		TYPEDEF		PROTO FAR PASCAL :BOOL
SwapMouseButton		PROTO		@proto_511

WM_MOUSEMOVE		EQU		000000200h
WM_LBUTTONDOWN		EQU		000000201h
WM_LBUTTONUP		EQU		000000202h
WM_LBUTTONDBLCLK		EQU		000000203h
WM_RBUTTONDOWN		EQU		000000204h
WM_RBUTTONUP		EQU		000000205h
WM_RBUTTONDBLCLK		EQU		000000206h
WM_MBUTTONDOWN		EQU		000000207h
WM_MBUTTONUP		EQU		000000208h
WM_MBUTTONDBLCLK		EQU		000000209h
WM_MOUSEFIRST		EQU		000000200h
WM_MOUSELAST		EQU		000000209h
MK_LBUTTON		EQU		000000001h
MK_RBUTTON		EQU		000000002h
MK_SHIFT		EQU		000000004h
MK_CONTROL		EQU		000000008h
MK_MBUTTON		EQU		000000010h
WM_NCMOUSEMOVE		EQU		0000000a0h
WM_NCLBUTTONDOWN		EQU		0000000a1h
WM_NCLBUTTONUP		EQU		0000000a2h
WM_NCLBUTTONDBLCLK		EQU		0000000a3h
WM_NCRBUTTONDOWN		EQU		0000000a4h
WM_NCRBUTTONUP		EQU		0000000a5h
WM_NCRBUTTONDBLCLK		EQU		0000000a6h
WM_NCMBUTTONDOWN		EQU		0000000a7h
WM_NCMBUTTONUP		EQU		0000000a8h
WM_NCMBUTTONDBLCLK		EQU		0000000a9h
WM_MOUSEACTIVATE		EQU		000000021h
MA_ACTIVATE		EQU		1t
MA_ACTIVATEANDEAT		EQU		2t
MA_NOACTIVATE		EQU		3t
MA_NOACTIVATEANDEAT		EQU		4t
WH_MOUSE		EQU		7t
tagMOUSEHOOKSTRUCT		STRUCT 1t
pt		POINT		<>
hwnd		HWND		?
wHitTestCode		UINT		?
dwExtraInfo		DWORD		?
tagMOUSEHOOKSTRUCT		ENDS

MOUSEHOOKSTRUCT		TYPEDEF		tagMOUSEHOOKSTRUCT

LPMOUSEHOOKSTRUCT		TYPEDEF		FAR PTR MOUSEHOOKSTRUCT

WM_CANCELMODE		EQU		00000001fh
@proto_512		TYPEDEF		PROTO FAR PASCAL 
GetSysModalWindow		PROTO		@proto_512

@proto_513		TYPEDEF		PROTO FAR PASCAL :HWND
SetSysModalWindow		PROTO		@proto_513

TIMERPROC		TYPEDEF		FARPROC

@proto_514		TYPEDEF		PROTO FAR PASCAL :HWND, :UINT, :UINT, :TIMERPROC
SetTimer		PROTO		@proto_514

@proto_515		TYPEDEF		PROTO FAR PASCAL :HWND, :UINT
KillTimer		PROTO		@proto_515

WM_TIMER		EQU		000000113h
HACCEL		TYPEDEF		UINT

@proto_516		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :LPCSTR
LoadAccelerators		PROTO		@proto_516

@proto_517		TYPEDEF		PROTO FAR PASCAL :HWND, :HACCEL, :FAR PTR MSG
TranslateAccelerator		PROTO		@proto_517

@tag_1		STRUCT 1t
versionNumber		UINT		?
_offset		UINT		?
@tag_1		ENDS


ifndef NOMENUS ; MENU FUNCTIONS

MENUITEMTEMPLATEHEADER		TYPEDEF		@tag_1

@tag_2		STRUCT 1t
mtOption		UINT		?
mtID		UINT		?
mtString		SBYTE		1t DUP (?)
@tag_2		ENDS

MENUITEMTEMPLATE		TYPEDEF		@tag_2

@proto_518		TYPEDEF		PROTO FAR PASCAL :HMENU
IsMenu		PROTO		@proto_518

@proto_519		TYPEDEF		PROTO FAR PASCAL 
CreateMenu		PROTO		@proto_519

@proto_520		TYPEDEF		PROTO FAR PASCAL 
CreatePopupMenu		PROTO		@proto_520

@proto_521		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :LPCSTR
LoadMenu		PROTO		@proto_521

@proto_522		TYPEDEF		PROTO FAR PASCAL :FAR PTR 
LoadMenuIndirect		PROTO		@proto_522

@proto_523		TYPEDEF		PROTO FAR PASCAL :HMENU
DestroyMenu		PROTO		@proto_523

@proto_524		TYPEDEF		PROTO FAR PASCAL :HWND
GetMenu		PROTO		@proto_524

@proto_525		TYPEDEF		PROTO FAR PASCAL :HWND, :HMENU
SetMenu		PROTO		@proto_525

@proto_526		TYPEDEF		PROTO FAR PASCAL :HWND, :BOOL
GetSystemMenu		PROTO		@proto_526

@proto_527		TYPEDEF		PROTO FAR PASCAL :HWND
DrawMenuBar		PROTO		@proto_527

@proto_528		TYPEDEF		PROTO FAR PASCAL :HWND, :HMENU, :UINT, :UINT
HiliteMenuItem		PROTO		@proto_528

@proto_529		TYPEDEF		PROTO FAR PASCAL :HMENU, :UINT, :UINT, :UINT, :LPCSTR
InsertMenu		PROTO		@proto_529

@proto_530		TYPEDEF		PROTO FAR PASCAL :HMENU, :UINT, :UINT, :LPCSTR
AppendMenu		PROTO		@proto_530

@proto_531		TYPEDEF		PROTO FAR PASCAL :HMENU, :UINT, :UINT, :UINT, :LPCSTR
ModifyMenu		PROTO		@proto_531

@proto_532		TYPEDEF		PROTO FAR PASCAL :HMENU, :UINT, :UINT
RemoveMenu		PROTO		@proto_532

@proto_533		TYPEDEF		PROTO FAR PASCAL :HMENU, :UINT, :UINT
DeleteMenu		PROTO		@proto_533

@proto_534		TYPEDEF		PROTO FAR PASCAL :HMENU, :UINT, :LPCSTR, :UINT, :UINT
ChangeMenu		PROTO		@proto_534

MF_INSERT		EQU		000000000h
MF_CHANGE		EQU		000000080h
MF_APPEND		EQU		000000100h
MF_DELETE		EQU		000000200h
MF_REMOVE		EQU		000001000h
MF_BYCOMMAND		EQU		000000000h
MF_BYPOSITION		EQU		000000400h
MF_SEPARATOR		EQU		000000800h
MF_ENABLED		EQU		000000000h
MF_GRAYED		EQU		000000001h
MF_DISABLED		EQU		000000002h
MF_UNCHECKED		EQU		000000000h
MF_CHECKED		EQU		000000008h
MF_USECHECKBITMAPS		EQU		000000200h
MF_STRING		EQU		000000000h
MF_BITMAP		EQU		000000004h
MF_OWNERDRAW		EQU		000000100h
MF_POPUP		EQU		000000010h
MF_MENUBARBREAK		EQU		000000020h
MF_MENUBREAK		EQU		000000040h
MF_UNHILITE		EQU		000000000h
MF_HILITE		EQU		000000080h
MF_SYSMENU		EQU		000002000h
MF_HELP		EQU		000004000h
MF_MOUSESELECT		EQU		000008000h
MF_END		EQU		000000080h
@proto_535		TYPEDEF		PROTO FAR PASCAL :HMENU, :UINT, :UINT
EnableMenuItem		PROTO		@proto_535

@proto_536		TYPEDEF		PROTO FAR PASCAL :HMENU, :UINT, :UINT
CheckMenuItem		PROTO		@proto_536

@proto_537		TYPEDEF		PROTO FAR PASCAL :HMENU, :SWORD
GetSubMenu		PROTO		@proto_537

@proto_538		TYPEDEF		PROTO FAR PASCAL :HMENU
GetMenuItemCount		PROTO		@proto_538

@proto_539		TYPEDEF		PROTO FAR PASCAL :HMENU, :SWORD
GetMenuItemID		PROTO		@proto_539

@proto_540		TYPEDEF		PROTO FAR PASCAL :HMENU, :UINT, :LPSTR, :SWORD, :UINT
GetMenuString		PROTO		@proto_540

@proto_541		TYPEDEF		PROTO FAR PASCAL :HMENU, :UINT, :UINT
GetMenuState		PROTO		@proto_541

@proto_542		TYPEDEF		PROTO FAR PASCAL :HMENU, :UINT, :UINT, :HBITMAP, :HBITMAP
SetMenuItemBitmaps		PROTO		@proto_542

@proto_543		TYPEDEF		PROTO FAR PASCAL 
GetMenuCheckMarkDimensions		PROTO		@proto_543

@proto_544		TYPEDEF		PROTO FAR PASCAL :HMENU, :UINT, :SWORD, :SWORD, :SWORD, :HWND, :FAR PTR tagRECT
TrackPopupMenu		PROTO		@proto_544

TPM_LEFTBUTTON		EQU		000000000h
TPM_RIGHTBUTTON		EQU		000000002h
TPM_LEFTALIGN		EQU		000000000h
TPM_CENTERALIGN		EQU		000000004h
TPM_RIGHTALIGN		EQU		000000008h

WM_MENUSELECT		EQU		00000011fh
WM_MENUCHAR		EQU		000000120h

endif 	; of ifndef NOMENUS

WM_INITMENU		EQU		000000116h
WM_INITMENUPOPUP		EQU		000000117h

WM_COMMAND		EQU		000000111h

ifndef NOSCROLL	; SCROLL FUNCTION

WM_HSCROLL		EQU		000000114h
WM_VSCROLL		EQU		000000115h
SB_LINEUP		EQU		0t
SB_LINELEFT		EQU		0t
SB_LINEDOWN		EQU		1t
SB_LINERIGHT		EQU		1t
SB_PAGEUP		EQU		2t
SB_PAGELEFT		EQU		2t
SB_PAGEDOWN		EQU		3t
SB_PAGERIGHT		EQU		3t
SB_THUMBPOSITION		EQU		4t
SB_THUMBTRACK		EQU		5t
SB_TOP		EQU		6t
SB_LEFT		EQU		6t
SB_BOTTOM		EQU		7t
SB_RIGHT		EQU		7t
SB_ENDSCROLL		EQU		8t
SB_HORZ		EQU		0t
SB_VERT		EQU		1t
SB_CTL		EQU		2t
SB_BOTH		EQU		3t
@proto_545		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :SWORD, :BOOL
SetScrollPos		PROTO		@proto_545

@proto_546		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD
GetScrollPos		PROTO		@proto_546

@proto_547		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :SWORD, :SWORD, :BOOL
SetScrollRange		PROTO		@proto_547

@proto_548		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :FAR PTR SWORD, :FAR PTR SWORD
GetScrollRange		PROTO		@proto_548

@proto_549		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :BOOL
ShowScrollBar		PROTO		@proto_549

@proto_550		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :UINT
EnableScrollBar		PROTO		@proto_550

ESB_ENABLE_BOTH		EQU		000000000h
ESB_DISABLE_BOTH		EQU		000000003h
ESB_DISABLE_LEFT		EQU		000000001h
ESB_DISABLE_RIGHT		EQU		000000002h
ESB_DISABLE_UP		EQU		000000001h
ESB_DISABLE_DOWN		EQU		000000002h
ESB_DISABLE_LTUP		EQU		000000001h
ESB_DISABLE_RTDN		EQU		000000002h

endif	; of ifndef NOSCROLL

ifndef NOCLIPBOARD

CF_TEXT		EQU		1t
CF_BITMAP		EQU		2t
CF_METAFILEPICT		EQU		3t
CF_SYLK		EQU		4t
CF_DIF		EQU		5t
CF_TIFF		EQU		6t
CF_OEMTEXT		EQU		7t
CF_DIB		EQU		8t
CF_PALETTE		EQU		9t
CF_PENDATA		EQU		10t
CF_RIFF		EQU		11t
CF_WAVE		EQU		12t
CF_OWNERDISPLAY		EQU		000000080h
CF_DSPTEXT		EQU		000000081h
CF_DSPBITMAP		EQU		000000082h
CF_DSPMETAFILEPICT		EQU		000000083h
CF_PRIVATEFIRST		EQU		000000200h
CF_PRIVATELAST		EQU		0000002ffh
CF_GDIOBJFIRST		EQU		000000300h
CF_GDIOBJLAST		EQU		0000003ffh
@proto_551		TYPEDEF		PROTO FAR PASCAL :HWND
OpenClipboard		PROTO		@proto_551

@proto_552		TYPEDEF		PROTO FAR PASCAL 
CloseClipboard		PROTO		@proto_552

@proto_553		TYPEDEF		PROTO FAR PASCAL 
EmptyClipboard		PROTO		@proto_553

@proto_554		TYPEDEF		PROTO FAR PASCAL 
GetOpenClipboardWindow		PROTO		@proto_554

@proto_555		TYPEDEF		PROTO FAR PASCAL 
GetClipboardOwner		PROTO		@proto_555

@proto_556		TYPEDEF		PROTO FAR PASCAL :HWND
SetClipboardViewer		PROTO		@proto_556

@proto_557		TYPEDEF		PROTO FAR PASCAL 
GetClipboardViewer		PROTO		@proto_557

@proto_558		TYPEDEF		PROTO FAR PASCAL :UINT, :HANDLE
SetClipboardData		PROTO		@proto_558

@proto_559		TYPEDEF		PROTO FAR PASCAL :UINT
GetClipboardData		PROTO		@proto_559

@proto_560		TYPEDEF		PROTO FAR PASCAL :UINT
IsClipboardFormatAvailable		PROTO		@proto_560

@proto_561		TYPEDEF		PROTO FAR PASCAL :FAR PTR UINT, :SWORD
GetPriorityClipboardFormat		PROTO		@proto_561

@proto_562		TYPEDEF		PROTO FAR PASCAL :LPCSTR
RegisterClipboardFormat		PROTO		@proto_562

@proto_563		TYPEDEF		PROTO FAR PASCAL 
CountClipboardFormats		PROTO		@proto_563

@proto_564		TYPEDEF		PROTO FAR PASCAL :UINT
EnumClipboardFormats		PROTO		@proto_564

@proto_565		TYPEDEF		PROTO FAR PASCAL :UINT, :LPSTR, :SWORD
GetClipboardFormatName		PROTO		@proto_565

@proto_566		TYPEDEF		PROTO FAR PASCAL :HWND, :HWND
ChangeClipboardChain		PROTO		@proto_566

WM_CUT		EQU		000000300h
WM_COPY		EQU		000000301h
WM_PASTE		EQU		000000302h
WM_CLEAR		EQU		000000303h
WM_UNDO		EQU		000000304h
WM_RENDERFORMAT		EQU		000000305h
WM_RENDERALLFORMATS		EQU		000000306h
WM_DESTROYCLIPBOARD		EQU		000000307h
WM_DRAWCLIPBOARD		EQU		000000308h
WM_PAINTCLIPBOARD		EQU		000000309h
WM_SIZECLIPBOARD		EQU		00000030bh
WM_VSCROLLCLIPBOARD		EQU		00000030ah
WM_HSCROLLCLIPBOARD		EQU		00000030eh
WM_ASKCBFORMATNAME		EQU		00000030ch
WM_CHANGECBCHAIN		EQU		00000030dh

endif 	; of ifndef NOCLIPBOARD

@proto_567		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :LPCSTR
LoadCursor		PROTO		@proto_567

@proto_568		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :SWORD, :SWORD, :SWORD, :SWORD, :FAR PTR , :FAR PTR 
CreateCursor		PROTO		@proto_568

@proto_569		TYPEDEF		PROTO FAR PASCAL :HCURSOR
DestroyCursor		PROTO		@proto_569

@proto_570		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :HCURSOR
CopyCursor		PROTO		@proto_570

@proto_571		TYPEDEF		PROTO FAR PASCAL :BOOL
ShowCursor		PROTO		@proto_571

@proto_572		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD
SetCursorPos		PROTO		@proto_572

@proto_573		TYPEDEF		PROTO FAR PASCAL :FAR PTR POINT
GetCursorPos		PROTO		@proto_573

@proto_574		TYPEDEF		PROTO FAR PASCAL :HCURSOR
SetCursor		PROTO		@proto_574

@proto_575		TYPEDEF		PROTO FAR PASCAL 
GetCursor		PROTO		@proto_575

@proto_576		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagRECT
ClipCursor		PROTO		@proto_576

@proto_577		TYPEDEF		PROTO FAR PASCAL :FAR PTR RECT
GetClipCursor		PROTO		@proto_577

IDC_ARROW		EQU		000007f00h
IDC_IBEAM		EQU		000007f01h
IDC_WAIT		EQU		000007f02h
IDC_CROSS		EQU		000007f03h
IDC_UPARROW		EQU		000007f04h
IDC_SIZE		EQU		000007f80h
IDC_ICON		EQU		000007f81h
IDC_SIZENWSE		EQU		000007f82h
IDC_SIZENESW		EQU		000007f83h
IDC_SIZEWE		EQU		000007f84h
IDC_SIZENS		EQU		000007f85h
WM_SETCURSOR		EQU		000000020h
@proto_578		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :LPCSTR
LoadIcon		PROTO		@proto_578

@proto_579		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :SWORD, :SWORD, :BYTE, :BYTE, :FAR PTR , :FAR PTR 
CreateIcon		PROTO		@proto_579

@proto_580		TYPEDEF		PROTO FAR PASCAL :HICON
DestroyIcon		PROTO		@proto_580

@proto_581		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :HICON
CopyIcon		PROTO		@proto_581

@proto_582		TYPEDEF		PROTO FAR PASCAL :HDC, :SWORD, :SWORD, :HICON
DrawIcon		PROTO		@proto_582

IDI_APPLICATION		EQU		000007f00h
IDI_HAND		EQU		000007f01h
IDI_QUESTION		EQU		000007f02h
IDI_EXCLAMATION		EQU		000007f03h
IDI_ASTERISK		EQU		000007f04h
@proto_583		TYPEDEF		PROTO FAR PASCAL :HWND, :LPCSTR, :LPCSTR, :UINT
MessageBox		PROTO		@proto_583

@proto_584		TYPEDEF		PROTO FAR PASCAL :UINT
MessageBeep		PROTO		@proto_584

MB_OK		EQU		000000000h
MB_OKCANCEL		EQU		000000001h
MB_ABORTRETRYIGNORE		EQU		000000002h
MB_YESNOCANCEL		EQU		000000003h
MB_YESNO		EQU		000000004h
MB_RETRYCANCEL		EQU		000000005h
MB_TYPEMASK		EQU		00000000fh
MB_ICONHAND		EQU		000000010h
MB_ICONQUESTION		EQU		000000020h
MB_ICONEXCLAMATION		EQU		000000030h
MB_ICONASTERISK		EQU		000000040h
MB_ICONMASK		EQU		0000000f0h
MB_ICONINFORMATION		EQU		000000040h
MB_ICONSTOP		EQU		000000010h
MB_DEFBUTTON1		EQU		000000000h
MB_DEFBUTTON2		EQU		000000100h
MB_DEFBUTTON3		EQU		000000200h
MB_DEFMASK		EQU		000000f00h
MB_APPLMODAL		EQU		000000000h
MB_SYSTEMMODAL		EQU		000001000h
MB_TASKMODAL		EQU		000002000h
MB_NOFOCUS		EQU		000008000h
@proto_585		TYPEDEF		PROTO FAR PASCAL :HWND, :HBITMAP, :SWORD, :SWORD
CreateCaret		PROTO		@proto_585

@proto_586		TYPEDEF		PROTO FAR PASCAL 
DestroyCaret		PROTO		@proto_586

@proto_587		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD
SetCaretPos		PROTO		@proto_587

@proto_588		TYPEDEF		PROTO FAR PASCAL :FAR PTR POINT
GetCaretPos		PROTO		@proto_588

@proto_589		TYPEDEF		PROTO FAR PASCAL :HWND
HideCaret		PROTO		@proto_589

@proto_590		TYPEDEF		PROTO FAR PASCAL :HWND
ShowCaret		PROTO		@proto_590

@proto_591		TYPEDEF		PROTO FAR PASCAL 
GetCaretBlinkTime		PROTO		@proto_591

@proto_592		TYPEDEF		PROTO FAR PASCAL :UINT
SetCaretBlinkTime		PROTO		@proto_592

WM_SYSCOMMAND		EQU		000000112h
SC_SIZE		EQU		00000f000h
SC_MOVE		EQU		00000f010h
SC_MINIMIZE		EQU		00000f020h
SC_MAXIMIZE		EQU		00000f030h
SC_NEXTWINDOW		EQU		00000f040h
SC_PREVWINDOW		EQU		00000f050h
SC_CLOSE		EQU		00000f060h
SC_VSCROLL		EQU		00000f070h
SC_HSCROLL		EQU		00000f080h
SC_MOUSEMENU		EQU		00000f090h
SC_KEYMENU		EQU		00000f100h
SC_ARRANGE		EQU		00000f110h
SC_RESTORE		EQU		00000f120h
SC_TASKLIST		EQU		00000f130h
SC_SCREENSAVE		EQU		00000f140h
SC_HOTKEY		EQU		00000f150h
SC_ICON		EQU		00000f020h
SC_ZOOM		EQU		00000f030h
tagCLIENTCREATESTRUCT		STRUCT 1t
hWindowMenu		HMENU		?
idFirstChild		UINT		?
tagCLIENTCREATESTRUCT		ENDS

CLIENTCREATESTRUCT		TYPEDEF		tagCLIENTCREATESTRUCT

LPCLIENTCREATESTRUCT		TYPEDEF		FAR PTR CLIENTCREATESTRUCT

MDIS_ALLCHILDSTYLES		EQU		000000001h
WM_MDICREATE		EQU		000000220h
WM_MDIDESTROY		EQU		000000221h
WM_MDIACTIVATE		EQU		000000222h
WM_MDIRESTORE		EQU		000000223h
WM_MDINEXT		EQU		000000224h
WM_MDIMAXIMIZE		EQU		000000225h
WM_MDITILE		EQU		000000226h
WM_MDICASCADE		EQU		000000227h
WM_MDIICONARRANGE		EQU		000000228h
WM_MDIGETACTIVE		EQU		000000229h
WM_MDISETMENU		EQU		000000230h
tagMDICREATESTRUCT		STRUCT 1t
szClass		LPCSTR		?
szTitle		LPCSTR		?
hOwner		HINSTANCE		?
x		SWORD		?
y		SWORD		?
_cx		SWORD		?
cy		SWORD		?
style		DWORD		?
lParam		LPARAM		?
tagMDICREATESTRUCT		ENDS

MDICREATESTRUCT		TYPEDEF		tagMDICREATESTRUCT

LPMDICREATESTRUCT		TYPEDEF		FAR PTR MDICREATESTRUCT

MDITILE_VERTICAL		EQU		000000000h
MDITILE_HORIZONTAL		EQU		000000001h
MDITILE_SKIPDISABLED		EQU		000000002h
WM_CHILDACTIVATE		EQU		000000022h
@proto_593		TYPEDEF		PROTO FAR PASCAL :HWND, :HWND, :UINT, :WPARAM, :LPARAM
DefFrameProc		PROTO		@proto_593

@proto_594		TYPEDEF		PROTO FAR PASCAL :HWND, :UINT, :WPARAM, :LPARAM
DefMDIChildProc		PROTO		@proto_594

@proto_595		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR MSG
TranslateMDISysAccel		PROTO		@proto_595

@proto_596		TYPEDEF		PROTO FAR PASCAL :HWND
ArrangeIconicWindows		PROTO		@proto_596

WC_DIALOG		EQU		000008002h
DLGWINDOWEXTRA		EQU		30t
DS_ABSALIGN		EQU		000000001h
DS_SYSMODAL		EQU		000000002h
DS_LOCALEDIT		EQU		000000020h
DS_SETFONT		EQU		000000040h
DS_MODALFRAME		EQU		000000080h
DS_NOIDLEMSG		EQU		000000100h
DM_GETDEFID		EQU		000000400h
DM_SETDEFID		EQU		000000401h
DC_HASDEFID		EQU		00000534bh
WM_INITDIALOG		EQU		000000110h
WM_NEXTDLGCTL		EQU		000000028h
WM_PARENTNOTIFY		EQU		000000210h
WM_ENTERIDLE		EQU		000000121h
DLGPROC		TYPEDEF		FARPROC

DWL_MSGRESULT		EQU		0t
DWL_DLGPROC		EQU		4t
DWL_USER		EQU		8t
@proto_597		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR MSG
IsDialogMessage		PROTO		@proto_597

@proto_598		TYPEDEF		PROTO FAR PASCAL :HWND, :UINT, :WPARAM, :LPARAM
DefDlgProc		PROTO		@proto_598

@proto_599		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :LPCSTR, :HWND, :DLGPROC
CreateDialog		PROTO		@proto_599

@proto_600		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :FAR PTR , :HWND, :DLGPROC
CreateDialogIndirect		PROTO		@proto_600

@proto_601		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :LPCSTR, :HWND, :DLGPROC, :LPARAM
CreateDialogParam		PROTO		@proto_601

@proto_602		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :FAR PTR , :HWND, :DLGPROC, :LPARAM
CreateDialogIndirectParam		PROTO		@proto_602

@proto_603		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :LPCSTR, :HWND, :DLGPROC
DialogBox		PROTO		@proto_603

@proto_604		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :HGLOBAL, :HWND, :DLGPROC
DialogBoxIndirect		PROTO		@proto_604

@proto_605		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :LPCSTR, :HWND, :DLGPROC, :LPARAM
DialogBoxParam		PROTO		@proto_605

@proto_606		TYPEDEF		PROTO FAR PASCAL :HINSTANCE, :HGLOBAL, :HWND, :DLGPROC, :LPARAM
DialogBoxIndirectParam		PROTO		@proto_606

@proto_607		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD
EndDialog		PROTO		@proto_607

@proto_608		TYPEDEF		PROTO FAR PASCAL :HWND
GetDlgCtrlID		PROTO		@proto_608

@proto_609		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD
GetDlgItem		PROTO		@proto_609

@proto_610		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :UINT, :WPARAM, :LPARAM
SendDlgItemMessage		PROTO		@proto_610

@proto_611		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :UINT, :BOOL
SetDlgItemInt		PROTO		@proto_611

@proto_612		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :FAR PTR BOOL, :BOOL
GetDlgItemInt		PROTO		@proto_612

@proto_613		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :LPCSTR
SetDlgItemText		PROTO		@proto_613

@proto_614		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :LPSTR, :SWORD
GetDlgItemText		PROTO		@proto_614

@proto_615		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :UINT
CheckDlgButton		PROTO		@proto_615

@proto_616		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD, :SWORD, :SWORD
CheckRadioButton		PROTO		@proto_616

@proto_617		TYPEDEF		PROTO FAR PASCAL :HWND, :SWORD
IsDlgButtonChecked		PROTO		@proto_617

@proto_618		TYPEDEF		PROTO FAR PASCAL :HWND, :HWND, :BOOL
GetNextDlgGroupItem		PROTO		@proto_618

@proto_619		TYPEDEF		PROTO FAR PASCAL :HWND, :HWND, :BOOL
GetNextDlgTabItem		PROTO		@proto_619

@proto_620		TYPEDEF		PROTO FAR PASCAL :HWND, :FAR PTR RECT
MapDialogRect		PROTO		@proto_620

@proto_621		TYPEDEF		PROTO FAR PASCAL 
GetDialogBaseUnits		PROTO		@proto_621

WM_GETDLGCODE		EQU		000000087h
DLGC_WANTARROWS		EQU		000000001h
DLGC_WANTTAB		EQU		000000002h
DLGC_WANTALLKEYS		EQU		000000004h
DLGC_WANTMESSAGE		EQU		000000004h
DLGC_HASSETSEL		EQU		000000008h
DLGC_DEFPUSHBUTTON		EQU		000000010h
DLGC_UNDEFPUSHBUTTON		EQU		000000020h
DLGC_RADIOBUTTON		EQU		000000040h
DLGC_WANTCHARS		EQU		000000080h
DLGC_STATIC		EQU		000000100h
DLGC_BUTTON		EQU		000002000h
WM_CTLCOLOR		EQU		000000019h
CTLCOLOR_MSGBOX		EQU		0t
CTLCOLOR_EDIT		EQU		1t
CTLCOLOR_LISTBOX		EQU		2t
CTLCOLOR_BTN		EQU		3t
CTLCOLOR_DLG		EQU		4t
CTLCOLOR_SCROLLBAR		EQU		5t
CTLCOLOR_STATIC		EQU		6t
WM_SETFONT		EQU		000000030h
WM_GETFONT		EQU		000000031h
IDOK		EQU		1t
IDCANCEL		EQU		2t
IDABORT		EQU		3t
IDRETRY		EQU		4t
IDIGNORE		EQU		5t
IDYES		EQU		6t
IDNO		EQU		7t
ODT_MENU		EQU		1t
ODT_LISTBOX		EQU		2t
ODT_COMBOBOX		EQU		3t
ODT_BUTTON		EQU		4t
ODA_DRAWENTIRE		EQU		000000001h
ODA_SELECT		EQU		000000002h
ODA_FOCUS		EQU		000000004h
ODS_SELECTED		EQU		000000001h
ODS_GRAYED		EQU		000000002h
ODS_DISABLED		EQU		000000004h
ODS_CHECKED		EQU		000000008h
ODS_FOCUS		EQU		000000010h
WM_DRAWITEM		EQU		00000002bh
tagDRAWITEMSTRUCT		STRUCT 1t
CtlType		UINT		?
CtlID		UINT		?
itemID		UINT		?
itemAction		UINT		?
itemState		UINT		?
hwndItem		HWND		?
hDC		HDC		?
rcItem		RECT		<>
itemData		DWORD		?
tagDRAWITEMSTRUCT		ENDS

DRAWITEMSTRUCT		TYPEDEF		tagDRAWITEMSTRUCT

PDRAWITEMSTRUCT		TYPEDEF		NEAR PTR DRAWITEMSTRUCT

LPDRAWITEMSTRUCT		TYPEDEF		FAR PTR DRAWITEMSTRUCT

WM_MEASUREITEM		EQU		00000002ch
tagMEASUREITEMSTRUCT		STRUCT 1t
CtlType		UINT		?
CtlID		UINT		?
itemID		UINT		?
itemWidth		UINT		?
itemHeight		UINT		?
itemData		DWORD		?
tagMEASUREITEMSTRUCT		ENDS

MEASUREITEMSTRUCT		TYPEDEF		tagMEASUREITEMSTRUCT

PMEASUREITEMSTRUCT		TYPEDEF		NEAR PTR MEASUREITEMSTRUCT

LPMEASUREITEMSTRUCT		TYPEDEF		FAR PTR MEASUREITEMSTRUCT

WM_DELETEITEM		EQU		00000002dh
tagDELETEITEMSTRUCT		STRUCT 1t
CtlType		UINT		?
CtlID		UINT		?
itemID		UINT		?
hwndItem		HWND		?
itemData		DWORD		?
tagDELETEITEMSTRUCT		ENDS

DELETEITEMSTRUCT		TYPEDEF		tagDELETEITEMSTRUCT

PDELETEITEMSTRUCT		TYPEDEF		NEAR PTR DELETEITEMSTRUCT

LPDELETEITEMSTRUCT		TYPEDEF		FAR PTR DELETEITEMSTRUCT

WM_COMPAREITEM		EQU		000000039h
tagCOMPAREITEMSTRUCT		STRUCT 1t
CtlType		UINT		?
CtlID		UINT		?
hwndItem		HWND		?
itemID1		UINT		?
itemData1		DWORD		?
itemID2		UINT		?
itemData2		DWORD		?
tagCOMPAREITEMSTRUCT		ENDS

COMPAREITEMSTRUCT		TYPEDEF		tagCOMPAREITEMSTRUCT

PCOMPAREITEMSTRUCT		TYPEDEF		NEAR PTR COMPAREITEMSTRUCT

LPCOMPAREITEMSTRUCT		TYPEDEF		FAR PTR COMPAREITEMSTRUCT

SS_LEFT		EQU		000000000h
SS_CENTER		EQU		000000001h
SS_RIGHT		EQU		000000002h
SS_ICON		EQU		000000003h
SS_BLACKRECT		EQU		000000004h
SS_GRAYRECT		EQU		000000005h
SS_WHITERECT		EQU		000000006h
SS_BLACKFRAME		EQU		000000007h
SS_GRAYFRAME		EQU		000000008h
SS_WHITEFRAME		EQU		000000009h
SS_SIMPLE		EQU		00000000bh
SS_LEFTNOWORDWRAP		EQU		00000000ch
SS_NOPREFIX		EQU		000000080h
STM_SETICON		EQU		000000400h
STM_GETICON		EQU		000000401h
BS_PUSHBUTTON		EQU		000000000h
BS_DEFPUSHBUTTON		EQU		000000001h
BS_CHECKBOX		EQU		000000002h
BS_AUTOCHECKBOX		EQU		000000003h
BS_RADIOBUTTON		EQU		000000004h
BS_3STATE		EQU		000000005h
BS_AUTO3STATE		EQU		000000006h
BS_GROUPBOX		EQU		000000007h
BS_USERBUTTON		EQU		000000008h
BS_AUTORADIOBUTTON		EQU		000000009h
BS_OWNERDRAW		EQU		00000000bh
BS_LEFTTEXT		EQU		000000020h
BM_GETCHECK		EQU		000000400h
BM_SETCHECK		EQU		000000401h
BM_GETSTATE		EQU		000000402h
BM_SETSTATE		EQU		000000403h
BM_SETSTYLE		EQU		000000404h
BN_CLICKED		EQU		0t
BN_PAINT		EQU		1t
BN_HILITE		EQU		2t
BN_UNHILITE		EQU		3t
BN_DISABLE		EQU		4t
BN_DOUBLECLICKED		EQU		5t
ES_LEFT		EQU		000000000h
ES_CENTER		EQU		000000001h
ES_RIGHT		EQU		000000002h
ES_MULTILINE		EQU		000000004h
ES_UPPERCASE		EQU		000000008h
ES_LOWERCASE		EQU		000000010h
ES_PASSWORD		EQU		000000020h
ES_AUTOVSCROLL		EQU		000000040h
ES_AUTOHSCROLL		EQU		000000080h
ES_NOHIDESEL		EQU		000000100h
ES_OEMCONVERT		EQU		000000400h
ES_READONLY		EQU		000000800h
ES_WANTRETURN		EQU		000001000h
EM_GETSEL		EQU		000000400h
EM_SETSEL		EQU		000000401h
EM_GETRECT		EQU		000000402h
EM_SETRECT		EQU		000000403h
EM_SETRECTNP		EQU		000000404h
EM_LINESCROLL		EQU		000000406h
EM_GETMODIFY		EQU		000000408h
EM_SETMODIFY		EQU		000000409h
EM_GETLINECOUNT		EQU		00000040ah
EM_LINEINDEX		EQU		00000040bh
EM_SETHANDLE		EQU		00000040ch
EM_GETHANDLE		EQU		00000040dh
EM_LINELENGTH		EQU		000000411h
EM_REPLACESEL		EQU		000000412h
EM_SETFONT		EQU		000000413h
EM_GETLINE		EQU		000000414h
EM_LIMITTEXT		EQU		000000415h
EM_CANUNDO		EQU		000000416h
EM_UNDO		EQU		000000417h
EM_FMTLINES		EQU		000000418h
EM_LINEFROMCHAR		EQU		000000419h
EM_SETWORDBREAK		EQU		00000041ah
EM_SETTABSTOPS		EQU		00000041bh
EM_SETPASSWORDCHAR		EQU		00000041ch
EM_EMPTYUNDOBUFFER		EQU		00000041dh
EM_GETFIRSTVISIBLELINE		EQU		00000041eh
EM_SETREADONLY		EQU		00000041fh
EM_SETWORDBREAKPROC		EQU		000000420h
EM_GETWORDBREAKPROC		EQU		000000421h
EM_GETPASSWORDCHAR		EQU		000000422h
@proto_622		TYPEDEF		PROTO FAR PASCAL :LPSTR, :SWORD, :SWORD, :SWORD
EDITWORDBREAKPROC		TYPEDEF		FAR PTR @proto_622

WB_LEFT		EQU		0t
WB_RIGHT		EQU		1t
WB_ISDELIMITER		EQU		2t
EN_SETFOCUS		EQU		000000100h
EN_KILLFOCUS		EQU		000000200h
EN_CHANGE		EQU		000000300h
EN_UPDATE		EQU		000000400h
EN_ERRSPACE		EQU		000000500h
EN_MAXTEXT		EQU		000000501h
EN_HSCROLL		EQU		000000601h
EN_VSCROLL		EQU		000000602h
SBS_HORZ		EQU		000000000h
SBS_VERT		EQU		000000001h
SBS_TOPALIGN		EQU		000000002h
SBS_LEFTALIGN		EQU		000000002h
SBS_BOTTOMALIGN		EQU		000000004h
SBS_RIGHTALIGN		EQU		000000004h
SBS_SIZEBOXTOPLEFTALIGN		EQU		000000002h
SBS_SIZEBOXBOTTOMRIGHTALIGN		EQU		000000004h
SBS_SIZEBOX		EQU		000000008h
LBS_NOTIFY		EQU		000000001h
LBS_SORT		EQU		000000002h
LBS_NOREDRAW		EQU		000000004h
LBS_MULTIPLESEL		EQU		000000008h
LBS_OWNERDRAWFIXED		EQU		000000010h
LBS_OWNERDRAWVARIABLE		EQU		000000020h
LBS_HASSTRINGS		EQU		000000040h
LBS_USETABSTOPS		EQU		000000080h
LBS_NOINTEGRALHEIGHT		EQU		000000100h
LBS_MULTICOLUMN		EQU		000000200h
LBS_WANTKEYBOARDINPUT		EQU		000000400h
LBS_EXTENDEDSEL		EQU		000000800h
LBS_DISABLENOSCROLL		EQU		000001000h
LBS_STANDARD		EQU		000a00003h
LB_ADDSTRING		EQU		000000401h
LB_INSERTSTRING		EQU		000000402h
LB_DELETESTRING		EQU		000000403h
LB_RESETCONTENT		EQU		000000405h
LB_SETSEL		EQU		000000406h
LB_SETCURSEL		EQU		000000407h
LB_GETSEL		EQU		000000408h
LB_GETCURSEL		EQU		000000409h
LB_GETTEXT		EQU		00000040ah
LB_GETTEXTLEN		EQU		00000040bh
LB_GETCOUNT		EQU		00000040ch
LB_SELECTSTRING		EQU		00000040dh
LB_DIR		EQU		00000040eh
LB_GETTOPINDEX		EQU		00000040fh
LB_FINDSTRING		EQU		000000410h
LB_GETSELCOUNT		EQU		000000411h
LB_GETSELITEMS		EQU		000000412h
LB_SETTABSTOPS		EQU		000000413h
LB_GETHORIZONTALEXTENT		EQU		000000414h
LB_SETHORIZONTALEXTENT		EQU		000000415h
LB_SETCOLUMNWIDTH		EQU		000000416h
LB_SETTOPINDEX		EQU		000000418h
LB_GETITEMRECT		EQU		000000419h
LB_GETITEMDATA		EQU		00000041ah
LB_SETITEMDATA		EQU		00000041bh
LB_SELITEMRANGE		EQU		00000041ch
LB_SETCARETINDEX		EQU		00000041fh
LB_GETCARETINDEX		EQU		000000420h
LB_SETITEMHEIGHT		EQU		000000421h
LB_GETITEMHEIGHT		EQU		000000422h
LB_FINDSTRINGEXACT		EQU		000000423h
LBN_ERRSPACE		EQU		-2t
LBN_SELCHANGE		EQU		1t
LBN_DBLCLK		EQU		2t
LBN_SELCANCEL		EQU		3t
LBN_SETFOCUS		EQU		4t
LBN_KILLFOCUS		EQU		5t
WM_VKEYTOITEM		EQU		00000002eh
WM_CHARTOITEM		EQU		00000002fh
LB_OKAY		EQU		0t
LB_ERR		EQU		-1t
LB_ERRSPACE		EQU		-2t
LB_CTLCODE		EQU		000000000h
@proto_623		TYPEDEF		PROTO FAR PASCAL :HWND, :LPSTR, :SWORD, :SWORD, :UINT
DlgDirList		PROTO		@proto_623

@proto_624		TYPEDEF		PROTO FAR PASCAL :HWND, :LPSTR, :SWORD
DlgDirSelect		PROTO		@proto_624

@proto_625		TYPEDEF		PROTO FAR PASCAL :HWND, :LPSTR, :SWORD, :SWORD, :UINT
DlgDirListComboBox		PROTO		@proto_625

@proto_626		TYPEDEF		PROTO FAR PASCAL :HWND, :LPSTR, :SWORD
DlgDirSelectComboBox		PROTO		@proto_626

@proto_627		TYPEDEF		PROTO FAR PASCAL :HWND, :LPSTR, :SWORD, :SWORD
DlgDirSelectEx		PROTO		@proto_627

@proto_628		TYPEDEF		PROTO FAR PASCAL :HWND, :LPSTR, :SWORD, :SWORD
DlgDirSelectComboBoxEx		PROTO		@proto_628

DDL_READWRITE		EQU		000000000h
DDL_READONLY		EQU		000000001h
DDL_HIDDEN		EQU		000000002h
DDL_SYSTEM		EQU		000000004h
DDL_DIRECTORY		EQU		000000010h
DDL_ARCHIVE		EQU		000000020h
DDL_POSTMSGS		EQU		000002000h
DDL_DRIVES		EQU		000004000h
DDL_EXCLUSIVE		EQU		000008000h
CBS_SIMPLE		EQU		000000001h
CBS_DROPDOWN		EQU		000000002h
CBS_DROPDOWNLIST		EQU		000000003h
CBS_OWNERDRAWFIXED		EQU		000000010h
CBS_OWNERDRAWVARIABLE		EQU		000000020h
CBS_AUTOHSCROLL		EQU		000000040h
CBS_OEMCONVERT		EQU		000000080h
CBS_SORT		EQU		000000100h
CBS_HASSTRINGS		EQU		000000200h
CBS_NOINTEGRALHEIGHT		EQU		000000400h
CBS_DISABLENOSCROLL		EQU		000000800h
CB_GETEDITSEL		EQU		000000400h
CB_LIMITTEXT		EQU		000000401h
CB_SETEDITSEL		EQU		000000402h
CB_ADDSTRING		EQU		000000403h
CB_DELETESTRING		EQU		000000404h
CB_DIR		EQU		000000405h
CB_GETCOUNT		EQU		000000406h
CB_GETCURSEL		EQU		000000407h
CB_GETLBTEXT		EQU		000000408h
CB_GETLBTEXTLEN		EQU		000000409h
CB_INSERTSTRING		EQU		00000040ah
CB_RESETCONTENT		EQU		00000040bh
CB_FINDSTRING		EQU		00000040ch
CB_SELECTSTRING		EQU		00000040dh
CB_SETCURSEL		EQU		00000040eh
CB_SHOWDROPDOWN		EQU		00000040fh
CB_GETITEMDATA		EQU		000000410h
CB_SETITEMDATA		EQU		000000411h
CB_GETDROPPEDCONTROLRECT		EQU		000000412h
CB_SETITEMHEIGHT		EQU		000000413h
CB_GETITEMHEIGHT		EQU		000000414h
CB_SETEXTENDEDUI		EQU		000000415h
CB_GETEXTENDEDUI		EQU		000000416h
CB_GETDROPPEDSTATE		EQU		000000417h
CB_FINDSTRINGEXACT		EQU		000000418h
CBN_ERRSPACE		EQU		-1t
CBN_SELCHANGE		EQU		1t
CBN_DBLCLK		EQU		2t
CBN_SETFOCUS		EQU		3t
CBN_KILLFOCUS		EQU		4t
CBN_EDITCHANGE		EQU		5t
CBN_EDITUPDATE		EQU		6t
CBN_DROPDOWN		EQU		7t
CBN_CLOSEUP		EQU		8t
CBN_SELENDOK		EQU		9t
CBN_SELENDCANCEL		EQU		10t
CB_OKAY		EQU		0t
CB_ERR		EQU		-1t
CB_ERRSPACE		EQU		-2t
HHOOK		TYPEDEF		DWORD

HOOKPROC		TYPEDEF		FARPROC

@proto_629		TYPEDEF		PROTO FAR PASCAL :SWORD, :HOOKPROC
SetWindowsHook		PROTO		@proto_629

@proto_630		TYPEDEF		PROTO FAR PASCAL :SWORD, :WPARAM, :LPARAM, :FAR PTR HOOKPROC
DefHookProc		PROTO		@proto_630

@proto_631		TYPEDEF		PROTO FAR PASCAL :SWORD, :HOOKPROC
UnhookWindowsHook		PROTO		@proto_631

@proto_632		TYPEDEF		PROTO FAR PASCAL :SWORD, :HOOKPROC, :HINSTANCE, :HTASK
SetWindowsHookEx		PROTO		@proto_632

@proto_633		TYPEDEF		PROTO FAR PASCAL :HHOOK
UnhookWindowsHookEx		PROTO		@proto_633

@proto_634		TYPEDEF		PROTO FAR PASCAL :HHOOK, :SWORD, :WPARAM, :LPARAM
CallNextHookEx		PROTO		@proto_634

HC_ACTION		EQU		0t
HC_GETLPLPFN		EQU		-3t
HC_LPLPFNNEXT		EQU		-2t
HC_LPFNNEXT		EQU		-1t
WM_QUEUESYNC		EQU		000000023h
WH_CBT		EQU		5t
HCBT_MOVESIZE		EQU		0t
HCBT_MINMAX		EQU		1t
HCBT_QS		EQU		2t
HCBT_CREATEWND		EQU		3t
HCBT_DESTROYWND		EQU		4t
HCBT_ACTIVATE		EQU		5t
HCBT_CLICKSKIPPED		EQU		6t
HCBT_KEYSKIPPED		EQU		7t
HCBT_SYSCOMMAND		EQU		8t
HCBT_SETFOCUS		EQU		9t
@t_3		TYPEDEF		FAR PTR CREATESTRUCT
tagCBT_CREATEWND		STRUCT 1t
lpcs		@t_3		?
hwndInsertAfter		HWND		?
tagCBT_CREATEWND		ENDS

CBT_CREATEWND		TYPEDEF		tagCBT_CREATEWND

LPCBT_CREATEWND		TYPEDEF		FAR PTR CBT_CREATEWND

tagCBTACTIVATESTRUCT		STRUCT 1t
fMouse		BOOL		?
hWndActive		HWND		?
tagCBTACTIVATESTRUCT		ENDS

CBTACTIVATESTRUCT		TYPEDEF		tagCBTACTIVATESTRUCT

WH_HARDWARE		EQU		8t
tagHARDWAREHOOKSTRUCT		STRUCT 1t
hWnd		HWND		?
wMessage		UINT		?
wParam		WPARAM		?
lParam		LPARAM		?
tagHARDWAREHOOKSTRUCT		ENDS

HARDWAREHOOKSTRUCT		TYPEDEF		tagHARDWAREHOOKSTRUCT

WH_SHELL		EQU		10t
HSHELL_WINDOWCREATED		EQU		1t
HSHELL_WINDOWDESTROYED		EQU		2t
HSHELL_ACTIVATESHELLWINDOW		EQU		3t
WH_JOURNALRECORD		EQU		0t
WH_JOURNALPLAYBACK		EQU		1t
HC_GETNEXT		EQU		1t
HC_SKIP		EQU		2t
HC_NOREMOVE		EQU		3t
HC_NOREM		EQU		000000003h
HC_SYSMODALON		EQU		4t
HC_SYSMODALOFF		EQU		5t
tagEVENTMSG		STRUCT 1t
message		UINT		?
paramL		UINT		?
paramH		UINT		?
time		DWORD		?
tagEVENTMSG		ENDS

EVENTMSG		TYPEDEF		tagEVENTMSG

PEVENTMSG		TYPEDEF		PTR EVENTMSG

NPEVENTMSG		TYPEDEF		NEAR PTR EVENTMSG

LPEVENTMSG		TYPEDEF		FAR PTR EVENTMSG

@proto_635		TYPEDEF		PROTO FAR PASCAL :BOOL
EnableHardwareInput		PROTO		@proto_635

WH_DEBUG		EQU		9t
tagDEBUGHOOKINFO		STRUCT 1t
hModuleHook		HMODULE		?
reserved		LPARAM		?
lParam		LPARAM		?
wParam		WPARAM		?
code		SWORD		?
tagDEBUGHOOKINFO		ENDS

DEBUGHOOKINFO		TYPEDEF		tagDEBUGHOOKINFO

LPDEBUGHOOKINFO		TYPEDEF		FAR PTR DEBUGHOOKINFO

@proto_636		TYPEDEF		PROTO FAR PASCAL :HANDLE, :HANDLE, :HANDLE, :LPMSG
QuerySendMessage		PROTO		@proto_636

@proto_637		TYPEDEF		PROTO FAR PASCAL :HANDLE, :HWND, :BOOL
LockInput		PROTO		@proto_637

@proto_638		TYPEDEF		PROTO FAR PASCAL 
GetSystemDebugState		PROTO		@proto_638

SDS_MENU		EQU		000000001h
SDS_SYSMODAL		EQU		000000002h
SDS_NOTASKQUEUE		EQU		000000004h
SDS_DIALOG		EQU		000000008h
SDS_TASKLOCKED		EQU		000000010h

ifndef	NOHELP ; HELP FUNCTIONS

@proto_639		TYPEDEF		PROTO FAR PASCAL :HWND, :LPCSTR, :UINT, :DWORD
WinHelp		PROTO		@proto_639

HELP_CONTEXT		EQU		000000001h
HELP_QUIT		EQU		000000002h
HELP_INDEX		EQU		000000003h
HELP_CONTENTS		EQU		000000003h
HELP_HELPONHELP		EQU		000000004h
HELP_SETINDEX		EQU		000000005h
HELP_SETCONTENTS		EQU		000000005h
HELP_CONTEXTPOPUP		EQU		000000008h
HELP_FORCEFILE		EQU		000000009h
HELP_KEY		EQU		000000101h
HELP_COMMAND		EQU		000000102h
HELP_PARTIALKEY		EQU		000000105h
HELP_MULTIKEY		EQU		000000201h
HELP_SETWINPOS		EQU		000000203h
tagMULTIKEYHELP		STRUCT 1t
mkSize		UINT		?
mkKeylist		BYTE		?
szKeyphrase		BYTE		1t DUP (?)
tagMULTIKEYHELP		ENDS

MULTIKEYHELP		TYPEDEF		tagMULTIKEYHELP

@tag_3		STRUCT 1t
wStructSize		SWORD		?
x		SWORD		?
y		SWORD		?
_dx		SWORD		?
dy		SWORD		?
wMax		SWORD		?
rgchMember		SBYTE		2t DUP (?)
@tag_3		ENDS

HELPWININFO		TYPEDEF		@tag_3

PHELPWININFO		TYPEDEF		NEAR PTR HELPWININFO

LPHELPWININFO		TYPEDEF		FAR PTR HELPWININFO

endif	; of ifndef NOHELP


ifndef NOSOUND ; SOUND FUNCTIONS

@proto_640		TYPEDEF		PROTO FAR PASCAL 
OpenSound		PROTO		@proto_640

@proto_641		TYPEDEF		PROTO FAR PASCAL 
CloseSound		PROTO		@proto_641

@proto_642		TYPEDEF		PROTO FAR PASCAL 
StartSound		PROTO		@proto_642

@proto_643		TYPEDEF		PROTO FAR PASCAL 
StopSound		PROTO		@proto_643

@proto_644		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD
SetVoiceQueueSize		PROTO		@proto_644

@proto_645		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD, :SWORD, :SWORD
SetVoiceNote		PROTO		@proto_645

@proto_646		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD, :SWORD, :SWORD, :SWORD
SetVoiceAccent		PROTO		@proto_646

@proto_647		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD, :SWORD
SetVoiceEnvelope		PROTO		@proto_647

@proto_648		TYPEDEF		PROTO FAR PASCAL :SWORD, :DWORD, :SWORD
SetVoiceSound		PROTO		@proto_648

@proto_649		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD
SetVoiceThreshold		PROTO		@proto_649

@proto_650		TYPEDEF		PROTO FAR PASCAL 
GetThresholdEvent		PROTO		@proto_650

@proto_651		TYPEDEF		PROTO FAR PASCAL 
GetThresholdStatus		PROTO		@proto_651

@proto_652		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD
SetSoundNoise		PROTO		@proto_652

S_PERIOD512		EQU		0t
S_PERIOD1024		EQU		1t
S_PERIOD2048		EQU		2t
S_PERIODVOICE		EQU		3t
S_WHITE512		EQU		4t
S_WHITE1024		EQU		5t
S_WHITE2048		EQU		6t
S_WHITEVOICE		EQU		7t
@proto_653		TYPEDEF		PROTO FAR PASCAL :SWORD
WaitSoundState		PROTO		@proto_653

S_QUEUEEMPTY		EQU		0t
S_THRESHOLD		EQU		1t
S_ALLTHRESHOLD		EQU		2t
@proto_654		TYPEDEF		PROTO FAR PASCAL 
SyncAllVoices		PROTO		@proto_654

@proto_655		TYPEDEF		PROTO FAR PASCAL :SWORD
CountVoiceNotes		PROTO		@proto_655

S_NORMAL		EQU		0t
S_LEGATO		EQU		1t
S_STACCATO		EQU		2t
S_SERDVNA		EQU		-1t
S_SEROFM		EQU		-2t
S_SERMACT		EQU		-3t
S_SERQFUL		EQU		-4t
S_SERBDNT		EQU		-5t
S_SERDLN		EQU		-6t
S_SERDCC		EQU		-7t
S_SERDTP		EQU		-8t
S_SERDVL		EQU		-9t
S_SERDMD		EQU		-10t
S_SERDSH		EQU		-11t
S_SERDPT		EQU		-12t
S_SERDFQ		EQU		-13t
S_SERDDR		EQU		-14t
S_SERDSR		EQU		-15t
S_SERDST		EQU		-16t

endif ; of ifndef NOSOUND

ifndef NOCOMM ; COMM SUPPORT

NOPARITY		EQU		0t
ODDPARITY		EQU		1t
EVENPARITY		EQU		2t
MARKPARITY		EQU		3t
SPACEPARITY		EQU		4t
ONESTOPBIT		EQU		0t
ONE5STOPBITS		EQU		1t
TWOSTOPBITS		EQU		2t
IGNORE		EQU		0t
INFINITE		EQU		00000ffffh
CE_RXOVER		EQU		000000001h
CE_OVERRUN		EQU		000000002h
CE_RXPARITY		EQU		000000004h
CE_FRAME		EQU		000000008h
CE_BREAK		EQU		000000010h
CE_CTSTO		EQU		000000020h
CE_DSRTO		EQU		000000040h
CE_RLSDTO		EQU		000000080h
CE_TXFULL		EQU		000000100h
CE_PTO		EQU		000000200h
CE_IOE		EQU		000000400h
CE_DNS		EQU		000000800h
CE_OOP		EQU		000001000h
CE_MODE		EQU		000008000h
IE_BADID		EQU		-1t
IE_OPEN		EQU		-2t
IE_NOPEN		EQU		-3t
IE_MEMORY		EQU		-4t
IE_DEFAULT		EQU		-5t
IE_HARDWARE		EQU		-10t
IE_BYTESIZE		EQU		-11t
IE_BAUDRATE		EQU		-12t
EV_RXCHAR		EQU		000000001h
EV_RXFLAG		EQU		000000002h
EV_TXEMPTY		EQU		000000004h
EV_CTS		EQU		000000008h
EV_DSR		EQU		000000010h
EV_RLSD		EQU		000000020h
EV_BREAK		EQU		000000040h
EV_ERR		EQU		000000080h
EV_RING		EQU		000000100h
EV_PERR		EQU		000000200h
EV_CTSS		EQU		000000400h
EV_DSRS		EQU		000000800h
EV_RLSDS		EQU		000001000h
EV_RingTe		EQU		000002000h
EV_RINGTE		EQU		000002000h
SETXOFF		EQU		1t
SETXON		EQU		2t
SETRTS		EQU		3t
CLRRTS		EQU		4t
SETDTR		EQU		5t
CLRDTR		EQU		6t
RESETDEV		EQU		7t
LPTx		EQU		000000080h
GETMAXLPT		EQU		8t
GETMAXCOM		EQU		9t
GETBASEIRQ		EQU		10t
CBR_110		EQU		00000ff10h
CBR_300		EQU		00000ff11h
CBR_600		EQU		00000ff12h
CBR_1200		EQU		00000ff13h
CBR_2400		EQU		00000ff14h
CBR_4800		EQU		00000ff15h
CBR_9600		EQU		00000ff16h
CBR_14400		EQU		00000ff17h
CBR_19200		EQU		00000ff18h
CBR_38400		EQU		00000ff1bh
CBR_56000		EQU		00000ff1fh
CBR_128000		EQU		00000ff23h
CBR_256000		EQU		00000ff27h
CN_RECEIVE		EQU		000000001h
CN_TRANSMIT		EQU		000000002h
CN_EVENT		EQU		000000004h
tagDCB		STRUCT 1t
Id		BYTE		?
BaudRate		UINT		?
ByteSize		BYTE		?
Parity		BYTE		?
StopBits		BYTE		?
RlsTimeout		UINT		?
CtsTimeout		UINT		?
DsrTimeout		UINT		?
rec@tagDCB_0		RECORD	fDummy2@tagDCB:1,
			fRtsflow@tagDCB:1,
			fDtrflow@tagDCB:1,
			fChEvt@tagDCB:1,
			fNull@tagDCB:1,
			fPeChar@tagDCB:1,
			fInX@tagDCB:1,
			fOutX@tagDCB:1,
			fDtrDisable@tagDCB:1,
			fDummy@tagDCB:2,
			fOutxDsrFlow@tagDCB:1,
			fOutxCtsFlow@tagDCB:1,
			fParity@tagDCB:1,
			fRtsDisable@tagDCB:1,
			fBinary@tagDCB:1
@bit_0		rec@tagDCB_0	<>
XonChar		SBYTE		?
XoffChar		SBYTE		?
XonLim		UINT		?
XoffLim		UINT		?
PeChar		SBYTE		?
EofChar		SBYTE		?
EvtChar		SBYTE		?
TxDelay		UINT		?
tagDCB		ENDS

DCB		TYPEDEF		tagDCB

LPDCB		TYPEDEF		FAR PTR DCB

tagCOMSTAT		STRUCT 1t
status		BYTE		?
cbInQue		UINT		?
cbOutQue		UINT		?
tagCOMSTAT		ENDS

COMSTAT		TYPEDEF		tagCOMSTAT

CSTF_CTSHOLD		EQU		000000001h
CSTF_DSRHOLD		EQU		000000002h
CSTF_RLSDHOLD		EQU		000000004h
CSTF_XOFFHOLD		EQU		000000008h
CSTF_XOFFSENT		EQU		000000010h
CSTF_EOF		EQU		000000020h
CSTF_TXIM		EQU		000000040h
@proto_656		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :FAR PTR DCB
BuildCommDCB		PROTO		@proto_656

@proto_657		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :UINT, :UINT
OpenComm		PROTO		@proto_657

@proto_658		TYPEDEF		PROTO FAR PASCAL :SWORD
CloseComm		PROTO		@proto_658

@proto_659		TYPEDEF		PROTO FAR PASCAL :SWORD, :FAR PTR , :SWORD
ReadComm		PROTO		@proto_659

@proto_660		TYPEDEF		PROTO FAR PASCAL :SWORD, :FAR PTR , :SWORD
WriteComm		PROTO		@proto_660

@proto_661		TYPEDEF		PROTO FAR PASCAL :SWORD, :SBYTE
UngetCommChar		PROTO		@proto_661

@proto_662		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD
FlushComm		PROTO		@proto_662

@proto_663		TYPEDEF		PROTO FAR PASCAL :SWORD, :SBYTE
TransmitCommChar		PROTO		@proto_663

@proto_664		TYPEDEF		PROTO FAR PASCAL :FAR PTR tagDCB
SetCommState		PROTO		@proto_664

@proto_665		TYPEDEF		PROTO FAR PASCAL :SWORD, :FAR PTR DCB
GetCommState		PROTO		@proto_665

@proto_666		TYPEDEF		PROTO FAR PASCAL :SWORD, :FAR PTR COMSTAT
GetCommError		PROTO		@proto_666

@proto_667		TYPEDEF		PROTO FAR PASCAL :SWORD
SetCommBreak		PROTO		@proto_667

@proto_668		TYPEDEF		PROTO FAR PASCAL :SWORD
ClearCommBreak		PROTO		@proto_668

@proto_669		TYPEDEF		PROTO FAR PASCAL :SWORD, :UINT
SetCommEventMask		PROTO		@proto_669

@proto_670		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD
GetCommEventMask		PROTO		@proto_670

@proto_671		TYPEDEF		PROTO FAR PASCAL :SWORD, :SWORD
EscapeCommFunction		PROTO		@proto_671

@proto_672		TYPEDEF		PROTO FAR PASCAL :SWORD, :HWND, :SWORD, :SWORD
EnableCommNotification		PROTO		@proto_672

WM_COMMNOTIFY		EQU		000000044h

endif ; of ifndef NOCOMM

@proto_673		TYPEDEF		PROTO FAR PASCAL :LPSTR, :LPCSTR, :FAR PTR 
wvsprintf		PROTO		@proto_673

@proto_674		TYPEDEF		PROTO FAR C :LPSTR, :LPCSTR, :VARARG
wsprintf		PROTO		@proto_674

ifndef NODRIVERS

HDRVR		TYPEDEF		UINT

@proto_675		TYPEDEF		PROTO FAR PASCAL :DWORD, :HDRVR, :UINT, :LPARAM, :LPARAM
DRIVERPROC		TYPEDEF		FAR PTR @proto_675

DRV_LOAD		EQU		000000001h
DRV_ENABLE		EQU		000000002h
DRV_OPEN		EQU		000000003h
DRV_CLOSE		EQU		000000004h
DRV_DISABLE		EQU		000000005h
DRV_FREE		EQU		000000006h
DRV_CONFIGURE		EQU		000000007h
DRV_QUERYCONFIGURE		EQU		000000008h
DRV_INSTALL		EQU		000000009h
DRV_REMOVE		EQU		00000000ah
DRV_EXITSESSION		EQU		00000000bh
DRV_EXITAPPLICATION		EQU		00000000ch
DRV_POWER		EQU		00000000fh
DRV_RESERVED		EQU		000000800h
DRV_USER		EQU		000004000h
tagDRVCONFIGINFO		STRUCT 1t
dwDCISize		DWORD		?
lpszDCISectionName		LPCSTR		?
lpszDCIAliasName		LPCSTR		?
tagDRVCONFIGINFO		ENDS

DRVCONFIGINFO		TYPEDEF		tagDRVCONFIGINFO

PDRVCONFIGINFO		TYPEDEF		NEAR PTR DRVCONFIGINFO

LPDRVCONFIGINFO		TYPEDEF		FAR PTR DRVCONFIGINFO

DRVCNF_CANCEL		EQU		000000000h
DRVCNF_OK		EQU		000000001h
DRVCNF_RESTART		EQU		000000002h
DRVEA_NORMALEXIT		EQU		000000001h
DRVEA_ABNORMALEXIT		EQU		000000002h
@proto_676		TYPEDEF		PROTO FAR PASCAL :DWORD, :HDRVR, :UINT, :LPARAM, :LPARAM
DefDriverProc		PROTO		@proto_676

@proto_677		TYPEDEF		PROTO FAR PASCAL :LPCSTR, :LPCSTR, :LPARAM
OpenDriver		PROTO		@proto_677

@proto_678		TYPEDEF		PROTO FAR PASCAL :HDRVR, :LPARAM, :LPARAM
CloseDriver		PROTO		@proto_678

@proto_679		TYPEDEF		PROTO FAR PASCAL :HDRVR, :UINT, :LPARAM, :LPARAM
SendDriverMessage		PROTO		@proto_679

@proto_680		TYPEDEF		PROTO FAR PASCAL :HDRVR
GetDriverModuleHandle		PROTO		@proto_680

@proto_681		TYPEDEF		PROTO FAR PASCAL :HDRVR, :DWORD
GetNextDriver		PROTO		@proto_681

GND_FIRSTINSTANCEONLY		EQU		000000001h
GND_FORWARD		EQU		000000000h
GND_REVERSE		EQU		000000002h
tagDRIVERINFOSTRUCT		STRUCT 1t
_length		UINT		?
hDriver		HDRVR		?
hModule		HINSTANCE		?
szAliasName		SBYTE		128t DUP (?)
tagDRIVERINFOSTRUCT		ENDS

DRIVERINFOSTRUCT		TYPEDEF		tagDRIVERINFOSTRUCT

LPDRIVERINFOSTRUCT		TYPEDEF		FAR PTR DRIVERINFOSTRUCT

@proto_682		TYPEDEF		PROTO FAR PASCAL :HDRVR, :FAR PTR DRIVERINFOSTRUCT
GetDriverInfo		PROTO		@proto_682

endif 	; of ifndef NODRIVERS
endif 	; of ifndef NOUSER

; End of file win31.h

endif	; of ifndef _INC_WINDOWS_INC


