@echo off
goto batch_start
rem
rem GETMSC.BAT
rem
:usage
echo .
echo This batch file copies the 32-bit Microsoft C compiler
echo from the NT CD-ROM to the specified target directory.
echo Along with the compiler, it will optionally copy the
echo Microsoft sample code and the Microsoft Foundation Classes.
echo .
echo Usage:
echo        GETMSC "cd drive" "target MSC dir" "PL tools dir" [min, sample, max]
echo e.g.
echo         getmsc f: c:\mstools c:\phar386 sample
echo where
echo         "cdrom drive"    = The driver letter for the NT CD-ROM
echo         "target MSC dir" = Target directory for 32-bit MSC compiler
echo         "PL tools dir"   = Directory which contains the Phar Lap 386 SDK
echo         min    = install MSC compiler only
echo         sample = install MSC compiler and Microsoft sample code
echo         max    = install MSC compiler, Microsoft sample code,
echo                  help files, and Microsoft Foundation Classes
echo .
echo The last parameter is optional and if omitted defaults to "min".
goto done
:batch_start
rem
rem First validate the parameters
rem
if "x%1" == "x" goto usage
if "x%2" == "x" goto nomscdir
if "x%3" == "x" goto nopldir
if "x%4" == "x" goto parm4ok
if "%4" == "min" goto parm4ok
if "%4" == "sample" goto parm4ok
if "%4" == "max" goto parm4ok
goto parm4bad
:parm4ok
rem
rem Make sure the CD ROM contains the NT CD-ROM
rem
if not exist %1\mstools\bin\i386\nmake.exe goto badcdrom
rem
rem Make sure that the target directory for the 32-bit compiler
rem does not already have a compiler in it
rem
if exist %2\bin\nmake.exe goto badmscdir
rem
rem Make sure that the Phar Lap SDK directory contains REBIND.EXE
rem and CFIG386.EXE
rem
if not exist %3\bin\rebind.exe goto badpldir
if not exist %3\bin\cfig386.exe goto badpldir
rem
rem Copy the MSC files from the BIN directory to the target directory
rem 
echo Now copying BIN subdirectory
mkdir %2\bin
xcopy %1\mstools\bin\i386 %2\bin /s /e
xcopy %1\i386\ntdll.dll %2\bin /s /e
xcopy %1\i386\cmd.exe %2\bin /s /e
rem
rem Copy the MSC files from the H directory to the target directory
rem 
echo Now copying H subdirectory
mkdir %2\h
xcopy %1\mstools\h %2\h /s /e
rem
rem Copy the MSC files from the INIT directory to the target directory
rem 
echo Now copying INIT subdirectory
mkdir %2\init
xcopy %1\mstools\init %2\init /s /e
rem
rem Copy the MSC files from the  LIB directory to the target directory
rem 
echo Now copying LIB subdirectory
mkdir %2\lib
xcopy %1\mstools\lib\i386 %2\lib /s /e
rem
rem Copy the sample files if we are doing a "sample" or "max" install
rem 
if "%4"=="min" goto done_copy
if "x%4"=="x" goto done_copy
echo Now copying SAMPLES subdirectory
mkdir %2\samples
xcopy %1\mstools\samples %2\samples /s /e
rem
rem Copy the help files and foundation classes if we are doing a "max" install
rem 
if "%4"=="sample" goto done_copy
echo Now copying HELP subdirectory
mkdir %2\help
xcopy %1\mstools\help %2\help /s /e
echo Now copying MFC subdirectory
mkdir %2\mfc
xcopy %1\mstools\mfc %2\mfc /s /e
echo Now copying RPC_DOS subdirectory
mkdir %2\rpc_dos
xcopy %1\mstools\rpc_dos %2\rpc_dos /s /e
rem
rem We are done copying the files.  Now we have to run
rem the REBIND utility on each of the NT executables which
rem we want to run under DOS.
rem
:done_copy
command/c %3\bin\bindone %2\bin CL386 %3\bin
command/c %3\bin\bindone %2\bin C13232 %3\bin silent
command/c %3\bin\bindone %2\bin C1XX3232 %3\bin silent 
command/c %3\bin\bindone %2\bin C23232 %3\bin silent
command/c %3\bin\bindone %2\bin COFF %3\bin
command/c %3\bin\bindone %2\bin CVTOMF %3\bin
command/c %3\bin\bindone %2\bin CVTRES %3\bin
command/c %3\bin\bindone %2\bin LIB %3\bin
command/c %3\bin\bindone %2\bin LINK %3\bin
command/c %3\bin\bindone %2\bin MASM386 %3\bin
command/c %3\bin\bindone %2\bin MIDL %3\bin
command/c %3\bin\bindone %2\bin NMAKE %3\bin
%3\bin\cfig386 %2\bin\nmake.exe -ntcomspec
command/c %3\bin\bindone %2\bin RC %3\bin
command/c %3\bin\bindone %2\bin RCPP %3\bin
rem
rem All done!!
rem 
echo All done
goto done
:nomscdir
echo .
echo Error -- No target directory specified for MSC compiler.
echo .
goto done
:nopldir
echo .
echo Error -- No directory specified for Phar Lap 386 SDK.
echo .
goto done
:parm4bad
echo .
echo Error -- The specified last parameter of "%4" is invalid.
echo It must be "min", "sample", or "max".
echo .
goto done
:badcdrom
echo .
echo Error -- Cannot locate the 32-bit MSC compiler on the
echo specified CD-ROM drive: %1.  Please make sure that the
echo CD-ROM drive contains the NT SDK.
echo .
goto done
:badmscdir
echo .
echo Error -- The specified target directory for the MSC compiler: "%2"
echo must not contain any subdirectories.  If you have already installed
echo a compiler in that directory, you must delete it.
echo .
goto done
:badpldir
echo .
echo Error -- The specified Phar Lap tools directory: "%3" either does
echo not exist or does not contain the Phar Lap 386DOS-Extender SDK.
echo .
goto done
:done
