;************************************************************************/
;*	Copyright (C) 1986-1988 Phar Lap Software, Inc.			*/
;*	Unpublished - rights reserved under the Copyright Laws of the	*/
;*	United States.  Use, duplication, or disclosure by the 		*/
;*	Government is subject to restrictions as set forth in 		*/
;*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 	*/
;*	Computer Software clause at 252.227-7013.			*/
;*	Phar Lap Software, Inc., 60 Aberdeen Ave., Cambridge, MA 02138	*/
;************************************************************************/
;
; ECHO386 - Echo command line arguments
;
; This program illustrates how to pick up command line arguments
; whenb running in 386 protected mode.  This program simply
; echos the command line arguments which it is given to the screen.
; The command line is contained in the PSP.  DOS-Extender sets up selector
; number #24 to point to the PSP.
;

;
;	Start of the program
;

_text	segment	byte public use32 'code'

	assume	cs:_text

;
; Local definitions
;

SS_UPSP	equ	024H			; PSP selector number


;
; The code
;

	public	_start_			;
_start_	proc	near			;

	mov	ax,SS_UPSP		; Set-up ES to address the PSP.
	mov	es,ax			;

	mov	cl,es:080H		; Load the length of the command line
	mov	esi,081H		;    into CL and set ESI to address
					;    the first text character of the
					;    command line.

	jmp	#bot1			; Go to the bottom of the output loop.

#loop1:	mov	dl,es:[esi]		; Call DOS to output the next 
	mov	ah,02H			;    character.
	int	21H			;

	add	esi,1			; Increment the command line pointer.

#bot1:	sub	cl,1			; Decrement CL and loop if not done
	jns	#loop1

	mov	dl,0DH			; Output CR/LF.
	mov	ah,02H			; 
	INT	21H			;
	mov	dl,0AH			; 
	mov	ah,02H			;
	INT	21H			;

	mov	ax,04C00H		; Exit back to DOS.
	INT 	21H			;

_start_	endp				;

_text	ends				;

_stack	segment byte stack use32 'stack'

	db	8192 dup (?)

_stack	ends

	end _start_
