//
// FREEMEM.C -- Print out available memory
//
#include <stdio.h>
#include <pharlap.h>
int main()
{
	CONFIG_INF config;
	UCHAR buf[256];
	VM_STATS memstats;

//
// The most accurate number is the largest available virtual memory
// block (virtual == physical when not in a virtual memory environment).
// This number does NOT include any free memory in the C run-time
// memory allocator heap, a number that can be obtained (if at all)
// only in a compiler-specific manner.
//
// Note that under Windows 3.x enhanced mode this number is not very 
// accurate, because the Windows DPMI services report inaccurate numbers.
// 
	_dx_config_inf(&config, buf);
	_dx_vm_stats(&memstats, FALSE);
	printf("Largest available memory block is %d bytes\n",
					memstats.vm_maxblk * 4096);
	if (config.c_windowsf && config.c_winenhf)
		printf("(Windows enhanced mode:  available memory \
count is inaccurate)\n");

	return 0;
}
