/* gdemo.c - Graphics demo program */

/************************************************************************/
/*	Copyright (C) 1986-1993 Phar Lap Software, Inc.			*/
/*	Unpublished - rights reserved under the Copyright Laws of the	*/
/*	United States.  Use, duplication, or disclosure by the 		*/
/*	Government is subject to restrictions as set forth in 		*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 	*/
/*	Computer Software clause at 252.227-7013.			*/
/*	Phar Lap Software, Inc., 60 Aberdeen Ave., Cambridge, MA 02138	*/
/************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "gserver.h"

/*
 * Include the Microsoft graphics library definition file.  Before we do
 * this, we will undefine the keywords '__far' and '__huge' so that we will
 * be able to compile the function prototypes with all 32-bit compilers.
 *
 * Also, for MetaWare High C/C++, define '__cdecl' so all the prototypes
 * in graph.h work.
 */
#undef __far
#undef __huge
#define __far
#define __huge
#ifdef __HIGHC__
#define __cdecl
#endif
#ifndef _MSC_VER
#define _MSC_VER 700	/* so __far and __huge don't get defined again */
#endif
#include "graph.h"

/*
 * Prototypes for routines in this file
 */
int randline();
short randx();
short randy();

/*

main - Main routine

*/

int main()
{
	struct _videoconfig vc;	/* Video configuration */
	int btime;		/* Execution time for buffered mode */
	int ubtime;		/* Execution time for unbuffered mode */

	/* Get the current video mode */

	_getvideoconfig(&vc);

	/* Switch to CGA medium res 4-color graphics mode */

	_setvideomode(_MRES4COLOR);
	_selectpalette(0);

	/* Run the demo first in buffered mode if protected mode */

	_gbuffmode(1);
	btime = randline();
	
	/* Run the demo again in unbuffered mode */

	_gbuffmode(0);
	ubtime = randline();

	/* Restore the original video mode */

	_setvideomode(vc.mode);

	/* Print out the buffered and unbuffered execution times */

	printf("\n\n");
	printf("Buffered mode execution time = %i milliseconds.\n",
	       btime);
	printf("Unbuffered mode execution time = %i milliseconds.\n",
	       ubtime);

	/* Exit back to DOS */

	return 0;	

}


/*

randline - Random line demo

*/

int randline()
{
	int i;		/* Loop counter */
	clock_t stime;	/* Start type */
	clock_t etime;	/* End time */

	/* Reseed the random number generator to a constant 100 so that
	   we always generate the same random lines. */

	srand(100);

	/* Start the clock */

	stime = clock();

	/* The demo code clears the screen and randomly draws 1000 lines 
	   in random colors */

	_clearscreen(_GCLEARSCREEN);
	for(i = 0; i < 1000; ++i)
	{
		_setcolor((short) (rand() % 4));
		_fmoveto(randx(), randy());
		_lineto(randx(), randy());
	}

	/* Stop the clock */

	etime = clock();

	/* Return withe the elapse execution time in milliseconds */

	return (int)((1000L * (etime - stime)) / CLOCKS_PER_SEC);

}


/*

randx - Generate a random X coordinate value

*/

short randx()
{
	return (short) (rand() % 320);
}


/*

randy - Generate a random Y coordinate value

*/

short randy()
{
	return (short) (rand() % 200);
}
