/* 
PVIDEO.C -- protected mode program to poke video display memory 
            1 million times using a real mode FAR pointer.
*/ 
 
#include <stdlib.h> 
#include <stdio.h> 
#include <dos.h>
#include <pharlap.h>
 
#define MAX 1000000L
 
unsigned short GetVidSeg(void);

int main()
{ 
    unsigned short VidSeg;
    REALPTR pVid;
    FARPTR fp;
    long i; 

//
// Get real mode paragraph addr of video memory, and use it to construct
// a real mode FAR pointer to video memory.
//
    VidSeg = GetVidSeg();
    if (VidSeg == 0)
    	return 1;
    RP_SET(pVid, 0, VidSeg);

 //
 // Poke video memory MAX times
 //
    for (i=MAX; i--; ) 
    	PokeRealWord(pVid + (i % 2000)*2, (USHORT) i);

    return 0; 
} 

unsigned short GetVidSeg(void)
{
    char VidMode;
    char ActivePage;

//
// Get video mode
//
    _asm {
        mov	ah,0Fh
	int	10h
	mov	VidMode,al
	mov	ActivePage,bh
    }

//
// This simple program only supports video page 0, 80x25 text modes
//
    if (ActivePage != 0)
    {
    	printf("Only video page 0 is supported\n");
	return 0;
    }
    if (VidMode == 7)
    	return (unsigned short) 0xB000;	// monochrome
    else if (VidMode == 2 || VidMode == 3)
        return (unsigned short) 0xB800;
    else
    {
    	printf("Only 80x25 text modes are supported\n");
	return 0;
    }
}
