//
// SIMPLE.CPP - Simple C++ program that shows class constructors and
//		destructors executing.
//
#include <iostream.h>
#include <string.h>

class a
{
	static a *pChain;
	static int num;
	a *pNext;
	char *pName;
	
public:

	a()
	{
		cout << "Hi from default a::a()\n";
		
		pName = new char[7];
		strcpy(pName, "NoName0");
		pName[6] += num ++;
		
		pNext = pChain;
		pChain = this;
		
		cout << "Created instance: " << pName << "\n";
	}
	
	a(char *s)
	{
		cout << "Hi from a::a(char *s)\n";
		
		pName = new char[strlen(s) + 1];
		strcpy(pName, s);
		
		cout << "Created instance: " << pName << "\n";
		
		pNext = pChain;
		pChain = this;
	}
	
	~a()
	{
		int i = 0;
		a *p;
		
		/* walk chain */
		
		for (p = pChain; p ; p = p -> pNext , i++)
		{
			cout << i << ": Instance name = " << p -> pName << "\n";
		}
		
		pChain = pChain -> pNext;
				
		cout << "There are " << i << " instances left.\n";
		
		delete[] pName;
	}
};

a* a::pChain = NULL;
int a::num = 0;

class b : public a
{
public:
	b() { cout << "Hi there from default b::b()!\n"; }
	b(char *s) : a(s) { cout << "Hi there from b::b(char *s)!\n"; }
	~b() { cout << "Bye from b::~b()!\n"; }
};

void main()
{
	a i1;			// use default constructor
	b i2;			// use default constructor
	a j1 = "My a string";	// use a::a(char *) constructor
	b j2 = "My b string";	// use b::b(char *) constructor
	
	cout << "***\n*** Exiting from main() ***\n***\n";
}
