//
// TERM.C -- Sample termination handlers with try-finally
//
#include <stdio.h>
#include <stdlib.h>
#include <pharlap.h>
#include <excpt.h>

void Level2(void);
void Level3(void);

int main()
{
	try
	{
		printf("Hello from main()\n");
		Level2();
	}
	finally
	{
		if (AbnormalTermination())
			printf("Abnormal termination in main()\n");
		else
			printf("Normal termination in main()\n");
	}

	printf("Exiting from main()\n");
	return 0;
}

void Level2(void)
{
	try
	{
		printf("Hello from Level2()\n");
		Level3();
		printf("Causing exception in Level2() try body\n");
		_asm
		{
			mov	eax,7FFFFFFFh
			mov	ebx,7FFFFFFFh
			add	eax,ebx
			into			; cause integer overflow
		}
	}
	finally
	{
		if (AbnormalTermination())
			printf("Abnormal termination in Level2()\n");
		else
			printf("Normal termination in Level2()\n");
	}

	printf("Exiting from Level2()\n");
	return;
}

void Level3(void)
{
	try
	{
		printf("Hello from Level3()\n");
	}
	finally
	{
		if (AbnormalTermination())
			printf("Abnormal termination in Level3()\n");
		else
			printf("Normal termination in Level3()\n");
	}

	printf("Exiting from Level3()\n");
	return;
}
