/* Video services for kaboom */
/*
 * We have deliberately put 2 bugs in this module
 * so that we can find them with 386|SRCBug.
 *
 * The first bug is in the nRandom function.  It attempts to scale
 * the generated random number to between 0 and 1 by
 * dividing by the largest possible integer.  Since
 * this program came from real mode, we have a portability
 * bug.  In real mode the largest possible integer is 0x7FFF.
 * In protected mode, the largest possible integer is 0x7FFFFFFF.
 *
 * The second bug is in the display_char function which is
 * attempting to directly reference the video buffer with
 * segment selector 0xB800.  Under 386|DOS-Extender you should
 * use selector 0x1C to reference the video buffer.
 *
 * We also modified the random number initialize call to
 * use the same number every time the program runs.  This
 * way we will always get the same values back from the
 * nRandom function and our debugging demo will work.
 */

#include "stdio.h"
#include "stdarg.h"
#include "stdlib.h"
#include "dos.h"
#include "conio.h"
#include "string.h"
#include "kaboom2.h"

#define SCREEN_X 80
#define SCREEN_Y 25
#define GRID_X 15
#define GRID_Y  9
#define TRUE 1
#define FALSE 0

void Pause(void)
{
	if (_getch() == 0) _getch();
}

void GetXY_(int *pX, int *pY)
{
	union REGS regs;
	regs.h.ah = 3;
	regs.h.bh = 0;                          /* display page 0 */
	_int86(0x10, &regs, &regs);
	if (pY != NULL) {
		(*pY) = regs.h.dh;
	}
	if (pX != NULL) {
		(*pX) = regs.h.dl;
	}
}
void GotoXY_(int x, int y)
{
	union REGS regs;
	regs.h.ah = 2;
	regs.h.dh = (unsigned char)y;
	regs.h.dl = (unsigned char)x;
	regs.h.bh = 0;                           /* display page 0 */
	_int86(0x10, &regs, &regs);
}
int nRandom(long nMax)
{
	static long maxint = 0x7FFF;

	return (long)(((double)rand() / (double)maxint) * (double)nMax);
}


/* Build a far pointer from components */
char _far *build_farptr(sel, off)
 int sel, off;
{
	union {
		char _far *fp;
		struct {
			long off;
			short sel;
		} s;
	} u;

	u.s.sel = sel;
	u.s.off = off;
	return u.fp;
}

void DisplayChar(int x, int y, char cChar, int nColor)
{
	char _far *cPos;
	static unsigned short scr_sel = 0xB800;

	if ((x>=0 && x<SCREEN_X) &&
	    (y>=0 && y<SCREEN_Y)) {
		cPos = build_farptr(scr_sel, (x+y*80)<<1);
		*cPos = cChar;
		*(cPos+1) = (char)nColor;
	}
}

void Initialize(void)
{
        extern initrand;
	unsigned int     nRand;     /* seed for random number generator */
	struct dostime_t sDosTime;    /* time structure; used for above seed     */

	if(initrand) {
		srand(initrand);
		return;
	}

	_dos_gettime(&sDosTime);
	nRand = (unsigned int)((sDosTime.hsecond * 600) +
	    (sDosTime.second * 10) +
	    (sDosTime.minute / 6));
	nRand = 0x12345678L;
	srand(nRand);
}
