/* 
PUTCLIP.C -- put text on Windows clipboard
*/ 
 
#include <stdlib.h> 
#include <stdio.h> 
#include <string.h> 
#include <dos.h> 
#include <io.h> 
#include <fcntl.h> 
#include <pltypes.h>
#include "winclip.h" 

#ifdef __WATCOMC__
#define _read read
#define _open open
#define _close close
#define _filelength filelength
#endif
 
void fail(char *s) { puts(s); exit(1); } 
 
int main(int argc, char *argv[]) 
{ 
    int f, len, maj, min; 
    int rc; // number of bytes read 
    char *p; 
 
    if (! WinOldApVersion(&maj, &min)) 
      fail("This program requires Windows Enhanced mode"); 
 
    if (argc < 2) 
        fail("usage: putclip [filename]"); 
     
    f = _open(argv[1], O_RDONLY);
    if (f == -1)
        fail("can't open file"); 
    len = _filelength(f); 
    if ((p = malloc(len+1)) == 0) 
        fail("insufficient memory"); 
    rc = _read(f, p, len);
    if (rc < 0)
        fail("can't read file"); 
    _close(f);
    p[rc] = '\0';  // must be NULL terminated 
     
    fputs("putclip ", stdout); 
    switch (PutClipStrLen(p, rc+1)) // include space for NULL 
    { 
        case 0:   puts("failed"); break; 
        case 1:   puts("successful"); break; 
        case -1:  puts("requires Windows Enhanced mode"); break; 
    } 
    free(p); 
    return 0; 
} 
