/*  
WINCLIP.H -- Windows Clipboard access -- definition 
386|DOS Extender functions for Windows 3.x (Enhanced) 
Clipboard 
*/ 
 
#ifndef PLTYPES
#include <pltypes.h>
#endif

/* predefined clipboard formats */ 
typedef enum { CF_TEXT=1, CF_BITMAP, CF_METAFILEPICT, CF_SYLK,  
    CF_DIF, CF_TIFF, CF_OEMTEXT 
    } CF_FORMAT; 
 
int WinOldApVersion(int *maj, int *min); 
unsigned GetDeviceCaps(unsigned cap); 
int OpenClipboard(void); 
void EmptyClipboard(void); 
unsigned long GetClipboardSize(CF_FORMAT format); 
REALPTR GetClipboardData(CF_FORMAT format); 
void CloseClipboard(void); 
void FreeClipboardData(REALPTR RealBufp);
int SetClipboardData(void *data, CF_FORMAT format, unsigned long size); 
unsigned long CompactClipboard(unsigned long desire); 
 
int PutClipStrLen(char *s, unsigned len); 
int PutClipString(char *s); 
char *GetClipString(void); 
void FreeClipString(char *s); 
