* MATHDEMO.FOR - This program forms part of a collection of FORTRAN
*		 code that demonstrates how to take over control of
*		 math error handling from the run-time system.

* Compile: wfc[386] mathdemo
* Link:    wlink file mathdemo, cw87, _matherr

      program mathdemo
      integer error_stat
      common /error/ error_stat

      real*8 x,y
      error_stat = 0
      call cw87

      x=12d300
      y=x*x
      call update
      print *, x, y

      x=12d-300
      y=x*x
      call update
      print *, x, y

      x=-12.0
      y=sqrt(x)
      call update
      print *, x, y

      x=0
      y=12/x
      call update
      print *, x, y

      end

      subroutine update
      integer error_stat
      common /error/ error_stat

*$pragma aux FPTrapInit "*_"

      include 'mathcode.fi'

      if( error_stat .ne. 0 ) then
	  print *, 'An error has occurred', error_stat
	  if(error_stat.eq.CP_TERMINATE) print *, 'CP_TERMINATE'
	  if(error_stat.eq.EX_Z_2_NOT_POS) print *, 'EX_Z_2_NOT_POS'
	  if(error_stat.eq.EX_NOT_INT_ARG) print *, 'EX_NOT_INT_ARG'
	  if(error_stat.eq.KO_FDIV_ZERO) print *, 'KO_FDIV_ZERO'
	  if(error_stat.eq.KO_FOVERFLOW) print *, 'KO_FOVERFLOW'
	  if(error_stat.eq.KO_FUNDERFLOW) print *, 'KO_FUNDERFLOW'
	  if(error_stat.eq.LI_ARG_NEG) print *, 'LI_ARG_NEG'
	  if(error_stat.eq.LI_ARG_LE_ONE) print *, 'LI_ARG_LE_ONE'
	  if(error_stat.eq.LI_ARG_ZERO) print *, 'LI_ARG_ZERO'
	  error_stat = 0
	  call FPTrapInit()
      endif
      end
