/*
    WINHANDL.C - This example shows how to allow for more
    than 20 file handles in a 32-bit Windows Application.
    Make sure INCLUDE environment variable includes path
    for new STDIO.H.

    Compile & Link:
	set include=.;\watcom\h
	wcl386 /l=win386 /zw winhandl.c ...
		... iob.obj nfiles.obj

    Bind with Supervisor:  wbind -n winhandl
*/
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

/* maximum # of file handles */
extern	unsigned __NFiles;

#define  FILE_MAX	70

void main()
{
    int     i;
    int     Handles_Available;
    int     file_cnt;
    char    buf[30];
    FILE    *fd[FILE_MAX];

    /*
	Are we getting the same STDIO.H that the
	library modules IOB and NFILES did?
    */
    assert( _NFILES == __NFiles );
    printf( "Number of available handles is %d\n",
	    _NFILES - 5 );

    file_cnt = min( FILE_MAX, _NFILES - 5 );
    /* Create/Open files */
    for ( i=0; i < file_cnt; i++ ) {
	sprintf( buf, "file%02d", i );
	if( (fd[i] = fopen( buf, "w" )) != NULL )
	    printf( "File '%s' opened\n", buf );
	else
	    printf( "File '%s' not opened\n", buf );
    }
    /* Close Files */
    for ( i=0; i < file_cnt; i++ ) {
	if( fd[i] != NULL ) fclose( fd[i] );
    }
}
