WATCOM binary patch file format

mpfile.c <  I                        e  
  	  x       ;  Q  I  	  a  R  m  O"      J%        ~(  #  C   )  $  w  ,  '     /  )  '  S1  *     >  2     G  :    I  <  ?   I  <       H     *******/

BOOL <H  	        *
  )H                      H                                       G                  *
 *              1                      ^1  !                                     T1              0     
 *          )*     *******/

VOID )  	        *
  )                      )  E   isk.            *
 *                                                 (  9                                *
 *  FUNCTION   : SaveFile %      *
 ************ N%              P"     er */
    f a  0   opened correctly */
    if ( fh < 0 )
              ****/

int q  	        *
  ^                      <                                         7                                        *
 *              *                      *
 * 
     L otherwise.                                        AddFile      j        *
 * 6                .   ile is already open.      *
 *                     Open   - Determines if a f   8   - Creates a new MDI window and, if specified,*
 *       +    extern char _class2[];

OFSTRUCT        of;
/****************************************************************************
 *                                                                          *
 *  FUNCTION   : AlreadyOpen(szFile)                                        *
 *                                                                          *
 *  PURPOSE    : Checks to see if the file described by the string pointed  *
 *               to by 'szFile' is already open.                            *
 *                                                                          *
 *  RETURNS    : a handle to the described file's window if that file is    *
 *               already open;  NUL m    *
 ****************************************************************************/

HWND AlreadyOpen(char *szFile)
{
    int     iDiff;
    HWND    hwndCheck;
    char    szChild[64];
    LPSTR   lpChild, lpFile;
    char far *fpFile;
    int     wFileTemp;

    /* Open the file with the OF_PARSE flag to obtain the fully qualified
     * pathname in the OFSTRUCT structure.
     */
    wFileTemp = OpenFile ((LPSTR)szFile, (LPOFSTRUCT)&of, OF_PARSE);
    if (! wFileTemp)
        return(NULL);
    _lclose (wFileTemp);

    /* Check each MDI child window in Multipad */
    for (   hwndCheck = GetWindow(hwndMDIClient, GW_CHILD);
            hwndCheck;
            hwndCheck = GetWindow(hwndCheck, GW_HWNDNEXT)   ) {
        /* Initialization  for comparison */
        lpChild = szChild;
        lpFile = AnsiUpper((LPSTR) of.szPathName);
        fpFile = MK_FP32( lpFile );
        iDiff = 0;

        /* Skip icon title windows */
        if (GetWindow(hwndCheck, GW_OWNER))
            continue;

        /* Get current child window's name */
        GetWindowText(hwndCheck, lpChild, 64);

        /* Compare window name with given name */
        while ((*lpChild) && (*fpFile) && (!iDiff)){
            if (*lpChild++ != *fpFile++)
                iDiff = 1;
        }

        /* If the two names matched, the file is already   */
        /* open -- return handle to matching child window. */
        if (!iDiff)
            return(hwndCheck);
    }
    /* No match found -- file is not open -- return NULL handle */
    return(NULL);
}

/****************************************************************************
 *                                                                          *
 *  FUNCTION   : AddFile (lpName)                                           *
 *                                                                          *
 *  PURPOSE    : Creates a new MDI window. If the lpName parameter is not   *
 *               NULL, it loads a file into the window.                     *
 *                                                                          *
 *  RETURNS    : HWND  - A handle to the new window.                        *
 *                                                                          *
 ****************************************************************************/

HWND PASCAL AddFile(pName)
char * pName;
{
    HWND hwnd;

    char            sz[160];
    MDICREATESTRUCT mcs;

    if (!pName) {
        /* The pName parameter is NULL -- load the "Untitled" string from */
        /* STRINGTABLE and set the title field of the MDI CreateStruct.    */
        LoadString (hInst, IDS_UNTITLED, sz, sizeof(sz));
	mcs.szTitle = (LPSTR)sz;
    }
    else 
        /* Title the window with the fully qualified pathname obtained by
         * calling OpenFile() with the OF_PARSE flag (in function
         * AlreadyOpen(), which is called before AddFile().
         */
	mcs.szTitle = of.szPathName;

    mcs.szClass = _class2;
    mcs.hOwner  = hInst;

    /* Use the default size for the window */
    mcs.x = mcs.cx = (short) CW_USEDEFAULT;
    mcs.y = mcs.cy = (short) CW_USEDEFAULT;

    /* Set the style DWORD of the window to default */
    mcs.style = styleDefault;

    /* tell the MDI Client to create the child */
    hwnd = (WORD)SendMessage (hwndMDIClient,
                              WM_MDICREATE,
                              0,
			      (LONG)(LPMDICREATESTRUCT)&mcs);

    /* Did we get a file? Read it into the window */
    if (pName){
        if (!LoadFile(hwnd, pName)){
            /* File couldn't be loaded -- close window */
            SendMessage(hwndMDIClient, WM_MDIDESTROY, (WORD) hwnd, 0L);
        }
    }

    return hwnd;
}

/****************************************************************************
 *                                                                          *
 *  FUNCTION   : LoadFile (lpName)                                          *
 *                                                                          *
 *  PURPOSE    : Given the handle to a MDI window and a filename, reads the *
 *               file into the window's edit control child.                 *
 *                                                                          *
 *  RETURNS    : TRUE  - If file is sucessfully loaded.                     *
 *               FALSE - Otherwise.    <     lpB;
    char far *f Z     s been               /* Couldn't reallocate to new size -- error */
        _lclose (fh);
        goto error;
    }

    /* read the file into the buffer */
    flpB = MK_LOCAL32( LocalLock(hT) );
    lpB = (LPSTR) MK_FP16( flpB );
    if (wLength != _16_lread (fh, lpB, wLength))
        MPError (hwnd, MB_OK|MB_ICONHAND, IDS_CANTREAD, (LPSTR)pName);

    /* Zero terminate the edit buf >%            *
 * %    /

VOID PASCAL ReadFile(HWND hwnd)
{
    char    szFile[128];
    HWND    hwndFile;

    GetFileName (szFile);

    /* If the result is not the empty string -- take appropriate action */
    if (*szFile) {
        /* Is file already open?? */
        if (hwndFile = AlreadyOpen(szFile)) {
            /* Yes -- bring the file's window to the top */
            BringWindowToTop(hwndFile);
        }
        else {
            /* No -- make a new window and load file into it */
            AddFile(szFile);
        }
    }
}

/****************************************************************************
 *                                     (     (hwnd)                                            *
 *                                                                          *
 *  PURPOSE    : Saves contents of current edit control to d +             switch (*lpT){
            case '.':
                 cch = TRUE;
                 break;

            case '\\':
            case ':' :
                 cch = FALSE;
                 break;
        }
    if (!cch)
         -            MPError (hwnd, MB_OK | MB_ICONHAND, IDS_CANTCREATE, (LPSTR)szFile);
        return;
    }

    /* Find out the length of the text in the edit control */
    cch = GetWindowTextLength (hwndEdit);

    /* Obtain a handle to the text buffer */
    hT  = (HANDLE)SendMessage (hwndEdit, EM_GETHANDLE, 0, 0L);
    lpT = (LPSTR) MK_FP16( MK_LOCAL32( LocalLock (hT) ) );

    /* Write out the contents of the buffer to the file. */
    if (cch != _16_lwrite (fh, lpT, cch))
         0                                                                      *
 *  FUNCTION   : SetSaveFrom ()                                             *
 *         1  $
                *
 *                                                                          *
 ****************************************************************************/

VOID PASCAL SetSaveFrom ( hwnd , psz)
HWND hwnd;
PSTR psz;
{
    char szFmt[32];
    char szText[160];

    /* The text string in the .RC file contains the format string... */
    GetDlgItemText( hwnd, IDD_SAVEFROM, szFmt, sizeof(szFmt));

    /* NOTE: this (LPSTR) cast MUST be here... wsprintf() is a cdecl
     * (C calling conventions) function with varying args... there is
     * no way for the compiler to know that all strings must be LPSTR's
     * and do the conversion, so we have to be careful about wsprintf()'s.
     */
    wsprintf ( szText, szFmt, (LPSTR)psz);

    /* set the text in the static control */
    SetDlgItemText (hwnd, IDD_SAVEFROM, szText);
}

/****************************************************************************
 *                                                                          *
 *  FUNCTION   : SaveAsDlgProc(hwnd, message, wParam, lParam)               *
 *                                                                          *
 *  PURPOSE    : Dialog function File/SaveAs. It waits for a filename, and  *
 *               then calls SaveFile or cancels the operation.              *
 *                                                                          *
 ****************************************************************************/

BOOL FAR PASCAL SaveAsDlgProc( hwnd, message, wParam, lParam)
HWND hwnd;
WORD message;
WORD wParam;
LONG lParam;
{
    char   sz[64];
    char   *pch;
    BOOL   fExt;
    HWND   hwndSave;

    switch (message){

        case WM_INITDIALOG:

            /* Identify the window whose contents we're saving */
            hwndSave = LOWORD (lParam);

            /* Set it's name in the property list */
            SetProp (hwnd, PROP_FILENAME, hwndSave);

            GetWindowText (hwndSave, sz, sizeof(sz));

            /* Set the save from string... */
            SetSaveFrom (hwnd,sz);

            /* Generate a filename complete with extension */
            AnsiUpper (sz);
            for (fExt = FALSE, pch = sz; *pch; pch++)
                if (*pch == '.')
                    fExt = TRUE;
                else if (*pch == '\\')
                    fExt = FALSE;
            if (!fExt)
                LoadString (hInst, IDS_ADDEXT, (LPSTR)pch, pch - sz);

            /* Display the filename in the edit control */
            SetDlgItemText (hwnd, IDD_SAVETO, sz);

            /* Select the entire range of text */
            SendDlgItemMessage (hwnd, IDD_SAVETO, EM_SETSEL, 0, MAKELONG (0,100));

            DlgDirList (hwnd, "*.*", IDD_DIRS, IDD_PATH, ATTR_DIRS);

            /* enable OK butto iff edit control is nonempty */
            if (!*sz)
                EnableWindow (GetDlgItem (hwnd, IDOK), FALSE);
            break;

        case WM_COMMAND:
            switch (wParam){
                case IDCANCEL:
                    /* Abort operation */
                    EndDialog(hwnd,1);
                    break;

                case IDOK:
                   /*  Just change the title of the MDI child. The calling
                    *  function of ChangeFile(), ?    uses the title text
                    *  for the filename, will do the actual save.
                    */
                    hwndSave = GetProp (hwnd, PROP_FILENAME);
                    GetDlgItemText (hwnd, IDD_SAVETO, sz, sizeof(sz));
                    AnsiUpper ((LPSTR)sz);
                    SetWindowText (hwndSave, sz);
                    EndDialog (hwnd, 0);
                    break;

                case IDD_SAVETO:
                   /* If the edit control changes, check to see if its empty.
                    * enable OK if it contains something
                    */
                    if (HIWORD (lParam) != EN_CHANGE)
                        return FALSE;
                    EnableWindow (GetDlgItem (hwnd, IDOK),
                        (WORD) SendDlgItemMessage (hwnd,
                                                   IDD_SAVETO,
                                                   WM_GETTEXTLENGTH,
                                                   0,
                                                   0L));
                    break;

                case IDD_DIRS:
                    if (HIWORD(lParam)==LBN_DBLCLK){
                        char szT[64];

                        DlgDirSelect ( hwnd, szT, IDD_DIRS);
                        lstrcat ( szT, "*.*");
                        DlgDirList (hwnd, szT, IDD_DIRS, IDD_PATH, ATTR_DIRS);
                        break;
                    }
                    return FALSE;

                default:
                    return FALSE;
            }

        default:
            return FALSE;
    }
    return TRUE;
}

/****************************************************************************
 *                                                                          *
 *  FUNCTION   : ChangeFile (hwnd)                                          *
 *                                                                          *
 *  PURPOSE    : Invokes the File/SaveAs dialog.                            *
 *                                                                          *
 *  RETURNS    : TRUE  - if user selected OK or NO.    I     )
    (   I   G   1     G    & G  !"F; G  n`jE G   f G  k_\i G   G   G   G  ߬ G   G    G   G    G   G   G      G     G    >   O> G   