WATCOM binary patch file format

mpfind.c   X-  	             H  K  )   x  *  :   g  
     
       J       	  	  J      #
  <   #         d  =      M  7    I      4  +  1  n  Y-         K,  	        *
  8,                      ,  $                                        +        *
 *         +                      4                        J   rection.         *
 *                                                     p     
 *               *****/
VOID   	        *
                        F  9       *
 *                                                 8     ion.              
 *          4     *****/
VOID   	        *
                          J   ection.              *
 *                                                      
 *          
                   
 *          '                                                             
  (                     *
 *                  
                        '     
 *          `                  V              H                      H  /***************************************************************************
 *                                                                         *
 *  MODULE      : MpFind.c                                                 *
 *                                                                         *
 *  PURPOSE     : Code to do text searches in MultiPad.                    *
 *                                                                         *
 *  FUNCTIONS   : RealSlowCompare () - Compares subject string with target *
 *                                     string.                             *
 *                                                                         *
 *                FindText ()        - Looks for the search string in the  *
 *                                     active window.                      *
 *                                                                         *
 *                FindPrev ()        - Find previous occurence of search   *
 *                                     string.                             *
 *   q                                  *
 *                FindNext ()        - Find next occurence of search string*
 *                                                                         *
 *                FindDlgProc ()     - Dialog function for Search/Find.    *
 *                                                                         *
 *                Find ()            - Invokes FindDlgProc ()              *
 *                                                                         *
 *****************      /
#include "multipad.h"

#include <malloc.h>

#undef HIWORD
#undef LOWORD

#define HIWORD(l) (((short *)&(l))[1])
#define LOWORD(l) (((short *)&(l))[0])

BOOL fCase       7                                                                 *
 *  FUNCTION   : RealSlowCompare ()                                         *
 *                                                                          *
 *  PURPOSE    : Compares subject string with the target string. This fn/   *
 *               is called repeatedly so that all substrings are compared,  *
 *               which makes it O(n ** 2), hence it's name.                 *
 *                                                                          *
 *  RETURNS    : TRUE  - If pSubject is identical to pTarget.               *
 *               FALSE - otherwise.       PASCAL RealSlowCompare (pSubject, pTarget )
register char far *pSubject;
register PSTR pTarget;
{
    WORD len;
    char *foo;
    
    if (fCase){
        while (*pTarget)
            if (*pTarget++ != *pSubject++)
                return FALSE;
    }
    else{
        /* If case-insensitive, convert both subject and target to lowercase
         * before comparing.
         */
        AnsiLower ((LPSTR)pTarget);
        len = strlen( pTarget );
        foo = alloca( len + 1 );
        _fstrncpy( foo, pSubject, len );
        foo[len] = 0;
        AnsiLower( foo );
        while (*pTarget)
            
            if (*pTarget++ != *pSubject++)
                   4                                                               *
 *  FUNCTION   : FindText ()                                                *
 *                                                                          *
 *  PURPOSE    : Finds the search string in the active window according to  *
 *      S                    forward searches).                                         *
 *                                                                          *
 **************** <     /
VOID PASCAL FindText( dch )
register int dch;

{
    register PSTR pText;
    char far *    fpText;
    HANDLE        hT;
    LONG          l;
    WORD          cch;
    int           i;

    if (!*szSearch)
                 = (HANDLE)SendMessage (hwndActiveEdit, EM_GETHANDLE, 0, 0L);
    fpText = MK_LOCAL32( LocalLock(hT) );

    /* Get the length of the text */
    cch = (WORD)SendMessage (hwndActiveEdit, WM_GETTEXTLENGTH, 0, 0L);

    /* Start with the next char. in selected range ... */
    fpText += LOWORD (l) + dch;

    /* Compute how many characters are before/after the current selection*/
    if (dch < 0)
        i = LOWORD (l);
    else
        i = cch - LOWORD (l) + 1 - lstrlen (szSearch);

    /* While there are uncompared substrings... */
    while ( i > 0){
        LOWORD(l)+=dch;

        /* Does this substring match? */
        if (RealSlowCompare(fpText,szSearch)){

            /* Yes, unlock the buffer.*/
            LocalUnlock(hT);

            /* Select the located string */
            HIWORD(l) = LOWORD(l) + lstrlen (szSearch);
            SendMessage (hwndActiveEdit, EM_SETSEL, 0, l);
            return;
        }
        i--;

        /* increment/decrement start position by 1 */
      !  c                                                               *
 *  FUNCTION   : FindPrev ()                                                *
 *                                                                          *
 *  PURPOSE    : Finds the previous occurence of the search string. Calls   *
 *               FindText () with a negative search di   f                                                               *
 *  FUNCTION   : FindNext ()                                                *
 *                                                                          *
 *  PURPOSE    : Finds the next occurence of search string. Calls           *
 *               FindText () with a positive search direc   h                                                               *
 *  FUNCTION   : FindDlgProc(hwnd, message, wParam, lParam)                 *
 *                                                                          *
 *  PURPOSE    : Dialog function for the Search/Find command. Prompts user  *
 *               for target string, case flag and search di              case WM_INITDIALOG:{

            /* Check/uncheck case button */
            CheckDlgButton (hwnd, IDD_CASE, fCase);

            /* Set default search string to most recently searched string */
            SetDlgItemText (hwnd, IDD_SEARCH, szSearch);

            /* Allow search only if target is nonempty */
            if (!lstrlen (szSearch)){
                EnableWindow (GetDlgItem (hwnd, IDOK), FALSE);
                EnableWindow (GetDlgItem (hwnd, IDD_PREV), FALSE);
            }
            break;
        }

        case WM_COMMAND:{

            /* Search forward by default (see IDOK below) */
            int i = 1;

            switch (wParam){
                /* if the search target becomes non-empty, enable searching */
                case IDD_SEARCH:
                    if (HIWORD (lParam) == EN_CHANGE){
                        if (!(WORD) SendDlgItemMessage (hwnd,
                                                        IDD_SEARCH,
                                                        WM_GETTEXTLENGTH,
                                                        0,
                                                        0L))
                            i = FALSE;
                        else
                            i = TRUE;
                        EnableWindow (GetDlgItem (hwnd, IDOK), i);
                        EnableWindow (GetDlgItem (hwnd, IDD_PREV), i);
                    }
                    break;

                case IDD_CASE:
                    /* Toggle state of case button */
                    CheckDlgButton (hwnd,
                                    IDD_CASE,
                                    !IsDlgButtonChecked (hwnd, IDD_CASE));
                    break;

                case IDD_PREV:
                    /* Set direction to backwards */
                    i=-1;
                    /*** FALL THRU ***/

                case IDOK:
                    /* Save case selection */
                    fCase = IsDlgButtonChecked( hwnd, IDD_CASE);

                    /* Get search string */
                    GetDlgItemText (hwnd, IDD_SEARCH, szSearch, sizeof (szSearch));

                    /* Find the text */
                    FindText (i);
                    /*** FALL THRU ***/

                /* End the dialog */
                case IDCANCEL:
                    EndDialog (hwnd, 0);
                    break;

                default:
                    return FALSE;
            }
            break;
        }
        default:
            return FALSE;
    }
    return TRUE;
}

/****************************************************************************
 *                                                                          *
 *  FUNCTION   : Find()                                                     *
 *                                                                          *
 *  PURPOSE    : Invokes the Search/Find dialog.     ,   %   ] ,   ,  6	 ,      