WATCOM binary patch file format

mpinit.c                         [       :   o  }     8    h   	    y     	     h  
  y   .    Y     
  /  [                       u                  g             0,
 Y              3              u        *pCmdLine i        char       *****/
BOOL D  	        *
  1                      >                      K      *
 *                           /********** f                                                        *
 *  MODULE      : MpInit.c                                                 *
 *                                                                         *
 *  PURPOSE     : Contains initialization code for MultiPad.               *
 *                                                                         *
 *  FUNCTIONS   : InitializeApplication() - Sets up Class data structure   *
 *                                          and registers window class.    *
 *                                                                         *
 *                InitializeInstance ()   - Does a per-instance initial-   *
 *                                          ization of MultiPad. Creates   *
 *                                          the "frame" and MDI client.    *
 *                                                                         *
 ***************** B  -   /
#include "multipad.h"
#include <malloc.h>   ?  char _class[64],_class2[64];

/****************************************************************************
 *                                                                          *
 *  FUNCTION   : InitializeApplication ()                                   *
 *                                                   ~   *
 *               initialization of the app by registering the window classes*
 *                                                                          *
 *  RETURNS    : TRUE  - If RegisterClass() was successful for both classes.*
 *               FALSE - otherwise.                                         *
 *                                                                          *
 ****************************************************************************/

BOOL PASCAL InitializeApplication()
{
    WNDCLASS    wc;

    /* Register the frame class */
    wc.style         = 0;
    wc.lpfnWndProc   = (LPVOID) 	  u     = LoadIcon(hInst,IDMULTIPAD);
    wc.hCursor       = LoadCursor(NULL,IDC_ARROW);
    wc.hbrBackground = COLOR_APPWORKSPACE+1;
    wc.lpszMenuName  = IDMULTIPAD;
    sprintf( _class,"%s%d",szFrame,hInst );
    wc.lpszClassName = _class;

    if (!RegisterClass (&wc) )
        return FALSE;

    /* Register the MDI child class */
    wc.lpfnWndProc   = (LPVOID) MPMDIChildWndProc;
    wc.hIcon         = LoadIcon(hInst,IDNOTE);
    wc.lpszMenuName  = NULL;
    wc.cbWndExtra    = CBWNDEXTRA;
    sprintf(_class2,"%s%d",szChild, hInst );
    wc.lpszClassName = _class2;

    if (!RegisterClass(&wc))
        return FALSE;

    return TRUE;

}

/****************************************************************************
 *                                                                          *
 *  FUNCTION   : InitializeInstance ()                                      *
 *                                                                          *
 *  PURPOSE    : Performs a per-instance initialization of MultiPad. It     *
 *               also creates the frame and an MDI window.                  *
 *                                                                          *
 *  RETURNS    : TRUE  - If initialization was successful.                  *
 *               FALSE - otherwise.                                         *
 *                `            sz[80];
    char         title[128];
    HDC          hdc;
    HMENU        hmenu;
   M      strcpy( title,"WATCOM Win386 " );
    strcat( title, sz );

    /* Create the frame */
    hwndFrame = CreateWindow (_class,
                              title,
                              WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
                              CW_USEDEFAULT,
                              0,
              2            NULL,
                              NULL,
                              hInst,
                              NULL);

    if ((!hwndFrame) || (!hwndMDIClient))
        return FALSE;

    /* Load main menu accelerators */
    if (!(hAccel = LoadAccelerators (hInst, IDMULTIPAD)))
           s          pCmdLine = NULL;
    else {
        pCmdLine = malloc( strlen( lpCmdLine ) +1 );
        if (pCmdLine)
    j   free( pCmdLine );

    /* Default to minimized windows after the first. */
    styleDefault = 0L;
        '        Q     P    8   #              